/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.settlement.biz.utils;

import com.dtyunxi.exceptions.BizException;
import java.io.IOException;
import java.io.InputStream;
import java.net.BindException;
import org.apache.commons.net.ftp.FTPClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpUtil {
    private static final Logger logger = LoggerFactory.getLogger(FtpUtil.class);

    public static InputStream getFile(String url, String username, String password, String fileName) {
        FTPClient ftpClient = FtpUtil.buildConnect(url, username, password);
        InputStream inputStream = null;
        try {
            ftpClient.enterLocalPassiveMode();
            inputStream = ftpClient.retrieveFileStream(fileName);
        }
        catch (IOException e) {
            logger.error("ftp\u8bfb\u53d6\u6587\u4ef6\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            throw new BizException("-1", "ftp\u8bfb\u53d6\u6587\u4ef6\u5f02\u5e38");
        }
        finally {
            if (null != inputStream) {
                try {
                    ftpClient.completePendingCommand();
                    FtpUtil.disConnect(ftpClient);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new BizException("-1", e.getMessage());
                }
            }
        }
        return inputStream;
    }

    private static FTPClient buildConnect(String url, String username, String password) {
        logger.info("\u6839\u636eApache\u7ec4\u4ef6\u8fde\u63a5ftp\u670d\u52a1\uff1a{}\uff0c{}\uff0c{}", new Object[]{url, username, password});
        FTPClient ftpClient = new FTPClient();
        try {
            ftpClient.setConnectTimeout(3600000);
            ftpClient.enterLocalActiveMode();
            ftpClient.setRemoteVerificationEnabled(false);
            ftpClient.setControlEncoding("GBK");
            ftpClient.connect(url, 21);
            ftpClient.setFileType(2);
            boolean login = ftpClient.login(username, password);
            if (!login) {
                throw new BindException("\u767b\u9646\u5931\u8d25");
            }
        }
        catch (Exception e) {
            logger.error("\u6839\u636eApache\u7ec4\u4ef6\u8fde\u63a5ftp\u670d\u52a1\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            throw new BizException("-1", "\u6839\u636eApache\u7ec4\u4ef6\u8fde\u63a5ftp\u670d\u52a1\u5f02\u5e38");
        }
        return ftpClient;
    }

    private static void disConnect(FTPClient ftpClient) {
        if (null != ftpClient && ftpClient.isConnected()) {
            try {
                ftpClient.disconnect();
            }
            catch (Exception e) {
                logger.info("\u5173\u95edftp\u8fde\u63a5\u5f02\u5e38");
            }
        }
    }
}

