/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.openapi.api.biz.jzt;

import com.dtyunxi.tcbj.center.openapi.api.biz.jzt.dto.QueryJztOrgConfigReq;
import com.dtyunxi.tcbj.center.openapi.api.biz.jzt.dto.QueryJztOrgConfigResp;
import java.sql.Timestamp;
import java.util.List;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class CustomerExport2025Service {
    private static final Logger log = LogManager.getLogger(CustomerExport2025Service.class);
    @Resource
    private JdbcTemplate jdbcTemplate;

    public QueryJztOrgConfigResp queryJztOrgConfig(QueryJztOrgConfigReq req) {
        log.info("\u67e5\u8be2\u4e5d\u5dde\u901a\u79df\u6237\u914d\u7f6e\u4fe1\u606f\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)req);
        String orgId = req.getOrgId();
        if (orgId == null || orgId.trim().isEmpty()) {
            log.warn("\u67e5\u8be2\u4e5d\u5dde\u901a\u914d\u7f6e\u5931\u8d25\uff0c\u79df\u6237ID\u4e3a\u7a7a");
            return null;
        }
        List<QueryJztOrgConfigResp> resultList = this.queryJztOrgConfigByOrgId(orgId);
        if (!resultList.isEmpty()) {
            QueryJztOrgConfigResp result = resultList.get(0);
            log.info("\u67e5\u8be2\u4e5d\u5dde\u901a\u914d\u7f6e\u6210\u529f\uff0c\u79df\u6237ID\uff1a{}\uff0c\u7ed3\u679c\uff1a{}", (Object)orgId, (Object)result);
            return result;
        }
        log.info("\u672a\u67e5\u8be2\u5230\u79df\u6237ID\u4e3a{}\u7684\u4e5d\u5dde\u901a\u914d\u7f6e\u4fe1\u606f", (Object)orgId);
        return null;
    }

    private List<QueryJztOrgConfigResp> queryJztOrgConfigByOrgId(String orgId) {
        String sql = "SELECT t.id, t.org_id AS orgId, t.enable_jzt AS enableJzt, t.remark, t.create_person AS createPerson, t.create_time AS createTime, t.update_person AS updatePerson, t.update_time AS updateTime, t.dr FROM `jzt_org_config` t WHERE t.org_id = ? AND t.dr = 0";
        return this.jdbcTemplate.query(sql, new Object[]{orgId}, (rs, rowNum) -> {
            QueryJztOrgConfigResp dto = new QueryJztOrgConfigResp();
            dto.setId(rs.getLong("id"));
            dto.setOrgId(rs.getString("orgId"));
            dto.setEnableJzt(rs.getString("enableJzt"));
            dto.setRemark(rs.getString("remark"));
            dto.setCreatePerson(rs.getString("createPerson"));
            Timestamp createTime = rs.getTimestamp("createTime");
            if (createTime != null) {
                dto.setCreateTime(createTime.toLocalDateTime());
            }
            dto.setUpdatePerson(rs.getString("updatePerson"));
            Timestamp updateTime = rs.getTimestamp("updateTime");
            if (updateTime != null) {
                dto.setUpdateTime(updateTime.toLocalDateTime());
            }
            dto.setDr(rs.getInt("dr"));
            return dto;
        });
    }
}

