/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.dto.RequestBaseData;
import com.dtyunxi.tcbj.app.open.biz.enums.CustomerMaterialRelEnum;
import com.dtyunxi.tcbj.app.open.biz.service.ICenterHandleService;
import com.dtyunxi.tcbj.app.open.biz.service.ISellerSkuPriceService;
import com.dtyunxi.tcbj.app.open.dao.das.DataDistributeDas;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.ModelInfoReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.DataDistributeRespDto;
import com.dtyunxi.tcbj.center.openapi.api.enums.ModelCodeEnum;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.RandomCodeUtil;
import com.dtyunxi.yundt.cube.center.customer.api.customer.ICustomerApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.IItemAuthApi;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemAuthReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.ItemAuthRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.query.IItemAuthQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemSkuQueryApi;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.api.IItemSycnExtApi;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="centerHandleCustomerMaterialRelServiceImpl")
public class CenterHandleCustomerMaterialRelServiceImpl
implements ICenterHandleService {
    private static Logger logger = LoggerFactory.getLogger(CenterHandleCustomerMaterialRelServiceImpl.class);
    @Value(value="${customer.price.relation.limitCount:15}")
    private Integer limitCount;
    @Resource
    private IItemSycnExtApi iItemSycnExtApi;
    @Resource
    private ICustomerApi customerApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private IItemAuthApi itemAuthApi;
    @Resource
    private IItemAuthQueryApi itemAuthQueryApi;
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private RequestBaseData requestBaseData;
    @Resource
    private IItemSkuQueryApi iItemSkuQueryApi;
    @Resource
    private ISellerSkuPriceService sellerSkuPriceService;
    @Autowired
    private DataDistributeDas dataDistributeDas;
    @Resource
    private ICacheService cacheService;
    private final ExecutorService executorService = new ThreadPoolExecutor(3, 3, 1L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(3, true), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());
    DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public void handle(Map maps) {
        if (ObjectUtil.isEmpty((Object)maps) && ObjectUtil.isEmpty(maps.get("D_SUPPLIER_ID")) && ObjectUtil.isEmpty(maps.get("D_PARTNER_ID"))) {
            logger.error("\u8bf7\u6c42\u53c2\u6570\u6709\u8bef");
            return;
        }
        this.executorService.execute(() -> {
            logger.info("\u5f00\u59cb\u6267\u884c\u5ba2\u6237\u7269\u6599\u540c\u6b65\uff1a{}", (Object)JSON.toJSONString((Object)maps));
            List<Object> applierIds = new ArrayList();
            if (ObjectUtil.isNotEmpty(maps.get("D_PARTNER_ID")) || ObjectUtil.isNotEmpty(maps.get("D_PARTNER_ID"))) {
                List ids = (List)JSON.parseObject((String)JSON.toJSONString(maps.get("D_PARTNER_ID")), List.class);
                applierIds.addAll(ids);
            } else {
                applierIds = this.sellerSkuPriceService.selectApplierIdsBySupplierId(String.valueOf(maps.get("D_SUPPLIER_ID")));
            }
            maps.remove("D_PARTNER_ID");
            if (CollectionUtils.isEmpty(applierIds)) {
                logger.error("\u8be5\u79df\u6237\u4e0b\u65e0\u5ba2\u6237\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)maps));
            }
            List<Object> finalApplierIds = applierIds;
            Stream.iterate(0, n -> n + 1).limit(this.getCount(finalApplierIds.size()).intValue()).forEach(i -> {
                List limitApplierIds = finalApplierIds.stream().skip((long)i.intValue() * (long)this.limitCount.intValue()).limit(this.limitCount.intValue()).collect(Collectors.toList());
                this.handleViewData(this.getViewData(null, this.dataDistributeDas.selectCustomerRefMaterial(limitApplierIds, maps)));
            });
        });
    }

    private void handleViewData(List<Map<String, String>> dataList) {
        if (CollectionUtils.isEmpty(dataList)) {
            logger.info("\u6682\u65e0\u6570\u636e\u5904\u7406");
            return;
        }
        logger.info("\u5904\u7406\u89c6\u56fe\u6570\u636e\uff1a{}=={}", (Object)dataList.size(), (Object)JSON.toJSONString(dataList));
        Date date = new Date();
        ArrayList<String> itemCodes = new ArrayList<String>();
        ArrayList<String> thirdPartyIds = new ArrayList<String>();
        for (Map<String, String> map : dataList) {
            itemCodes.add(map.get(CustomerMaterialRelEnum.PRODUCT_ID_EASNO.name()));
            thirdPartyIds.add(map.get(CustomerMaterialRelEnum.PARTNER_ID.name()));
        }
        List itemRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.itemQueryApi.queryByItemLongCodes(itemCodes));
        if (CollectionUtils.isEmpty((Collection)itemRespDtoList)) {
            logger.info("\u5ba2\u6237\u7269\u6599\u5173\u7cfb\u6570\u636e\u5206\u53d1\u7ed3\u675f\uff0c\u65e0\u5546\u54c1\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(itemCodes));
            return;
        }
        HashMap itemListMap = new HashMap();
        HashMap itemCodeSkuIdMap = new HashMap();
        itemRespDtoList.forEach(itemRespDto -> {
            itemListMap.put(itemRespDto.getLongCode(), itemRespDto.getId());
            itemCodeSkuIdMap.put(itemRespDto.getLongCode(), itemRespDto.getSkuId());
        });
        List customerRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryByThirdPartyIds(thirdPartyIds));
        if (CollectionUtils.isEmpty((Collection)customerRespDtoList)) {
            logger.info("\u5ba2\u6237\u7269\u6599\u5173\u7cfb\u6570\u636e\u5206\u53d1\u7ed3\u675f\uff0c\u65e0\u5ba2\u6237\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(thirdPartyIds));
        }
        Map<String, CustomerRespDto> customerRespMap = customerRespDtoList.stream().collect(Collectors.toMap(CustomerRespDto::getThirdPartyId, t -> t, (last, next) -> next));
        ArrayList<ItemAuthReqDto> itemAuthReqDtoList = new ArrayList<ItemAuthReqDto>();
        for (Map<String, String> map : dataList) {
            logger.info("\u5904\u7406\u6388\u6743\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(map));
            CustomerRespDto customer = customerRespMap.get(map.get(CustomerMaterialRelEnum.PARTNER_ID.name()));
            if (ObjectUtil.isEmpty((Object)customer)) {
                logger.info("\u627e\u4e0d\u5230\u5ba2\u6237");
                continue;
            }
            Long itemId = (Long)itemListMap.get(map.get(CustomerMaterialRelEnum.PRODUCT_ID_EASNO.name()));
            if (ObjectUtil.isEmpty((Object)itemId)) {
                logger.info("\u627e\u4e0d\u5230\u8be5\u5546\u54c1");
                continue;
            }
            Long skuId = (Long)itemCodeSkuIdMap.get(map.get(CustomerMaterialRelEnum.PRODUCT_ID_EASNO.name()));
            if (ObjectUtil.isEmpty((Object)skuId)) {
                logger.info("\u627e\u4e0d\u5230SkuId");
                continue;
            }
            boolean ifTimeValid = true;
            Date authEndTime = null;
            if (ObjectUtil.isNotEmpty((Object)map.get(CustomerMaterialRelEnum.INVALID_DATE.name()))) {
                String authEndTimeStr = String.valueOf(map.get(CustomerMaterialRelEnum.INVALID_DATE.name())).replace(".0", "");
                authEndTime = DateUtil.parse((String)authEndTimeStr);
                ifTimeValid = this.isValid(date, authEndTime.getTime());
            }
            ItemAuthReqDto itemAuthReqDto = new ItemAuthReqDto();
            itemAuthReqDto.setTargetType(Integer.valueOf(1));
            itemAuthReqDto.setTargetId(customer.getId());
            itemAuthReqDto.setBusinessType("SKU");
            itemAuthReqDto.setBusinessId(skuId);
            itemAuthReqDto.setAuthEndTime(ObjectUtil.isEmpty((Object)authEndTime) ? null : authEndTime);
            itemAuthReqDto.setStatus(Integer.valueOf(ifTimeValid ? 1 : 0));
            itemAuthReqDto.setInstanceId(this.requestBaseData.getInstanceId());
            itemAuthReqDto.setTenantId(this.requestBaseData.getTenantId());
            itemAuthReqDtoList.add(itemAuthReqDto);
        }
        this.iItemSycnExtApi.updateOrInsertItemAuth(itemAuthReqDtoList);
        logger.info("\u5220\u9664\u5546\u54c1\u7f13\u5b58\u4fe1\u606f");
        customerRespDtoList.forEach(e -> this.cacheService.delCache("COMMON", "AUTH_CACHE_PRE:" + e.getId()));
    }

    @Override
    public String getModelType() {
        return ModelCodeEnum.CUSTOMER_MATERIAL_REL.name();
    }

    @Override
    @Deprecated
    public List<DataDistributeRespDto> handle(ModelInfoReqDto modelInfoReqDto) {
        logger.info("\u5ba2\u6237\u7269\u6599\u5173\u7cfb\u6570\u636e\u5206\u53d1\uff1a{}", (Object)JSON.toJSONString((Object)modelInfoReqDto));
        Date date = new Date();
        List maps = JSONArray.parseArray((String)modelInfoReqDto.getDataStr(), Map.class);
        ArrayList itemCodes = new ArrayList();
        ArrayList thirdPartyIds = new ArrayList();
        for (Map map : maps) {
            itemCodes.add(map.get(CustomerMaterialRelEnum.PRODUCT_ID_EASNO.name()));
            thirdPartyIds.add(map.get(CustomerMaterialRelEnum.PARTNER_ID.name()));
        }
        List itemRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.itemQueryApi.queryByItemLongCodes(itemCodes));
        if (CollectionUtils.isEmpty((Collection)itemRespDtoList)) {
            logger.info("\u5ba2\u6237\u7269\u6599\u5173\u7cfb\u6570\u636e\u5206\u53d1\u7ed3\u675f\uff0c\u65e0\u5546\u54c1\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(itemCodes));
            return null;
        }
        HashMap itemListMap = new HashMap();
        HashMap itemCodeSkuIdMap = new HashMap();
        itemRespDtoList.forEach(itemRespDto -> {
            itemListMap.put(itemRespDto.getLongCode(), itemRespDto.getId());
            itemCodeSkuIdMap.put(itemRespDto.getLongCode(), itemRespDto.getSkuId());
        });
        List customerRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryByThirdPartyIds(thirdPartyIds));
        if (CollectionUtils.isEmpty((Collection)customerRespDtoList)) {
            logger.info("\u5ba2\u6237\u7269\u6599\u5173\u7cfb\u6570\u636e\u5206\u53d1\u7ed3\u675f\uff0c\u65e0\u5ba2\u6237\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(thirdPartyIds));
        }
        Map<String, CustomerRespDto> customerRespMap = customerRespDtoList.stream().collect(Collectors.toMap(CustomerRespDto::getThirdPartyId, t -> t, (last, next) -> next));
        List targetIds = customerRespDtoList.stream().map(BaseRespDto::getId).collect(Collectors.toList());
        ItemAuthReqDto queryCondition = new ItemAuthReqDto();
        queryCondition.setTargetIdList(targetIds);
        queryCondition.setTargetType(Integer.valueOf(1));
        List itemAuthRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.itemAuthQueryApi.queryByTargetIds(queryCondition));
        Map<Object, Object> itemAuthMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)itemAuthRespDtoList)) {
            itemAuthMap = itemAuthRespDtoList.stream().collect(Collectors.toMap(t -> t.getTargetId() + "-" + t.getBusinessId(), t -> t, (last, next) -> next));
        }
        ArrayList itemAuthReqDtoList = Lists.newArrayList();
        for (Map map : maps) {
            ItemAuthReqDto itemAuthReqDto;
            logger.info("\u5904\u7406\u6388\u6743\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)map));
            CustomerRespDto customer = customerRespMap.get(map.get(CustomerMaterialRelEnum.PARTNER_ID.name()));
            if (ObjectUtil.isEmpty((Object)customer)) {
                logger.info("\u627e\u4e0d\u5230\u5ba2\u6237");
                continue;
            }
            Long itemId = (Long)itemListMap.get(map.get(CustomerMaterialRelEnum.PRODUCT_ID_EASNO.name()));
            if (ObjectUtil.isEmpty((Object)itemId)) {
                logger.info("\u627e\u4e0d\u5230\u8be5\u5546\u54c1");
                continue;
            }
            Long skuId = (Long)itemCodeSkuIdMap.get(map.get(CustomerMaterialRelEnum.PRODUCT_ID_EASNO.name()));
            if (ObjectUtil.isEmpty((Object)skuId)) {
                logger.info("\u627e\u4e0d\u5230SkuId");
            }
            boolean ifHave = false;
            ItemAuthRespDto itemAuthRespDto = (ItemAuthRespDto)itemAuthMap.get(customer.getId() + "-" + skuId);
            if (ObjectUtil.isNotEmpty((Object)itemAuthRespDto)) {
                ifHave = true;
            }
            Long authEndTime = ObjectUtil.isEmpty(map.get(CustomerMaterialRelEnum.INVALID_DATE.name())) ? null : Long.valueOf(Long.parseLong(String.valueOf(map.get(CustomerMaterialRelEnum.INVALID_DATE.name()))));
            boolean ifTimeValid = this.isValid(date, authEndTime);
            if (!ifHave) {
                itemAuthReqDto = new ItemAuthReqDto();
                itemAuthReqDto.setTargetType(Integer.valueOf(1));
                itemAuthReqDto.setTargetId(customer.getId());
                itemAuthReqDto.setBusinessType("SKU");
                itemAuthReqDto.setBusinessId(skuId);
                itemAuthReqDto.setStatus(Integer.valueOf(ifTimeValid ? 1 : 0));
                itemAuthReqDto.setInstanceId(this.requestBaseData.getInstanceId());
                itemAuthReqDto.setTenantId(this.requestBaseData.getTenantId());
                itemAuthReqDtoList.add(itemAuthReqDto);
                continue;
            }
            try {
                itemAuthReqDto = new ItemAuthReqDto();
                itemAuthReqDto.setId(itemAuthRespDto.getId());
                itemAuthReqDto.setStatus(Integer.valueOf(ifTimeValid ? 1 : 0));
                this.itemAuthApi.modifyItemAuth(itemAuthReqDto);
            }
            catch (Exception e) {
                logger.info("\u66f4\u65b0\u6388\u6743\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)itemAuthRespDto));
                e.printStackTrace();
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)itemAuthReqDtoList)) {
            try {
                logger.info("\u6267\u884c\u65b0\u589e\u6388\u6743\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)itemAuthReqDtoList));
                this.itemAuthApi.batchAddItemAuth((List)itemAuthReqDtoList);
            }
            catch (Exception e) {
                logger.info("\u6279\u91cf\u65b0\u589e\u5546\u54c1\u6388\u6743\u4fe1\u606f\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            }
        } else {
            logger.info("\u6267\u884c\u65b0\u589e\u6388\u6743\u4fe1\u606f\uff1a\u65e0\u9700\u8981");
        }
        logger.info("\u5ba2\u6237\u7269\u6599\u5173\u7cfb\u6570\u636e\u5206\u53d1\u7ed3\u675f");
        return null;
    }

    private DataDistributeRespDto dataResp(String taskId, String type, String reason) {
        DataDistributeRespDto dataDistributeRespDto = new DataDistributeRespDto();
        dataDistributeRespDto.setTask_id(taskId);
        dataDistributeRespDto.setType(type);
        dataDistributeRespDto.setReason(reason);
        return dataDistributeRespDto;
    }

    private boolean isValid(Date date, Long invalidDate) {
        logger.info("\u5f53\u524d\u540c\u6b65\u65f6\u95f4\uff1a" + date.toString() + "\u7ed3\u675f\u65f6\u95f4\uff1a" + invalidDate);
        boolean mark = false;
        if (ObjectUtil.isEmpty((Object)invalidDate)) {
            mark = true;
            return mark;
        }
        if (invalidDate > date.getTime()) {
            mark = true;
        }
        return mark;
    }

    private Integer getCount(Integer size) {
        return (this.limitCount + size - 1) / this.limitCount;
    }

    private List<Map<String, String>> getViewData(String modelCode, List<Map<String, String>> list) {
        ArrayList<Map<String, String>> dataList = new ArrayList<Map<String, String>>();
        for (Map<String, String> map : list) {
            HashMap<String, String> fileds = new HashMap<String, String>();
            for (String key : map.keySet()) {
                if (key.startsWith("D_")) {
                    fileds.put(key.substring(2), map.get(key));
                    continue;
                }
                fileds.put(key, map.get(key));
            }
            fileds.put("CIDP_TASK_UUID", RandomCodeUtil.generateTextCode((int)0, (int)6));
            dataList.add(fileds);
        }
        return dataList;
    }
}

