/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.utils;

import java.math.BigDecimal;

public class NumberUtil {
    public static BigDecimal notNull(BigDecimal big) {
        return null == big ? BigDecimal.ZERO : big;
    }

    public static Integer notNull(Integer big) {
        return null == big ? 0 : big;
    }

    public static Double cutTo4DigitFrom(Double num) {
        num = (double)Math.round(num * 10000.0) / 10000.0;
        return num;
    }

    public static int toNegative(Integer num) {
        if (num == null) {
            return 0;
        }
        return num > 0 ? -num.intValue() : num;
    }

    public static Double cutTo2DigitFrom(Double num) {
        num = (double)Math.round(num * 100.0) / 100.0;
        return num;
    }

    public static boolean isEqual(BigDecimal v1, BigDecimal v2) {
        if (NumberUtil.isBlack(v1) && NumberUtil.isBlack(v2)) {
            return true;
        }
        if (NumberUtil.isBlack(v1)) {
            return false;
        }
        if (NumberUtil.isBlack(v2)) {
            return false;
        }
        return v1.compareTo(v2) == 0;
    }

    public static Integer add(Integer ... v) {
        Integer total = 0;
        for (int i = 0; i < v.length; ++i) {
            total = total + (v[i] != null ? v[i] : 0);
        }
        return total;
    }

    public static BigDecimal add(BigDecimal ... v) {
        BigDecimal total = BigDecimal.ZERO;
        for (int i = 0; i < v.length; ++i) {
            BigDecimal bigDecimal = v[i];
            if (!NumberUtil.isNotBlack(bigDecimal)) continue;
            total = total.add(bigDecimal);
        }
        return total;
    }

    public static BigDecimal sub(BigDecimal ... v) {
        BigDecimal result = BigDecimal.ZERO;
        if (NumberUtil.isNotBlack(v[0])) {
            result = v[0];
        }
        if (v.length <= 1) {
            return result;
        }
        for (int i = 1; i < v.length; ++i) {
            BigDecimal bigDecimal = v[i];
            if (!NumberUtil.isNotBlack(bigDecimal)) continue;
            result = result.subtract(bigDecimal);
        }
        return result;
    }

    public static boolean isNotBlack(BigDecimal bd) {
        return !NumberUtil.isBlack(bd);
    }

    public static boolean isBlack(BigDecimal bd) {
        return bd == null || bd.compareTo(BigDecimal.ZERO) == 0;
    }

    public static BigDecimal mul(BigDecimal bd, double m) {
        if (bd == null || bd.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return bd.multiply(new BigDecimal(m + ""));
    }

    public static BigDecimal mul(BigDecimal bd, BigDecimal m) {
        if (bd == null || bd.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return bd.multiply(m);
    }

    public static BigDecimal mulAndRound(BigDecimal bd, BigDecimal m) {
        if (bd == null || bd.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return NumberUtil.round(NumberUtil.mul(bd, m));
    }

    public static BigDecimal round(BigDecimal v) {
        if (NumberUtil.isNotBlack(v)) {
            return NumberUtil.roundScale(v, 2);
        }
        return BigDecimal.ZERO;
    }

    public static BigDecimal roundScale(BigDecimal v, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        v = NumberUtil.notNull(v);
        return v.setScale(scale, 4);
    }
}

