/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.constant.enums.EmployeeStatusEnum;
import com.dtyunxi.tcbj.app.open.biz.constant.CommonConstant;
import com.dtyunxi.tcbj.app.open.biz.enums.AccountColumnEnum;
import com.dtyunxi.tcbj.app.open.biz.enums.CustomerMaterialRelEnum;
import com.dtyunxi.tcbj.app.open.biz.enums.DataDistributeRespEnum;
import com.dtyunxi.tcbj.app.open.biz.service.ICenterHandleService;
import com.dtyunxi.tcbj.app.open.biz.service.ICustomerSalesmanRelationService;
import com.dtyunxi.tcbj.app.open.dao.das.DataDistributeDas;
import com.dtyunxi.tcbj.app.open.dao.eo.CustomerSalesmanRelationEo;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.ModelInfoReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.DataDistributeRespDto;
import com.dtyunxi.tcbj.center.openapi.api.enums.ModelCodeEnum;
import com.dtyunxi.util.Base64;
import com.dtyunxi.util.RandomCodeUtil;
import com.dtyunxi.yundt.cube.center.customer.api.ICsRCustomerSalesmanApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.ICustomerApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.ICustomerSalesmanApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSalesmanReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.RCustomerSalesmanRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerSalesmanQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CsRCustomerSalesmanReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.ICsRCustomerSalesmanQueryApi;
import com.dtyunxi.yundt.cube.center.identity.api.ITokenApi;
import com.dtyunxi.yundt.cube.center.identity.api.IUserLoginConfigApi;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.UserLoginConfigReqDto;
import com.dtyunxi.yundt.cube.center.user.api.IEmployeeApi;
import com.dtyunxi.yundt.cube.center.user.api.IEmployeeExpandApi;
import com.dtyunxi.yundt.cube.center.user.api.IOrganizationApi;
import com.dtyunxi.yundt.cube.center.user.api.ISecurityApi;
import com.dtyunxi.yundt.cube.center.user.api.IUserApi;
import com.dtyunxi.yundt.cube.center.user.api.IUserOrgExpandApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.EmployeeOrgRelationReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationInfoDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.RoleDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeAddReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeExtReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeModifyReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeOrgRelationExtReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAndOrgInfoReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserOrgRelationReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.EmployeeRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvDetailRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IEmployeeQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryExtApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="centerHandleAccountImpl")
public class CenterHandleAccountImpl
implements ICenterHandleService {
    private static Logger logger = LoggerFactory.getLogger(CenterHandleAccountImpl.class);
    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IEmployeeQueryApi employeeQueryApi;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IUserQueryApi userQueryApi;
    @Autowired
    private IOrganizationQueryExtApi organizationQueryExtApi;
    @Autowired
    private IOrganizationApi organizationApi;
    @Autowired
    private ICustomerQueryApi customerQueryApi;
    @Autowired
    private IUserLoginConfigApi userLoginConfigApi;
    @Autowired
    private ISecurityApi securityApi;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private ICustomerApi customerApi;
    @Resource
    private ITokenApi tokenApi;
    @Resource
    private ICustomerSalesmanRelationService customerSalesmanRelationService;
    @Autowired
    private DataDistributeDas dataDistributeDas;
    @Autowired
    private ICustomerSalesmanQueryApi customerSalesmanQueryApi;
    @Autowired
    private ICacheService cacheService;
    @Autowired
    private ICustomerSalesmanApi customerSalesmanApi;
    @Autowired
    private IEmployeeExpandApi employeeExpandApi;
    @Autowired
    private IUserOrgExpandApi userOrgExpandApi;
    @Resource
    private ICsRCustomerSalesmanApi csRCustomerSalesmanApi;
    @Resource
    private ICsRCustomerSalesmanQueryApi csRCustomerSalesmanQueryApi;

    @Override
    public String getModelType() {
        return ModelCodeEnum.OUTSIDER.name();
    }

    @Override
    public List<DataDistributeRespDto> handle(ModelInfoReqDto modelInfoReqDto) {
        logger.info("\u8d26\u6237\u6570\u636e\u540c\u6b65\u5f00\u59cb:{}", (Object)JSONObject.toJSONString((Object)modelInfoReqDto));
        List list = JSONObject.parseArray((String)modelInfoReqDto.getDataStr(), Map.class);
        ArrayList<DataDistributeRespDto> responseList = new ArrayList<DataDistributeRespDto>();
        for (Map map : list) {
            try {
                Long userId = 0L;
                if (StringUtils.isNotEmpty((CharSequence)((CharSequence)map.get(AccountColumnEnum.USER_ID.name())))) {
                    String dateStr;
                    userId = this.handleAccount(map);
                    Long orgId = this.handleOrg(map, userId);
                    ArrayList<Long> orgIds = new ArrayList<Long>();
                    orgIds.add(orgId);
                    UserOrgRelationReqDto userOrgRelationReqDto = new UserOrgRelationReqDto();
                    userOrgRelationReqDto.setUserId(userId);
                    userOrgRelationReqDto.setOrgIds(orgIds);
                    userOrgRelationReqDto.setInstanceId(CommonConstant.INSTANCE_ID);
                    userOrgRelationReqDto.setTenantId(CommonConstant.TENANT_ID);
                    this.organizationApi.addUserOrgRelation(userOrgRelationReqDto);
                    logger.info("\u8d26\u6237\u4e0e\u79df\u6237\u7684\u5173\u7cfb:orgId={}, {}", (Object)orgId, (Object)JSONObject.toJSONString((Object)userOrgRelationReqDto));
                    if (ObjectUtils.isNotEmpty(map.get(AccountColumnEnum.ENDDATE.name())) && new Date(Long.parseLong(dateStr = String.valueOf(map.get(AccountColumnEnum.ENDDATE.name())).replace(".0", ""))).before(new Date())) {
                        this.organizationApi.deleteUserOrgRelation(userOrgRelationReqDto);
                    }
                    this.ywyProcessor(map, userId, orgId);
                }
                Long employeeId = this.handleEmployee(map, userId);
                this.handleEmployeeOrgRelation(map, employeeId);
                this.handelCustomerSalesmanRelation(map);
                responseList.add(this.dataResp(map.get(CustomerMaterialRelEnum.CIDP_TASK_UUID.name()) == null ? RandomCodeUtil.generateTextCode((int)10, (int)0) : (String)map.get(CustomerMaterialRelEnum.CIDP_TASK_UUID.name()), DataDistributeRespEnum.SUCCESS.getCode(), DataDistributeRespEnum.SUCCESS.getValue()));
            }
            catch (Exception e) {
                logger.info("\u8d26\u6237\u6570\u636e\u5904\u7406\u5f02\u5e38:{}  [{}]", (Object)map, (Object)e);
                responseList.add(this.dataResp(map.get(CustomerMaterialRelEnum.CIDP_TASK_UUID.name()) == null ? RandomCodeUtil.generateTextCode((int)10, (int)0) : (String)map.get(CustomerMaterialRelEnum.CIDP_TASK_UUID.name()), DataDistributeRespEnum.FAILURE.getCode(), e.getMessage()));
            }
        }
        logger.info("\u8d26\u6237\u6570\u636e\u540c\u6b65\u7ed3\u675f:{}", (Object)JSONObject.toJSONString(responseList));
        return responseList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ywyProcessor(Map<String, String> map, Long userId, Long orgId) {
        CustomerSalesmanReqDto reqDto = new CustomerSalesmanReqDto();
        reqDto.setUserId(userId);
        reqDto.setOrgInfoId(orgId);
        reqDto.setStatus(this.getSalesmanStatus(map));
        try {
            this.customerSalesmanApi.updateStatus(reqDto);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (reqDto.getStatus() == 0) {
                this.tokenApi.deleteToken(String.valueOf(userId));
            }
        }
    }

    private Integer getSalesmanStatus(Map<String, String> map) {
        try {
            return Optional.ofNullable(String.valueOf(map.get(AccountColumnEnum.ENDDATE.name()))).map(s -> s.replace(".0", "")).map(s -> new Date(Long.parseLong(s)).after(new Date()) ? 1 : 0).orElse(1);
        }
        catch (Exception e) {
            logger.error("\u65f6\u95f4\u8f6c\u6362\u5931\u8d25:{}", (Object)e.getMessage());
            return 1;
        }
    }

    private void handelCustomerSalesmanRelation(Map<String, String> map) {
        try {
            logger.info("\u6279\u91cf\u540c\u6b65\u4e1a\u52a1\u5458\u4e0e\u5c0fb\u5173\u8054\u5173\u7cfb");
            if (StringUtils.isNotBlank((CharSequence)map.get(AccountColumnEnum.ACCOUNT.name()))) {
                String phone = map.get(AccountColumnEnum.PHONENUMBER.name());
                String orgId = map.get(AccountColumnEnum.ORG_ID.name());
                if (StringUtils.isEmpty((CharSequence)phone)) {
                    logger.info("\u540c\u6b65\u4eba\u5458\u6570\u636e\uff0c\u624b\u673a\u53f7\u4e3a\u7a7a");
                    return;
                }
                if (StringUtils.isEmpty((CharSequence)orgId)) {
                    logger.info("\u540c\u6b65\u4eba\u5458\u6570\u636e\uff0c\u7ec4\u7ec7ID\u4e3a\u7a7a");
                    return;
                }
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("LOGIN", phone);
                params.put("ORG_ID", orgId);
                List salesManViews = this.dataDistributeDas.selectViewData("SALES_MAN_RELATION", params, "", Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE));
                PageInfo user = (PageInfo)this.userQueryApi.queryUser(Long.valueOf(1L), null, phone, null, null, Integer.valueOf(1), Integer.valueOf(1)).getData();
                List tenantDto = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryByThirdPartyIds((List)Lists.newArrayList((Object[])new String[]{orgId})));
                if (CollectionUtils.isEmpty((Collection)tenantDto)) {
                    logger.info("customer info is not exit , {} .", (Object)orgId);
                    return;
                }
                if (!CollectionUtils.isEmpty((Collection)salesManViews) && user != null && !CollectionUtils.isEmpty((Collection)user.getList())) {
                    List thirdPartyIds = salesManViews.stream().map(m -> (String)m.get("DEALERID")).collect(Collectors.toList());
                    logger.info("\u5df2\u5206\u914d\u7684\u5ba2\u6237\u5173\u7cfb : {} ", (Object)JSONObject.toJSONString(thirdPartyIds));
                    if (CollectionUtils.isEmpty(thirdPartyIds)) {
                        return;
                    }
                    List customerRespDtos = (List)this.customerQueryApi.queryByThirdPartyIds(thirdPartyIds).getData();
                    if (!CollectionUtils.isEmpty((Collection)customerRespDtos)) {
                        List rCustomerSalesmanRespDtos;
                        List customerIds = customerRespDtos.stream().map(BaseRespDto::getId).collect(Collectors.toList());
                        logger.info("customerIds\u6570\u636e:{}", (Object)JSONObject.toJSONString(customerIds));
                        CsRCustomerSalesmanReqDto csRCustomerSalesmanReqDto = new CsRCustomerSalesmanReqDto();
                        csRCustomerSalesmanReqDto.setSalesmanId(((UserDto)user.getList().get(0)).getId());
                        csRCustomerSalesmanReqDto.setOrgId(((CustomerRespDto)tenantDto.stream().findFirst().get()).getOrgInfoId());
                        List salesmanRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.csRCustomerSalesmanQueryApi.queryCustomerSalesman(csRCustomerSalesmanReqDto));
                        if (!CollectionUtils.isEmpty((Collection)salesmanRespDtos) && !CollectionUtils.isEmpty(rCustomerSalesmanRespDtos = salesmanRespDtos.stream().filter(s -> !customerIds.contains(s.getCustomerId())).collect(Collectors.toList()))) {
                            List ids = rCustomerSalesmanRespDtos.stream().map(RCustomerSalesmanRespDto::getId).collect(Collectors.toList());
                            logger.info("\u5df2\u89e3\u7ed1\u7684\u5ba2\u6237\u5173\u7cfb\u96c6\u5408 : {}", (Object)JSONObject.toJSONString(ids));
                            CsRCustomerSalesmanReqDto customerSalesmanReqDto = new CsRCustomerSalesmanReqDto();
                            customerSalesmanReqDto.setIds(ids);
                            this.csRCustomerSalesmanApi.removeCustomerSalesman(customerSalesmanReqDto);
                        }
                    }
                }
                CustomerSalesmanRelationEo customerSalesmanRelationEo = new CustomerSalesmanRelationEo();
                customerSalesmanRelationEo.setLogin(map.get(AccountColumnEnum.ACCOUNT.name()));
                customerSalesmanRelationEo.setOrgId(map.get(AccountColumnEnum.ORG_ID.name()));
                this.customerSalesmanRelationService.centerHandleCustomerSalesmanRelation(customerSalesmanRelationEo);
            }
        }
        catch (RuntimeException e) {
            logger.error("\u6279\u91cf\u540c\u6b65\u4e1a\u52a1\u5458\u4e0e\u5c0fb\u5173\u8054\u5173\u7cfb\u51fa\u9519:{}", (Throwable)e);
        }
    }

    private void handleEmployeeOrgRelation(Map<String, String> map, Long employeeId) {
        Long groupId = this.getEmployeeOrgId(map);
        EmployeeOrgRelationExtReqDto employeeOrgRelationExtReqDto = new EmployeeOrgRelationExtReqDto();
        employeeOrgRelationExtReqDto.setEmployeeId(employeeId);
        employeeOrgRelationExtReqDto.setOrganizationId(groupId);
        List empOrgList = (List)RestResponseHelper.extractData((RestResponse)this.employeeExpandApi.queryEmployeeOrgParam(employeeOrgRelationExtReqDto));
        if (CollectionUtils.isEmpty((Collection)empOrgList)) {
            EmployeeOrgRelationReqDto employeeOrgRelationReqDto = new EmployeeOrgRelationReqDto();
            employeeOrgRelationReqDto.setEmployeeId(employeeId);
            employeeOrgRelationReqDto.setOrgId(groupId);
            logger.info("\u5904\u7406\u4eba\u5458\u4e0e\u7ec4\u7ec7\u7684\u5173\u7cfb: employeeId={} , {}", (Object)employeeId, (Object)JSONObject.toJSONString((Object)employeeOrgRelationReqDto));
            this.organizationApi.addEmployeeOrgRelation(employeeOrgRelationReqDto);
        }
    }

    private Long getEmployeeOrgId(Map<String, String> map) {
        String personType = map.get(AccountColumnEnum.PERSONTYPE.name());
        if ("EXTERNAL".equals(personType.toUpperCase())) {
            return this.getCustomerId(map);
        }
        Long organizationId = this.getOrgId(map.get(AccountColumnEnum.PARTNER_ID.name()));
        logger.info("\u5927B\u8d26\u6237\u5bf9\u5e94\u7684\u79df\u6237: {}", (Object)organizationId);
        return organizationId;
    }

    private Long getCustomerId(Map<String, String> map) {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add(map.get(AccountColumnEnum.PARTNER_ID.name()));
        RestResponse response = this.customerQueryApi.queryByThirdPartyIds(list1);
        logger.info("\u5c0fB\u8d26\u6237\u5bf9\u5e94\u7684\u5ba2\u6237: {}", (Object)JSONObject.toJSONString((Object)response));
        if (!CollectionUtils.isEmpty((Collection)((Collection)response.getData()))) {
            return ((CustomerRespDto)((List)response.getData()).get(0)).getOrgInfoId();
        }
        return null;
    }

    private DataDistributeRespDto dataResp(String taskId, String type, String reason) {
        DataDistributeRespDto dataDistributeRespDto = new DataDistributeRespDto();
        dataDistributeRespDto.setTask_id(taskId);
        dataDistributeRespDto.setType(type);
        dataDistributeRespDto.setReason(reason);
        return dataDistributeRespDto;
    }

    private Long handleEmployee(Map<String, String> map, Long userId) {
        logger.info("\u5904\u7406\u4eba\u5458\uff0c \u8fd4\u56de\u4eba\u5458\u4fe1\u606f {}", map);
        EmployeeAddReqDto employeeAddReqDto = new EmployeeAddReqDto();
        String employeeNo = map.get(AccountColumnEnum.EMPNO.name());
        if (StringUtils.isEmpty((CharSequence)employeeNo)) {
            employeeNo = map.get(AccountColumnEnum.ROW_ID.name());
        }
        RestResponse employeeResponse = this.employeeQueryApi.queryByEmployeeNo(employeeNo);
        logger.info("\u67e5\u8be2\u4eba\u5458\u4fe1\u606f\uff1a{}, {}", (Object)employeeNo, (Object)JSONObject.toJSONString((Object)employeeResponse));
        EmployeeRespDto employeeRespDto = (EmployeeRespDto)employeeResponse.getData();
        employeeAddReqDto.setStatus(this.getSalesmanStatus(map));
        if (employeeRespDto != null && employeeRespDto.getId() != null) {
            EmployeeModifyReqDto employeeModifyReqDto = new EmployeeModifyReqDto();
            employeeModifyReqDto.setId(employeeRespDto.getId());
            employeeModifyReqDto.setName(map.get(AccountColumnEnum.FULLNAME.name()));
            employeeModifyReqDto.setEmployeeNo(employeeNo);
            employeeModifyReqDto.setPhoneNum(map.get(AccountColumnEnum.PHONENUMBER.name()));
            employeeModifyReqDto.setEmail(map.get(AccountColumnEnum.EMAIL.name()));
            if (StringUtils.isEmpty((CharSequence)employeeModifyReqDto.getEmail())) {
                employeeModifyReqDto.setEmail(employeeAddReqDto.getPhoneNum() + "@tcbj.com");
            }
            employeeAddReqDto.setStatus(this.getSalesmanStatus(map));
            employeeModifyReqDto.setUserId(userId);
            employeeModifyReqDto.setNickName(employeeModifyReqDto.getName());
            employeeModifyReqDto.setInstanceId(CommonConstant.INSTANCE_ID);
            employeeModifyReqDto.setTenantId(CommonConstant.TENANT_ID);
            employeeModifyReqDto.setYxyPartnerId(map.get(AccountColumnEnum.PARTNER_ID.name()));
            employeeModifyReqDto.setYxyOrgId(map.get(AccountColumnEnum.ORG_ID.name()));
            employeeModifyReqDto.setPersonType(map.get(AccountColumnEnum.PERSONTYPE.name()));
            try {
                String dateStr;
                if (ObjectUtils.isNotEmpty((Object)map.get(AccountColumnEnum.STARTDATE.name()))) {
                    dateStr = String.valueOf(map.get(AccountColumnEnum.STARTDATE.name())).replace(".0", "");
                    employeeModifyReqDto.setStartDate(new Date(Long.parseLong(dateStr)));
                }
                if (ObjectUtils.isNotEmpty((Object)map.get(AccountColumnEnum.ENDDATE.name()))) {
                    dateStr = String.valueOf(map.get(AccountColumnEnum.ENDDATE.name())).replace(".0", "");
                    employeeModifyReqDto.setEndDate(new Date(Long.parseLong(dateStr)));
                } else {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    Date date = sdf.parse("2199-01-01");
                    employeeModifyReqDto.setEndDate(date);
                }
                if (new Date().before(employeeModifyReqDto.getEndDate())) {
                    employeeModifyReqDto.setStatus(EmployeeStatusEnum.ENABLE.getCode());
                } else {
                    employeeModifyReqDto.setStatus(EmployeeStatusEnum.DISABLE.getCode());
                }
            }
            catch (Exception e) {
                logger.info("\u540c\u6b65\u4eba\u5458\u8d26\u53f7\u65e5\u671f\u89e3\u6790\u9519\u8bef:{}", (Object)e.getMessage());
            }
            this.employeeApi.modifyEmployee(employeeModifyReqDto);
            logger.info("\u66f4\u65b0\u4eba\u5458\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)employeeModifyReqDto));
            return employeeRespDto.getId();
        }
        employeeAddReqDto.setName(map.get(AccountColumnEnum.FULLNAME.name()));
        employeeAddReqDto.setEmployeeNo(employeeNo);
        employeeAddReqDto.setPhoneNum(map.get(AccountColumnEnum.PHONENUMBER.name()));
        employeeAddReqDto.setEmail(map.get(AccountColumnEnum.EMAIL.name()));
        if (StringUtils.isEmpty((CharSequence)employeeAddReqDto.getEmail())) {
            employeeAddReqDto.setEmail(employeeAddReqDto.getPhoneNum() + "@tcbj.com");
        }
        employeeAddReqDto.setUserId(userId);
        employeeAddReqDto.setNickName(employeeAddReqDto.getName());
        employeeAddReqDto.setInstanceId(CommonConstant.INSTANCE_ID);
        employeeAddReqDto.setTenantId(CommonConstant.TENANT_ID);
        try {
            String dateStr;
            if (ObjectUtils.isNotEmpty((Object)map.get(AccountColumnEnum.STARTDATE.name()))) {
                dateStr = String.valueOf(map.get(AccountColumnEnum.STARTDATE.name())).replace(".0", "");
                employeeAddReqDto.setStartDate(new Date(Long.parseLong(dateStr)));
            }
            if (ObjectUtils.isNotEmpty((Object)map.get(AccountColumnEnum.ENDDATE.name()))) {
                dateStr = String.valueOf(map.get(AccountColumnEnum.ENDDATE.name())).replace(".0", "");
                employeeAddReqDto.setEndDate(new Date(Long.parseLong(dateStr)));
            } else {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                Date date = sdf.parse("2199-01-01");
                employeeAddReqDto.setStartDate(date);
            }
            if (new Date().before(employeeAddReqDto.getEndDate())) {
                employeeAddReqDto.setStatus(EmployeeStatusEnum.ENABLE.getCode());
            } else {
                employeeAddReqDto.setStatus(EmployeeStatusEnum.DISABLE.getCode());
            }
        }
        catch (Exception e) {
            logger.info("\u540c\u6b65\u4eba\u5458\u8d26\u53f7\u65e5\u671f\u89e3\u6790\u9519\u8bef:{}", (Object)e.getMessage());
        }
        employeeAddReqDto.setYxyPartnerId(map.get(AccountColumnEnum.PARTNER_ID.name()));
        employeeAddReqDto.setYxyOrgId(map.get(AccountColumnEnum.ORG_ID.name()));
        employeeAddReqDto.setPersonType(map.get(AccountColumnEnum.PERSONTYPE.name()));
        RestResponse response = this.employeeApi.addEmployee(employeeAddReqDto);
        logger.info("\u65b0\u589e\u4eba\u5458\u4fe1\u606f, {} , {}", (Object)JSONObject.toJSONString((Object)employeeAddReqDto), (Object)JSONObject.toJSONString((Object)response));
        return (Long)response.getData();
    }

    private Long handleAccount(Map<String, String> map) {
        String loginStr = map.get(AccountColumnEnum.ACCOUNT.name());
        UserDto userDto = (UserDto)this.userQueryApi.queryByLoginStr(loginStr, CommonConstant.INSTANCE_ID, "").getData();
        logger.info("\u67e5\u8be2\u8d26\u53f7, {}", (Object)JSONObject.toJSONString((Object)userDto));
        boolean isUpdate = true;
        if (userDto == null) {
            isUpdate = false;
            userDto = new UserDto();
        }
        userDto.setUserName(loginStr);
        userDto.setExtension(map.get(AccountColumnEnum.USER_ID.name()));
        userDto.setNickName(map.get(AccountColumnEnum.USER_NAME.name()));
        userDto.setValidType(Integer.valueOf(1));
        userDto.setTenantId(CommonConstant.TENANT_ID);
        userDto.setInstanceId(CommonConstant.INSTANCE_ID);
        userDto.setPassword(Base64.encodeString((String)"ZJJK123456").replace("==", ""));
        userDto.setUserType(Integer.valueOf("SysAdmin".equals(map.get(AccountColumnEnum.ROLETYPE.name())) ? 11 : 1));
        String personType = map.get(AccountColumnEnum.PERSONTYPE.name());
        if ("INTERNAL".equalsIgnoreCase(personType)) {
            HashSet<RoleDto> roleSet = new HashSet<RoleDto>();
            RoleDto roleDto = new RoleDto();
            roleDto.setCode("tob-dealer-admin");
            roleDto.setId(CommonConstant.TOB_DEALER_ADMIN_ID);
            roleDto.setInstanceId(CommonConstant.TOB_DEALER_ADMIN_INSTANCE_ID);
            roleDto.setTenantId(CommonConstant.TENANT_ID);
            roleSet.add(roleDto);
            userDto.setRoleSet(roleSet);
        }
        if (isUpdate) {
            logger.info("\u66f4\u65b0\u8d26\u53f7, userid = {}, {}", (Object)userDto.getId(), (Object)JSONObject.toJSONString((Object)userDto));
            ServiceContext.getContext().setAttachment("yes.req.instanceId", CommonConstant.TOB_DEALER_ADMIN_INSTANCE_ID.toString());
            ServiceContext.getContext().setAttachment("yes.req.tenantId", CommonConstant.TENANT_ID.toString());
            RestResponse userResponse = this.userApi.update(userDto.getId(), userDto);
            ServiceContext.getContext().setAttachment("yes.req.instanceId", CommonConstant.INSTANCE_ID.toString());
            logger.info("\u66f4\u65b0\u8d26\u53f7\u8fd4\u56de\u4fe1\u606f, userid = {}, {}", (Object)userDto.getId(), (Object)JSONObject.toJSONString((Object)userResponse));
            RestResponse resetPasswordResponse = this.securityApi.resetPasswordByAdmin(userDto.getId(), userDto.getPassword());
            logger.info("\u91cd\u7f6e\u5bc6\u7801\u8fd4\u56de\u4fe1\u606f, userid = {}, {}", (Object)userDto.getId(), (Object)JSONObject.toJSONString((Object)resetPasswordResponse));
            this.handleOrgAdmin(map, userDto.getId());
            this.cacheMaintain(userDto, userDto.getId());
            return userDto.getId();
        }
        ServiceContext.getContext().setAttachment("yes.req.instanceId", CommonConstant.TOB_DEALER_ADMIN_INSTANCE_ID.toString());
        RestResponse longRestResponse1 = this.userApi.addUser(CommonConstant.INSTANCE_ID, userDto);
        ServiceContext.getContext().setAttachment("yes.req.instanceId", CommonConstant.INSTANCE_ID.toString());
        logger.info("\u65b0\u589e\u8d26\u53f7, userid = {}, {}", (Object)JSONObject.toJSONString((Object)longRestResponse1), (Object)JSONObject.toJSONString((Object)userDto));
        Long userId = (Long)longRestResponse1.getData();
        this.securityApi.resetPasswordByAdmin(userId, userDto.getPassword());
        UserLoginConfigReqDto userLoginConfigReqDto = new UserLoginConfigReqDto();
        userLoginConfigReqDto.setLoginConfig("1,2");
        userLoginConfigReqDto.setUserId(userId);
        RestResponse loginCoifg = this.userLoginConfigApi.putUserLoginConfig(userId, userLoginConfigReqDto);
        this.handleOrgAdmin(map, userDto.getId());
        logger.info("\u7528\u6237\u767b\u5f55\u914d\u7f6e\u4fe1\u606f {} , {}", (Object)JSONObject.toJSONString((Object)loginCoifg), (Object)JSONObject.toJSONString((Object)userLoginConfigReqDto));
        this.cacheMaintain(userDto, userId);
        return userId;
    }

    private void cacheMaintain(UserDto userDto, Long id) {
        if (userDto.getUserType().equals(11)) {
            this.cacheService.hset("COMMON", "USER_ADMIN_KEY", id + "", (Object)1, 0);
        } else {
            this.cacheService.hdel("COMMON", "USER_ADMIN_KEY", new String[]{id + ""});
        }
    }

    private void handleOrgAdmin(Map<String, String> map, Long userId) {
        if (!"1".equals(map.get(AccountColumnEnum.ADMIN_USER.name()))) {
            return;
        }
        RestResponse restResponse = this.customerQueryApi.queryByThirdPartyIds((List)Lists.newArrayList((Object[])new String[]{map.get(AccountColumnEnum.PARTNER_ID.name())}));
        logger.info("\u67e5\u8be2\u5ba2\u6237\u662f\u5426\u5b58\u5728\uff1a{}", (Object)JSONObject.toJSONString((Object)restResponse));
        if (ObjectUtil.isNotEmpty((Object)restResponse.getData())) {
            CustomerReqDto customerReqDto = new CustomerReqDto();
            customerReqDto.setId(((CustomerRespDto)((List)restResponse.getData()).get(0)).getId());
            customerReqDto.setUserId(userId);
            customerReqDto.setName(((CustomerRespDto)((List)restResponse.getData()).get(0)).getName());
            customerReqDto.setCode(((CustomerRespDto)((List)restResponse.getData()).get(0)).getCode());
            logger.info("\u4fee\u6539\u5ba2\u6237\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)customerReqDto));
            RestResponse customerRespone = this.customerApi.update(customerReqDto);
            logger.info("\u4fee\u6539\u5ba2\u6237\uff1a{}", (Object)JSONObject.toJSONString((Object)customerRespone));
        } else {
            logger.info("\u7ba1\u7406\u5458{} \u6ca1\u6709\u5bf9\u5e94\u7684\u5ba2\u6237\u4fe1\u606f, cs_customer\u8868", (Object)userId);
        }
    }

    private Long handleOrg(Map<String, String> map, Long userId) {
        logger.info("\u5904\u7406\u79df\u6237\uff0c \u8fd4\u56de\u79df\u6237id {}", map);
        String personType = map.get(AccountColumnEnum.PERSONTYPE.name());
        if ("EXTERNAL".equalsIgnoreCase(personType)) {
            Long orgId = this.getCustomerId(map);
            RestResponse orgResponse = this.organizationQueryExtApi.queryById(orgId);
            if (orgResponse.getData() != null) {
                return ((OrgAdvDetailRespDto)orgResponse.getData()).getId();
            }
            return null;
        }
        String orgCode = map.get(AccountColumnEnum.ORG_ID.name());
        Long orgId = this.getOrgId(orgCode);
        if (orgId != null) {
            return orgId;
        }
        OrgAndOrgInfoReqDto orgAdvAddReqDto = new OrgAndOrgInfoReqDto();
        OrganizationDto organizationDto = new OrganizationDto();
        organizationDto.setCode(orgCode);
        OrganizationInfoDto organizationInfoDto = new OrganizationInfoDto();
        organizationInfoDto.setOrgCode(orgCode);
        organizationInfoDto.setUserId(userId);
        orgAdvAddReqDto.setOrganizationDto(organizationDto);
        orgAdvAddReqDto.setOrganizationInfoDto(organizationInfoDto);
        orgId = (Long)this.organizationApi.addOrgAndOrgInfo(orgAdvAddReqDto).getData();
        logger.info("\u65b0\u589e\u79df\u6237: organizationDto = {}, orgAdvAddReqDto = {}", (Object)JSONObject.toJSONString((Object)organizationDto), (Object)JSONObject.toJSONString((Object)orgAdvAddReqDto));
        return orgId;
    }

    public Long getOrgId(String code) {
        RestResponse organizationDtoRestResponse = this.organizationQueryApi.queryOneByOrgCode(null, code);
        if (organizationDtoRestResponse.getData() != null) {
            return ((OrganizationDto)organizationDtoRestResponse.getData()).getId();
        }
        return null;
    }

    private Long handleSynEmployee(Map<String, String> map, Long userId, Long orgId) {
        String departureTime;
        logger.info("\u4e3b\u6570\u636e\u540c\u6b65\u66f4\u65b0\u4eba\u5458\u4fe1\u606f {}", map);
        EmployeeExtReqDto addEmployeeDto = new EmployeeExtReqDto();
        String employeeNo = map.get(AccountColumnEnum.EMPNO.name());
        addEmployeeDto.setEmployeeNo(employeeNo);
        addEmployeeDto.setName(map.get(AccountColumnEnum.FULLNAME.name()));
        addEmployeeDto.setUserId(userId);
        addEmployeeDto.setNickName(addEmployeeDto.getName() + "_" + map.get(AccountColumnEnum.EMPNO.name()));
        addEmployeeDto.setPhoneNum(map.get(AccountColumnEnum.PHONENUMBER.name()));
        addEmployeeDto.setEmail(map.get(AccountColumnEnum.EMAIL.name()));
        if (StringUtils.isEmpty((CharSequence)addEmployeeDto.getEmail())) {
            addEmployeeDto.setEmail(addEmployeeDto.getPhoneNum() + "@tcbj.com");
        }
        addEmployeeDto.setStatus(this.getSalesmanStatus(map));
        addEmployeeDto.setOrganizationId(orgId);
        addEmployeeDto.setSex(map.get(AccountColumnEnum.MF.name()));
        String startTimeStr = String.valueOf(map.get(AccountColumnEnum.STARTDATE.name())).replace(".0", "");
        Date startTime = DateUtil.getToday();
        if (StringUtils.isNotEmpty((CharSequence)startTimeStr)) {
            startTime = new Date(Long.parseLong(startTimeStr));
        }
        addEmployeeDto.setStartTime(startTime);
        String endTimeStr = String.valueOf(map.get(AccountColumnEnum.ENDDATE.name())).replace(".0", "");
        Date endTime = null;
        if (StringUtils.isNotEmpty((CharSequence)endTimeStr)) {
            endTime = new Date(Long.parseLong(endTimeStr));
        }
        addEmployeeDto.setEndTime(endTime);
        addEmployeeDto.setIdCardNo(map.get(AccountColumnEnum.IDNUMBER.name()));
        String birthday = String.valueOf(map.get(AccountColumnEnum.BIRTHDATE.name()));
        if (StringUtils.isNotEmpty((CharSequence)birthday)) {
            addEmployeeDto.setBirthday(DateUtil.parseDate((String)birthday, (String)"yyyy-MM-dd"));
        }
        addEmployeeDto.setHomeTel(map.get(AccountColumnEnum.FAMILYPHONE.name()));
        addEmployeeDto.setFixedTel(map.get(AccountColumnEnum.PRIMARYPHONE.name()));
        addEmployeeDto.setExtTelNumber(map.get(AccountColumnEnum.EXTPHONE.name()));
        addEmployeeDto.setQq(map.get(AccountColumnEnum.QQ.name()));
        addEmployeeDto.setFax(map.get(AccountColumnEnum.FAXPHONE.name()));
        addEmployeeDto.setEducation(map.get(AccountColumnEnum.EDUCATIONALBG.name()));
        addEmployeeDto.setContactAddress(map.get(AccountColumnEnum.ADDRESS.name()));
        String entryTime = map.get(AccountColumnEnum.HIREDATE.name());
        if (StringUtils.isNotEmpty((CharSequence)entryTime)) {
            addEmployeeDto.setEntryTime(DateUtil.parseDate((String)entryTime, (String)"yyyy-MM-dd"));
        }
        if (StringUtils.isNotEmpty((CharSequence)(departureTime = String.valueOf(map.get(AccountColumnEnum.DIMISSIONDATE.name()))))) {
            addEmployeeDto.setDepartureTime(DateUtil.parseDate((String)departureTime, (String)"yyyy-MM-dd"));
        }
        addEmployeeDto.setPosition(map.get(AccountColumnEnum.ROLETYPENAME.name()));
        addEmployeeDto.setStaffId(map.get(AccountColumnEnum.ROW_ID.name()));
        addEmployeeDto.setInstanceId(CommonConstant.INSTANCE_ID);
        addEmployeeDto.setTenantId(CommonConstant.TENANT_ID);
        addEmployeeDto.setYxyPartnerId(map.get(AccountColumnEnum.PARTNER_ID.name()));
        addEmployeeDto.setYxyOrgId(map.get(AccountColumnEnum.ORG_ID.name()));
        addEmployeeDto.setPersonType(map.get(AccountColumnEnum.PERSONTYPE.name()));
        if (Objects.equals(addEmployeeDto.getPersonType(), "Internal")) {
            addEmployeeDto.setType(Integer.valueOf(1));
        } else {
            addEmployeeDto.setType(Integer.valueOf(0));
        }
        List employeeExtReqDtos = (List)RestResponseHelper.extractData((RestResponse)this.employeeExpandApi.batchSynSaveEmployee(Collections.singletonList(addEmployeeDto)));
        if (CollectionUtils.isEmpty((Collection)employeeExtReqDtos)) {
            logger.info("\u6279\u91cf\u66f4\u65b0\u4eba\u5458\u4fe1\u606f\u5931\u8d25");
            return null;
        }
        return ((EmployeeExtReqDto)employeeExtReqDtos.get(0)).getId();
    }
}

