/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.mq.dispatch.vo.ItemUpdatePriceVo;
import com.dtyunxi.tcbj.app.open.biz.service.ISellerSkuPriceService;
import com.dtyunxi.tcbj.app.open.dao.eo.MpPriceAdjustDetailEo;
import com.dtyunxi.tcbj.app.open.dao.eo.MpPriceAdjustDetailGroupEo;
import com.dtyunxi.tcbj.app.open.dao.eo.MpPriceAdjustEo;
import com.dtyunxi.tcbj.app.open.dao.eo.MpPricePackMainEo;
import com.dtyunxi.tcbj.app.open.dao.eo.MpProductVo;
import com.dtyunxi.tcbj.app.open.dao.eo.SellerSkuPriceEo;
import com.dtyunxi.tcbj.app.open.dao.mapper.MpPricePackMainMapper;
import com.dtyunxi.tcbj.app.open.dao.mapper.SellerSkuPriceMapper;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.api.ISellerSkuPriceApi;
import com.yx.tcbj.center.api.dto.response.ProductPriceRespDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@DS(value="slave_1")
public class SellerSkuPriceServiceImpl
implements ISellerSkuPriceService {
    private static final Logger log = LoggerFactory.getLogger(SellerSkuPriceServiceImpl.class);
    @Resource
    private ISellerSkuPriceApi sellerSkuPriceApi;
    @Resource
    private SellerSkuPriceMapper sellerSkuPriceMapper;
    @Resource
    private ISellerSkuPriceService sellerSkuPriceService;
    @Resource
    private MpPricePackMainMapper mpPricePackMainMapper;
    @Value(value="${customer.price.relation.pageSize:1000}")
    private Integer pageSize;

    @Override
    public List<MpProductVo> selectMpProductByOrgId(String organizationCode) {
        return this.sellerSkuPriceMapper.selectMpProductByOrgId(organizationCode);
    }

    @Override
    public List<MpPricePackMainEo> selectPricePackBySupplierId(ItemUpdatePriceVo itemUpdatePriceVo) {
        if (StringUtils.isNotEmpty((CharSequence)itemUpdatePriceVo.getLastUpdateTime())) {
            Date date = DateUtil.addHours((Date)DateUtil.parseDate((String)itemUpdatePriceVo.getLastUpdateTime(), (String)"yyyy-MM-dd HH:mm:ss"), (int)-2);
            itemUpdatePriceVo.setLastUpdateTime(DateUtil.getDateFormat((Date)date, (String)"yyyy-MM-dd HH:mm:ss"));
        }
        return this.mpPricePackMainMapper.selectPricePackBySupplierId(itemUpdatePriceVo.getTenantId(), itemUpdatePriceVo.getLastUpdateTime());
    }

    @Override
    public String syncSellerSkuPrice(ItemUpdatePriceVo itemUpdatePriceVo) {
        if (Objects.isNull(itemUpdatePriceVo.getTenantId())) {
            log.info("\u53c2\u6570\u65e0\u79df\u6237id");
            return "";
        }
        Integer pageNum = 1;
        List<SellerSkuPriceEo> sellerSkuPriceEo = this.sellerSkuPriceService.selectList(itemUpdatePriceVo, (pageNum - 1) * this.pageSize, pageNum * this.pageSize);
        while (CollectionUtils.isNotEmpty(sellerSkuPriceEo)) {
            this.handle(sellerSkuPriceEo);
            Integer n = pageNum;
            Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
            sellerSkuPriceEo = this.sellerSkuPriceService.selectList(itemUpdatePriceVo, (pageNum - 1) * this.pageSize, pageNum * this.pageSize);
        }
        return "";
    }

    private void handle(List<SellerSkuPriceEo> sellerSkuPriceEo) {
        ArrayList respProductPriceDto = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)respProductPriceDto, sellerSkuPriceEo, ProductPriceRespDto.class);
        this.sellerSkuPriceApi.updatePriceList((List)respProductPriceDto);
    }

    @Override
    public String addNewSellerSkuPrice(String easno) {
        String result = "";
        Integer success = 0;
        Integer fail = 0;
        List sellerSkuPriceEoList = this.sellerSkuPriceMapper.selectByEasNo(easno);
        List list = sellerSkuPriceEoList.stream().map(eo -> {
            ProductPriceRespDto productPriceRespDto = new ProductPriceRespDto();
            CubeBeanUtils.copyProperties((Object)productPriceRespDto, (Object)eo, (String[])new String[0]);
            return productPriceRespDto;
        }).collect(Collectors.toList());
        RestResponse resp = this.sellerSkuPriceApi.addNewPrice(list);
        if (!"0".equals(resp.getResultCode())) {
            log.info("\u4ea7\u54c1\u521d\u59cb\u5316\u4ef7\u683c\u5931\u8d25:{}", (Object)resp.getResultMsg());
            fail = fail + 1;
        } else {
            success = success + 1;
        }
        result = "\u65b0\u589e\u5546\u54c1\u540c\u6b65\u7ed3\u679c\uff1a\u4e00\u5171\u540c\u6b65:" + sellerSkuPriceEoList.size() + "\uff0c\u6210\u529f:" + success + "\uff0c\u5931\u8d25:" + fail;
        return result;
    }

    @Override
    public List<SellerSkuPriceEo> selectBySupplierId(String supplierId) {
        return this.sellerSkuPriceMapper.selectBySupplierId(supplierId);
    }

    @Override
    public List<SellerSkuPriceEo> selectList(ItemUpdatePriceVo itemUpdatePriceVo, int pageSize, int pageNum) {
        SellerSkuPriceEo sellerSkuPriceEo = new SellerSkuPriceEo();
        sellerSkuPriceEo.setSupplierId(itemUpdatePriceVo.getTenantId());
        if (StringUtils.isNotEmpty((CharSequence)itemUpdatePriceVo.getPartnerId())) {
            sellerSkuPriceEo.setApplierId(itemUpdatePriceVo.getPartnerId());
        }
        return this.sellerSkuPriceMapper.selectPriceList(sellerSkuPriceEo, itemUpdatePriceVo.getApplierIds(), itemUpdatePriceVo.getLastUpdateTime(), pageSize, pageNum);
    }

    @Override
    public List<SellerSkuPriceEo> selectListNoLimit(ItemUpdatePriceVo itemUpdatePriceVo) {
        SellerSkuPriceEo sellerSkuPriceEo = new SellerSkuPriceEo();
        sellerSkuPriceEo.setSupplierId(itemUpdatePriceVo.getTenantId());
        if (StringUtils.isNotEmpty((CharSequence)itemUpdatePriceVo.getPartnerId())) {
            sellerSkuPriceEo.setApplierId(itemUpdatePriceVo.getPartnerId());
        }
        if (StringUtils.isNotEmpty((CharSequence)itemUpdatePriceVo.getLastUpdateTime())) {
            Date date = DateUtil.addHours((Date)DateUtil.parseDate((String)itemUpdatePriceVo.getLastUpdateTime(), (String)"yyyy-MM-dd HH:mm:ss"), (int)-2);
            itemUpdatePriceVo.setLastUpdateTime(DateUtil.getDateFormat((Date)date, (String)"yyyy-MM-dd HH:mm:ss"));
        }
        return this.sellerSkuPriceMapper.selectPriceListNoLimit(sellerSkuPriceEo, itemUpdatePriceVo.getApplierIds(), itemUpdatePriceVo.getLastUpdateTime());
    }

    @Override
    public String syncCustomerAddress(ItemUpdatePriceVo itemUpdatePriceVo) {
        return null;
    }

    @Override
    public List<SellerSkuPriceEo> selectListBylogin(ItemUpdatePriceVo itemUpdatePriceVo) {
        return this.sellerSkuPriceMapper.selectListBylogin(itemUpdatePriceVo.getLogin(), itemUpdatePriceVo.getTenantId());
    }

    @Override
    public List<String> selectApplierIdsBySupplierId(String tenantId) {
        return this.sellerSkuPriceMapper.selectApplierIdsBySupplierId(tenantId);
    }

    @Override
    public List<MpPriceAdjustEo> selectMpPriceAdjustByOrgId(String organizationCode) {
        return this.sellerSkuPriceMapper.selectMpPriceAdjustByOrgId(organizationCode);
    }

    @Override
    public List<MpPriceAdjustDetailEo> selectMpPriceAdjustDetailByAdjustIds(List<String> adjustIdList) {
        return this.sellerSkuPriceMapper.selectMpPriceAdjustDetailByAdjustIds(adjustIdList);
    }

    @Override
    public List<MpPriceAdjustEo> selectMpPriceAdjustDetailCount(List<String> adjustIdList) {
        return this.sellerSkuPriceMapper.selectMpPriceAdjustDetailCount(adjustIdList);
    }

    @Override
    public List<MpPriceAdjustDetailGroupEo> selectAdjustDetailGroupEosBySku(String adjustId) {
        return this.sellerSkuPriceMapper.selectAdjustDetailGroupEosBySku(adjustId);
    }

    @Override
    public List<MpPriceAdjustDetailGroupEo> selectAdjustDetailGroupEos(String adjustId, String groupKey) {
        return this.sellerSkuPriceMapper.selectAdjustDetailGroupEos(adjustId, groupKey);
    }
}

