/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl.db;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.IterUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.constant.enums.CustomerTypeEnum;
import com.dtyunxi.tcbj.app.open.biz.config.MarketingCloudConfig;
import com.dtyunxi.tcbj.app.open.biz.dto.RequestBaseData;
import com.dtyunxi.tcbj.app.open.biz.dto.marketingcloud.RetunCustomerDto;
import com.dtyunxi.tcbj.app.open.biz.enums.AddressEnum;
import com.dtyunxi.tcbj.app.open.biz.enums.CustomerEnum;
import com.dtyunxi.tcbj.app.open.biz.enums.DataDistributeRespEnum;
import com.dtyunxi.tcbj.app.open.biz.mq.dispatch.processor.ItemUpdatePriceProcessor;
import com.dtyunxi.tcbj.app.open.biz.service.ICenterHandleService;
import com.dtyunxi.tcbj.app.open.biz.service.ICustomerSalesmanRelationService;
import com.dtyunxi.tcbj.app.open.biz.service.impl.CenterHandleCustomerAddressServiceImpl;
import com.dtyunxi.tcbj.app.open.biz.utils.HttpUtil;
import com.dtyunxi.tcbj.app.open.dao.das.DataDistributeDas;
import com.dtyunxi.tcbj.app.open.dao.das.OrganizationPartnerDas;
import com.dtyunxi.tcbj.app.open.dao.eo.CustomerSalesmanRelationEo;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.ModelInfoReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.DataDistributeRespDto;
import com.dtyunxi.tcbj.center.openapi.api.enums.ModelCodeEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.ICreditEntityApi;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditEntityDetailSaveReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditEntitySaveReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.EntityStatusEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.EntityTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.ICustomerCheckRelationApi;
import com.dtyunxi.yundt.cube.center.customer.api.ICustomerExtV3Api;
import com.dtyunxi.yundt.cube.center.customer.api.customer.ICustomerApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.AddressAddReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerTypeRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerAreaQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerTypeQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerReqExtDto;
import com.dtyunxi.yundt.cube.center.price.api.ISyncPriceDataApi;
import com.dtyunxi.yundt.cube.center.rebate.api.IBalanceApi;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.BalanceAddReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.BalanceQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.IGiftBalanceApi;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.GiftBalanceAddReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.query.IGiftBalanceQueryApi;
import com.dtyunxi.yundt.cube.center.rebate.api.query.IBalanceQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.ISellerApi;
import com.dtyunxi.yundt.cube.center.shop.api.IShopApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.IBasicConfigApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.BasicConfigEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.BasicConfigReqDto;
import com.dtyunxi.yundt.cube.center.user.api.IOrganizationExtApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAdvAddReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAdvModifyReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAdvQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvOpRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.demo.center.xx.api.ISellerExtendsApi;
import com.yx.demo.center.xx.api.dto.request.SellerBizStatusReqDto;
import com.yx.tcbj.center.customer.api.ICustomerExpandApi;
import com.yx.tcbj.center.customer.api.ICustomerExtThreeApi;
import com.yx.tcbj.center.customer.api.dto.request.AddressExtReqDto;
import com.yx.tcbj.center.rebate.api.IOfflineBalanceAccountApi;
import com.yx.tcbj.center.rebate.api.IReturnsQuotaAccountApi;
import com.yx.tcbj.center.rebate.api.dto.request.OfflineBalanceAccountReqDto;
import com.yx.tcbj.center.rebate.api.dto.request.ReturnsQuotaAccountReqDto;
import com.yx.tcbj.center.rebate.api.dto.response.OfflineBalanceAccountRespDto;
import com.yx.tcbj.center.rebate.api.enums.OfflineBalanceAccountEnum;
import com.yx.tcbj.center.rebate.api.query.IOfflineBalanceAccountQueryApi;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import liquibase.util.StringUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="centerHandleCustomerDBServiceImpl")
public class CenterHandleCustomerDBServiceImpl
implements ICenterHandleService {
    private static Logger logger = LoggerFactory.getLogger(CenterHandleCustomerDBServiceImpl.class);
    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    @Resource
    private ICustomerApi customerApi;
    @Resource
    private com.yx.tcbj.center.customer.api.query.ICustomerQueryApi customerQueryApi;
    @Resource
    private ICustomerCheckRelationApi customerCheckRelationApi;
    @Resource
    private ICustomerQueryApi iCustomerQueryApi;
    @Resource
    private CenterHandleCustomerAddressServiceImpl centerHandleCustomerAddressService;
    @Resource
    private ICustomerTypeQueryApi customerTypeQueryApi;
    @Resource
    private ICustomerAreaQueryApi customerAreaQueryApi;
    @Resource
    private IShopApi shopApi;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource
    private ISellerApi sellerApi;
    @Resource
    private ISellerQueryApi sellerQueryApi;
    @Resource
    private IOrganizationExtApi organizationExtApi;
    @Resource
    private ICustomerExtV3Api customerExtV3Api;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private ICustomerExpandApi customerExpandApi;
    @Resource
    private RequestBaseData requestBaseData;
    @Resource
    private MarketingCloudConfig marketingCloudConfig;
    @Resource
    private HttpUtil httpUtil;
    @Value(value="${level.name}")
    private String level;
    @Value(value="${customer.orgIdUrl}")
    private String orgIdUrl;
    @Value(value="${customerLevel.max}")
    private Long customerLevelMax;
    @Value(value="${customerLevel.min}")
    private Long customerLevelMin;
    @Value(value="${publishCustomerSyncUpd.topic:PUBLISH-CUSTOMER-SYNC-UPD-TOPIC}")
    private String publishCustomerUpdTopic;
    @Value(value="${publishCustomerSyncUpd.tag:PUBLISH-CUSTOMER-SYNC-UPD-TAG}")
    private String publishCustomerUpdTag;
    @Resource
    private ICacheService cacheService;
    @Resource
    private IReturnsQuotaAccountApi returnsQuotaAccountApi;
    @Resource
    private IGiftBalanceApi giftBalanceApi;
    @Resource
    private IGiftBalanceQueryApi giftBalanceQueryApi;
    @Resource
    private IBalanceApi balanceApi;
    @Resource
    private DataDistributeDas dataDistributeDas;
    @Resource
    private IBalanceQueryApi balanceQueryApi;
    @Resource
    private IBasicConfigApi basicConfigApi;
    @Resource
    private ICustomerSalesmanRelationService customerSalesmanRelationService;
    @Resource
    private ICreditEntityApi creditEntityApi;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IOfflineBalanceAccountApi offlineBalanceAccountApi;
    @Resource
    private IOfflineBalanceAccountQueryApi offlineBalanceAccountQueryApi;
    @Resource
    private ItemUpdatePriceProcessor itemUpdatePriceProcessor;
    @Resource
    private ISyncPriceDataApi syncPriceDataApi;
    @Resource
    private ISellerExtendsApi sellerExtendsApi;
    @Resource
    private OrganizationPartnerDas organizationPartnerDas;
    private static final String DEALER = "\u79df\u6237";
    private static final String FIRST_DEALER = "1P\u7ecf\u9500\u5546";
    private static final Long DEFAULT_ORG_PARENT_ID = 1252411810853067012L;
    private static final Long CUSTOMER_STATUS_ID = 1256288005151458333L;
    private static final Long CUSTOMER_STATUS_ID_EXPIRE = 1256288052502004816L;
    private static final String ORG_ID = "orgId";
    private static final String PARENT_ORG_ID = "parentOrgId";
    private static final Long DIVISION_TCBJ = 1000000000000000001L;
    private static final Long DIVISION_JLD = 1000000000000000002L;
    private static final Long DIVISION_LIFE_SPACE = 1000000000000000003L;
    private static final String DIVISION_JLD_ORG_ID = "1-8GDRG";
    private static final String DIVISION_LIFE_SPACE_ORG_ID = "241ae7b5ce2142a78e7c6fe14d3587c0";
    private static final Long CUSTOMER_STATUS_ID_FREEZE = 1256288052502004817L;
    @Resource
    private ICustomerExtThreeApi customerExtThreeApi;
    private final ExecutorService executorService = new ThreadPoolExecutor(2, 10, 1L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(5, true), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());

    @Override
    public String getModelType() {
        return ModelCodeEnum.MP_CX_AWK_PARTNER.name();
    }

    @Override
    public List<DataDistributeRespDto> handle(ModelInfoReqDto modelInfoReqDto) {
        Long startTime = System.currentTimeMillis();
        logger.info("\u5ba2\u6237\u6570\u636e\u540c\u6b65\u5f00\u59cb:{}", (Object)JSONObject.toJSONString((Object)modelInfoReqDto));
        HashSet customerSalesmanRelationEoList = new HashSet();
        List respDtos = Optional.ofNullable(JSONObject.parseArray((String)modelInfoReqDto.getDataStr(), Map.class)).map(list -> list.stream().map(map -> {
            try {
                return this.getDataDistributeRespDto(customerSalesmanRelationEoList, (Map)map);
            }
            catch (Exception e) {
                e.printStackTrace();
                DataDistributeRespDto dataDistributeRespDto = new DataDistributeRespDto();
                dataDistributeRespDto.setType(DataDistributeRespEnum.FAILURE.getCode());
                dataDistributeRespDto.setReason(e.getMessage());
                return dataDistributeRespDto;
            }
        }).collect(Collectors.toList())).orElse(new ArrayList(0));
        Long endTime = System.currentTimeMillis();
        String reqId = ServiceContext.getContext().get("yes.req.requestId").toString();
        this.executorService.execute(new Thread(() -> {
            MDC.put((String)"yes.req.requestId", (String)reqId);
            ServiceContext.getContext().setAttachment("yes.req.requestId", reqId);
            MDC.put((String)"yes.req.userCode", (String)"csp-sync");
            ServiceContext.getContext().set("yes.req.userCode", (Object)"csp-sync");
            logger.info("\u5f02\u6b65\u5904\u7406\u4e1a\u52a1\u5458\u548c\u5c0fb\u7684\u5173\u7cfb");
            this.dealWithCustomerSalseMan(Lists.newArrayList((Iterable)customerSalesmanRelationEoList));
        }));
        logger.info("\u5ba2\u6237\u6570\u636e\u540c\u6b65\u7ed3\u675f:{}, \u8017\u65f6:{}", (Object)JSONObject.toJSONString((Object)respDtos), (Object)((endTime - startTime) / 1000L + "s"));
        return respDtos;
    }

    private DataDistributeRespDto getDataDistributeRespDto(Set<CustomerSalesmanRelationEo> customerSalesmanRelationEoList, Map map) {
        DataDistributeRespDto dataDistributeRespDto = new DataDistributeRespDto();
        dataDistributeRespDto.setType(DataDistributeRespEnum.SUCCESS.getCode());
        dataDistributeRespDto.setReason("\u5ba2\u6237id\u4e3a:" + map.get(CustomerEnum.ROW_ID.getCode()) + "\u5ba2\u6237" + DataDistributeRespEnum.SUCCESS.getValue());
        try {
            logger.info("============\u300b map = \uff1a{}", (Object)JSONObject.toJSONString((Object)map, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            dataDistributeRespDto.setTask_id(String.valueOf(map.get(CustomerEnum.CIDP_TASK_UUID.getCode())));
            logger.info("====================\u300b \u5904\u7406\u79df\u6237(\u7ec4\u7ec7)\uff0c\u5e76\u8fd4\u56de\u79df\u6237id");
            Map<String, Long> orgMap = this.handleOrg(map);
            RestResponse restResponse = this.customerQueryApi.queryByThirdPartyIds((List)Lists.newArrayList((Object[])new String[]{(String)map.get(CustomerEnum.ROW_ID.getCode())}));
            if (ObjectUtil.isNotEmpty((Object)restResponse.getData()) && ObjectUtil.isNotEmpty(((List)restResponse.getData()).get(0)) && CUSTOMER_STATUS_ID_FREEZE.equals(((CustomerRespDto)((List)restResponse.getData()).get(0)).getStatusId())) {
                dataDistributeRespDto.setReason("\u5ba2\u6237id\u4e3a:" + map.get(CustomerEnum.ROW_ID.getCode()) + "\u7684\u4fe1\u606f:\u5c0fB\u5546\u57ce\u5df2\u5c06\u5ba2\u6237\u72b6\u6001\u7f6e\u4e3a\u51bb\u7ed3\uff0c\u4e0d\u5141\u8bb8\u4efb\u4f55\u4fee\u6539");
                return dataDistributeRespDto;
            }
            MDC.put((String)"yes.req.userCode", (String)"csp-sync");
            ServiceContext.getContext().set("yes.req.userCode", (Object)"csp-sync");
            logger.info("====================\u300b \u5904\u7406\u5ba2\u6237");
            CustomerReqDto customer = this.handleCustomer(map, orgMap.get(ORG_ID), orgMap.get(PARENT_ORG_ID));
            logger.info("====================\u300b \u5904\u7406\u5927B\u5356\u5bb6, \u5e97\u94fa");
            this.handleSellerShop(map, orgMap.get(ORG_ID));
            logger.info("====================\u300b \u65b0\u589e\u514d\u8d39\u8d60\u54c1\u989d\u5ea6\u8d26\u6237");
            this.createGiftBalance(customer);
            logger.info("====================\u300b \u65b0\u589e\u8fd4\u5229\u8d26\u6237");
            this.createBalance(customer);
            logger.info("====================\u300b \u65b0\u589e\u4f59\u989d\u8d26\u6237");
            this.createBalanceAccount(customer);
            if (map.get(CustomerEnum.LEVELNAME.getCode()).equals(FIRST_DEALER)) {
                CustomerSalesmanRelationEo customerSalesmanRelationEo = new CustomerSalesmanRelationEo();
                customerSalesmanRelationEo.setOrgId(String.valueOf(map.get(CustomerEnum.MASTER_OU_ID.getCode()) == null ? "" : map.get(CustomerEnum.MASTER_OU_ID.getCode())));
                customerSalesmanRelationEo.setDealerId(String.valueOf(map.get(CustomerEnum.ROW_ID.getCode()) == null ? "" : map.get(CustomerEnum.ROW_ID.getCode())));
                customerSalesmanRelationEoList.add(customerSalesmanRelationEo);
            }
            logger.info("====================\u300b \u5904\u7406\u4eba\u5e97\u8003\u6838\u5173\u7cfb");
            this.extractedDisableRelation(customer);
        }
        catch (Exception e) {
            logger.info("\u540c\u6b65\u5ba2\u6237\u5f02\u5e38:{}", (Object)e.getMessage());
            dataDistributeRespDto.setType(DataDistributeRespEnum.FAILURE.getCode());
            dataDistributeRespDto.setReason("\u5ba2\u6237id\u4e3a:" + map.get(CustomerEnum.ROW_ID.getCode()) + "\u7684\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
        }
        return dataDistributeRespDto;
    }

    private void extractedDisableRelation(CustomerReqDto customer) {
        if (CustomerTypeEnum.DEALER.getCode().equals(customer.getType()) && CUSTOMER_STATUS_ID_EXPIRE.equals(customer.getStatusId())) {
            RestResponseHelper.extractData((RestResponse)this.customerCheckRelationApi.disableRelationByOrgId(String.valueOf(customer.getOrgInfoId())));
        }
    }

    private void dealWithCustomerSalseMan(List<CustomerSalesmanRelationEo> customerSalesmanRelationEoList) {
        customerSalesmanRelationEoList.forEach(customerSalesmanRelationEo -> this.customerSalesmanRelationService.centerHandleCustomerSalesmanRelation((CustomerSalesmanRelationEo)customerSalesmanRelationEo));
    }

    private void createReturnsQuotaAccount(Long customerId) {
        ReturnsQuotaAccountReqDto reqDto = new ReturnsQuotaAccountReqDto();
        reqDto.setCustomerId(customerId);
        reqDto.setGeneralReturnsQuota(BigDecimal.valueOf(0L));
        reqDto.setAdvanceQuota(BigDecimal.valueOf(0L));
        reqDto.setAdvanceUnbackQuota(BigDecimal.valueOf(0L));
        reqDto.setTenantId(this.requestBaseData.getTenantId());
        reqDto.setInstanceId(this.requestBaseData.getInstanceId());
        logger.info("\u65b0\u589e\u9000\u8d27\u989d\u5ea6\u8d26\u6237 \uff1a{}", (Object)JSONObject.toJSONString((Object)reqDto));
        this.returnsQuotaAccountApi.addReturnsQuotaAccount(reqDto);
    }

    private void createGiftBalance(CustomerReqDto customer) {
        com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.BalanceQueryReqDto reqDto = new com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.BalanceQueryReqDto();
        reqDto.setCustomerId(customer.getId());
        RestResponse response = this.giftBalanceQueryApi.queryByCustomerId(reqDto);
        logger.info("\u514d\u8d39\u8d60\u54c1\u989d\u5ea6\u8d26\u6237 {}", (Object)JSONObject.toJSONString((Object)response.getData()));
        if (!this.isEmpty(response.getData())) {
            logger.info("\u514d\u8d39\u8d60\u54c1\u989d\u5ea6\u8d26\u6237\u5b58\u5728\uff0c {}", (Object)JSONObject.toJSONString((Object)response.getData()));
            return;
        }
        GiftBalanceAddReqDto settingReqDto = new GiftBalanceAddReqDto();
        settingReqDto.setCustomerId(customer.getId());
        settingReqDto.setCustomerCode(customer.getCode());
        settingReqDto.setCustomerName(customer.getName());
        settingReqDto.setOrganizationId(customer.getMerchantId());
        settingReqDto.setBalance(BigDecimal.valueOf(0L));
        logger.info("\u65b0\u589e\u514d\u8d39\u8d60\u54c1\u989d\u5ea6\u8d26\u6237 : {}", (Object)JSONObject.toJSONString((Object)settingReqDto));
        this.giftBalanceApi.add(settingReqDto);
    }

    private void createBalance(CustomerReqDto customer) {
        BalanceQueryReqDto reqDto = new BalanceQueryReqDto();
        reqDto.setUserId(customer.getId());
        reqDto.setOrganizationId(customer.getMerchantId());
        PageInfo pageInfo = (PageInfo)this.balanceQueryApi.queryBalanceByPage(reqDto, Integer.valueOf(1), Integer.valueOf(10)).getData();
        logger.info("\u67e5\u8be2\u8fd4\u5229\u8d26\u6237\u8fd4\u56de\u4fe1\u606f\uff1a {}", (Object)JSONObject.toJSONString((Object)pageInfo));
        if (ObjectUtils.isNotEmpty((Object)pageInfo)) {
            logger.info("==========================> \u8fd4\u5229\u8d26\u6237\u5df2\u5b58\u5728!");
            return;
        }
        BalanceAddReqDto balanceAddReqDto = new BalanceAddReqDto();
        balanceAddReqDto.setUserId(customer.getId());
        balanceAddReqDto.setUserName(customer.getName());
        balanceAddReqDto.setOrganizationId(customer.getMerchantId());
        balanceAddReqDto.setUserType("CUSTOMER");
        balanceAddReqDto.setBalance(BigDecimal.ZERO);
        balanceAddReqDto.setBelongTo("-1");
        balanceAddReqDto.setInstanceId(this.requestBaseData.getInstanceId());
        balanceAddReqDto.setTenantId(this.requestBaseData.getTenantId());
        logger.info("\u65b0\u589e\u8fd4\u5229\u8d26\u6237\u5165\u53c2 : {}", (Object)JSONObject.toJSONString((Object)balanceAddReqDto));
        this.balanceApi.addBalance(balanceAddReqDto);
    }

    private void createBalanceAccount(CustomerReqDto customer) {
        OfflineBalanceAccountRespDto offlineBalanceAccountRespDto = (OfflineBalanceAccountRespDto)RestResponseHelper.extractData((RestResponse)this.offlineBalanceAccountQueryApi.queryByCustomerId(customer.getId()));
        if (Objects.nonNull(offlineBalanceAccountRespDto) && Objects.nonNull(offlineBalanceAccountRespDto.getId())) {
            logger.info("\u7ebf\u4e0b\u4f59\u989d\u8d26\u6237\u5df2\u5b58\u5728={}", (Object)JSONObject.toJSONString((Object)offlineBalanceAccountRespDto));
            return;
        }
        OfflineBalanceAccountReqDto balanceAddReqDto = new OfflineBalanceAccountReqDto();
        balanceAddReqDto.setCustomerId(customer.getId());
        balanceAddReqDto.setCustomerName(customer.getName());
        balanceAddReqDto.setMerchantId(customer.getMerchantId());
        balanceAddReqDto.setCustomerCode(customer.getCode());
        balanceAddReqDto.setAccountBalance(BigDecimal.ZERO);
        balanceAddReqDto.setAccountCode("YEZH" + customer.getCode());
        balanceAddReqDto.setAgentUse(OfflineBalanceAccountEnum.ENABLED.getValue());
        balanceAddReqDto.setAgentView(OfflineBalanceAccountEnum.ENABLED.getValue());
        balanceAddReqDto.setAccountStatus("ENABLED");
        balanceAddReqDto.setInstanceId(this.requestBaseData.getInstanceId());
        balanceAddReqDto.setTenantId(this.requestBaseData.getTenantId());
        logger.info("\u65b0\u589e\u8fd4\u5229\u8d26\u6237\u5165\u53c2 : {}", (Object)JSONObject.toJSONString((Object)balanceAddReqDto));
        ArrayList addReqDtos = Lists.newArrayList();
        addReqDtos.add(balanceAddReqDto);
        this.offlineBalanceAccountApi.saveBalanceAccountBatch((List)addReqDtos);
    }

    private void handleSellerShop(Map<String, String> map, Long orgId) {
        List respDtos;
        if (map.get(CustomerEnum.LEVELNAME.getCode()).equals(FIRST_DEALER)) {
            logger.info("\u5c0fB\u4e0d\u521b\u5efa\u5356\u5bb6");
            return;
        }
        SellerQueryReqDto dto = new SellerQueryReqDto();
        dto.setCode(map.get(CustomerEnum.MASTER_OU_ID.getCode()));
        RestResponse restResponse = this.sellerQueryApi.queryList(dto);
        logger.info("\u67e5\u8be2\u7ecf\u9500\u5546\u5bf9\u5e94\u7684\u5e97\u94fa\uff1a{},  {}", (Object)JSONObject.toJSONString((Object)restResponse), (Object)JSONObject.toJSONString((Object)dto));
        Long sellerId = null;
        if (CollectionUtil.isNotEmpty((Collection)((Collection)restResponse.getData())) && !CollectionUtil.isEmpty(respDtos = ((List)restResponse.getData()).stream().filter(t -> t.getCode().equals(map.get(CustomerEnum.MASTER_OU_ID.getCode()))).collect(Collectors.toList()))) {
            sellerId = ((SellerRespDto)respDtos.get(0)).getId();
        }
        SellerReqDto sellerReqDto = new SellerReqDto();
        sellerReqDto.setCode(map.get(CustomerEnum.MASTER_OU_ID.getCode()));
        sellerReqDto.setName(map.get(CustomerEnum.ORGNAME.getCode()));
        sellerReqDto.setThirdSellerId(map.get(CustomerEnum.MASTER_OU_ID.getCode()));
        sellerReqDto.setOwnerId(Long.valueOf(1L));
        sellerReqDto.setTenantId(this.requestBaseData.getTenantId());
        sellerReqDto.setInstanceId(this.requestBaseData.getInstanceId());
        sellerReqDto.setStatus("NORMAL");
        sellerReqDto.setOrganizationName(map.get(CustomerEnum.ORGNAME.getCode()));
        sellerReqDto.setId(sellerId);
        if (sellerId == null) {
            sellerReqDto.setOrganizationId(orgId);
            logger.info("\u65b0\u589e\u5546\u94fa\uff1asellerReqDto = {}", (Object)JSONObject.toJSONString((Object)sellerReqDto));
            sellerId = (Long)this.sellerApi.addSeller(sellerReqDto, false).getData();
        } else {
            logger.info("\u4fee\u6539\uff1asellerReqDto = {}", (Object)JSONObject.toJSONString((Object)sellerReqDto));
            this.sellerApi.modifySeller(sellerReqDto, false);
        }
        SellerBizStatusReqDto sellerBizStatusReqDto = new SellerBizStatusReqDto();
        sellerBizStatusReqDto.setStatus("NORMAL");
        sellerBizStatusReqDto.setCode(sellerReqDto.getCode());
        this.sellerExtendsApi.changeStatus(sellerBizStatusReqDto);
        ShopDto shopDto = (ShopDto)this.shopQueryApi.queryByCode(map.get(CustomerEnum.MASTER_OU_ID.getCode())).getData();
        logger.info("\u67e5\u8be2\u5230\u5e97\u94fa\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)shopDto));
        if (ObjectUtil.isEmpty((Object)shopDto)) {
            ShopDto shopReqDto = new ShopDto();
            shopReqDto.setCode(map.get(CustomerEnum.MASTER_OU_ID.getCode()));
            shopReqDto.setName(map.get(CustomerEnum.ORGNAME.getCode()));
            shopReqDto.setType(Long.valueOf(1L));
            shopReqDto.setTenantId(this.requestBaseData.getTenantId());
            shopReqDto.setInstanceId(this.requestBaseData.getInstanceId());
            shopReqDto.setOrganizationId(orgId);
            shopReqDto.setOrganizationCode(map.get(CustomerEnum.MASTER_OU_ID.getCode()));
            shopReqDto.setOrganizationName(map.get(CustomerEnum.ORGNAME.getCode()));
            shopReqDto.setSellerId(sellerId);
            RestResponse shopResponse = this.shopApi.addShop(shopReqDto, false);
            logger.info("\u65b0\u589e\u5e97\u94fa\u4fe1\u606f {}", (Object)JSONObject.toJSONString((Object)shopResponse));
            try {
                this.initDefaultPrice((RestResponse<Long>)shopResponse, orgId, shopReqDto.getOrganizationName());
            }
            catch (Exception e) {
                logger.error("initDefaultPrice:Exception shopResponse={}", (Object)shopResponse);
                e.printStackTrace();
            }
        }
    }

    private void initDefaultPrice(RestResponse<Long> shopResponse, Long orgId, String orgName) {
        Long shopId = (Long)shopResponse.getData();
        this.syncPriceDataApi.initDefaultPrice(shopId, orgId, orgName);
    }

    private CustomerReqDto handleCustomer(Map<String, String> map, Long orgId, Long parentOrgId) {
        String index = this.generaAccount(map.get(CustomerEnum.CUSTOMER_CODE.getCode()));
        String code = map.get(CustomerEnum.CUSTOMER_CODE.getCode()) + "_" + index;
        String name = map.get(CustomerEnum.NAME.getCode());
        CustomerReqExtDto customerReqExtDto = new CustomerReqExtDto();
        customerReqExtDto.setCode(code);
        customerReqExtDto.setName(name);
        customerReqExtDto.setOrgInfoId(orgId);
        customerReqExtDto.setSigningCompany(map.get(CustomerEnum.ASSIGN_ORGNAME.getCode()));
        customerReqExtDto.setMerchantId(parentOrgId);
        try {
            String authEndTimeStr;
            String startDateStr;
            if (ObjectUtils.isNotEmpty((Object)map.get(CustomerEnum.STARTDATE.getCode()))) {
                startDateStr = String.valueOf(map.get(CustomerEnum.STARTDATE.getCode())).replace(".0", "");
                customerReqExtDto.setStartDate(new Date(Long.parseLong(startDateStr)));
                if (ObjectUtils.isNotEmpty((Object)map.get(CustomerEnum.ENDDATE.getCode()))) {
                    authEndTimeStr = String.valueOf(map.get(CustomerEnum.ENDDATE.getCode())).replace(".0", "");
                    customerReqExtDto.setEndDate(new Date(Long.parseLong(authEndTimeStr)));
                }
            } else if (ObjectUtils.isNotEmpty((Object)map.get(CustomerEnum.START.getCode()))) {
                startDateStr = String.valueOf(map.get(CustomerEnum.START.getCode())).replace(".0", "");
                customerReqExtDto.setStartDate(DateUtil.parseDate((String)startDateStr, (String)"yyyy-MM-dd HH:mm:ss"));
                if (ObjectUtils.isNotEmpty((Object)map.get(CustomerEnum.ENDDATE.getCode()))) {
                    authEndTimeStr = String.valueOf(map.get(CustomerEnum.ENDDATE.getCode())).replace(".0", "");
                    customerReqExtDto.setEndDate(DateUtil.parseDate((String)authEndTimeStr, (String)"yyyy-MM-dd HH:mm:ss"));
                }
            }
            if (ObjectUtil.isEmpty((Object)customerReqExtDto.getEndDate())) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                Date date = sdf.parse("2199-01-01");
                customerReqExtDto.setEndDate(date);
            }
            Date now = new Date();
            if (customerReqExtDto.getEndDate().getTime() < now.getTime()) {
                customerReqExtDto.setStatusId(CUSTOMER_STATUS_ID_EXPIRE);
            } else {
                customerReqExtDto.setStatusId(CUSTOMER_STATUS_ID);
            }
        }
        catch (Exception e) {
            logger.info("\u540c\u6b65\u4eba\u5458\u8d26\u53f7\u65e5\u671f\u89e3\u6790\u9519\u8bef:{}", (Object)e.getMessage());
        }
        customerReqExtDto.setAuditStatus(CustomerEnum.AUDIT_PASS.getCode());
        customerReqExtDto.setProvinceCode(map.get(CustomerEnum.PROVINCE.getCode()));
        customerReqExtDto.setProvince(map.get(CustomerEnum.PROVINCENAME.getCode()));
        customerReqExtDto.setCityCode(map.get(CustomerEnum.CITY.getCode()));
        customerReqExtDto.setCity(map.get(CustomerEnum.CITYNAME.getCode()));
        customerReqExtDto.setCountyCode(map.get(CustomerEnum.COUNTY.getCode()));
        customerReqExtDto.setCounty(map.get(CustomerEnum.COUNTYNAME.getCode()));
        customerReqExtDto.setAddress(map.get(CustomerEnum.COMPANYADDRESS.getCode()));
        customerReqExtDto.setThirdParentPartyId(map.get(CustomerEnum.PARPARTNERID.getCode()));
        customerReqExtDto.setThirdPartyId(map.get(CustomerEnum.ROW_ID.getCode()));
        customerReqExtDto.setAliasname(map.get(CustomerEnum.ALIASNAME.getCode()));
        customerReqExtDto.setEasCode(map.get(CustomerEnum.EXTERNALCODE.getCode()));
        customerReqExtDto.setTenantId(this.requestBaseData.getTenantId());
        customerReqExtDto.setInstanceId(this.requestBaseData.getInstanceId());
        customerReqExtDto.setLevelId(this.getCustomerLevel(map.get(CustomerEnum.LEVELNAME.getCode())));
        customerReqExtDto.setRegionCodeList((List)Lists.newArrayList((Object[])new String[]{map.get(CustomerEnum.REGIONID.getCode())}));
        customerReqExtDto.setCustomerTypeId(this.getCustomerTypeId(map));
        customerReqExtDto.setDistrictCodeExt(map.get(CustomerEnum.DISTRICTCODE.getCode()));
        customerReqExtDto.setDistrictNameExt(map.get(CustomerEnum.DISTRICTNAME.getCode()));
        customerReqExtDto.setRegionCodeExt(map.get(CustomerEnum.REGIONCODE.getCode()));
        customerReqExtDto.setRegionNameExt(map.get(CustomerEnum.REGIONNAME.getCode()));
        List maps = this.organizationPartnerDas.selectMapping(map.get(CustomerEnum.ROW_ID.getCode()));
        if (CollectionUtil.isNotEmpty((Collection)maps)) {
            Map mappingMap = (Map)maps.get(0);
            customerReqExtDto.setThirdPartyMappingId((String)mappingMap.get("customerCode"));
        }
        if (map.get(CustomerEnum.LEVELNAME.getCode()).equals(FIRST_DEALER)) {
            customerReqExtDto.setType(Integer.valueOf(3));
        } else {
            customerReqExtDto.setType(Integer.valueOf(2));
        }
        logger.info("\u62fc\u63a5\u5ba2\u6237\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)customerReqExtDto));
        CustomerReqExtDto customerRespDto = new CustomerReqExtDto();
        RestResponse restResponse = this.customerQueryApi.queryByThirdPartyIds((List)Lists.newArrayList((Object[])new String[]{map.get(CustomerEnum.ROW_ID.getCode())}));
        logger.info("\u67e5\u8be2\u5ba2\u6237\u662f\u5426\u5b58\u5728\uff1a{}", (Object)JSONObject.toJSONString((Object)restResponse));
        if (ObjectUtil.isNotEmpty((Object)restResponse.getData())) {
            List customerRespDtos = (List)restResponse.getData();
            logger.info("\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u4e0d\u4e3a\u7a7a\uff0c\u66f4\u65b0\u5ba2\u6237\u4fe1\u606f\uff01");
            customerReqExtDto.setId(((CustomerRespDto)customerRespDtos.get(0)).getId());
            BeanUtils.copyProperties((Object)customerReqExtDto, (Object)customerRespDto);
            customerRespDto.setId(((CustomerRespDto)customerRespDtos.get(0)).getId());
            RestResponse customerRespone = this.customerExtV3Api.update(customerRespDto);
            this.sendMQCustomerUpdExt(customerReqExtDto);
            logger.info("\u4fee\u6539\u5ba2\u6237\uff1a{}", (Object)JSONObject.toJSONString((Object)customerReqExtDto));
            String reqId = ServiceContext.getContext().get("yes.req.requestId").toString();
            if (customerRespDto.getType() == 3) {
                this.executorService.execute(new Thread(() -> {
                    MDC.put((String)"yes.req.requestId", (String)reqId);
                    ServiceContext.getContext().setAttachment("yes.req.requestId", reqId);
                    MDC.put((String)"yes.req.userCode", (String)"csp-sync");
                    ServiceContext.getContext().set("yes.req.userCode", (Object)"csp-sync");
                    logger.info("\u5f02\u6b65\u5904\u7406\u5730\u5740,\u7ec4\u7ec7id\u4e3a:{}", (Object)((CustomerRespDto)customerRespDtos.get(0)).getOrgInfoId());
                    this.handleUpdateAddress(((CustomerRespDto)customerRespDtos.get(0)).getOrgInfoId());
                }));
            }
        } else {
            BeanUtils.copyProperties((Object)customerReqExtDto, (Object)customerRespDto);
            RestResponse customerRespone = this.customerApi.add((CustomerReqDto)customerRespDto);
            customerRespDto.setId((Long)customerRespone.getData());
            logger.info("\u65b0\u589e\u5ba2\u6237\uff1a{}", (Object)JSONObject.toJSONString((Object)customerRespone));
            this.addCredit((CustomerReqDto)customerRespDto, parentOrgId);
            String reqId = ServiceContext.getContext().get("yes.req.requestId").toString();
            if (customerRespDto.getType() == 3) {
                this.executorService.execute(new Thread(() -> {
                    MDC.put((String)"yes.req.requestId", (String)reqId);
                    ServiceContext.getContext().setAttachment("yes.req.requestId", reqId);
                    MDC.put((String)"yes.req.userCode", (String)"csp-sync");
                    ServiceContext.getContext().set("yes.req.userCode", (Object)"csp-sync");
                    try {
                        Thread.sleep(2000L);
                        this.handleAddress((String)map.get(CustomerEnum.ROW_ID.getCode()));
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }));
            }
            if (map.get(CustomerEnum.LEVELNAME.getCode()).equals(FIRST_DEALER)) {
                logger.info("====================\u300b \u65b0\u589e\u9000\u8d27\u989d\u5ea6\u8d26\u6237");
                this.createReturnsQuotaAccount(customerRespDto.getId());
            }
        }
        return customerRespDto;
    }

    private void addCredit(CustomerReqDto customerRespDto, Long orgId) {
        logger.info("\u540c\u6b65\u5ba2\u5546\u6570\u636e\u65f6\uff0c\u9ed8\u8ba4\u8bbe\u4e3a\u51c6\u5165\u5ba2\u6237\u521d\u59cb\u53c2\u6570:{}", (Object)JSONObject.toJSONString((Object)customerRespDto));
        CreditEntitySaveReqDto creditEntitySaveReqDto = new CreditEntitySaveReqDto();
        creditEntitySaveReqDto.setName(customerRespDto.getName());
        creditEntitySaveReqDto.setEntityStatus(EntityStatusEnum.ENABLED.getCode());
        creditEntitySaveReqDto.setType(EntityTypeEnum.CUSTOMER.getCode());
        creditEntitySaveReqDto.setId(customerRespDto.getId());
        creditEntitySaveReqDto.setOrgInfoId(orgId);
        CreditEntityDetailSaveReqDto creditEntityDetailSaveReqDto = this.getCreditEntityDetailSaveReqDto(creditEntitySaveReqDto, customerRespDto);
        creditEntitySaveReqDto.setInstanceId(creditEntityDetailSaveReqDto.getInstanceId());
        creditEntitySaveReqDto.setTenantId(creditEntityDetailSaveReqDto.getTenantId());
        ArrayList<CreditEntityDetailSaveReqDto> list = new ArrayList<CreditEntityDetailSaveReqDto>();
        list.add(creditEntityDetailSaveReqDto);
        creditEntitySaveReqDto.setCreditList(list);
        logger.info("\u540c\u6b65\u5ba2\u5546\u6570\u636e\u65f6\uff0c\u9ed8\u8ba4\u8bbe\u4e3a\u51c6\u5165\u5ba2\u6237\u53c2\u6570:{}", (Object)JSONObject.toJSONString((Object)creditEntitySaveReqDto));
        RestResponse longRestResponse = this.creditEntityApi.addCustomerCreditEntity(creditEntitySaveReqDto);
        Long result = (Long)RestResponseHelper.extractData((RestResponse)longRestResponse);
        logger.info("\u540c\u6b65\u5ba2\u5546\u6570\u636e\u65f6\uff0c\u9ed8\u8ba4\u8bbe\u4e3a\u51c6\u5165\u5ba2\u6237\u7ed3\u679c:{}", (Object)result);
    }

    private CreditEntityDetailSaveReqDto getCreditEntityDetailSaveReqDto(CreditEntitySaveReqDto creditEntitySaveReqDto, CustomerReqDto customerRespDto) {
        CreditEntityDetailSaveReqDto creditEntityDetailSaveReqDto = new CreditEntityDetailSaveReqDto();
        BeanUtils.copyProperties((Object)customerRespDto, (Object)creditEntityDetailSaveReqDto);
        creditEntityDetailSaveReqDto.setCustomerId(customerRespDto.getId());
        creditEntityDetailSaveReqDto.setCustomerName(customerRespDto.getName());
        creditEntityDetailSaveReqDto.setCustomerCode(customerRespDto.getCode());
        if (customerRespDto.getCustomerTypeId() != null) {
            creditEntityDetailSaveReqDto.setCustomerTypeId(customerRespDto.getCustomerTypeId());
            CustomerTypeRespDto customerTypeRespDtos = (CustomerTypeRespDto)RestResponseHelper.extractData((RestResponse)this.customerTypeQueryApi.queryById(customerRespDto.getCustomerTypeId()));
            if (Objects.nonNull(customerTypeRespDtos)) {
                creditEntityDetailSaveReqDto.setCustomerTypeName(customerTypeRespDtos.getName());
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)customerRespDto.getRegionCodeList())) {
            String regionCode = (String)customerRespDto.getRegionCodeList().get(0);
            creditEntityDetailSaveReqDto.setRegionCode(regionCode);
            if (StringUtils.isNotEmpty((String)regionCode)) {
                String regionName = (String)RestResponseHelper.extractData((RestResponse)this.customerAreaQueryApi.queryAreaNameByCode((List)Lists.newArrayList((Object[])new String[]{regionCode})));
                creditEntityDetailSaveReqDto.setRegion(regionName);
            }
        }
        creditEntityDetailSaveReqDto.setStatusId(CUSTOMER_STATUS_ID);
        creditEntityDetailSaveReqDto.setStatusName("\u542f\u52a8");
        return creditEntityDetailSaveReqDto;
    }

    private void handleUpdateAddress(Long orgId) {
        List customerRespDtoList = (List)this.customerQueryApi.queryCustomerByOrgId((List)Lists.newArrayList((Object[])new Long[]{orgId})).getData();
        if (!CollectionUtils.isEmpty((Collection)customerRespDtoList)) {
            CustomerRespDto customerRespDto = (CustomerRespDto)customerRespDtoList.get(0);
            List idList = customerRespDtoList.stream().map(CustomerRespDto::getThirdPartyId).collect(Collectors.toList());
            List addressByIdList = this.dataDistributeDas.selectAddressByIds(idList);
            if (!CollectionUtils.isEmpty((Collection)addressByIdList)) {
                ArrayList addressAddReqDtoList = Lists.newArrayList();
                addressByIdList.forEach(map -> {
                    AddressAddReqDto reqDto = new AddressAddReqDto();
                    reqDto.setOrgInfoId(orgId);
                    reqDto.setAddressType("1");
                    reqDto.setCity((String)map.get(AddressEnum.CITY_NAME.getCode()));
                    reqDto.setCityCode((String)map.get(AddressEnum.TYPE.getCode()));
                    reqDto.setContact((String)map.get(AddressEnum.DEFPERID.getCode()));
                    reqDto.setPhone((String)map.get(AddressEnum.DEFPERPHONE.getCode()));
                    reqDto.setStatus(Integer.valueOf(1));
                    reqDto.setTenantId(customerRespDto.getTenantId());
                    reqDto.setInstanceId(customerRespDto.getInstanceId());
                    reqDto.setProvince((String)map.get(AddressEnum.STATE_NAME.getCode()));
                    reqDto.setProvinceCode((String)map.get(AddressEnum.STATE.getCode()));
                    reqDto.setDetailAddr((String)map.get(AddressEnum.ADDRESS.getCode()));
                    reqDto.setRegion((String)map.get(AddressEnum.COUNTY_NAME.getCode()));
                    reqDto.setDistrict((String)map.get(AddressEnum.COUNTY_NAME.getCode()));
                    reqDto.setDistrictCode((String)map.get(AddressEnum.COUNTY.getCode()));
                    addressAddReqDtoList.add(reqDto);
                });
                AddressExtReqDto addressExtReqDto = new AddressExtReqDto();
                addressExtReqDto.setOrgInfoId(orgId);
                addressExtReqDto.setAddressAddReqDtoList((List)addressAddReqDtoList);
                this.customerExpandApi.deleteAndUpdateAddress(addressExtReqDto);
            }
        }
    }

    private void handleAddress(String parentId) {
        Optional.ofNullable(this.dataDistributeDas.selectAddress(parentId)).filter(CollUtil::isNotEmpty).ifPresent(list -> list.forEach(map -> {
            try {
                this.centerHandleCustomerAddressService.addAddress((Map<String, String>)map);
            }
            catch (Exception e) {
                logger.error("\u5730\u5740\u540c\u6b65\u5f02\u5e38:{}", (Object)e.getMessage());
            }
        }));
    }

    private Long getCustomerTypeId(Map<String, String> map) {
        if (map.get(CustomerEnum.LEVELNAME.getCode()).equals(FIRST_DEALER)) {
            logger.info("============================= \u5f00\u59cb\u83b7\u53d6\u5c0fb\u5ba2\u6237\u7ea7\u522b =======================");
            RestResponse listRestResponse = this.customerTypeQueryApi.queryAllSimpleCustomerType(Integer.valueOf(2));
            logger.info("\u67e5\u8be2\u5ba2\u6237\u7ea7\u522b\uff1a{}, {}", (Object)FIRST_DEALER, (Object)JSONObject.toJSONString((Object)listRestResponse));
            String orgTypeName = map.get(CustomerEnum.ORGTYPENAME.getCode());
            return ((CustomerTypeRespDto)((List)listRestResponse.getData()).stream().filter(s -> orgTypeName.equals(s.getName())).collect(Collectors.toList()).get(0)).getId();
        }
        logger.info("============================= \u5f00\u59cb\u83b7\u53d6\u5927b\u5ba2\u6237\u7ea7\u522b ========================");
        RestResponse listRestResponse = this.customerTypeQueryApi.queryAllSimpleCustomerType(Integer.valueOf(1));
        logger.info("\u67e5\u8be2\u5ba2\u6237\u7ea7\u522b\uff1a{}, {}", (Object)FIRST_DEALER, (Object)JSONObject.toJSONString((Object)listRestResponse));
        return ((CustomerTypeRespDto)((List)listRestResponse.getData()).stream().filter(s -> "\u4e00\u7ea7\u7ecf\u9500\u5546".equals(s.getName())).collect(Collectors.toList()).get(0)).getId();
    }

    private Map<String, Long> handleOrg(Map<String, String> map) {
        String orgCode = map.get(CustomerEnum.MASTER_OU_ID.getCode());
        String orgName = map.get(CustomerEnum.ORGNAME.getCode());
        HashMap<String, Long> orgMap = new HashMap<String, Long>();
        if (map.get(CustomerEnum.LEVELNAME.getCode()).equals(DEALER)) {
            Long orgId = this.getOrgId(orgCode, orgName);
            orgMap.put(ORG_ID, orgId);
            RetunCustomerDto customerDto = this.handleSmallB(map.get(CustomerEnum.MASTER_OU_ID.getCode()));
            logger.info("\u5927B\u79df\u6237\u5bf9\u5e94\u7ecf\u9500\u5546\u67e5\u8be2 MASTER_OU_ID={}, {}", (Object)map.get(CustomerEnum.MASTER_OU_ID.getCode()), (Object)JSONObject.toJSONString((Object)customerDto));
            Long parentOrgId = DIVISION_TCBJ;
            if (ObjectUtil.isNotEmpty((Object)customerDto)) {
                if (DIVISION_JLD_ORG_ID.equals(customerDto.getPAR_ORG_ID())) {
                    parentOrgId = DIVISION_JLD;
                }
                if (DIVISION_LIFE_SPACE_ORG_ID.equals(customerDto.getPAR_ORG_ID())) {
                    parentOrgId = DIVISION_LIFE_SPACE;
                }
            }
            orgMap.put(PARENT_ORG_ID, parentOrgId);
            BasicConfigReqDto basicConfigReqDto = new BasicConfigReqDto();
            basicConfigReqDto.setOrganizationId(orgId);
            basicConfigReqDto.setType(BasicConfigEnum.BATCH_NO.getType());
            basicConfigReqDto.setValue("1");
            basicConfigReqDto.setConfigCode(BasicConfigEnum.BATCH_NO.getCode());
            this.basicConfigApi.addBasicConfig(basicConfigReqDto);
            basicConfigReqDto = new BasicConfigReqDto();
            basicConfigReqDto.setOrganizationId(orgId);
            basicConfigReqDto.setType(BasicConfigEnum.CREATE_ORDER_CS_AUDIT.getType());
            basicConfigReqDto.setValue("2");
            basicConfigReqDto.setConfigCode(BasicConfigEnum.CREATE_ORDER_CS_AUDIT.getCode());
            this.basicConfigApi.addBasicConfig(basicConfigReqDto);
            basicConfigReqDto = new BasicConfigReqDto();
            basicConfigReqDto.setOrganizationId(orgId);
            basicConfigReqDto.setType(BasicConfigEnum.REFUND_CS_AUDIT.getType());
            basicConfigReqDto.setValue("2");
            basicConfigReqDto.setConfigCode(BasicConfigEnum.REFUND_CS_AUDIT.getCode());
            this.basicConfigApi.addBasicConfig(basicConfigReqDto);
        } else {
            Long orgId = this.getOrgId(orgCode, orgName);
            orgMap.put(PARENT_ORG_ID, orgId);
            String orgCodeCSN = map.get(CustomerEnum.CUSTOMER_CODE.getCode());
            String orgNameCSN = map.get(CustomerEnum.NAME.getCode());
            orgMap.put(ORG_ID, this.getOrgId(orgCodeCSN, orgNameCSN));
        }
        logger.info("====================================== {}", (Object)JSONObject.toJSONString(orgMap));
        return orgMap;
    }

    private Long getOrgId(String orgCode, String orgName) {
        OrgAdvQueryReqDto orgAdvQueryReqDto = new OrgAdvQueryReqDto();
        orgAdvQueryReqDto.setCode(orgCode);
        RestResponse organizationDtoRestResponse = this.organizationQueryApi.queryOneByOrgCode(null, orgCode);
        logger.info("\u67e5\u8be2\u79df\u6237\u4fe1\u606f {}", (Object)JSONObject.toJSONString((Object)organizationDtoRestResponse));
        if (organizationDtoRestResponse != null && organizationDtoRestResponse.getData() != null) {
            Long oldId = ((OrganizationDto)organizationDtoRestResponse.getData()).getId();
            OrgAdvModifyReqDto orgAdvModifyReqDto = new OrgAdvModifyReqDto();
            orgAdvModifyReqDto.setCode(orgCode);
            if (StringUtils.isNotEmpty((String)orgName)) {
                orgAdvModifyReqDto.setName(orgName);
            }
            orgAdvModifyReqDto.setId(oldId);
            orgAdvModifyReqDto.setParentId(DEFAULT_ORG_PARENT_ID);
            this.organizationExtApi.modify(orgAdvModifyReqDto);
            return oldId;
        }
        OrgAdvAddReqDto orgAdvAddReqDto = new OrgAdvAddReqDto();
        orgAdvAddReqDto.setCode(orgCode);
        orgAdvAddReqDto.setName(orgName);
        orgAdvAddReqDto.setType("2");
        orgAdvAddReqDto.setTenantId(this.requestBaseData.getTenantId());
        orgAdvAddReqDto.setInstanceId(this.requestBaseData.getInstanceId());
        orgAdvAddReqDto.setParentId(DEFAULT_ORG_PARENT_ID);
        return ((OrgAdvOpRespDto)this.organizationExtApi.add(orgAdvAddReqDto).getData()).getOrgId();
    }

    private Long getCustomerLevel(String type) {
        switch (type) {
            case "1P\u7ecf\u9500\u5546": {
                return this.customerLevelMin;
            }
            case "\u79df\u6237": {
                return this.customerLevelMax;
            }
        }
        return this.customerLevelMax;
    }

    private RetunCustomerDto handleSmallB(String orgId) {
        Map map;
        List list;
        ArrayList<String> orgids = new ArrayList<String>();
        orgids.add(orgId);
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        jsonMap.put("orgIds", orgids);
        logger.info("\u6253\u5370\u67e5\u8be2\u7ecf\u9500\u5546\u5165\u53c2\uff1a{}, ================  {}", (Object)JSONObject.toJSONString((Object)this.marketingCloudConfig), (Object)JSONObject.toJSONString(jsonMap));
        Map result = this.httpUtil.httpPost(this.orgIdUrl, null, jsonMap, Map.class);
        logger.info("\u8bf7\u6c42\u8425\u9500\u4e91\u670d\u52a1\uff0c\u5927B\u79df\u6237\u5bf9\u5e94\u7ecf\u9500\u5546\u67e5\u8be2\uff1a{}", (Object)JSONObject.toJSONString((Object)result));
        if (!CollectionUtils.isEmpty((Map)result) && result.get("data") != null && !CollectionUtil.isEmpty((Collection)(list = JSONArray.parseArray((String)(map = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)result), Map.class)).get("data").toString(), RetunCustomerDto.class)))) {
            return (RetunCustomerDto)list.get(0);
        }
        return null;
    }

    private boolean isEmpty(Object obj) {
        if (obj.toString().equals("{\"extFields\":{}}")) {
            return true;
        }
        if (JSONObject.toJSONString((Object)obj).equals("{}")) {
            return true;
        }
        if (null == obj) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return StrUtil.isEmpty((CharSequence)((CharSequence)obj));
        }
        if (obj instanceof Map) {
            return MapUtil.isEmpty((Map)((Map)obj));
        }
        if (obj instanceof Iterable) {
            return IterUtil.isEmpty((Iterable)((Iterable)obj));
        }
        if (obj instanceof Iterator) {
            return IterUtil.isEmpty((Iterator)((Iterator)obj));
        }
        return ArrayUtil.isArray((Object)obj) ? ArrayUtil.isEmpty((Object)obj) : false;
    }

    private String generaAccount(String code) {
        Long i = this.cacheService.incr(code);
        String str = String.format("%06d", i);
        return str;
    }

    private void sendMQCustomerUpd(CustomerReqDto reqDto) {
        logger.info("\u53d1\u9001\u66f4\u65b0\u5e7f\u64adMQ\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        this.commonsMqService.publishMessage(this.publishCustomerUpdTopic, this.publishCustomerUpdTag, (Object)JSONObject.toJSONString((Object)reqDto));
    }

    private void sendMQCustomerUpdExt(CustomerReqExtDto reqDto) {
        logger.info("sendMQCustomerUpdExt \u53d1\u9001\u66f4\u65b0\u5e7f\u64adMQ\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        this.commonsMqService.publishMessage(this.publishCustomerUpdTopic, this.publishCustomerUpdTag, (Object)JSONObject.toJSONString((Object)reqDto));
    }
}

