/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.csp.service;

import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.tcbj.app.open.biz.csp.ApiClient;
import com.dtyunxi.tcbj.app.open.biz.csp.dto.BaseRequest;
import com.dtyunxi.tcbj.app.open.biz.csp.dto.BaseResponse;
import com.dtyunxi.tcbj.app.open.biz.csp.dto.CspUserDto;
import com.dtyunxi.tcbj.app.open.biz.csp.dto.DataSyncRequest;
import com.dtyunxi.tcbj.app.open.biz.csp.dto.Role;
import com.dtyunxi.tcbj.app.open.biz.csp.dto.RoleResourceRelation;
import com.dtyunxi.tcbj.app.open.biz.csp.dto.TenantUserRelation;
import com.dtyunxi.tcbj.app.open.biz.csp.dto.UserRoleRelation;
import com.dtyunxi.tcbj.app.open.biz.csp.service.DataSyncService;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PortalDataSyncServiceImpl
implements DataSyncService {
    private static final Logger log = LoggerFactory.getLogger(PortalDataSyncServiceImpl.class);
    private final ApiClient apiClient;
    @Value(value="portal.api.token")
    private String apiToken;

    @Override
    public BaseResponse<List<CspUserDto>> syncUsers(String seq, DataSyncRequest request) {
        return this.postRequest("/dataSync/users", seq, request, new TypeRef<List<CspUserDto>>(){});
    }

    @Override
    public BaseResponse<List<Role>> syncRoles(String seq, DataSyncRequest request) {
        return this.postRequest("/dataSync/roles", seq, request, new TypeRef<List<Role>>(){});
    }

    @Override
    public BaseResponse<List<UserRoleRelation>> syncUserRoles(String seq, DataSyncRequest request) {
        return this.postRequest("/dataSync/userRoles", seq, request, new TypeRef<List<UserRoleRelation>>(){});
    }

    @Override
    public BaseResponse<List<RoleResourceRelation>> syncRoleResources(String seq, DataSyncRequest request) {
        return this.postRequest("/dataSync/roleFunctions", seq, request, new TypeRef<List<RoleResourceRelation>>(){});
    }

    @Override
    public BaseResponse<List<TenantUserRelation>> syncUserTenants(String seq, DataSyncRequest request) {
        return this.postRequest("/dataSync/userTenants", seq, request, new TypeRef<List<TenantUserRelation>>(){});
    }

    private <T> BaseResponse<List<T>> postRequest(String endpoint, String seq, DataSyncRequest request, TypeRef<List<T>> typeRef) {
        BaseRequest<DataSyncRequest> baseRequest = new BaseRequest<DataSyncRequest>();
        baseRequest.setToken(this.apiToken);
        baseRequest.setSeq(seq);
        baseRequest.setRequest(request);
        try {
            BaseResponse<List<T>> response = this.apiClient.post(endpoint, baseRequest, (Class)typeRef.getType());
            this.validateResponse(response);
            return response;
        }
        catch (BizException e) {
            log.error("API request failed for {}: {}", (Object)endpoint, (Object)e.getMessage());
            throw e;
        }
    }

    private void validateResponse(BaseResponse<?> response) {
        if (response.getCode() != 200) {
            throw new BizException("API returned error: " + response.getMsg());
        }
    }

    public PortalDataSyncServiceImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private static abstract class TypeRef<T>
    extends TypeReference<T> {
        private TypeRef() {
        }
    }
}

