/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.scheduler;

import com.dtyunxi.tcbj.app.open.biz.scheduler.SchedulerHelper;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.annotation.Scope;

@Scope(value="prototype")
public class UserStatusSyncEvent
extends SingleTupleScheduleEvent
implements CommandLineRunner {
    private static final Logger logger = LoggerFactory.getLogger(UserStatusSyncEvent.class);
    @Resource
    private SchedulerHelper schedulerHelper;
    @Value(value="${scheduler.client.app_code:tcbj-openapi-platform}")
    private String appCode;
    @Value(value="${scheduler.client.syncUserEventCron:0 5 0 * * ?}")
    private String syncUserEventCron;
    @Value(value="${scheduler.client.ifOpenSyncUser:true}")
    private boolean ifOpenSyncUser;
    @Value(value="${customer.user.relation.sync:false}")
    private boolean syncOpen;

    public void before(TaskMsg taskMsg) {
    }

    public boolean execute(TaskMsg taskMsg) {
        if (!this.syncOpen) {
            return true;
        }
        long startTime = System.currentTimeMillis();
        long endTime = System.currentTimeMillis();
        logger.info("\u5b9a\u65f6\u7528\u6237\u540c\u6b65\u7ed3\u675f\uff0c\u7528\u65f6\uff1a{}", (Object)(startTime - endTime + "ms"));
        return true;
    }

    private void doExecute(List<String> objs) {
        if (CollectionUtils.isEmpty(objs)) {
            return;
        }
        logger.info("\u540c\u6b65\u7528\u6237\u72b6\u6001:{}", (Object)objs.size());
    }

    public void after(TaskMsg taskMsg) {
    }

    public void run(String ... args) {
        logger.info(">>>>\u8c03\u5ea6\u4efb\u52a1\u5f00\u59cb\u521b\u5efa");
        try {
            if (!this.ifOpenSyncUser) {
                logger.info(">>>>\u4e0d\u521d\u59cb\u5316\u4efb\u52a1");
                this.schedulerHelper.stopEvent("userStatusSyncEvent");
                return;
            }
            this.schedulerHelper.startSyncEvent(this.appCode, "userStatusSyncEvent", "\u5b9a\u65f6\u540c\u6b65\u4ef7\u683c\u4efb\u52a1", this.syncUserEventCron);
            logger.info(">>>>\u8c03\u5ea6\u4efb\u52a1\u521b\u5efa\u6210\u529f");
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
    }
}

