/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.dto.BaseRespDto;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.dto.EmployeeRoleForViewDto;
import com.dtyunxi.tcbj.app.open.biz.service.IExternalMasterDataSyncService;
import com.dtyunxi.tcbj.app.open.dao.das.DataDistributeDas;
import com.dtyunxi.yundt.cube.center.user.api.IEmployeeRoleApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeRoleReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.tcbj.UserDtoExtDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.EmployeeExtRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.EmployeeRoleRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.RoleExpandRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.RoleRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IEmployeeRoleQueryApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class ExternalMasterDataSyncServiceImpl
implements IExternalMasterDataSyncService {
    private static final Logger log = LogManager.getLogger(ExternalMasterDataSyncServiceImpl.class);
    @Resource
    private IEmployeeRoleApi employeeRoleApi;
    @Resource
    private IEmployeeRoleQueryApi employeeRoleQueryApi;
    @Resource
    private DataDistributeDas dataDistributeDas;

    @Override
    public void syncEmployeeRoleForView(String orgId) {
        List roleExpandRespDtoList;
        List employeeExtRespDtoList;
        List organizationDtoList;
        log.info("\u6839\u636e\u89c6\u56fe\u540c\u6b65\u4eba\u5458\u89d2\u8272\u5173\u7cfb\u4fe1\u606f\uff1a{}", (Object)orgId);
        List maps = this.dataDistributeDas.selectPersonRoleView(orgId);
        List viewDtoList = new ArrayList();
        if (CollectionUtil.isNotEmpty((Collection)maps)) {
            viewDtoList = JSON.parseArray((String)JSON.toJSONString((Object)maps), EmployeeRoleForViewDto.class);
        }
        if (CollectionUtil.isEmpty(viewDtoList)) {
            log.info("");
            return;
        }
        Map<Object, Object> organizationMap = new HashMap();
        List orgIds = viewDtoList.stream().map(EmployeeRoleForViewDto::getOrgId).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(orgIds) && CollectionUtil.isNotEmpty((Collection)(organizationDtoList = (List)RestResponseHelper.extractData((RestResponse)this.employeeRoleQueryApi.queryOrgByCodes(orgIds))))) {
            organizationMap = organizationDtoList.stream().collect(Collectors.toMap(OrganizationDto::getCode, OrganizationDto::getId, (k1, k2) -> k1));
        }
        Map<Object, Object> userMap = new HashMap();
        List userIds = viewDtoList.stream().map(EmployeeRoleForViewDto::getLoginName).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(userIds)) {
            UserDtoExtDto userDtoExtDto = new UserDtoExtDto();
            userDtoExtDto.setUserNameList(userIds);
            List userRespExtDtoList = (List)RestResponseHelper.extractData((RestResponse)this.employeeRoleQueryApi.queryUserByCodeOrPhone(userDtoExtDto));
            if (CollectionUtil.isNotEmpty((Collection)userRespExtDtoList)) {
                userMap = userRespExtDtoList.stream().collect(Collectors.toMap(UserRespDto::getUserName, UserRespDto::getId, (k1, k2) -> k1));
            }
        }
        Map<Object, Object> empMap = new HashMap();
        List empnos = viewDtoList.stream().map(EmployeeRoleForViewDto::getEmpno).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(empnos) && CollectionUtil.isNotEmpty((Collection)(employeeExtRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.employeeRoleQueryApi.queryEmployeeByNos(empnos))))) {
            empMap = employeeExtRespDtoList.stream().collect(Collectors.toMap(EmployeeExtRespDto::getEmployeeNo, BaseRespDto::getId, (k1, k2) -> k1));
        }
        Map<Object, Object> roleMap = new HashMap();
        List roleIds = viewDtoList.stream().map(EmployeeRoleForViewDto::getRoleId).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(empnos) && CollectionUtil.isNotEmpty((Collection)(roleExpandRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.employeeRoleQueryApi.queryRoleByCodes(roleIds))))) {
            roleMap = roleExpandRespDtoList.stream().collect(Collectors.toMap(RoleRespDto::getCode, Function.identity(), (k1, k2) -> k1));
        }
        for (EmployeeRoleForViewDto viewDto : viewDtoList) {
            log.info("\u5173\u7cfb\u5904\u7406\uff1a{}", (Object)JSON.toJSONString((Object)viewDto));
            Long orgIdLocal = (Long)organizationMap.get(viewDto.getOrgId());
            if (ObjectUtils.isEmpty((Object)orgIdLocal)) {
                log.info("\u7ec4\u7ec7ID\u627e\u4e0d\u5230\uff0c{}", (Object)viewDto.getOrgId());
                continue;
            }
            Long empId = (Long)empMap.get(viewDto.getEmpno());
            if (ObjectUtils.isEmpty((Object)empId)) {
                log.info("\u4eba\u5458ID\u627e\u4e0d\u5230\uff0c{}", (Object)viewDto.getEmpno());
                continue;
            }
            RoleExpandRespDto roleDto = (RoleExpandRespDto)roleMap.get(viewDto.getRoleId());
            if (ObjectUtils.isEmpty((Object)roleDto)) {
                log.info("\u89d2\u8272ID\u627e\u4e0d\u5230\uff0c{}", (Object)viewDto.getRoleId());
                continue;
            }
            EmployeeRoleReqDto reqDto = new EmployeeRoleReqDto();
            reqDto.setEmployeeId(empId);
            reqDto.setOrgId(orgIdLocal);
            List employeeRoleRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.employeeRoleQueryApi.queryList(reqDto));
            if (CollectionUtil.isNotEmpty((Collection)employeeRoleRespDtoList) && employeeRoleRespDtoList.size() > 1) {
                log.info("\u5173\u7cfb\u6570\u636e\u5f02\u5e38\uff0c\u5b58\u5728\u591a\u6761\uff0c{}", (Object)JSON.toJSONString((Object)reqDto));
                continue;
            }
            if (CollectionUtil.isEmpty((Collection)employeeRoleRespDtoList)) {
                Long userId = (Long)userMap.get(viewDto.getLoginName());
                if (ObjectUtils.isEmpty((Object)userId)) {
                    log.info("\u65b0\u589e\u5173\u7cfb\u5931\u8d25\uff0c\u7528\u6237ID\u627e\u4e0d\u5230\uff0c{}", (Object)viewDto.getLoginName());
                    continue;
                }
                EmployeeRoleReqDto addDto = new EmployeeRoleReqDto();
                addDto.setEmployeeId(empId);
                addDto.setOrgId(orgIdLocal);
                addDto.setRoleId(roleDto.getId());
                addDto.setRoleCode(roleDto.getCode());
                addDto.setUserId(userId);
                addDto.setSuperAdmin(Integer.valueOf(0));
                addDto.setTenantId(Long.valueOf(1L));
                addDto.setCreatePerson("openapi");
                RestResponseHelper.extractData((RestResponse)this.employeeRoleApi.addEmployeeRole(Long.valueOf(1282837033627498907L), addDto));
                continue;
            }
            EmployeeRoleRespDto employeeRoleRespDto = (EmployeeRoleRespDto)employeeRoleRespDtoList.get(0);
            EmployeeRoleReqDto modDto = new EmployeeRoleReqDto();
            modDto.setId(employeeRoleRespDto.getId());
            modDto.setRoleCode(roleDto.getCode());
            modDto.setRoleId(roleDto.getId());
            RestResponseHelper.extractData((RestResponse)this.employeeRoleApi.modifyEmployeeRole(Long.valueOf(1282837033627498907L), modDto));
        }
    }
}

