/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.storage;

import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.storage.IStorageHelper;
import com.dtyunxi.tcbj.app.open.biz.utils.OrderExceptionEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.ICsInventoryExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.CargoStorageInfoCreateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjProOccupyItemReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjProOccupyReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateCargoReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryReleasePreemptOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryInOutEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemStorageReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OrderDeliveryTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.TradeItemReqDto;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="storageHelper")
public class StorageHelper
implements IStorageHelper {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ICsInventoryExposedApi inventoryExposedApi;
    @Resource
    private ICsInventoryExposedApi csInventoryExposedApi;

    @Override
    public void subVirStorage(OrderReqDto orderReqDto) {
        if (Objects.equals("1", orderReqDto.getSubmitType())) {
            return;
        }
        ArrayList needSubVirList = Lists.newArrayList();
        for (TradeItemReqDto orderItemInfoDto : orderReqDto.getOrderItems()) {
            ItemStorageReqDto itemStorageReqDto = new ItemStorageReqDto();
            itemStorageReqDto.setBalance(Long.valueOf(-Long.valueOf(orderItemInfoDto.getItemNum().intValue()).longValue()));
            itemStorageReqDto.setShopId(Long.valueOf(orderItemInfoDto.getShopId()));
            itemStorageReqDto.setItemType(orderItemInfoDto.getItemType());
            itemStorageReqDto.setSkuId(Long.valueOf(orderItemInfoDto.getSkuSerial()));
            HashMap<String, String> extFields = new HashMap<String, String>();
            Assert.notNull((Object)orderItemInfoDto.getCargoSerial(), (String)"\u8be5\u503c\u4e3a\u7a7a:CargoCode,\u65e0\u6cd5\u6263\u51cf\u5e93\u5b58", (Object[])new Object[0]);
            extFields.put("cargoCode", orderItemInfoDto.getCargoSerial());
            itemStorageReqDto.setExtFields(extFields);
            needSubVirList.add(itemStorageReqDto);
        }
        if (OrderDeliveryTypeEnum.SELLER.getType().equals(orderReqDto.getDeliveryType()) && CollectionUtils.isNotEmpty((Collection)needSubVirList)) {
            try {
                List cargoList = needSubVirList.stream().map(data -> {
                    CargoStorageInfoCreateReqDto newData = new CargoStorageInfoCreateReqDto();
                    BeanUtils.copyProperties((Object)data, (Object)newData);
                    newData.setExtFields(data.getExtFields());
                    newData.setWarehouseCode(orderReqDto.getWarehouseCode());
                    newData.setNum(BigDecimal.valueOf(data.getBalance()).negate());
                    newData.setCargoCode(String.valueOf(data.getExtFields().get("cargoCode")));
                    return newData;
                }).collect(Collectors.toList());
                this.logger.info("[operatingItemStorage]>>>{}", (Object)JSONObject.toJSONString(cargoList));
                TcbjProOccupyReqDto tcbjProOccupyReqDto = new TcbjProOccupyReqDto();
                tcbjProOccupyReqDto.setOrderNo(orderReqDto.getOrderNo());
                ArrayList<TcbjProOccupyItemReqDto> list = new ArrayList<TcbjProOccupyItemReqDto>();
                for (CargoStorageInfoCreateReqDto cargoStorageInfoCreateReqDto : cargoList) {
                    TcbjProOccupyItemReqDto tcbjProOccupyItemReqDto = this.getTcbjProOccupyItemReqDto(cargoStorageInfoCreateReqDto, cargoStorageInfoCreateReqDto.getNum().intValue());
                    list.add(tcbjProOccupyItemReqDto);
                }
                tcbjProOccupyReqDto.setTcbjProOccupyItemReqDtos(list);
                tcbjProOccupyReqDto.setOrderType("101");
                this.logger.info("refactorPreemptInventory==>\u5e93\u5b58\u9884\u5360\u5904\u7406\uff0c\u4e0b\u5355\u5904\u7406\u3001\u4e1a\u52a1\u5ba1\u6279\u3001\u8d22\u52a1\u5ba1\u6279,tcbjProOccupyReqDto:{}", (Object)JSON.toJSONString((Object)tcbjProOccupyReqDto));
                RestResponseHelper.checkOrThrow(this.placeOrderPreempt(tcbjProOccupyReqDto));
            }
            catch (Exception e) {
                this.logger.error("\u64cd\u4f5c\u5e93\u5b58\u629b\u9519", (Throwable)e);
                OrderExceptionEnum.STORAGE_NOT_ENOUGH.buildBizException(new String[0]);
            }
        }
    }

    @Override
    public void rollbackVirSotrage(String orderNo) {
        this.logger.info("\u53d6\u6d88\u5360\u7528\u63a5\u53e3\u5c40\u8bf7\u6c42\u53c2\u6570:{}", (Object)orderNo);
        if (StringUtils.isBlank((String)orderNo)) {
            this.logger.info("\u8ba2\u5355\u7f16\u53f7\u4e3a\u7a7a\uff0c\u53d6\u6d88\u56de\u6eda\u5e93\u5b58\uff01");
            return;
        }
        CsInventoryReleasePreemptOperateReqDto releasePreemptOperateReqDto = new CsInventoryReleasePreemptOperateReqDto();
        releasePreemptOperateReqDto.setSourceNo(orderNo);
        releasePreemptOperateReqDto.setSourceType(CsInventorySourceTypeEnum.IN_SALE_RELEASE.getCode());
        RestResponseHelper.extractData((RestResponse)this.inventoryExposedApi.releaseInventoryByPreemption(releasePreemptOperateReqDto));
    }

    private RestResponse<String> placeOrderPreempt(TcbjProOccupyReqDto tcbjProOccupyReqDto) {
        this.logger.info("placeOrderPreempt==>\u4e0b\u5355\u9884\u5360\u5e93\u5b58,orderNo:{}", (Object)tcbjProOccupyReqDto.getOrderNo());
        RestResponse result = RestResponse.SUCCEED;
        List tcbjProOccupyItemReqDtoList = tcbjProOccupyReqDto.getTcbjProOccupyItemReqDtos();
        CsInventoryOperateReqDto csInventoryOperateReqDto = new CsInventoryOperateReqDto();
        csInventoryOperateReqDto.setSourceNo(tcbjProOccupyReqDto.getOrderNo());
        csInventoryOperateReqDto.setSourceType(CsInventorySourceTypeEnum.OUT_SALE_PREEMPT.getCode());
        csInventoryOperateReqDto.setInOutFlag(CsInventoryInOutEnum.OUT.getCode());
        ArrayList operateCargoReqDtoList = Lists.newArrayList();
        for (TcbjProOccupyItemReqDto itemReqDto : tcbjProOccupyItemReqDtoList) {
            CsInventoryOperateCargoReqDto operateCargoReqDto = new CsInventoryOperateCargoReqDto();
            operateCargoReqDto.setWarehouseCode(itemReqDto.getWarehouseCode());
            operateCargoReqDto.setCargoCode(itemReqDto.getCargoCode());
            operateCargoReqDto.setBatch(itemReqDto.getBatch());
            operateCargoReqDto.setActivityId(itemReqDto.getActivityId());
            operateCargoReqDto.setChangeInventory(new BigDecimal(itemReqDto.getNum()));
            operateCargoReqDtoList.add(operateCargoReqDto);
        }
        csInventoryOperateReqDto.setOperateCargoReqDtoList((List)operateCargoReqDtoList);
        this.logger.info("placeOrderPreempt==>\u4e0b\u5355\u9884\u5360\u5e93\u5b58,csInventoryOperateReqDto:{}", (Object)JSON.toJSONString((Object)csInventoryOperateReqDto));
        RestResponse preemptInventoryResp = this.csInventoryExposedApi.preemptInventory(csInventoryOperateReqDto);
        this.logger.info("placeOrderPreempt==>\u4e0b\u5355\u9884\u5360\u5e93\u5b58,preemptInventoryResp:{}", (Object)JSON.toJSONString((Object)preemptInventoryResp));
        Boolean preemptResult = (Boolean)RestResponseHelper.extractData((RestResponse)preemptInventoryResp);
        if (!preemptResult.booleanValue()) {
            result = RestResponse.FAILED;
        }
        return result;
    }

    private TcbjProOccupyItemReqDto getTcbjProOccupyItemReqDto(CargoStorageInfoCreateReqDto cargoStorageInfoCreateReqDto, int i) {
        TcbjProOccupyItemReqDto tcbjProOccupyItemReqDto = new TcbjProOccupyItemReqDto();
        BeanUtils.copyProperties((Object)cargoStorageInfoCreateReqDto, (Object)tcbjProOccupyItemReqDto);
        tcbjProOccupyItemReqDto.setCargoCode(cargoStorageInfoCreateReqDto.getCargoCode());
        tcbjProOccupyItemReqDto.setWarehouseCode(cargoStorageInfoCreateReqDto.getWarehouseCode());
        tcbjProOccupyItemReqDto.setNum(Integer.valueOf(i));
        return tcbjProOccupyItemReqDto;
    }
}

