/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.utils;

import com.dtyunxi.tcbj.center.openapi.api.exception.DBItemEnum;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaterialDataCompatibilityUtil {
    private static final Logger logger = LoggerFactory.getLogger(MaterialDataCompatibilityUtil.class);

    public static Map<String, String> processCompatibility(Map<String, String> dataMap) {
        if (dataMap == null) {
            return dataMap;
        }
        MaterialDataCompatibilityUtil.processStatusField(dataMap);
        MaterialDataCompatibilityUtil.processOrgIdField(dataMap);
        MaterialDataCompatibilityUtil.processBrandCodeField(dataMap);
        MaterialDataCompatibilityUtil.processUnitField(dataMap);
        MaterialDataCompatibilityUtil.processBarcodeField(dataMap);
        MaterialDataCompatibilityUtil.processUseTypeField(dataMap);
        MaterialDataCompatibilityUtil.processMinUnitField(dataMap);
        MaterialDataCompatibilityUtil.processProductExtensionFields(dataMap);
        logger.debug("\u6570\u636e\u517c\u5bb9\u6027\u5904\u7406\u5b8c\u6210: {}", dataMap);
        return dataMap;
    }

    private static void processStatusField(Map<String, String> dataMap) {
        String status = dataMap.get(DBItemEnum.MATERIAL_STATUS.getCode());
        if (StringUtils.isEmpty((CharSequence)status)) {
            dataMap.put(DBItemEnum.MATERIAL_STATUS.getCode(), "Active");
            logger.debug("\u8bbe\u7f6e\u9ed8\u8ba4\u7269\u6599\u72b6\u6001: Active");
        }
    }

    private static void processOrgIdField(Map<String, String> dataMap) {
        String orgId = dataMap.get(DBItemEnum.ORGID.getCode());
        if (StringUtils.isEmpty((CharSequence)orgId)) {
            dataMap.put(DBItemEnum.ORGID.getCode(), "1-1JK1");
        }
    }

    private static void processBrandCodeField(Map<String, String> dataMap) {
        String brandCode = dataMap.get(DBItemEnum.CFPINPAIDNUM.getCode());
        if (StringUtils.isEmpty((CharSequence)brandCode)) {
            String brandName = dataMap.get(DBItemEnum.CFPINPAINAME.getCode());
            if (StringUtils.isNotEmpty((CharSequence)brandName)) {
                String generatedCode = MaterialDataCompatibilityUtil.generateBrandCode(brandName);
                dataMap.put(DBItemEnum.CFPINPAIDNUM.getCode(), generatedCode);
                logger.debug("\u751f\u6210\u54c1\u724c\u4ee3\u7801: {} for \u54c1\u724c\u540d\u79f0: {}", (Object)generatedCode, (Object)brandName);
            } else {
                dataMap.put(DBItemEnum.CFPINPAIDNUM.getCode(), "DEFAULT");
                dataMap.put(DBItemEnum.CFPINPAINAME.getCode(), "\u9ed8\u8ba4\u54c1\u724c");
                logger.warn("\u54c1\u724c\u540d\u79f0\u4e3a\u7a7a\uff0c\u4f7f\u7528\u9ed8\u8ba4\u54c1\u724c");
            }
        }
    }

    private static void processUnitField(Map<String, String> dataMap) {
        String unit = dataMap.get(DBItemEnum.UNITTYPE.getCode());
        if (StringUtils.isEmpty((CharSequence)unit)) {
            String prodSpec = dataMap.get(DBItemEnum.PRODSPEC.getCode());
            if (StringUtils.isNotEmpty((CharSequence)prodSpec)) {
                String defaultUnit = MaterialDataCompatibilityUtil.extractUnitFromSpec(prodSpec);
                dataMap.put(DBItemEnum.UNITTYPE.getCode(), defaultUnit);
                dataMap.put(DBItemEnum.UNIT_NAME.getCode(), defaultUnit);
                logger.debug("\u4ece\u89c4\u683c\u4e2d\u63d0\u53d6\u5355\u4f4d: {} from {}", (Object)defaultUnit, (Object)prodSpec);
            } else {
                dataMap.put(DBItemEnum.UNITTYPE.getCode(), "PCS");
                dataMap.put(DBItemEnum.UNIT_NAME.getCode(), "PCS");
            }
        }
    }

    private static void processBarcodeField(Map<String, String> dataMap) {
        String barcode = dataMap.get(DBItemEnum.BARCODE.getCode());
        if (StringUtils.isEmpty((CharSequence)barcode)) {
            logger.debug("\u6761\u5f62\u7801\u5b57\u6bb5\u4e3a\u7a7a\uff0c\u4fdd\u6301\u539f\u72b6");
        }
    }

    private static void processUseTypeField(Map<String, String> dataMap) {
        String useType = dataMap.get(DBItemEnum.USETYPE.getCode());
        if (StringUtils.isEmpty((CharSequence)useType)) {
            String prodType = dataMap.get(DBItemEnum.ORDERPRODTYPE.getCode());
            if ("PRODUCT".equalsIgnoreCase(prodType)) {
                dataMap.put(DBItemEnum.USETYPE.getCode(), "\u56fa\u4f53\u5236\u5242");
            } else {
                dataMap.put(DBItemEnum.USETYPE.getCode(), "\u5176\u4ed6");
            }
        }
    }

    private static void processMinUnitField(Map<String, String> dataMap) {
        String minUnit = dataMap.get(DBItemEnum.FNUMBER_MINUNIT.getCode());
        if (StringUtils.isEmpty((CharSequence)minUnit)) {
            dataMap.put(DBItemEnum.FNUMBER_MINUNIT.getCode(), "1");
            logger.debug("\u8bbe\u7f6e\u9ed8\u8ba4\u6700\u5c0f\u5305\u88c5\u6570: 1");
        }
    }

    private static void processProductExtensionFields(Map<String, String> dataMap) {
        String prodLine;
        String prodNum = dataMap.get(DBItemEnum.PRODNUM.getCode());
        if (StringUtils.isEmpty((CharSequence)prodNum)) {
            String prodno = dataMap.get(DBItemEnum.ZNUMBER.getCode());
            dataMap.put(DBItemEnum.PRODNUM.getCode(), StringUtils.defaultString((String)prodno, (String)""));
        }
        if (StringUtils.isEmpty((CharSequence)(prodLine = dataMap.get(DBItemEnum.PRODLINE.getCode())))) {
            dataMap.put(DBItemEnum.PRODLINE.getCode(), "\u9ed8\u8ba4\u7cfb\u5217");
        }
    }

    private static String extractUnitFromSpec(String prodSpec) {
        if (StringUtils.isEmpty((CharSequence)prodSpec)) {
            return "PCS";
        }
        if (prodSpec.contains("kg") || prodSpec.contains("KG")) {
            return "KG";
        }
        if (prodSpec.contains("g") || prodSpec.contains("G")) {
            return "G";
        }
        if (prodSpec.contains("ml") || prodSpec.contains("ML")) {
            return "ML";
        }
        if (prodSpec.contains("l") || prodSpec.contains("L")) {
            return "L";
        }
        if (prodSpec.contains("\u74f6")) {
            return "BOT";
        }
        if (prodSpec.contains("\u76d2") || prodSpec.contains("BOX")) {
            return "BOX";
        }
        if (prodSpec.contains("\u7247") || prodSpec.contains("\u7c92")) {
            return "TAB";
        }
        return "PCS";
    }

    private static String generateBrandCode(String brandName) {
        if (StringUtils.isEmpty((CharSequence)brandName)) {
            return "DEFAULT";
        }
        try {
            String pinyin = MaterialDataCompatibilityUtil.convertChineseToPinyin(brandName);
            String code = pinyin.length() > 3 ? pinyin.substring(0, 3) : pinyin;
            String result = code.toUpperCase().replaceAll("[^A-Z0-9]", "");
            return StringUtils.isEmpty((CharSequence)result) ? "DEFAULT" : result;
        }
        catch (Exception e) {
            logger.warn("\u54c1\u724c\u4ee3\u7801\u751f\u6210\u5931\u8d25\uff0c\u4f7f\u7528\u9ed8\u8ba4\u503c: {}, \u9519\u8bef: {}", (Object)brandName, (Object)e.getMessage());
            return "DEFAULT";
        }
    }

    private static String convertChineseToPinyin(String chinese) {
        if (StringUtils.isEmpty((CharSequence)chinese)) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < chinese.length(); ++i) {
            char c = chinese.charAt(i);
            if (c >= '\u4e00' && c <= '\u9fa5') {
                String pinyin = MaterialDataCompatibilityUtil.getSimplePinyin(c);
                result.append(pinyin);
                continue;
            }
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') && (c < '0' || c > '9')) continue;
            result.append(c);
        }
        return result.toString();
    }

    private static String getSimplePinyin(char c) {
        switch (c) {
            case '\u5065': {
                return "J";
            }
            case '\u5eb7': {
                return "K";
            }
            case '\u4e50': {
                return "L";
            }
            case '\u591a': {
                return "D";
            }
            case '\u7f8e': {
                return "M";
            }
            case '\u597d': {
                return "H";
            }
            case '\u4f18': {
                return "Y";
            }
            case '\u4f73': {
                return "J";
            }
            case '\u5b9d': {
                return "B";
            }
            case '\u5b89': {
                return "A";
            }
            case '\u4e00': {
                return "Y";
            }
            case '\u4e8c': {
                return "E";
            }
            case '\u4e09': {
                return "S";
            }
            case '\u56db': {
                return "S";
            }
            case '\u4e94': {
                return "W";
            }
            case '\u516d': {
                return "L";
            }
            case '\u4e03': {
                return "Q";
            }
            case '\u516b': {
                return "B";
            }
            case '\u4e5d': {
                return "J";
            }
            case '\u5341': {
                return "S";
            }
            case '\u6c47': {
                return "H";
            }
            case '\u4ec1': {
                return "R";
            }
            case '\u548c': {
                return "H";
            }
            case '\u8bda': {
                return "C";
            }
            case '\u4fe1': {
                return "X";
            }
            case '\u5fb7': {
                return "D";
            }
            case '\u798f': {
                return "F";
            }
            case '\u5bff': {
                return "S";
            }
            case '\u559c': {
                return "X";
            }
            case '\u8d22': {
                return "C";
            }
            case '\u4e1c': {
                return "D";
            }
            case '\u5357': {
                return "N";
            }
            case '\u897f': {
                return "X";
            }
            case '\u5317': {
                return "B";
            }
            case '\u4e2d': {
                return "Z";
            }
            case '\u7ea2': {
                return "H";
            }
            case '\u9ec4': {
                return "H";
            }
            case '\u84dd': {
                return "L";
            }
            case '\u7eff': {
                return "L";
            }
            case '\u767d': {
                return "B";
            }
            case '\u9ed1': {
                return "H";
            }
        }
        char unicode = c;
        if (unicode >= '\u4e00' && unicode <= '\u5200') {
            return String.valueOf((char)(65 + (unicode - 19968) % 26));
        }
        if (unicode >= '\u5200' && unicode <= '\u6400') {
            return String.valueOf((char)(65 + (unicode - 20992) % 26));
        }
        if (unicode >= '\u6400' && unicode <= '\u7600') {
            return String.valueOf((char)(65 + (unicode - 25600) % 26));
        }
        if (unicode >= '\u7600' && unicode <= '\u8800') {
            return String.valueOf((char)(65 + (unicode - 30208) % 26));
        }
        return String.valueOf((char)(65 + (unicode - 34816) % 26));
    }
}

