/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.ICspTbPersonPartnerRelApi;
import com.dtyunxi.tcbj.api.dto.request.CspTbPersonPartnerRelReqDto;
import com.dtyunxi.tcbj.api.query.ICspTbPersonPartnerRelQueryApi;
import com.dtyunxi.tcbj.app.open.biz.service.IPersonPartnerRelService;
import com.dtyunxi.tcbj.app.open.dao.das.PersonPartnerRelDas;
import com.dtyunxi.tcbj.app.open.dao.eo.PersonPartnerRelEo;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.yundt.cube.center.customer.api.ICsRCustomerSalesmanApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryExtApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@DS(value="slave_1")
public class PersonPartnerRelServiceImpl
implements IPersonPartnerRelService {
    private Logger logger = LoggerFactory.getLogger(IPersonPartnerRelService.class);
    @Autowired
    private PersonPartnerRelDas personPartnerRelDas;
    @Value(value="${customer.salesman.relation.pageSize:2000}")
    private Integer pageSize;
    @Autowired
    private ICspTbPersonPartnerRelApi cspTbPersonPartnerRelApi;
    @Autowired
    private IShopQueryApi shopQueryApi;
    @Autowired
    private ICsRCustomerSalesmanApi csRCustomerSalesmanApi;
    @Autowired
    private ICspTbPersonPartnerRelQueryApi cspTbPersonPartnerRelQueryApi;
    @Resource
    private IOrganizationQueryExtApi organizationQueryExtApi;

    @Override
    public String syncCustomerSalesman(List<String> masterOuIdList) {
        this.logger.info("\u5f00\u59cb\u8fdb\u884c\u5ba2\u6237\u4eba\u5458\u5173\u7cfb\u540c\u6b65\u66f4\u65b0\u5220\u9664\u4efb\u52a1:{}", masterOuIdList);
        String str = null;
        ShopQueryReqDto shopQueryReqDto = new ShopQueryReqDto();
        shopQueryReqDto.setCodes(masterOuIdList);
        List shopDtos = (List)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryShopByCode(shopQueryReqDto));
        if (shopDtos.size() < 1) {
            throw new BizException("\u7ec4\u7ec7\u4e0d\u5b58\u5728");
        }
        Set ouSet = shopDtos.stream().map(ShopDto::getCode).collect(Collectors.toSet());
        this.cspTbPersonPartnerRelApi.deleteByMasterOuId(masterOuIdList);
        for (String masterOuId : masterOuIdList) {
            if (!ouSet.contains(masterOuId) || masterOuId == null || masterOuId.equals("")) {
                str = "\u7ec4\u7ec7\u4e0d\u5b58\u5728";
                break;
            }
            long start = System.currentTimeMillis();
            Integer pageNum = 1;
            List relationList = this.personPartnerRelDas.personPartnerRelPage(Integer.valueOf((pageNum - 1) * this.pageSize), Integer.valueOf(pageNum * this.pageSize), masterOuId);
            while (CollectionUtils.isNotEmpty((Collection)relationList)) {
                this.personPartnerInsert(relationList);
                Integer n = pageNum;
                Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
                relationList = this.personPartnerRelDas.personPartnerRelPage(Integer.valueOf((pageNum - 1) * this.pageSize), Integer.valueOf(pageNum * this.pageSize), masterOuId);
                this.logger.info("\u4e1a\u52a1\u5458\u4e0e\u5c0fb\u5ba2\u6237\u5173\u7cfb\u540c\u6b65\u4e1a\u52a1\uff0c\u5f53\u524d\u9875\uff1a{}", (Object)pageNum);
            }
            List logicDellist = (List)RestResponseHelper.extractData((RestResponse)this.cspTbPersonPartnerRelQueryApi.salesManOrgIdbyMasterOuId(masterOuId));
            this.logger.info("\u67e5\u8be2\u9700\u8981\u903b\u8f91\u5220\u9664orgId:{}", (Object)JacksonUtil.toJson((Object)logicDellist));
            if (CollectionUtils.isNotEmpty((Collection)logicDellist)) {
                str = "\u540c\u6b65\u540e\u903b\u8f91\u5220\u9664\u884c\u6570:" + RestResponseHelper.extractData((RestResponse)this.csRCustomerSalesmanApi.removeCustomerSalesmanByOrgIds(logicDellist));
                this.logger.info(str);
            }
            this.logger.info("\u4e1a\u52a1\u5458\u4e0e\u5c0fb\u5ba2\u6237\u5173\u7cfb\u540c\u6b65\u4e1a\u52a1\uff0c\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
        }
        return str;
    }

    private void personPartnerInsert(List<PersonPartnerRelEo> relationList) {
        ArrayList<CspTbPersonPartnerRelReqDto> cspTbPersonPartnerRelReqDtos = new ArrayList<CspTbPersonPartnerRelReqDto>();
        for (PersonPartnerRelEo personPartnerRelEo : relationList) {
            CspTbPersonPartnerRelReqDto cspTbPersonPartnerRelReqDto = new CspTbPersonPartnerRelReqDto();
            cspTbPersonPartnerRelReqDto.setRowId(personPartnerRelEo.getRid());
            cspTbPersonPartnerRelReqDto.setFullName(personPartnerRelEo.getFullname());
            cspTbPersonPartnerRelReqDto.setEmpNo(personPartnerRelEo.getEmpno());
            cspTbPersonPartnerRelReqDto.setPhoneNumber(personPartnerRelEo.getPhonenumber());
            cspTbPersonPartnerRelReqDto.setCustomerId(personPartnerRelEo.getCustomerid());
            cspTbPersonPartnerRelReqDto.setName(personPartnerRelEo.getName());
            cspTbPersonPartnerRelReqDto.setMasterOuId(personPartnerRelEo.getMasterOuId());
            cspTbPersonPartnerRelReqDtos.add(cspTbPersonPartnerRelReqDto);
        }
        this.cspTbPersonPartnerRelApi.batchAddCspTbPersonPartnerRel(cspTbPersonPartnerRelReqDtos);
    }
}

