/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.scheduler;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.tcbj.app.open.biz.service.ILimitsService;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.LimsQualityInfoPredictReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import java.util.Calendar;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="SyncReportSubmitInspectedEvent")
@Scope(value="prototype")
public class SyncReportSubmitInspectedEvent
extends SingleTupleScheduleEvent {
    private static Logger logger = LoggerFactory.getLogger(SyncReportSubmitInspectedEvent.class);
    private static final String SYNC_REPORT_SUBMIT_INSPECTED_START_TIME = "sync_report_submit_inspected_start_time";
    @Value(value="${scheduler.client.syncSubmitQualityStartTime:2021-01-01 00:00:00}")
    private String syncStartTime;
    @Value(value="${scheduler.client.aheadSubmitQualityStartTime:-11}")
    private Integer aheadStartTime;
    @Resource
    private ICacheService cacheService;
    @Resource
    private ILimitsService limitsService;

    public void before(TaskMsg taskMsg) {
        logger.info("\u3010-----------------------\u5b9a\u65f6\u4efb\u52a1\u540c\u6b65\u8d28\u68c0\u63d0\u5355\u62a5\u544a\u6570\u636e\u5f00\u59cb--------------\u3011");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(TaskMsg taskMsg) {
        if (!this.cacheService.setIfAbsent("syncReportSubmitInspectedEvent", (Object)1, 1800).booleanValue()) {
            return true;
        }
        try {
            logger.info("\u5b9a\u65f6\u4efb\u52a1\u540c\u6b65\u8d28\u68c0\u63d0\u5355\u62a5\u544a\u6570\u636e\u5f00\u59cb");
            long startTime = System.currentTimeMillis();
            this.task();
            long endTime = System.currentTimeMillis();
            logger.info("SyncReportSubmitInspectedEvent\u3010\u5b9a\u65f6\u4efb\u52a1\u540c\u6b65\u8d28\u68c0\u63d0\u5355\u62a5\u544a\u6570\u636e\u3011\u7ed3\u675f\uff0c\u7528\u65f6\uff1a{}", (Object)(startTime - endTime + "ms"));
        }
        catch (Exception e) {
            logger.error("\u5b9a\u65f6\u4efb\u52a1\u540c\u6b65\u8d28\u68c0\u63d0\u5355\u62a5\u544a\u6570\u636e\u5f00\u59cb\u5f02\u5e38", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.cacheService.delCache("syncReportInspectedEvent");
        }
        return true;
    }

    private void task() {
        String startTime = (String)this.cacheService.getCache(SYNC_REPORT_SUBMIT_INSPECTED_START_TIME, String.class);
        if (StringUtils.isBlank((CharSequence)startTime)) {
            startTime = this.syncStartTime;
        }
        startTime = this.getLimitDate(startTime);
        LimsQualityInfoPredictReqDto reqDto = new LimsQualityInfoPredictReqDto();
        reqDto.setStartDate(startTime);
        String time = this.limitsService.syncQueryPredictQualityReport(reqDto);
        if (StringUtils.isNotBlank((CharSequence)time)) {
            this.cacheService.setCache(SYNC_REPORT_SUBMIT_INSPECTED_START_TIME, (Object)time);
        }
    }

    private String getLimitDate(String startTime) {
        try {
            DateTime date;
            try {
                date = DateUtil.parse((CharSequence)startTime, (String)"yyyy-MM-dd HH:mm:ss");
            }
            catch (Exception ex) {
                date = DateUtil.parse((CharSequence)startTime, (String)"yyyy-MM-dd");
            }
            Calendar instance = Calendar.getInstance();
            instance.setTime((Date)date);
            instance.add(12, this.aheadStartTime);
            startTime = DateUtil.format((Date)instance.getTime(), (String)"yyyy-MM-dd HH:mm:ss");
            return startTime;
        }
        catch (Exception e) {
            e.printStackTrace();
            return startTime;
        }
    }

    public void after(TaskMsg taskMsg) {
        logger.info("\u3010-----------------------\u5b9a\u65f6\u4efb\u52a1\u540c\u6b65\u8d28\u68c0\u63d0\u5355\u62a5\u544a\u6570\u636e\u7ed3\u675f--------------\u3011");
    }
}

