/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.dtyunxi.tcbj.app.open.biz.enums.AddressEnum;
import com.dtyunxi.tcbj.app.open.biz.enums.DataDistributeRespEnum;
import com.dtyunxi.tcbj.app.open.biz.service.ICenterHandleService;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.ModelInfoReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.DataDistributeRespDto;
import com.dtyunxi.tcbj.center.openapi.api.enums.ModelCodeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.IAddressApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.AddressAddReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.IAddressQueryApi;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="centerHandleCustomerAddressServiceImpl")
public class CenterHandleCustomerAddressServiceImpl
implements ICenterHandleService {
    private static Logger logger = LoggerFactory.getLogger(CenterHandleCustomerAddressServiceImpl.class);
    @Resource
    private IAddressApi addressApi;
    @Resource
    private IAddressQueryApi addressQueryApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi iCustomerQueryApi;

    @Override
    public String getModelType() {
        return ModelCodeEnum.ADDRESS.name();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DataDistributeRespDto> handle(ModelInfoReqDto modelInfoReqDto) {
        logger.info("\u5730\u5740\u6570\u636e\u540c\u6b65\u5f00\u59cb:{}", (Object)JSONObject.toJSONString((Object)modelInfoReqDto));
        List list = JSONObject.parseArray((String)modelInfoReqDto.getDataStr(), Map.class);
        ArrayList<DataDistributeRespDto> responseList = new ArrayList<DataDistributeRespDto>();
        DataDistributeRespDto dataDistributeRespDto = new DataDistributeRespDto();
        String type = DataDistributeRespEnum.SUCCESS.getCode();
        String reason = DataDistributeRespEnum.SUCCESS.getValue();
        for (Map map : list) {
            try {
                logger.info("============\u300b map = \uff1a{}", (Object)JSONObject.toJSONString((Object)map, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                this.addAddress(map);
            }
            catch (Exception e) {
                logger.info("\u540c\u6b65\u5730\u5740\u5f02\u5e38:{}", (Throwable)e);
                type = DataDistributeRespEnum.FAILURE.getCode();
                reason = e.getMessage();
            }
            finally {
                dataDistributeRespDto.setType(type);
                dataDistributeRespDto.setReason(reason);
                responseList.add(dataDistributeRespDto);
            }
        }
        logger.info("\u5730\u5740\u6570\u636e\u540c\u6b65\u7ed3\u675f:{}", (Object)JSONObject.toJSONString(responseList));
        return responseList;
    }

    public void addAddress(Map<String, String> map) {
        Optional.ofNullable(this.customerQueryApi.queryByThirdPartyIds((List)Lists.newArrayList((Object[])new String[]{map.get(AddressEnum.PARTNER_ID.getCode())})).getData()).filter(CollUtil::isNotEmpty).ifPresent(customerRespDtos -> {
            CustomerRespDto customerRespDto = (CustomerRespDto)customerRespDtos.get(0);
            Long orgInfoId = customerRespDto.getOrgInfoId();
            AddressAddReqDto reqDto = new AddressAddReqDto();
            reqDto.setOrgInfoId(orgInfoId);
            reqDto.setAddressType("1");
            reqDto.setCity((String)map.get(AddressEnum.CITY_NAME.getCode()));
            reqDto.setCityCode((String)map.get(AddressEnum.TYPE.getCode()));
            reqDto.setContact((String)map.get(AddressEnum.DEFPERID.getCode()));
            reqDto.setPhone((String)map.get(AddressEnum.DEFPERPHONE.getCode()));
            reqDto.setStatus(Integer.valueOf(1));
            reqDto.setTenantId(customerRespDto.getTenantId());
            reqDto.setInstanceId(customerRespDto.getInstanceId());
            reqDto.setProvince((String)map.get(AddressEnum.STATE_NAME.getCode()));
            reqDto.setProvinceCode((String)map.get(AddressEnum.STATE.getCode()));
            reqDto.setDetailAddr((String)map.get(AddressEnum.ADDRESS.getCode()));
            String district = (String)map.get(AddressEnum.COUNTY_NAME.getCode());
            reqDto.setRegion(district == null ? "" : district);
            reqDto.setDistrict(district == null ? "" : district);
            reqDto.setDistrictCode((String)map.get(AddressEnum.COUNTY.getCode()));
            this.addressApi.addAddress(reqDto);
        });
    }
}

