/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.IterUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.dto.RequestBaseData;
import com.dtyunxi.tcbj.app.open.biz.enums.DataDistributeRespEnum;
import com.dtyunxi.tcbj.app.open.biz.service.ICenterHandleService;
import com.dtyunxi.tcbj.app.open.biz.service.ISellerSkuPriceService;
import com.dtyunxi.tcbj.app.open.dao.das.DataDistributeDas;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.ModelInfoReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.UpdateItemDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.DataDistributeRespDto;
import com.dtyunxi.tcbj.center.openapi.api.enums.ModelCodeEnum;
import com.dtyunxi.tcbj.center.openapi.api.exception.ItemEnum;
import com.dtyunxi.yundt.cube.center.item.api.IItemSycnExtApi;
import com.dtyunxi.yundt.cube.center.item.api.IPcpItemApi;
import com.dtyunxi.yundt.cube.center.item.api.base.IBrandApi;
import com.dtyunxi.yundt.cube.center.item.api.base.IItemApi;
import com.dtyunxi.yundt.cube.center.item.api.base.IItemSkuApi;
import com.dtyunxi.yundt.cube.center.item.api.base.IPropApi;
import com.dtyunxi.yundt.cube.center.item.api.base.IUnitApi;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemBundleReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemChangeApplyDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemPriceReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.TagReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.UnitReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.BrandRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.UnitRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IBrandQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemSkuQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IPropQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IUnitQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemExtendReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemProValue;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.PcpItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemExtendRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.PcpItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.query.IItemExtendQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.query.IPcpItemQueryApi;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="centerHandleMaterialServiceImpl")
public class CenterHandleMaterialServiceImpl
implements ICenterHandleService {
    private static Logger logger = LoggerFactory.getLogger(CenterHandleMaterialServiceImpl.class);
    @Resource
    private IItemApi iItemApi;
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private IItemSkuApi iItemSkuApi;
    @Resource
    private IItemSkuQueryApi iItemSkuQueryApi;
    @Resource
    private IPropQueryApi propQueryApi;
    @Resource
    private IItemSycnExtApi iItemSycnExtApi;
    @Resource
    private IBrandApi brandApi;
    @Resource
    private IBrandQueryApi brandQueryApi;
    @Resource
    private RequestBaseData requestBaseData;
    @Resource
    private ISellerSkuPriceService sellerSkuPriceService;
    @Resource
    private IPropApi propApi;
    @Resource
    private IPcpItemApi pcpItemApi;
    @Autowired
    private DataDistributeDas dataDistributeDas;
    @Autowired
    private IUnitQueryApi unitQueryApi;
    @Resource
    private IUnitApi unitApi;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IPcpItemQueryApi iPcpItemQueryApi;
    @Resource
    private IItemExtendQueryApi itemExtendQueryApi;

    @Override
    public String getModelType() {
        return ModelCodeEnum.MATERIAL.name();
    }

    @Override
    public List<DataDistributeRespDto> handle(ModelInfoReqDto modelInfoReqDto) {
        logger.info("\u7269\u6599\u6570\u636e\u5206\u53d1:{}", (Object)JSONObject.toJSONString((Object)modelInfoReqDto));
        ArrayList<UpdateItemDto> updateItemDtoList = new ArrayList<UpdateItemDto>();
        List respDtos = Optional.ofNullable(JSONObject.parseArray((String)modelInfoReqDto.getDataStr(), Map.class)).map(list -> {
            List futures = list.stream().map(map -> CompletableFuture.supplyAsync(() -> {
                DataDistributeRespDto dataDistributeRespDto = new DataDistributeRespDto();
                dataDistributeRespDto.setType(DataDistributeRespEnum.SUCCESS.getCode());
                dataDistributeRespDto.setReason("\u5546\u54c1\u7f16\u7801\u4e3a:" + map.get(ItemEnum.FNUMBER.getCode()));
                try {
                    dataDistributeRespDto.setTask_id(String.valueOf(map.get(ItemEnum.CIDP_TASK_UUID.getCode())));
                    logger.info("\u65b0\u589e\u5546\u54c1");
                    Object itemName = map.get(ItemEnum.FNAME.getCode());
                    logger.info("\u5546\u54c1\u540d\u79f0\u4e3a:{}", (Object)JSON.toJSONString(itemName));
                    if (Objects.isNull(itemName)) {
                        return dataDistributeRespDto;
                    }
                    Long itemId = this.createItem((Map<String, String>)map);
                    logger.info("\u65b0\u589e\u5546\u54c1sku,itemId\uff1a{}", (Object)itemId);
                    this.createItemSku((Map<String, String>)map, itemId);
                    logger.info("================\u300b \u65b0\u589e\u5e93\u5b58\u8d27\u54c1\u5165\u53c2");
                    updateItemDtoList.add(this.buildUpdateItem((Map<String, String>)map));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.info("\u540c\u6b65\u5546\u54c1\u62a5\u9519:{}", (Object)e.getMessage());
                    dataDistributeRespDto.setType(DataDistributeRespEnum.FAILURE.getCode());
                    dataDistributeRespDto.setReason(e.getMessage());
                }
                return dataDistributeRespDto;
            })).collect(Collectors.toList());
            return futures.stream().map(future -> {
                try {
                    return (DataDistributeRespDto)future.get();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DataDistributeRespDto dataDistributeRespDto = new DataDistributeRespDto();
                    dataDistributeRespDto.setType(DataDistributeRespEnum.FAILURE.getCode());
                    dataDistributeRespDto.setReason(e.getMessage());
                    return dataDistributeRespDto;
                }
            }).collect(Collectors.toList());
        }).orElse(new ArrayList(0));
        ArrayList<PcpItemRespDto> itemExtendRespDtoList = new ArrayList<PcpItemRespDto>();
        if (CollectionUtil.isNotEmpty(updateItemDtoList)) {
            ItemExtendReqDto itemExtendReqDto = new ItemExtendReqDto();
            List itemCodeList = updateItemDtoList.stream().map(UpdateItemDto::getCode).collect(Collectors.toList());
            itemExtendReqDto.setItemCodeList(itemCodeList);
            List csInventorySupplierRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemExtendQueryApi.queryParam(itemExtendReqDto));
            logger.info("\u540c\u6b65\u5546\u54c1\u67e5\u8be2\u5230\u6570\u636e:{}", (Object)JSON.toJSONString((Object)csInventorySupplierRespDtos));
            for (ItemExtendRespDto dto : csInventorySupplierRespDtos) {
                if (dto.getId() == null) continue;
                PcpItemRespDto pcpItemRespDto = (PcpItemRespDto)RestResponseHelper.extractData((RestResponse)this.iPcpItemQueryApi.queryByPrimaryKey(dto.getId()));
                itemExtendRespDtoList.add(pcpItemRespDto);
            }
            if (CollectionUtils.isNotEmpty(itemExtendRespDtoList)) {
                MessageVo messageVo = new MessageVo();
                messageVo.setData((Object)JSON.toJSONString(itemExtendRespDtoList));
                this.commonsMqService.sendSingleMessage("PRODUCT_INFORMATION_RECEIVING_LOG", (Object)messageVo);
            }
            this.publicSyncItem(updateItemDtoList);
        }
        return respDtos;
    }

    private UpdateItemDto buildUpdateItem(Map<String, String> map) {
        UpdateItemDto updateItemDto = new UpdateItemDto();
        updateItemDto.setCode(map.get(ItemEnum.FNUMBER.getCode()));
        updateItemDto.setName(map.get(ItemEnum.FNAME.getCode()));
        if (StringUtils.isBlank((CharSequence)updateItemDto.getCode()) || StringUtils.isBlank((CharSequence)updateItemDto.getName())) {
            logger.info("\u53c2\u6570\u5f02\u5e38\uff0c\u540d\u79f0\u4e0e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return null;
        }
        return updateItemDto;
    }

    private void publicSyncItem(List<UpdateItemDto> list) {
        logger.info("\u5e7f\u64ad\u540c\u6b65\u5546\u54c1\u6d88\u606f\uff0c\u4f9b\u5176\u4ed6\u4e2d\u5fc3\u66f4\u65b0\u5546\u54c1\u540d\u79f0\u7b49\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(list));
        try {
            MessageVo messageVo = new MessageVo();
            messageVo.setData((Object)JSON.toJSONString(list));
            MessageResponse messageResponse = this.commonsMqService.publishMessage("PCP_PUBLIC_SYNC_ITEM", (Object)messageVo);
        }
        catch (Exception e) {
            logger.error("\u5e7f\u64ad\u540c\u6b65\u5546\u54c1\u6d88\u606f\uff0c\u4f9b\u5176\u4ed6\u4e2d\u5fc3\u66f4\u65b0\u5546\u54c1\u540d\u79f0\u7b49\u4fe1\u606f\u5f02\u5e38");
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private Long createItem(Map<String, String> map) {
        logger.info("test");
        String itemName = map.get(ItemEnum.FNAME.getCode());
        ItemChangeApplyDto changApply = new ItemChangeApplyDto();
        Long id = null;
        String longCode = map.get(ItemEnum.FNUMBER.getCode());
        List itemRespDtos = (List)this.itemQueryApi.queryByItemLongCodes((List)Lists.newArrayList((Object[])new String[]{longCode})).getData();
        logger.info("\u6821\u9a8c\u5546\u54c1\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)itemRespDtos));
        if (CollectionUtil.isNotEmpty((Collection)itemRespDtos) && !Objects.isNull(((ItemRespDto)itemRespDtos.get(0)).getId())) {
            ItemReqDto itemReqDto = new ItemReqDto();
            id = ((ItemRespDto)itemRespDtos.get(0)).getId();
            itemReqDto.setName(itemName);
            itemReqDto.setId(id);
            itemReqDto.setUpdatePerson("MDM");
            this.iItemApi.modifyItem(itemReqDto);
            PcpItemReqDto pcpItemReqDto = new PcpItemReqDto();
            pcpItemReqDto.setExpirationDate(map.get(ItemEnum.FPERIODVALID));
            pcpItemReqDto.setExpirationUnit(map.get(ItemEnum.FPERIODVALIDUNIT));
            pcpItemReqDto.setCfproducers(map.get(ItemEnum.CFPRODUCERS));
            pcpItemReqDto.setLongCode(map.get(ItemEnum.FNUMBER));
            this.pcpItemApi.modifyPcpItem(pcpItemReqDto);
            logger.info("\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5df2\u5b58\u5728\uff01");
        } else {
            changApply.setBrandId(this.createBrand(map));
            changApply.setStatus(Integer.valueOf(2));
            changApply.setItemCode(map.get(ItemEnum.ZNUMBER.getCode()));
            changApply.setItemName(itemName);
            logger.info("=================> \u65b0\u589e\u5546\u54c1\u540d\u79f0 : {}", (Object)changApply.getItemName());
            changApply.setDisplayName(changApply.getItemName());
            changApply.setBrand(map.get(ItemEnum.CFPINPAINAME.getCode()));
            changApply.setDirId(Long.valueOf(1288630386802423099L));
            changApply.setDirName("\u9ed8\u8ba4\u7c7b\u76ee");
            changApply.setLongCode(longCode);
            changApply.setType(Integer.valueOf(1));
            changApply.setSubType(this.getItemType(map.get(ItemEnum.FNUMBER_ORDERPRODTYPE.getCode())));
            if (changApply.getLongCode().startsWith("A.A")) {
                changApply.setSubType(Integer.valueOf(1));
            }
            changApply.setAttrs(this.assembleAttr(map));
            changApply.setSellerId(Long.valueOf(0L));
            changApply.setCreatePerson("MDM");
            changApply.setUpdatePerson("MDM");
            changApply.setDosageForm(map.get(ItemEnum.CFJIXINGNAME.getCode()));
            changApply.setTenantId(this.requestBaseData.getTenantId());
            changApply.setInstanceId(this.requestBaseData.getInstanceId());
            logger.info("\u65b0\u589e\u5546\u54c1\u5165\u53c2 : {}", (Object)JSONObject.toJSONString((Object)changApply));
            id = (Long)this.iItemApi.addItem(changApply).getData();
        }
        return id;
    }

    private void createItemSku(Map<String, String> map, Long itemId) {
        ItemBundleReqDto itemBundleReqDto = new ItemBundleReqDto();
        List skuRespDtos = (List)this.iItemSkuQueryApi.queryBySkuCode((List)Lists.newArrayList((Object[])new String[]{map.get(ItemEnum.FNUMBER.getCode())})).getData();
        logger.info("\u67e5\u8be2\u5546\u54c1sku\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)skuRespDtos));
        if (CollectionUtil.isNotEmpty((Collection)skuRespDtos)) {
            logger.info("\u5546\u54c1sku\u5df2\u5b58\u5728\uff01");
            ItemSkuRespDto itemSkuRespDto = (ItemSkuRespDto)skuRespDtos.get(0);
            BeanUtils.copyProperties((Object)itemSkuRespDto, (Object)itemBundleReqDto);
            itemBundleReqDto.setBarCode(StringUtils.isEmpty((CharSequence)map.get(ItemEnum.FBARCODE.getCode())) ? null : map.get(ItemEnum.FBARCODE.getCode()));
            itemBundleReqDto.setName(map.get(ItemEnum.FNAME.getCode()));
            itemBundleReqDto.setId(itemSkuRespDto.getId());
            String unitCode = map.get(ItemEnum.FBASEUNIT.getCode());
            String unitName = map.get(ItemEnum.FBASEUNITNUM.getCode());
            itemBundleReqDto.setAttr("{\"\u9ed8\u8ba4\":\"" + unitName + "\"}");
            if (StringUtils.isNotBlank((CharSequence)unitName) && StringUtils.isNotBlank((CharSequence)unitCode)) {
                itemBundleReqDto.setUnit(this.createItemUnit(unitCode, unitName).toString());
            }
            ArrayList bundleReqDtos = Lists.newArrayList();
            bundleReqDtos.add(itemBundleReqDto);
            this.iItemSkuApi.modifyItemSku((List)bundleReqDtos);
        } else {
            itemBundleReqDto.setItemId(itemId);
            itemBundleReqDto.setBarCode(StringUtils.isEmpty((CharSequence)map.get(ItemEnum.FBARCODE.getCode())) ? null : map.get(ItemEnum.FBARCODE.getCode()));
            itemBundleReqDto.setVolumeUnit(StringUtils.isEmpty((CharSequence)map.get(ItemEnum.FVOLUME.getCode())) ? null : map.get(ItemEnum.FVOLUME.getCode()));
            itemBundleReqDto.setGrossWeight(StringUtils.isEmpty((CharSequence)map.get(ItemEnum.FGROSSWEIGHT.getCode())) ? null : BigDecimal.valueOf(Double.parseDouble(map.get(ItemEnum.FGROSSWEIGHT.getCode()))));
            itemBundleReqDto.setNetWeight(StringUtils.isEmpty((CharSequence)map.get(ItemEnum.FNETWEIGHT.getCode())) ? null : BigDecimal.valueOf(Double.parseDouble(map.get(ItemEnum.FNETWEIGHT.getCode()))));
            itemBundleReqDto.setMinPackage(StringUtils.isEmpty((CharSequence)map.get(ItemEnum.FNUMBER_MINUNIT.getCode())) ? null : Integer.valueOf((int)Double.parseDouble(map.get(ItemEnum.FNUMBER_MINUNIT.getCode()))));
            String unitCode = map.get(ItemEnum.FBASEUNIT.getCode());
            String unitName = map.get(ItemEnum.FBASEUNITNUM.getCode());
            itemBundleReqDto.setAttr("{\"\u9ed8\u8ba4\":\"" + unitName + "\"}");
            if (StringUtils.isNotBlank((CharSequence)unitName) && StringUtils.isNotBlank((CharSequence)unitCode)) {
                itemBundleReqDto.setUnit(this.createItemUnit(unitCode, unitName).toString());
            }
            itemBundleReqDto.setName(map.get(ItemEnum.FNAME.getCode()));
            itemBundleReqDto.setMinPackage(Integer.valueOf(1));
            itemBundleReqDto.setCargoCode(map.get(ItemEnum.FNUMBER.getCode()));
            itemBundleReqDto.setCode(map.get(ItemEnum.FNUMBER.getCode()));
            itemBundleReqDto.setCreatePerson("\u7cfb\u7edf\u7528\u6237");
            itemBundleReqDto.setTenantId(this.requestBaseData.getTenantId());
            itemBundleReqDto.setInstanceId(this.requestBaseData.getInstanceId());
            logger.info("=================> \u65b0\u589e\u5546\u54c1sku\u5165\u53c2 : {}", (Object)JSONObject.toJSONString((Object)itemBundleReqDto));
            ArrayList prices = Lists.newArrayList();
            ItemPriceReqDto itemPriceReqDto = new ItemPriceReqDto();
            itemPriceReqDto.setName("\u5212\u7ebf\u4ef7");
            itemPriceReqDto.setCurrency("\u5143");
            itemPriceReqDto.setPrice(new BigDecimal(99999.9));
            itemPriceReqDto.setPriceType("PRICE");
            prices.add(itemPriceReqDto);
            itemPriceReqDto = new ItemPriceReqDto();
            itemPriceReqDto.setName("\u552e\u4ef7");
            itemPriceReqDto.setCurrency("\u5143");
            itemPriceReqDto.setPrice(new BigDecimal(99999.9));
            itemPriceReqDto.setPriceType("RETAIL_PRICE");
            prices.add(itemPriceReqDto);
            itemBundleReqDto.setPrices((List)prices);
            this.iItemSkuApi.addItemSku((List)Lists.newArrayList((Object[])new ItemBundleReqDto[]{itemBundleReqDto}));
        }
    }

    private Long createBrand(Map<String, String> map) {
        Long id = null;
        BrandRespDto brandRespDto = (BrandRespDto)this.brandQueryApi.queryCode(ItemEnum.CFPINPAIDNUM.getCode()).getData();
        logger.info("\u67e5\u8be2\u54c1\u724c\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)brandRespDto));
        if (brandRespDto == null) {
            TagReqDto.BrandReqDto brandReqDto = new TagReqDto.BrandReqDto();
            brandReqDto.setCode(map.get(ItemEnum.CFPINPAIDNUM.getCode()));
            brandReqDto.setName(map.get(ItemEnum.CFPINPAINAME.getCode()));
            brandReqDto.setStatus(Integer.valueOf(1));
            brandReqDto.setCreatePerson("\u7cfb\u7edf\u7528\u6237");
            brandReqDto.setTenantId(this.requestBaseData.getTenantId());
            brandReqDto.setInstanceId(this.requestBaseData.getInstanceId());
            logger.info("=================> \u65b0\u589e\u54c1\u724c\u5165\u53c2 : {}", (Object)JSONObject.toJSONString((Object)brandReqDto));
            id = (Long)this.brandApi.addBrand(brandReqDto).getData();
            logger.info("=================> \u65b0\u589e\u54c1\u724cid : {}", (Object)id);
        } else {
            logger.info("=================> \u54c1\u724c\u5df2\u5b58\u5728 : {}", (Object)brandRespDto.getId());
            id = brandRespDto.getId();
        }
        return id;
    }

    private Long createItemUnit(String code, String name) {
        UnitRespDto unitRespDto = (UnitRespDto)this.unitQueryApi.queryByCode(code.replace("/", ".")).getData();
        if (unitRespDto == null) {
            UnitReqDto unitReqDto = new UnitReqDto();
            unitReqDto.setCode(code);
            unitReqDto.setName(name);
            unitReqDto.setEnglishName(name);
            unitReqDto.setType("number");
            unitReqDto.setStatus(Integer.valueOf(1));
            unitReqDto.setCreatePerson("MDM");
            unitReqDto.setTenantId(this.requestBaseData.getTenantId());
            unitReqDto.setInstanceId(this.requestBaseData.getInstanceId());
            return (Long)this.unitApi.addUnit(unitReqDto).getData();
        }
        return unitRespDto.getId();
    }

    private void createItemPrice(String longCode) {
        this.sellerSkuPriceService.addNewSellerSkuPrice(longCode);
    }

    private Integer getItemType(String type) {
        switch (type) {
            case "PRODUCT": {
                return 1;
            }
            case "MATERIAL": {
                return 3;
            }
            case "GIFT": {
                return 2;
            }
        }
        return 1;
    }

    private boolean isEmpty(Object obj) {
        if (obj.toString().equals("{\"extFields\":{}}")) {
            return true;
        }
        if (null == obj) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return StrUtil.isEmpty((CharSequence)((CharSequence)obj));
        }
        if (obj instanceof Map) {
            return MapUtil.isEmpty((Map)((Map)obj));
        }
        if (obj instanceof Iterable) {
            return IterUtil.isEmpty((Iterable)((Iterable)obj));
        }
        if (obj instanceof Iterator) {
            return IterUtil.isEmpty((Iterator)((Iterator)obj));
        }
        return ArrayUtil.isArray((Object)obj) ? ArrayUtil.isEmpty((Object)obj) : false;
    }

    private String assembleAttr(Map<String, String> map) {
        String fmodle = map.get(ItemEnum.FMODEL.getCode());
        if (StringUtils.isEmpty((CharSequence)fmodle)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{\"backDirList\":[1288630386802423099],\"propList\":[{\"extFields\":{},\"id\":");
        ItemProValue itemProValue = new ItemProValue();
        itemProValue.setName(fmodle);
        itemProValue.setPropNameId(Long.valueOf(1291088791304623272L));
        this.iItemSycnExtApi.addProValue(itemProValue);
        String name = "\"name\":\"\u9ed8\u8ba4\",";
        String propValueList = "\"propValueList\":[\"" + fmodle + "\"]}]}";
        stringBuilder.append(name);
        stringBuilder.append(propValueList);
        logger.info("\u7ec4\u88c5\u5c5e\u6027\uff1a{}", (Object)JSONObject.toJSONString((Object)stringBuilder.toString()));
        return stringBuilder.toString();
    }
}

