/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.dto.request.PcpItemExtend;
import com.dtyunxi.tcbj.app.open.biz.enums.PcpItemExtendColumnEnum;
import com.dtyunxi.tcbj.app.open.biz.service.ICenterHandleService;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.ModelInfoReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.DataDistributeRespDto;
import com.dtyunxi.tcbj.center.openapi.api.enums.ModelCodeEnum;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.yundt.cube.center.item.api.IItemExtendApi;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemExtendReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemExtendRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.PcpItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.query.IItemExtendQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.query.IPcpItemQueryApi;
import com.google.common.base.Functions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import liquibase.util.StringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="CenterHandlePcpItemExtendServiceImpl")
public class CenterHandlePcpItemExtendServiceImpl
implements ICenterHandleService {
    private static Logger logger = LoggerFactory.getLogger(CenterHandlePcpItemExtendServiceImpl.class);
    @Resource
    private IItemExtendQueryApi itemExtendQueryApi;
    @Resource
    private IItemExtendApi itemExtendApi;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IPcpItemQueryApi iPcpItemQueryApi;

    @Override
    public String getModelType() {
        return ModelCodeEnum.PCP_ITEM_EXTEND.name();
    }

    @Override
    public List<DataDistributeRespDto> handle(ModelInfoReqDto modelInfoReqDto) {
        long startTime = System.currentTimeMillis();
        ArrayList<DataDistributeRespDto> respDtoList = new ArrayList<DataDistributeRespDto>();
        DataDistributeRespDto respDto = new DataDistributeRespDto();
        logger.info("\u5546\u54c1\u6269\u5c55\u6570\u636e\u5206\u53d1:{}", (Object)JSON.toJSONString((Object)modelInfoReqDto));
        List maps = JSONArray.parseArray((String)modelInfoReqDto.getDataStr(), Map.class);
        String str = this.validaData(maps);
        if (StringUtils.isNotEmpty((String)str)) {
            throw new BizException(str);
        }
        List pcpWarehousesList = maps.stream().map(map -> (PcpItemExtend)JacksonUtil.readValue((String)JacksonUtil.toJson((Object)map), PcpItemExtend.class)).collect(Collectors.toList());
        List itemCodeList = pcpWarehousesList.stream().map(PcpItemExtend::getItemCode).collect(Collectors.toList());
        ItemExtendReqDto itemExtendReqDto = new ItemExtendReqDto();
        itemExtendReqDto.setItemCodeList(itemCodeList);
        List csInventorySupplierRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemExtendQueryApi.queryParam(itemExtendReqDto));
        Map itemExtendMap = csInventorySupplierRespDtos.stream().collect(Collectors.toMap(ItemExtendRespDto::getItemCode, Functions.identity(), (n1, n2) -> n1));
        AtomicInteger insertCount = new AtomicInteger(0);
        AtomicInteger updateCount = new AtomicInteger(0);
        AtomicInteger failCount = new AtomicInteger(0);
        ArrayList<PcpItemRespDto> itemExtendRespDtoList = new ArrayList<PcpItemRespDto>();
        for (PcpItemExtend dto : pcpWarehousesList) {
            ItemExtendRespDto itemExtendRespDto = (ItemExtendRespDto)itemExtendMap.get(dto.getItemCode());
            if (Objects.nonNull(itemExtendRespDto)) {
                if (itemExtendRespDto.getId() != null) {
                    PcpItemRespDto pcpItemRespDto = (PcpItemRespDto)RestResponseHelper.extractData((RestResponse)this.iPcpItemQueryApi.queryByPrimaryKey(itemExtendRespDto.getId()));
                    itemExtendRespDtoList.add(pcpItemRespDto);
                }
                ItemExtendReqDto modifyReqDto = new ItemExtendReqDto();
                modifyReqDto.setId(itemExtendRespDto.getId());
                CubeBeanUtils.copyProperties((Object)modifyReqDto, (Object)dto, (String[])new String[0]);
                this.itemExtendApi.modifyItemExtend(modifyReqDto);
                updateCount.addAndGet(1);
                continue;
            }
            ItemExtendReqDto addReqDto = new ItemExtendReqDto();
            CubeBeanUtils.copyProperties((Object)addReqDto, (Object)dto, (String[])new String[0]);
            this.itemExtendApi.addItemExtend(addReqDto);
            insertCount.addAndGet(1);
        }
        if (CollectionUtils.isNotEmpty(itemExtendRespDtoList)) {
            MessageVo messageVo = new MessageVo();
            messageVo.setData((Object)JSON.toJSONString(itemExtendRespDtoList));
            this.commonsMqService.sendSingleMessage("PRODUCT_INFORMATION_RECEIVING_LOG", (Object)messageVo);
        }
        logger.info("\u3010PCP\u5546\u54c1\u6269\u5c55\u65b0\u589e\u540c\u6b65mq\u3011\u843d\u5e93\u5b8c\u6210\uff0c\u5171\u8ba1\uff1a{}\uff0c\u65b0\u589e\uff1a{}\uff0c\u66f4\u65b0\uff1a{}\uff0c\u5f02\u5e38\uff1a{}", new Object[]{maps.size(), insertCount, updateCount, failCount});
        long endTime = System.currentTimeMillis();
        logger.info("\u3010PCP\u5546\u54c1\u6269\u5c55\u65b0\u589e\u540c\u6b65mq\u3011\u8017\u65f6\uff1a{}", (Object)(startTime - endTime + "ms"));
        logger.info("\u3010PCP\u5546\u54c1\u6269\u5c55\u65b0\u589e\u540c\u6b65mq\u3011\u7ed3\u675f\u540c\u6b65--------->");
        respDto.setReason("\u66f4\u65b0\u6210\u529f");
        respDtoList.add(respDto);
        return respDtoList;
    }

    private String validaData(List<Map> dataMap) {
        if (dataMap == null || dataMap.size() <= 0) {
            return "\u540c\u6b65\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a";
        }
        for (Map map : dataMap) {
            for (Object s : map.keySet()) {
                if (Objects.isNull(s)) {
                    return "\u540c\u6b65\u6570\u636e\u5b57\u6bb5\u540d\u4e0d\u80fd\u4e3a\u7a7a";
                }
                PcpItemExtendColumnEnum pcpSupplierColumnEnum = PcpItemExtendColumnEnum.getByField(s.toString());
                if (pcpSupplierColumnEnum == null || pcpSupplierColumnEnum.validate(s.toString()).booleanValue()) continue;
                return String.format("%s\u4e0d\u80fd\u4e3a\u7a7a", pcpSupplierColumnEnum.getFieldName());
            }
        }
        return null;
    }
}

