/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.INutritionCollectApi;
import com.dtyunxi.tcbj.api.dto.request.NutritionCollectReqDto;
import com.dtyunxi.tcbj.app.open.biz.service.INutritionistService;
import com.dtyunxi.tcbj.center.openapi.api.external.IExternalOutEasApi;
import com.dtyunxi.tcbj.center.openapi.common.eas.dto.Bill;
import com.dtyunxi.tcbj.center.openapi.common.eas.dto.BillEntry;
import com.dtyunxi.tcbj.center.openapi.common.eas.dto.EASBillReqDto;
import com.dtyunxi.tcbj.center.openapi.common.eas.dto.EASOrderBaseResult;
import com.dtyunxi.yundt.cube.center.trade.api.ISaleOrderApi;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class NutritionistServiceImpl
implements INutritionistService {
    private static final Logger logger = LoggerFactory.getLogger(NutritionistServiceImpl.class);
    @Resource
    private INutritionCollectApi nutritionCollectApi;
    @Resource(name="externalOutEasRest")
    private IExternalOutEasApi externalOutEasRest;
    @Resource
    private ISaleOrderApi saleOrderApi;

    @Override
    public RestResponse<String> nutritionOrderCollectToEas(NutritionCollectReqDto reqDto) {
        logger.info("nutritionOrderCollectToEas\u8425\u517b\u5bb6\u5355\u636e\u6c47\u603b\u63a8\u9001EAS\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        List execute = (List)RestResponseHelper.extractData((RestResponse)this.nutritionCollectApi.execute(reqDto));
        if (CollectionUtil.isEmpty((Collection)execute)) {
            logger.info("\u65e0\u6c47\u603b\u6570\u636e");
            return new RestResponse((Object)"\u65e0\u6c47\u603b\u6570\u636e");
        }
        logger.info("\u6c47\u603b\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)execute));
        execute.forEach(e -> {
            logger.info("\u6c47\u603b\u6570\u636e\uff0c\u63a8\u9001EAS\uff1a{}", (Object)JSON.toJSONString((Object)e));
            EASOrderBaseResult result = null;
            try {
                Bill bill = new Bill();
                BeanUtils.copyProperties((Object)e, (Object)bill);
                ArrayList entries = new ArrayList();
                CubeBeanUtils.copyCollection(entries, (Collection)e.getEntrys(), BillEntry.class);
                bill.setEntrys(entries);
                EASBillReqDto easBillReqDto = new EASBillReqDto();
                easBillReqDto.setAutoSubmit(Boolean.valueOf(true));
                easBillReqDto.setAutoAudit(Boolean.valueOf(true));
                easBillReqDto.setOtherIssueBills((List)Lists.newArrayList((Object[])new Bill[]{bill}));
                result = (EASOrderBaseResult)RestResponseHelper.extractData((RestResponse)this.externalOutEasRest.otherOut(easBillReqDto));
            }
            catch (Exception e0) {
                logger.error("\u8bf7\u6c42EAS\u5931\u8d25");
                logger.error(e0.getMessage(), (Throwable)e0);
            }
            try {
                if (ObjectUtil.isNotEmpty(result) && ObjectUtil.isNotEmpty((Object)result.getOrderNum())) {
                    RestResponseHelper.extractData((RestResponse)this.saleOrderApi.updateEasOutOrderNo(e.getSaleOrderNoList(), result.getOrderNum()));
                } else {
                    logger.error("\u7ed3\u679c\u4e3a\u7a7a");
                }
            }
            catch (Exception e1) {
                logger.error("\u6267\u884c\u6210\u529f\u4fdd\u5b58EAS\u5355\u53f7\u5f02\u5e38");
                logger.error(e1.getMessage(), (Throwable)e1);
            }
        });
        return new RestResponse((Object)"\u6267\u884c\u5b8c\u6bd5");
    }
}

