/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.mq.dispatch.processor;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.tcbj.app.open.biz.constant.CommonConstant;
import com.dtyunxi.tcbj.app.open.biz.mq.dispatch.vo.EmployeeEventVo;
import com.dtyunxi.tcbj.app.open.biz.utils.RestUtil;
import com.dtyunxi.yundt.cube.center.identity.api.v3.ITokenApi;
import com.dtyunxi.yundt.cube.center.user.api.IUserApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="tcbj-employee-event-queue")
public class EmployeeStatusProcessor
implements IMessageProcessor<Object> {
    private static final Logger log = LoggerFactory.getLogger(EmployeeStatusProcessor.class);
    @Value(value="${employee.update.syncEmployeeStatus:false}")
    private boolean syncEmployeeStatus;
    @Resource
    private IUserQueryApi userQueryApi;
    @Resource
    private ITokenApi tokenApi;
    @Resource
    private IUserApi userApi;

    public MessageResponse process(Object message) {
        log.info("\u63a5\u6536\u5230\u5458\u5de5\u72b6\u6001\u53d8\u66f4\u7684MQ\u6570\u636e:{}", message);
        if (!this.syncEmployeeStatus) {
            log.info("\u63a5\u6536\u5230\u5458\u5de5\u72b6\u6001\u53d8\u66f4\u7684MQ\u6570\u636e");
            return MessageResponse.SUCCESS;
        }
        this.handler(message);
        return MessageResponse.SUCCESS;
    }

    private void handler(Object message) {
        EmployeeEventVo employeeEventVo = (EmployeeEventVo)JSONObject.parseObject((String)String.valueOf(message), EmployeeEventVo.class);
        UserDto userDto = (UserDto)this.userQueryApi.queryByLoginStr(employeeEventVo.getLoginName(), CommonConstant.INSTANCE_ID, "").getData();
        if (userDto == null) {
            return;
        }
        try {
            if (Objects.equals(employeeEventVo.getState(), 0)) {
                this.tokenApi.deleteToken(userDto.getId() + "");
            }
            userDto.setStatus(employeeEventVo.getState());
            RestUtil.checkResponse(this.userApi.update(userDto.getId(), userDto));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u540c\u6b65\u7528\u6237\u72b6\u6001\u5f02\u5e38:{}", (Object)e.getMessage());
        }
    }
}

