/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.scheduler;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.service.IDataDistributeService;
import com.dtyunxi.tcbj.app.open.dao.eo.YxyInventoryVo;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.log.ICsInventoryYxyDailyApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.log.CsInventoryYxyDailyAddReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAdvQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryExtApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="syncCargoBalanceEvent")
@Scope(value="prototype")
public class SyncCargoBalanceEvent
extends SingleTupleScheduleEvent {
    private static Logger logger = LoggerFactory.getLogger(SyncCargoBalanceEvent.class);
    @Autowired
    private IDataDistributeService dataDistributeService;
    @Resource
    private IOrganizationQueryExtApi organizationQueryExtApi;
    @Resource
    private ICsInventoryYxyDailyApi csInventoryYxyDailyApi;

    public void before(TaskMsg taskMsg) {
    }

    public boolean execute(TaskMsg taskMsg) {
        long startTime = System.currentTimeMillis();
        this.task(null);
        long endTime = System.currentTimeMillis();
        logger.info("SyncCargoBalanceEvent\u3010\u5b9a\u65f6\u5bf9\u6bd4\u8425\u9500\u4e91\u5e93\u5b58\u548c\u5e93\u5b58\u4e2d\u5fc3\u5e93\u5b58\u3011\u7ed3\u675f\uff0c\u7528\u65f6\uff1a{}", (Object)(startTime - endTime + "ms"));
        return true;
    }

    public void task(List<String> orgCodeList) {
        logger.info("SyncCargoBalanceEvent \u8425\u9500\u4e91\u5e93\u5b58\u4e0e\u5e93\u5b58\u4e2d\u5fc3\u5e93\u5b58\u5bf9\u6bd4\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(orgCodeList));
        if (CollectionUtils.isEmpty(orgCodeList)) {
            logger.info("SyncCargoBalanceEvent \u6ca1\u6709\u4f20\u7ec4\u7ec7\u7f16\u7801\u5373\u67e5\u8be2\u6240\u6709\u7ec4\u7ec7\u7684\u8425\u9500\u4e91\u5e93\u5b58\u4fe1\u606f");
            PageInfo orgPage = (PageInfo)RestResponseHelper.extractData((RestResponse)this.organizationQueryExtApi.queryPage(new OrgAdvQueryReqDto(), Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE)));
            if (Objects.isNull(orgPage) || CollectionUtils.isEmpty((Collection)orgPage.getList())) {
                return;
            }
            orgCodeList = orgPage.getList().stream().map(e -> e.getCode()).collect(Collectors.toList());
        }
        logger.info("SyncCargoBalanceEvent \u67e5\u8be2\u8425\u9500\u4e91\u5e93\u5b58\u7ec4\u7ec7id\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(orgCodeList));
        for (String orgCode : orgCodeList) {
            List<YxyInventoryVo> yxyInventoryVoList = this.dataDistributeService.queryListByOrgIdList(Lists.newArrayList((Object[])new String[]{orgCode}));
            if (CollectionUtils.isEmpty(yxyInventoryVoList)) {
                logger.info("SyncCargoBalanceEvent \u79df\u6237\u7f16\u7801\uff1a{}\u6570\u636e\u4e3a\u7a7a", (Object)orgCode);
                continue;
            }
            HashMap<String, ArrayList<CsInventoryYxyDailyAddReqDto>> map = new HashMap<String, ArrayList<CsInventoryYxyDailyAddReqDto>>();
            for (YxyInventoryVo yxyInventoryVo : yxyInventoryVoList) {
                CsInventoryYxyDailyAddReqDto addReqDto = new CsInventoryYxyDailyAddReqDto();
                addReqDto.setBatch(yxyInventoryVo.getLot());
                addReqDto.setCargoCode(yxyInventoryVo.getMaterialNo());
                addReqDto.setCargoName(yxyInventoryVo.getMaterialName());
                addReqDto.setWarehouseCode(yxyInventoryVo.getDepotNo());
                addReqDto.setWarehouseName(yxyInventoryVo.getDepotName());
                addReqDto.setQuantity(StringUtils.isBlank((CharSequence)yxyInventoryVo.getBaseqty()) ? BigDecimal.ZERO : new BigDecimal(yxyInventoryVo.getBaseqty()));
                addReqDto.setOrgCode(yxyInventoryVo.getYxyTenantId());
                if (StringUtils.isBlank((CharSequence)addReqDto.getWarehouseCode()) || StringUtils.isBlank((CharSequence)addReqDto.getCargoCode()) || StringUtils.isBlank((CharSequence)addReqDto.getBatch())) continue;
                ArrayList<CsInventoryYxyDailyAddReqDto> list = (ArrayList<CsInventoryYxyDailyAddReqDto>)map.get(addReqDto.getWarehouseCode());
                if (CollectionUtils.isEmpty((Collection)list)) {
                    list = new ArrayList<CsInventoryYxyDailyAddReqDto>();
                }
                list.add(addReqDto);
                map.put(addReqDto.getWarehouseCode(), list);
            }
            for (Map.Entry entry : map.entrySet()) {
                logger.info("SyncCargoBalanceEvent \u8c03\u7528\u8425\u9500\u4e91\u5e93\u5b58\u4e0e\u5e93\u5b58\u4e2d\u5fc3\u903b\u8f91\u6279\u6b21\u8868\u5bf9\u6bd4 \u4ed3\u5e93\u7f16\u7801\uff1a\u3010{}\u3011", entry.getKey());
                RestResponseHelper.extractData((RestResponse)this.csInventoryYxyDailyApi.add((List)entry.getValue()));
                logger.info("SyncCargoBalanceEvent \u8c03\u7528\u8425\u9500\u4e91\u5e93\u5b58\u4e0e\u5e93\u5b58\u4e2d\u5fc3\u903b\u8f91\u6279\u6b21\u8868\u5bf9\u6bd4 \u4ed3\u5e93\u7f16\u7801\uff1a\u3010{}\u3011\u5b8c\u6210", entry.getKey());
            }
        }
    }

    public void after(TaskMsg taskMsg) {
    }
}

