/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import cn.hutool.core.collection.IterUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.dto.RequestBaseData;
import com.dtyunxi.tcbj.app.open.biz.enums.CustomerEnum;
import com.dtyunxi.tcbj.app.open.biz.service.IPcpCustomerHandleService;
import com.dtyunxi.tcbj.app.open.dao.das.OpPcpCustomerDas;
import com.dtyunxi.tcbj.app.open.dao.das.PcpCustomerDas;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsCustomerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.IEasCustomerOrgRelationApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.ICustomerApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerTypeRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerTypeQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EasCustomerOrgRelationReqDto;
import com.dtyunxi.yundt.cube.center.user.api.IOrganizationExtApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAdvAddReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAdvQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvOpRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CenterHandlePcpCustomerServiceImpl
implements IPcpCustomerHandleService {
    private static Logger logger = LoggerFactory.getLogger(CenterHandlePcpCustomerServiceImpl.class);
    @Resource
    private ICustomerApi customerApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private ICustomerTypeQueryApi customerTypeQueryApi;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private RequestBaseData requestBaseData;
    @Value(value="${level.name}")
    private String level;
    @Value(value="${customer.orgIdUrl}")
    private String orgIdUrl;
    @Value(value="${customerLevel.max}")
    private Long customerLevelMax;
    @Value(value="${customerLevel.min}")
    private Long customerLevelMin;
    @Value(value="${yundt.com.open.query.customer:false}")
    private boolean queryEasCustomerView;
    @Value(value="${yundt.com.open.query.customer.pageSize:200}")
    private Integer pageSize;
    @Resource
    private ICacheService cacheService;
    @Resource
    private IOrganizationExtApi organizationExtApi;
    @Resource
    private PcpCustomerDas pcpCustomerDas;
    private static final String DEALER = "\u79df\u6237";
    private static final String FIRST_DEALER = "1P\u7ecf\u9500\u5546";
    private static final Long DEFAULT_ORG_PARENT_ID = 1252411810853067012L;
    private static final Long CUSTOMER_STATUS_ID = 1256288005151458333L;
    private static final Long CUSTOMER_TYPE_ID = 1283393536750893057L;
    private static final Long CUSTOMER_STATUS_ID_EXPIRE = 1256288052502004816L;
    private static final String ORG_ID = "orgId";
    private static final String PARENT_ORG_ID = "parentOrgId";
    private static final Long DIVISION_TCBJ = 1000000000000000001L;
    private static final Long DIVISION_JLD = 1000000000000000002L;
    private static final Long DIVISION_LIFE_SPACE = 1000000000000000003L;
    private static final String DIVISION_JLD_ORG_ID = "1-8GDRG";
    private static final String DIVISION_LIFE_SPACE_ORG_ID = "241ae7b5ce2142a78e7c6fe14d3587c0";
    @Resource
    private OpPcpCustomerDas opPcpCustomerDas;
    @Resource
    private IEasCustomerOrgRelationApi easCustomerOrgRelationApi;
    @Resource
    private ICommonsMqService commonsMqService;

    @Override
    public void syncCustomer(Map params) {
        logger.info("\u5ba2\u6237\u6570\u636e\u540c\u6b65\u5f00\u59cb----->>");
        logger.info("\u6267\u884c\u53c2\u6570\uff1a{}", (Object)(ObjectUtil.isNotEmpty((Object)params) ? JSON.toJSONString((Object)params) : "\u65e0"));
        String startDate = null;
        String endDate = null;
        if (ObjectUtil.isNotEmpty((Object)params) && ObjectUtil.isNotEmpty(params.get("startDate")) && ObjectUtil.isNotEmpty(params.get("endDate"))) {
            startDate = params.get("startDate").toString();
            endDate = params.get("endDate").toString();
            params.remove("startDate");
            params.remove("endDate");
        }
        Integer pageNum = 1;
        List<Map<String, String>> mapList = Lists.newArrayList();
        mapList = this.queryEasCustomerView ? this.pcpCustomerDas.selectPcpCustomer(params, pageNum, this.pageSize, startDate, endDate) : this.opPcpCustomerDas.selectPcpCustomer(params, pageNum, this.pageSize);
        while (CollectionUtils.isNotEmpty((Collection)mapList)) {
            mapList.forEach(map -> {
                try {
                    this.getDataDistributeRespDto((Map)map);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error("\u540c\u6b65eas\u5ba2\u6237\u4fe1\u606f\u62a5\u9519\uff0c\u5ba2\u6237\u7f16\u7801\u4e3a:{}", map.get(CustomerEnum.CUSTOMER_CODE.getCode()));
                }
            });
            this.handleEasCustomerTenant(mapList);
            Integer n = pageNum;
            Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
            mapList = this.queryEasCustomerView ? this.pcpCustomerDas.selectPcpCustomer(params, Integer.valueOf((pageNum - 1) * this.pageSize), Integer.valueOf(pageNum * this.pageSize), startDate, endDate) : this.opPcpCustomerDas.selectPcpCustomer(params, Integer.valueOf((pageNum - 1) * this.pageSize), Integer.valueOf(pageNum * this.pageSize));
            logger.info("\u540c\u6b65\u89c6\u56fe\uff0c\u5f53\u524d\u9875\uff1a{}", (Object)pageNum);
        }
    }

    private void getDataDistributeRespDto(Map map) {
        try {
            logger.info("====================\u300b \u5904\u7406\u79df\u6237(\u7ec4\u7ec7)\uff0c\u5e76\u8fd4\u56de\u79df\u6237id");
            Map<String, Long> orgMap = this.handleOrg(map);
            Long orgId = orgMap.get(ORG_ID);
            logger.info("====================\u300b \u5904\u7406\u5ba2\u6237");
            this.handleCustomer(map, orgId, orgMap.get(PARENT_ORG_ID));
            logger.info("====================\u300b \u5904\u7406\u5927B\u5356\u5bb6, \u5e97\u94fa");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info("\u540c\u6b65\u5ba2\u6237\u5f02\u5e38:{}", (Object)e.getMessage());
        }
    }

    private void handleEasCustomerTenant(List<Map<String, String>> maps) {
        try {
            logger.info("\u8bb0\u5f55EAS\u5ba2\u6237\u79df\u6237\u5173\u7cfb\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(maps));
            List partition = Lists.partition(maps, (int)100);
            partition.forEach(cutList -> {
                ArrayList list = new ArrayList();
                cutList.forEach(map -> {
                    EasCustomerOrgRelationReqDto dto = new EasCustomerOrgRelationReqDto();
                    dto.setCustomerCode((String)map.get(CustomerEnum.CUSTOMER_CODE.getCode()));
                    dto.setTenantCode((String)map.get(CustomerEnum.MASTER_OU_NO.getCode()));
                    list.add(dto);
                });
                if (CollectionUtils.isNotEmpty(list)) {
                    this.easCustomerOrgRelationApi.syncEasCustomerOrgRelation(list);
                }
            });
        }
        catch (Exception e) {
            logger.info("\u8bb0\u5f55\u5173\u7cfb\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            e.printStackTrace();
        }
    }

    private CustomerReqDto handleCustomer(Map<String, String> map, Long orgId, Long parentOrgId) {
        logger.info("\u5ba2\u6237\u6570\u636e\u4e3a:{}", (Object)JSONObject.toJSONString(map));
        String name = map.get(CustomerEnum.NAME.getCode());
        String orgCode = map.get(CustomerEnum.MASTER_OU_NO.getCode());
        if (StringUtils.isBlank((CharSequence)orgCode)) {
            orgCode = map.get(CustomerEnum.MASTER_OU_ID.getCode());
        }
        CustomerReqDto customerRespDto = new CustomerReqDto();
        customerRespDto.setCode(map.get(CustomerEnum.CUSTOMER_CODE.getCode()));
        customerRespDto.setName(name);
        customerRespDto.setOrgInfoId(orgId);
        customerRespDto.setEasCode(map.get(CustomerEnum.CUSTOMER_CODE.getCode()));
        customerRespDto.setMerchantId(parentOrgId);
        customerRespDto.setStatusId(CUSTOMER_STATUS_ID);
        customerRespDto.setAuditStatus(CustomerEnum.AUDIT_PASS.getCode());
        customerRespDto.setProvinceCode(map.get(CustomerEnum.PROVINCE.getCode()));
        customerRespDto.setProvince(map.get(CustomerEnum.PROVINCENAME.getCode()));
        customerRespDto.setCityCode(map.get(CustomerEnum.CITY.getCode()));
        customerRespDto.setCity(map.get(CustomerEnum.CITYNAME.getCode()));
        customerRespDto.setCountyCode(map.get(CustomerEnum.COUNTY.getCode()));
        customerRespDto.setCounty(map.get(CustomerEnum.COUNTYNAME.getCode()));
        customerRespDto.setAddress(map.get(CustomerEnum.COMPANYADDRESS.getCode()));
        customerRespDto.setAliasname(map.get(CustomerEnum.ALIASNAME.getCode()));
        customerRespDto.setEasCode(map.get(CustomerEnum.EXTERNALCODE.getCode()));
        customerRespDto.setTenantId(this.requestBaseData.getTenantId());
        customerRespDto.setInstanceId(this.requestBaseData.getInstanceId());
        customerRespDto.setEasCode(map.get(CustomerEnum.EXTERNALCODE.getCode()));
        customerRespDto.setLevelId(this.getCustomerLevel(map.get(CustomerEnum.LEVELNAME.getCode())));
        customerRespDto.setCustomerTypeId(CUSTOMER_TYPE_ID);
        String thridId = map.get(CustomerEnum.ROW_ID.getCode());
        if (this.queryEasCustomerView) {
            thridId = map.get(CustomerEnum.CUSTOMER_CODE.getCode());
        }
        logger.info("\u62fc\u63a5\u5ba2\u6237\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)customerRespDto));
        RestResponse restResponse = this.customerQueryApi.queryCustomerListByCodes((List)Lists.newArrayList((Object[])new String[]{thridId}));
        logger.info("\u67e5\u8be2\u5ba2\u6237\u662f\u5426\u5b58\u5728\uff1a{}", (Object)JSONObject.toJSONString((Object)restResponse));
        WmsCustomerReqDto wmsCustomerReqDto = new WmsCustomerReqDto();
        if (ObjectUtil.isNotEmpty((Object)restResponse.getData())) {
            List customerRespDtos = (List)restResponse.getData();
            logger.info("\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u4e0d\u4e3a\u7a7a\uff0c\u66f4\u65b0\u5ba2\u6237\u4fe1\u606f\uff01");
            customerRespDto.setId(((CustomerRespDto)customerRespDtos.get(0)).getId());
            customerRespDto.setUpdatePerson("EAS");
            RestResponse customerRespone = this.customerApi.update(customerRespDto);
            logger.info("\u4fee\u6539\u5ba2\u6237\uff1a{}", (Object)JSONObject.toJSONString((Object)customerRespone));
            CubeBeanUtils.copyProperties((Object)wmsCustomerReqDto, (Object)customerRespDto, (String[])new String[0]);
        } else {
            customerRespDto.setType(Integer.valueOf(2));
            customerRespDto.setThirdParentPartyId(orgCode);
            customerRespDto.setThirdPartyId(thridId);
            customerRespDto.setCreatePerson("EAS");
            customerRespDto.setUpdatePerson("EAS");
            RestResponse customerRespone = this.customerApi.add(customerRespDto);
            customerRespDto.setId((Long)customerRespone.getData());
            logger.info("\u65b0\u589e\u5ba2\u6237\uff1a{}", (Object)JSONObject.toJSONString((Object)customerRespone));
            CubeBeanUtils.copyProperties((Object)wmsCustomerReqDto, (Object)customerRespDto, (String[])new String[0]);
            wmsCustomerReqDto.setId(null);
        }
        MessageVo messageVo = new MessageVo();
        messageVo.setData(JSONObject.toJSON((Object)wmsCustomerReqDto));
        this.commonsMqService.sendSingleMessage("SAVE_SUPPLIER_TAG", (Object)messageVo);
        return customerRespDto;
    }

    private Long getCustomerTypeId(Map<String, String> map) {
        if (map.get(CustomerEnum.LEVELNAME.getCode()).equals(FIRST_DEALER)) {
            logger.info("============================= \u5f00\u59cb\u83b7\u53d6\u5c0fb\u5ba2\u6237\u7ea7\u522b =======================");
            RestResponse listRestResponse = this.customerTypeQueryApi.queryAllSimpleCustomerType(Integer.valueOf(2));
            logger.info("\u67e5\u8be2\u5ba2\u6237\u7ea7\u522b\uff1a{}, {}", (Object)FIRST_DEALER, (Object)JSONObject.toJSONString((Object)listRestResponse));
            String orgTypeName = map.get(CustomerEnum.ORGTYPENAME.getCode());
            return ((CustomerTypeRespDto)((List)listRestResponse.getData()).stream().filter(s -> orgTypeName.equals(s.getName())).collect(Collectors.toList()).get(0)).getId();
        }
        logger.info("============================= \u5f00\u59cb\u83b7\u53d6\u5927b\u5ba2\u6237\u7ea7\u522b ========================");
        RestResponse listRestResponse = this.customerTypeQueryApi.queryAllSimpleCustomerType(Integer.valueOf(1));
        logger.info("\u67e5\u8be2\u5ba2\u6237\u7ea7\u522b\uff1a{}, {}", (Object)FIRST_DEALER, (Object)JSONObject.toJSONString((Object)listRestResponse));
        return ((CustomerTypeRespDto)((List)listRestResponse.getData()).stream().filter(s -> "\u4e00\u7ea7\u7ecf\u9500\u5546".equals(s.getName())).collect(Collectors.toList()).get(0)).getId();
    }

    private Map<String, Long> handleOrg(Map<String, String> map) {
        String orgCode = map.get(CustomerEnum.MASTER_OU_NO.getCode());
        if (StringUtils.isBlank((CharSequence)orgCode)) {
            orgCode = map.get(CustomerEnum.MASTER_OU_ID.getCode());
        }
        String orgName = map.get(CustomerEnum.ORGNAME.getCode());
        HashMap<String, Long> orgMap = new HashMap<String, Long>();
        Long orgId = this.getOrgId(orgCode, orgName);
        orgMap.put(PARENT_ORG_ID, orgId);
        String orgCodeCSN = map.get(CustomerEnum.CUSTOMER_CODE.getCode());
        String orgNameCSN = map.get(CustomerEnum.NAME.getCode());
        orgMap.put(ORG_ID, this.getOrgId(orgCodeCSN, orgNameCSN));
        logger.info("====================================== {}", (Object)JSONObject.toJSONString(orgMap));
        return orgMap;
    }

    private Long getOrgId(String orgCode, String orgName) {
        OrgAdvQueryReqDto orgAdvQueryReqDto = new OrgAdvQueryReqDto();
        orgAdvQueryReqDto.setCode(orgCode);
        RestResponse organizationDtoRestResponse = this.organizationQueryApi.queryOneByOrgCode(null, orgCode);
        logger.info("\u67e5\u8be2\u79df\u6237\u4fe1\u606f {}", (Object)JSONObject.toJSONString((Object)organizationDtoRestResponse));
        if (organizationDtoRestResponse.getData() != null) {
            return ((OrganizationDto)organizationDtoRestResponse.getData()).getId();
        }
        OrgAdvAddReqDto orgAdvAddReqDto = new OrgAdvAddReqDto();
        orgAdvAddReqDto.setCode(orgCode);
        orgAdvAddReqDto.setName(orgName);
        orgAdvAddReqDto.setType("2");
        orgAdvAddReqDto.setTenantId(this.requestBaseData.getTenantId());
        orgAdvAddReqDto.setInstanceId(this.requestBaseData.getInstanceId());
        orgAdvAddReqDto.setParentId(DEFAULT_ORG_PARENT_ID);
        return ((OrgAdvOpRespDto)this.organizationExtApi.add(orgAdvAddReqDto).getData()).getOrgId();
    }

    private Long getCustomerLevel(String type) {
        if (StringUtils.isBlank((CharSequence)type)) {
            return this.customerLevelMin;
        }
        switch (type) {
            case "1P\u7ecf\u9500\u5546": {
                return this.customerLevelMin;
            }
            case "\u79df\u6237": {
                return this.customerLevelMax;
            }
        }
        return this.customerLevelMax;
    }

    private boolean isEmpty(Object obj) {
        if (obj.toString().equals("{\"extFields\":{}}")) {
            return true;
        }
        if (JSONObject.toJSONString((Object)obj).equals("{}")) {
            return true;
        }
        if (null == obj) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return StrUtil.isEmpty((CharSequence)((CharSequence)obj));
        }
        if (obj instanceof Map) {
            return MapUtil.isEmpty((Map)((Map)obj));
        }
        if (obj instanceof Iterable) {
            return IterUtil.isEmpty((Iterable)((Iterable)obj));
        }
        if (obj instanceof Iterator) {
            return IterUtil.isEmpty((Iterator)((Iterator)obj));
        }
        return ArrayUtil.isArray((Object)obj) ? ArrayUtil.isEmpty((Object)obj) : false;
    }

    private String generaAccount(String code) {
        Long i = this.cacheService.incr(code);
        String str = String.format("%06d", i);
        return str;
    }
}

