/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.scheduler;

import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.IQualityInspectionDataApi;
import com.dtyunxi.tcbj.api.dto.request.QualityInspectionSubmitDataReqDto;
import com.dtyunxi.tcbj.app.open.biz.service.IExternalOutService;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.LimsQualityInfoPredictReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="SyncReportSubmitInspectedUpdateEvent")
@Scope(value="prototype")
public class SyncReportSubmitInspectedUpdateEvent
extends SingleTupleScheduleEvent {
    private static final Logger logger = LoggerFactory.getLogger(SyncReportSubmitInspectedUpdateEvent.class);
    @Resource
    private IQualityInspectionDataApi qualityInspectionDataApi;
    @Resource
    private IExternalOutService externalOutService;

    public void before(TaskMsg taskMsg) {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        logger.info("\u8d28\u68c0\u63d0\u5355\u62a5\u544a\u66f4\u65b0\u53d7\u7406\u65f6\u95f4\u8c03\u5ea6");
    }

    public boolean execute(TaskMsg taskMsg) {
        List list = (List)RestResponseHelper.extractData((RestResponse)this.qualityInspectionDataApi.queryListByNotAcceptDate());
        if (CollectionUtil.isEmpty((Collection)list)) {
            List orderNos = list.stream().map(QualityInspectionSubmitDataReqDto::getOrderNo).collect(Collectors.toList());
            LimsQualityInfoPredictReqDto reqDto = new LimsQualityInfoPredictReqDto();
            reqDto.setOrderNOs(orderNos);
            List<Object> resultList = this.externalOutService.queryPredictQualityReport(reqDto);
            resultList = resultList.stream().filter(f -> StringUtils.isNotEmpty((CharSequence)f.getAcceptDate())).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(resultList)) {
                ArrayList dataReqDtoList = new ArrayList();
                CubeBeanUtils.copyCollection(dataReqDtoList, resultList, QualityInspectionSubmitDataReqDto.class);
                this.qualityInspectionDataApi.batchSubmitDataCU(dataReqDtoList);
            }
        }
        return true;
    }

    public void after(TaskMsg taskMsg) {
    }
}

