/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.tcbj.app.open.biz.config.E3BS2Config;
import com.dtyunxi.tcbj.app.open.biz.config.E3BSConfig;
import com.dtyunxi.tcbj.app.open.biz.service.IExternalE3Service;
import com.dtyunxi.tcbj.app.open.biz.service.impl.E3BSService;
import com.dtyunxi.tcbj.center.openapi.api.enums.ExternalSystenEnum;
import com.dtyunxi.tcbj.center.openapi.common.e3.dto.E3BSOtherAddReqDto;
import com.dtyunxi.tcbj.center.openapi.common.e3.dto.E3BSPurchaseAddReqDto;
import com.dtyunxi.tcbj.center.openapi.common.e3.dto.E3BsOtherCancelReqDto;
import java.util.HashMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ExternalE3ServiceImpl
implements IExternalE3Service {
    private static final Logger logger = LoggerFactory.getLogger(ExternalE3ServiceImpl.class);
    @Value(value="${e3Supplier.bs:010001}")
    private String bsSupplier;
    @Value(value="${e3Supplier.my:my001}")
    private String mySupplier;
    @Resource
    private E3BSConfig e3BSConfig;
    @Resource
    private E3BSService e3BSService;
    @Resource
    private E3BS2Config e3BS2Config;

    @Override
    public void otherInAdd(E3BSOtherAddReqDto reqDto, ExternalSystenEnum sysEnum) {
        logger.info("\u5176\u4ed6\u5165\u5e93\u5355\u65b0\u589e\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        this.defaultData(reqDto, sysEnum);
        this.e3BSService.e3Post(this.e3BSConfig.getQtrkdAdd(), BeanUtil.beanToMap((Object)reqDto), sysEnum);
    }

    @Override
    public void otherInCancel(E3BsOtherCancelReqDto reqDto, ExternalSystenEnum sysEnum) {
        logger.info("\u5176\u4ed6\u5165\u5e93\u5355\u53d6\u6d88\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("djbh", reqDto.getOrderNo());
        this.e3BSService.e3Post(this.e3BSConfig.getQtrkdCancel(), map, sysEnum);
    }

    @Override
    public void otherOutAdd(E3BSOtherAddReqDto reqDto, ExternalSystenEnum sysEnum) {
        logger.info("\u5176\u4ed6\u51fa\u5e93\u5355\u65b0\u589e\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        this.defaultData(reqDto, sysEnum);
        this.e3BSService.e3Post(this.e3BSConfig.getQtckdAdd(), BeanUtil.beanToMap((Object)reqDto), sysEnum);
    }

    @Override
    public void otherOutCancel(E3BsOtherCancelReqDto reqDto, ExternalSystenEnum sysEnum) {
        logger.info("\u5176\u4ed6\u51fa\u5e93\u5355\u53d6\u6d88\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("djbh", reqDto.getOrderNo());
        this.e3BSService.e3Post(this.e3BSConfig.getQtckdCancel(), map, sysEnum);
    }

    @Override
    public void purchaseAdd(E3BSPurchaseAddReqDto reqDto, ExternalSystenEnum sysEnum) {
        logger.info("E3\u91c7\u8d2d\u5165\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        this.e3BSService.e3Post(this.e3BS2Config.getSpjhdAdd(), BeanUtil.beanToMap((Object)reqDto), sysEnum);
    }

    @Override
    public void purchaseRefund(E3BSPurchaseAddReqDto reqDto, ExternalSystenEnum sysEnum) {
        logger.info("E3\u91c7\u8d2d\u9000\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        this.e3BSService.e3Post(this.e3BS2Config.getCktcdAdd(), BeanUtil.beanToMap((Object)reqDto), sysEnum);
    }

    private void defaultData(E3BSOtherAddReqDto reqDto, ExternalSystenEnum sysEnum) {
        logger.info("\u8bbe\u7f6e\u9ed8\u8ba4\u503c");
        if (ObjectUtil.isNotEmpty((Object)reqDto) && sysEnum.getCode().equals(ExternalSystenEnum.E3BS.getCode())) {
            reqDto.setGhsdm(this.bsSupplier);
        }
        if (ObjectUtil.isNotEmpty((Object)reqDto) && sysEnum.getCode().equals(ExternalSystenEnum.E3MY.getCode())) {
            reqDto.setGhsdm(this.mySupplier);
        }
    }
}

