/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.scheduler;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.SaleSpOrderSyncReqDto;
import com.dtyunxi.tcbj.api.query.ISaleOrderReportQueryApi;
import com.dtyunxi.tcbj.app.open.biz.service.IExternalOutService;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="SyncSpOrderEvent")
@Scope(value="prototype")
public class SyncSpOrderEvent
extends SingleTupleScheduleEvent {
    private static final Logger logger = LoggerFactory.getLogger(SyncSpOrderEvent.class);
    @Resource
    private IExternalOutService externalOutService;
    @Resource
    private ISaleOrderReportQueryApi saleOrderReportQueryApi;

    public void before(TaskMsg taskMsg) {
        logger.info(JSON.toJSONString((Object)taskMsg));
        logger.info("\u3010-----------------------\u5b9a\u65f6\u4efb\u52a1\u540c\u6b65\u7d22\u8d54\u5355eas\u5355\u53f7\uff0c\u5b9e\u9645\u5ba2\u6237\u4fe1\u606f\u5f00\u59cb--------------\u3011");
    }

    public boolean execute(TaskMsg taskMsg) {
        String content = taskMsg.getContent();
        ArrayList<String> exeDates = new ArrayList<String>();
        String format = "yyyy-MM-dd";
        if (StringUtils.isNotBlank((CharSequence)content)) {
            String[] dates;
            for (String day : dates = content.split(",")) {
                if (!SyncSpOrderEvent.isThisDateValid(day, format)) continue;
                exeDates.add(day);
            }
        }
        SaleSpOrderSyncReqDto dto = new SaleSpOrderSyncReqDto();
        dto.setDates(exeDates);
        List listOrder = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderReportQueryApi.querySaleCompensationOrderList(dto));
        logger.info("\u540c\u6b65\u7d22\u8d54\u5355\u6570\u91cf\u4e3a\uff1a" + listOrder.size());
        this.externalOutService.syncSaleCompensationOrderInfo(listOrder);
        return true;
    }

    public void after(TaskMsg taskMsg) {
    }

    public static boolean isThisDateValid(String dateToValidate, String dateFormat) {
        if (dateToValidate == null) {
            return false;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        sdf.setLenient(false);
        try {
            sdf.parse(dateToValidate);
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }
}

