/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.constant.CommonConstant;
import com.dtyunxi.tcbj.app.open.biz.enums.CustomerMaterialRelEnum;
import com.dtyunxi.tcbj.app.open.biz.enums.DataDistributeRespEnum;
import com.dtyunxi.tcbj.app.open.biz.enums.PsnColumnEnum;
import com.dtyunxi.tcbj.app.open.biz.service.ICenterHandleService;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.ModelInfoReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.DataDistributeRespDto;
import com.dtyunxi.tcbj.center.openapi.api.enums.ModelCodeEnum;
import com.dtyunxi.util.Base64;
import com.dtyunxi.util.RandomCodeUtil;
import com.dtyunxi.yundt.cube.center.identity.api.IUserLoginConfigApi;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.UserLoginConfigReqDto;
import com.dtyunxi.yundt.cube.center.user.api.IEmployeeApi;
import com.dtyunxi.yundt.cube.center.user.api.IOrganizationApi;
import com.dtyunxi.yundt.cube.center.user.api.ISecurityApi;
import com.dtyunxi.yundt.cube.center.user.api.IUserApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.EmployeeOrgRelationReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeAddReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeModifyReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.EmployeeRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IEmployeeQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="centerHandlePsnImpl")
public class CenterHandlePsnImpl
implements ICenterHandleService {
    private static Logger logger = LoggerFactory.getLogger(CenterHandlePsnImpl.class);
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IEmployeeQueryApi employeeQueryApi;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IUserQueryApi userQueryApi;
    @Autowired
    private IOrganizationApi organizationApi;
    @Autowired
    private IUserLoginConfigApi userLoginConfigApi;
    @Autowired
    private ISecurityApi securityApi;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;

    @Override
    public String getModelType() {
        return ModelCodeEnum.PSN.name();
    }

    @Override
    public List<DataDistributeRespDto> handle(ModelInfoReqDto modelInfoReqDto) {
        logger.info("\u8d26\u6237\u6570\u636e\u540c\u6b65\u5f00\u59cb:{}", (Object)JSONObject.toJSONString((Object)modelInfoReqDto));
        List list = JSONObject.parseArray((String)modelInfoReqDto.getDataStr(), Map.class);
        ArrayList<DataDistributeRespDto> responseList = new ArrayList<DataDistributeRespDto>();
        for (Map map : list) {
            try {
                Long userId = 0L;
                if (StringUtils.isNotEmpty((CharSequence)((CharSequence)map.get(PsnColumnEnum.USER_CODE.name())))) {
                    userId = this.handleAccount(map);
                }
                Long employeeId = this.handleEmployee(map, userId);
                this.handleEmployeeOrgRelation(map, employeeId);
                responseList.add(this.dataResp(map.get(CustomerMaterialRelEnum.CIDP_TASK_UUID.name()) == null ? RandomCodeUtil.generateTextCode((int)10, (int)0) : (String)map.get(CustomerMaterialRelEnum.CIDP_TASK_UUID.name()), DataDistributeRespEnum.SUCCESS.getCode(), DataDistributeRespEnum.SUCCESS.getValue()));
            }
            catch (Exception e) {
                logger.info("\u8d26\u6237\u6570\u636e\u5904\u7406\u5f02\u5e38:{}  [{}]", (Object)map, (Object)e);
                e.printStackTrace();
                responseList.add(this.dataResp(map.get(CustomerMaterialRelEnum.CIDP_TASK_UUID.name()) == null ? RandomCodeUtil.generateTextCode((int)10, (int)0) : (String)map.get(CustomerMaterialRelEnum.CIDP_TASK_UUID.name()), DataDistributeRespEnum.FAILURE.getCode(), e.getMessage()));
            }
        }
        logger.info("\u8d26\u6237\u6570\u636e\u540c\u6b65\u7ed3\u675f:{}", (Object)JSONObject.toJSONString(responseList));
        return responseList;
    }

    private void handleEmployeeOrgRelation(Map<String, String> map, Long employeeId) {
        EmployeeOrgRelationReqDto employeeOrgRelationReqDto = new EmployeeOrgRelationReqDto();
        Long groupId = this.getEmployeeOrgId(map);
        if (groupId == null) {
            return;
        }
        employeeOrgRelationReqDto.setEmployeeId(employeeId);
        employeeOrgRelationReqDto.setOrgId(groupId);
        logger.info("\u5904\u7406\u4eba\u5458\u4e0e\u7ec4\u7ec7\u7684\u5173\u7cfb: employeeId={} , {}", (Object)employeeId, (Object)JSONObject.toJSONString((Object)employeeOrgRelationReqDto));
        this.organizationApi.addEmployeeOrgRelation(employeeOrgRelationReqDto);
    }

    private Long getEmployeeOrgId(Map<String, String> map) {
        Long organizationId = this.getOrgId(map.get(PsnColumnEnum.ORGCODE.name()));
        logger.info("\u5927B\u8d26\u6237\u5bf9\u5e94\u7684\u79df\u6237: {}", (Object)organizationId);
        return organizationId;
    }

    private DataDistributeRespDto dataResp(String taskId, String type, String reason) {
        DataDistributeRespDto dataDistributeRespDto = new DataDistributeRespDto();
        dataDistributeRespDto.setTask_id(taskId);
        dataDistributeRespDto.setType(type);
        dataDistributeRespDto.setReason(reason);
        return dataDistributeRespDto;
    }

    private Long handleEmployee(Map<String, String> map, Long userId) {
        logger.info("\u5904\u7406\u4eba\u5458\uff0c \u8fd4\u56de\u4eba\u5458\u4fe1\u606f {}", map);
        EmployeeAddReqDto employeeAddReqDto = new EmployeeAddReqDto();
        String employeeNo = map.get(PsnColumnEnum.PSNCODE.name());
        String oaId = map.get(PsnColumnEnum.OAID.name());
        String dingId = map.get(PsnColumnEnum.DINGID.name());
        HashMap<String, String> extFieldsParam = new HashMap<String, String>();
        HashMap<String, String> extFields = new HashMap<String, String>();
        extFields.put("oaId", oaId);
        extFields.put("dingId", dingId);
        extFieldsParam.put("extension", JSONObject.toJSONString(extFields));
        RestResponse employeeResponse = this.employeeQueryApi.queryByEmployeeNo(employeeNo);
        logger.info("\u67e5\u8be2\u4eba\u5458\u4fe1\u606f\uff1a{}, {}", (Object)employeeNo, (Object)JSONObject.toJSONString((Object)employeeResponse));
        EmployeeRespDto employeeRespDto = (EmployeeRespDto)employeeResponse.getData();
        String phone = map.get(PsnColumnEnum.PHONE.name());
        if (employeeRespDto != null && employeeRespDto.getId() != null) {
            EmployeeModifyReqDto employeeModifyReqDto = new EmployeeModifyReqDto();
            employeeModifyReqDto.setId(employeeRespDto.getId());
            employeeModifyReqDto.setName(map.get(PsnColumnEnum.PSNNAME.name()));
            employeeModifyReqDto.setEmployeeNo(employeeNo);
            if (StringUtils.isNotEmpty((CharSequence)phone)) {
                employeeModifyReqDto.setPhoneNum(phone);
            }
            employeeModifyReqDto.setEmail(map.get(PsnColumnEnum.EMAIL.name()));
            employeeModifyReqDto.setExtFields(extFieldsParam);
            if (StringUtils.isEmpty((CharSequence)employeeModifyReqDto.getEmail())) {
                employeeModifyReqDto.setEmail(employeeAddReqDto.getPhoneNum() + "@tcbj.com");
            }
            employeeModifyReqDto.setUserId(userId);
            employeeModifyReqDto.setNickName(employeeModifyReqDto.getName());
            employeeModifyReqDto.setInstanceId(CommonConstant.INSTANCE_ID);
            employeeModifyReqDto.setTenantId(CommonConstant.TENANT_ID);
            this.employeeApi.modifyEmployee(employeeModifyReqDto);
            logger.info("\u66f4\u65b0\u4eba\u5458\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)employeeModifyReqDto));
            return employeeRespDto.getId();
        }
        employeeAddReqDto.setName(map.get(PsnColumnEnum.PSNNAME.name()));
        employeeAddReqDto.setEmployeeNo(employeeNo);
        if (StringUtils.isNotEmpty((CharSequence)phone)) {
            employeeAddReqDto.setPhoneNum(phone);
        }
        employeeAddReqDto.setEmail(map.get(PsnColumnEnum.EMAIL.name()));
        if (StringUtils.isEmpty((CharSequence)employeeAddReqDto.getEmail())) {
            employeeAddReqDto.setEmail(employeeAddReqDto.getPhoneNum() + "@tcbj.com");
        }
        employeeAddReqDto.setUserId(userId);
        employeeAddReqDto.setNickName(employeeAddReqDto.getName());
        employeeAddReqDto.setInstanceId(CommonConstant.INSTANCE_ID);
        employeeAddReqDto.setTenantId(CommonConstant.TENANT_ID);
        employeeAddReqDto.setExtFields(extFields);
        RestResponse response = this.employeeApi.addEmployee(employeeAddReqDto);
        logger.info("\u65b0\u589e\u4eba\u5458\u4fe1\u606f, {} , {}", (Object)JSONObject.toJSONString((Object)employeeAddReqDto), (Object)JSONObject.toJSONString((Object)response));
        return (Long)response.getData();
    }

    private Long handleAccount(Map<String, String> map) {
        String loginStr = map.get(PsnColumnEnum.USER_CODE.name());
        UserDto userDto = (UserDto)this.userQueryApi.queryByLoginStr(loginStr, CommonConstant.INSTANCE_ID, "").getData();
        logger.info("\u67e5\u8be2\u8d26\u53f7, {}", (Object)JSONObject.toJSONString((Object)userDto));
        boolean isUpdate = true;
        if (userDto == null) {
            isUpdate = false;
            userDto = new UserDto();
        }
        userDto.setUserName(loginStr);
        userDto.setExtension(map.get(PsnColumnEnum.USER_CODE.name()));
        userDto.setNickName(map.get(PsnColumnEnum.PSNNAME.name()));
        userDto.setValidType(Integer.valueOf(1));
        if ("1".equals(map.get(PsnColumnEnum.DATASTATUS.name()))) {
            userDto.setStatus(CommonConstant.UserStatus.ENABLE);
        } else {
            userDto.setStatus(CommonConstant.UserStatus.DISABLE);
        }
        userDto.setTenantId(CommonConstant.TENANT_ID);
        userDto.setInstanceId(CommonConstant.INSTANCE_ID);
        userDto.setPassword(Base64.encodeString((String)"ZJJK123456").replace("==", ""));
        if (isUpdate) {
            logger.info("\u66f4\u65b0\u8d26\u53f7, userid = {}, {}", (Object)userDto.getId(), (Object)JSONObject.toJSONString((Object)userDto));
            ServiceContext.getContext().setAttachment("yes.req.instanceId", CommonConstant.TOB_DEALER_ADMIN_INSTANCE_ID.toString());
            ServiceContext.getContext().setAttachment("yes.req.tenantId", CommonConstant.TENANT_ID.toString());
            this.userApi.update(userDto.getId(), userDto);
            ServiceContext.getContext().setAttachment("yes.req.instanceId", CommonConstant.INSTANCE_ID.toString());
            return userDto.getId();
        }
        ServiceContext.getContext().setAttachment("yes.req.instanceId", CommonConstant.TOB_DEALER_ADMIN_INSTANCE_ID.toString());
        RestResponse longRestResponse1 = this.userApi.addUser(CommonConstant.INSTANCE_ID, userDto);
        ServiceContext.getContext().setAttachment("yes.req.instanceId", CommonConstant.INSTANCE_ID.toString());
        logger.info("\u65b0\u589e\u8d26\u53f7, userid = {}, {}", (Object)JSONObject.toJSONString((Object)longRestResponse1), (Object)JSONObject.toJSONString((Object)userDto));
        Long userId = (Long)longRestResponse1.getData();
        this.securityApi.resetPasswordByAdmin(userId, userDto.getPassword());
        UserLoginConfigReqDto userLoginConfigReqDto = new UserLoginConfigReqDto();
        userLoginConfigReqDto.setLoginConfig("1");
        userLoginConfigReqDto.setUserId(userId);
        RestResponse loginCoifg = this.userLoginConfigApi.putUserLoginConfig(userId, userLoginConfigReqDto);
        logger.info("\u7528\u6237\u767b\u5f55\u914d\u7f6e\u4fe1\u606f {} , {}", (Object)JSONObject.toJSONString((Object)loginCoifg), (Object)JSONObject.toJSONString((Object)userLoginConfigReqDto));
        return userId;
    }

    public Long getOrgId(String code) {
        RestResponse organizationDtoRestResponse = this.organizationQueryApi.queryOneByOrgCode(null, code);
        if (organizationDtoRestResponse.getData() != null) {
            return ((OrganizationDto)organizationDtoRestResponse.getData()).getId();
        }
        return null;
    }
}

