/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.component.track.commons.utils.TransactionTrackContextUtils;
import com.dtyunxi.tcbj.app.open.biz.config.E3BS2Config;
import com.dtyunxi.tcbj.app.open.biz.config.E3BSConfig;
import com.dtyunxi.tcbj.app.open.biz.config.E3Config;
import com.dtyunxi.tcbj.app.open.biz.config.E3MYConfig;
import com.dtyunxi.tcbj.app.open.biz.service.impl.ExternalClientAbstract;
import com.dtyunxi.tcbj.center.openapi.api.enums.ExternalSystenEnum;
import com.dtyunxi.tcbj.center.openapi.common.e3.dto.E3BSApiResponse;
import com.dtyunxi.util.DateUtil;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.DigestUtils;

@Service
public class E3BSService
extends ExternalClientAbstract<E3BSConfig> {
    private static final Logger logger = LoggerFactory.getLogger(E3BSService.class);
    @Resource
    private E3BSConfig e3BSConfig;
    @Resource
    private E3MYConfig e3MYConfig;
    @Resource
    private E3BS2Config e3BS2Config;

    @Override
    public String buildUrl(String url) {
        return url;
    }

    public void e3Post(String serviceType, Map<String, Object> jsonDate, ExternalSystenEnum sysEnum) {
        logger.info("E3\u670d\u52a1\u8bf7\u6c42\uff1a{}", (Object)JSON.toJSONString(jsonDate));
        logger.info(sysEnum.getSystenName());
        String nowDateStr = DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmss");
        E3Config config = new E3Config();
        switch (sysEnum) {
            case E3BS: {
                config = (E3Config)JSON.parseObject((String)JSON.toJSONString((Object)this.e3BSConfig), E3Config.class);
                break;
            }
            case E3MY: {
                config = (E3Config)JSON.parseObject((String)JSON.toJSONString((Object)this.e3MYConfig), E3Config.class);
                break;
            }
            case E3BS2: {
                config = (E3Config)JSON.parseObject((String)JSON.toJSONString((Object)this.e3BS2Config), E3Config.class);
                break;
            }
            default: {
                throw new BizException("-1", "\u672a\u6307\u5b9a\u5bf9\u5e94\u7684E3");
            }
        }
        TreeMap<String, Object> formDate = this.buildData(serviceType, jsonDate, nowDateStr, config);
        this.post_execute(config.getServiceAddress(), formDate, config);
    }

    @Override
    void check(String result) {
        E3BSApiResponse response = null;
        try {
            response = (E3BSApiResponse)JSON.parseObject((String)result, E3BSApiResponse.class);
        }
        catch (Exception e) {
            throw new BizException("\u8bf7\u6c42E3\u54cd\u5e94\u89e3\u6790\u5f02\u5e38\uff1a" + result);
        }
        if (ObjectUtil.isEmpty((Object)response) || ObjectUtil.isEmpty((Object)response.getStatus())) {
            throw new BizException("\u8bf7\u6c42E3\u54cd\u5e94\u53c2\u6570\u6709\u8bef\uff1a" + result);
        }
        if (!Objects.equals(response.getStatus(), "1") && !Objects.equals(response.getStatus(), "api-success")) {
            throw new BizException("\u8bf7\u6c42E3\u5931\u8d25\uff1a" + JSON.toJSONString((Object)response));
        }
        logger.info("check\u54cd\uff1a{}", (Object)JSON.toJSONString((Object)response));
    }

    private String sign(String serviceType, Object data, String date, E3Config config) {
        String sign = "";
        try {
            String context = "key=%s&requestTime=%s&secret=%s&version=%s&serviceType=%s&data=%s";
            String format = String.format(context, config.getKey(), date, config.getSecret(), config.getVersion(), serviceType, JSON.toJSONString((Object)data));
            logger.info("E3\u5bf9\u63a5\u8bf7\u6c42\u7b7e\u540d\u53c2\u6570\uff1a{}", (Object)format);
            sign = DigestUtils.md5DigestAsHex((byte[])format.getBytes());
            logger.info("E3\u5bf9\u63a5\u8bf7\u6c42\u7b7e\u540d\uff1a{}", (Object)sign);
        }
        catch (Exception e) {
            logger.error("\u53d1\u8d77E3\u670d\u52a1\u8bf7\u6c42\u5931\u8d25\uff1a\u83b7\u53d6\u7b7e\u540d\u5f02\u5e38");
            logger.error(e.getMessage(), (Throwable)e);
            throw new BizException("\u53d1\u8d77E3\u670d\u52a1\u8bf7\u6c42\u5931\u8d25\uff1a\u83b7\u53d6\u7b7e\u540d\u5f02\u5e38");
        }
        return sign;
    }

    public TreeMap<String, Object> buildData(String serviceType, Map<String, Object> jsonDate, String date, E3Config config) {
        TreeMap<String, Object> params = new TreeMap<String, Object>();
        params.put("key", config.getKey());
        params.put("secret", config.getSecret());
        params.put("serviceType", serviceType);
        params.put("requestTime", date);
        params.put("sign", this.sign(serviceType, jsonDate, date, config));
        params.put("data", JSON.toJSONString(jsonDate));
        params.put("version", config.getVersion());
        return params;
    }

    public String post_execute(String url, TreeMap<String, Object> data, E3Config config) {
        logger.info("\u53d1\u8d77POST\u8bf7\u6c42E3\u670d\u52a1\uff1a{}", (Object)JSON.toJSONString(data));
        logger.info("\u8bf7\u6c42\u8def\u5f84\uff1a{}", (Object)url);
        HttpRequest post = (HttpRequest)HttpUtil.createPost((String)url).header("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
        post.form(data);
        TransactionTrackContextUtils.setTrackLogRequestData((String)"requestUrl", (Object)url);
        TransactionTrackContextUtils.setTrackLogRequestData((String)"requestData", data);
        Instant start = Instant.now();
        HttpResponse httpResponse = post.execute();
        String body = httpResponse.body();
        Instant end = Instant.now();
        logger.info("\u8bf7\u6c42" + config.getServiceName() + "\u54cd\u5e94\u8017\u65f6\uff1a{}\uff0c\u7ed3\u679c\uff1a{}", (Object)Duration.between(start, end).toMillis(), (Object)body);
        TransactionTrackContextUtils.setTrackLogResultData((String)"responseStatus", (Object)httpResponse.isGzip());
        TransactionTrackContextUtils.setTrackLogResultData((String)"responseData", (Object)body);
        TransactionTrackContextUtils.setTrackLogResultData((String)"responseCode", (Object)httpResponse.getStatus());
        this.check(body);
        return body;
    }
}

