/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.tcbj.app.open.biz.service.IExternalOutService;
import com.dtyunxi.tcbj.app.open.biz.service.ISapCenterHandleService;
import com.dtyunxi.tcbj.center.openapi.api.enums.SapModelTypeEnum;
import com.dtyunxi.tcbj.center.openapi.common.sap.dto.MaterialPriceReqDto;
import com.dtyunxi.tcbj.center.openapi.common.sap.dto.MaterialPriceRespDto;
import com.dtyunxi.yundt.cube.center.item.api.IItemExtendApi;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemExtendReqDto;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SapCenterHandleMaterialPriceServiceImpl
implements ISapCenterHandleService {
    private static final Logger logger = LoggerFactory.getLogger(SapCenterHandleMaterialPriceServiceImpl.class);
    @Resource
    private IExternalOutService externalOutService;
    @Resource
    private IItemExtendApi itemExtendApi;

    @Override
    public String getModelType() {
        return SapModelTypeEnum.MATERIALPRICE.getValue();
    }

    @Override
    public void handle(Map<String, Object> map) {
        MaterialPriceReqDto reqDto = new MaterialPriceReqDto();
        String[] materialTypes = new String[]{"ZFIN", "ZGEN"};
        LocalDate currentDate = LocalDate.now();
        LocalDate firstDayOfLastMonth = currentDate.withDayOfMonth(1).minusMonths(1L);
        LocalDate lastDayOfLastMonth = currentDate.withDayOfMonth(1).minusDays(1L);
        DateTimeFormatter formatter = DateTimeFormatter.ISO_LOCAL_DATE;
        String startDate = firstDayOfLastMonth.format(formatter);
        String endDate = lastDayOfLastMonth.format(formatter);
        logger.info("sap-ocs\u4ef7\u683c\u6570\u636e\u62c9\u53d6\u65e5\u671f\u4ece\uff1a{} \u5230 {}", (Object)startDate, (Object)endDate);
        reqDto.setStartDate(startDate);
        reqDto.setEndDate(endDate);
        for (String materialType : materialTypes) {
            BigDecimal price;
            ItemExtendReqDto itemExtendReqDto;
            reqDto.setMaterialType(materialType);
            logger.info("sap-ocs\u4ef7\u683c\u6570\u636e\u62c9\u53d6:{}", (Object)JSON.toJSONString((Object)reqDto));
            List<MaterialPriceRespDto> respDtoList = this.externalOutService.queryMaterialPriceList(reqDto);
            if (!CollectionUtils.isNotEmpty(respDtoList)) continue;
            logger.info("sap-ocs\u4ef7\u683c\u6570\u636e\u62c9\u53d6\u7269\u6599\u7c7b\u578b\uff1a{}\uff0c\u6570\u636e\u6761\u6570:{}\u6761", (Object)materialType, (Object)respDtoList.size());
            if (materialType.equals("ZFIN")) {
                for (MaterialPriceRespDto dto : respDtoList) {
                    if (!"CNY".equals(dto.getWaers())) continue;
                    itemExtendReqDto = new ItemExtendReqDto();
                    price = dto.getNetpr().multiply(new BigDecimal("1.13")).divide(new BigDecimal(dto.getPeinh())).setScale(2, RoundingMode.DOWN);
                    itemExtendReqDto.setItemCode(dto.getMatnr());
                    itemExtendReqDto.setClaimPrice(price);
                    this.itemExtendApi.modifyPrice(itemExtendReqDto);
                }
                continue;
            }
            for (MaterialPriceRespDto dto : respDtoList) {
                if (!"CNY".equals(dto.getWaers())) continue;
                itemExtendReqDto = new ItemExtendReqDto();
                price = dto.getNetpr().multiply(new BigDecimal("1.13")).divide(new BigDecimal(dto.getPeinh())).setScale(2, RoundingMode.DOWN);
                itemExtendReqDto.setItemCode(dto.getMatnr());
                itemExtendReqDto.setRecommendPrice(price);
                itemExtendReqDto.setClaimPrice(price);
                this.itemExtendApi.modifyPrice(itemExtendReqDto);
            }
        }
        logger.info("\u7269\u6599\u4ef7\u683c\u6570\u636e\u66f4\u65b0\u5b8c\u6210");
    }
}

