/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.IQualityInspectionDataApi;
import com.dtyunxi.tcbj.api.dto.request.QualityInspectionSubmitDataReqDto;
import com.dtyunxi.tcbj.app.open.biz.service.IExternalOutService;
import com.dtyunxi.tcbj.app.open.biz.service.ILimitsService;
import com.dtyunxi.tcbj.app.open.dao.das.LimitsDas;
import com.dtyunxi.tcbj.app.open.dao.eo.LimitsEo;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.LimsQualityInfoPredictReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.LimsQualityInfoPredictRespDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.LimsQualityInfoRespDto;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class LimitsServiceImpl
implements ILimitsService {
    private static final Logger log = LoggerFactory.getLogger(LimitsServiceImpl.class);
    @Value(value="${scheduler.client.pageSize:1000}")
    private Long pageSize;
    @Resource
    private LimitsDas limitsDas;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private ICacheService cacheService;
    @Resource
    private IQualityInspectionDataApi qualityInspectionDataApi;
    @Resource
    private IExternalOutService externalOutService;

    @Override
    public String syncReportInspected(String syncStartTime) {
        List<LimsQualityInfoRespDto> list;
        log.info("\u540c\u6b65\u5f85\u68c0\u6570\u636e\uff0c\u4ece\u89c6\u56fe\u4e2d\u83b7\u53d6\uff1a{}", (Object)syncStartTime);
        Long pageNum = 1L;
        String startTime = DateUtil.formatDate((DatePattern)DatePattern.DATE_PATTERN, (Date)new Date());
        while (!CollectionUtil.isEmpty(list = this.selectReportInspectionData(syncStartTime, pageNum, this.pageSize))) {
            this.commonsMqService.sendSingleMessage("OP_EXTERNAL_TOPIC", "QUALITY_INSPECTION_DATA_SYNC_EXT", (Object)JSON.toJSONString(list));
            if ((long)list.size() < this.pageSize) break;
            Long l = pageNum;
            Long l2 = pageNum = Long.valueOf(pageNum + 1L);
        }
        return startTime;
    }

    @Override
    public String syncReportInspectedForPsi(LimsQualityInfoPredictReqDto reqDto) {
        log.info("\u540c\u6b65\u8d28\u68c0\u62a5\u544a\uff0c\u4ece\u8fdb\u9500\u5b58\u63a5\u53e3\u4e2d\u83b7\u53d6\uff1a{}", (Object)reqDto);
        reqDto.setSize(Integer.valueOf(this.pageSize.intValue()));
        Long pageNum = 1L;
        String endTime = DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)new Date());
        reqDto.setEndDate(endTime);
        while (true) {
            reqDto.setPage(Integer.valueOf(pageNum.intValue()));
            List<LimsQualityInfoRespDto> list = this.externalOutService.queryQualityReport(reqDto);
            if (CollectionUtil.isEmpty(list)) break;
            this.commonsMqService.sendSingleMessage("OP_EXTERNAL_TOPIC", "QUALITY_INSPECTION_DATA_SYNC_EXT", (Object)JSON.toJSONString(list));
            if ((long)list.size() < this.pageSize) break;
            Long l = pageNum;
            Long l2 = pageNum = Long.valueOf(pageNum + 1L);
        }
        return endTime;
    }

    @Override
    public String syncReportInspectedForSap(LimsQualityInfoPredictReqDto reqDto) {
        log.info("\u540c\u6b65\u8d28\u68c0\u62a5\u544a\uff0c\u4eceSAP\u63a5\u53e3\u4e2d\u83b7\u53d6\uff1a{}", (Object)reqDto);
        String endTime = DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)new Date());
        reqDto.setEndDate(endTime);
        List<LimsQualityInfoRespDto> list = this.externalOutService.queryQualityReportBySap(reqDto);
        this.commonsMqService.sendSingleMessage("OP_EXTERNAL_TOPIC", "QUALITY_INSPECTION_DATA_SYNC_EXT", (Object)JSON.toJSONString(list));
        return endTime;
    }

    @Override
    public void syncReportInspected(String syncStartTime, String syncEndTime) {
        List<LimsQualityInfoRespDto> list;
        Long pageNum = 1L;
        while (!CollectionUtil.isEmpty(list = this.selectReportInspectionData(syncStartTime, syncEndTime, pageNum, this.pageSize))) {
            this.commonsMqService.sendSingleMessage("OP_EXTERNAL_TOPIC", "QUALITY_INSPECTION_DATA_SYNC_EXT", (Object)JSON.toJSONString(list));
            if ((long)list.size() < this.pageSize) break;
            Long l = pageNum;
            Long l2 = pageNum = Long.valueOf(pageNum + 1L);
        }
    }

    @Override
    public String syncQueryPredictQualityReport(LimsQualityInfoPredictReqDto reqDto) {
        reqDto.setSize(Integer.valueOf(this.pageSize.intValue()));
        log.info("\u540c\u6b65\u8d28\u68c0\u63d0\u5355\u62a5\u544a\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        Long pageNum = 1L;
        String startTime = DateUtil.formatDate((DatePattern)DatePattern.DATE_PATTERN, (Date)new Date());
        while (true) {
            reqDto.setPage(Integer.valueOf(pageNum.intValue()));
            List<LimsQualityInfoPredictRespDto> list = this.externalOutService.queryPredictQualityReport(reqDto);
            if (CollectionUtil.isEmpty(list)) break;
            ArrayList dataReqDtoList = new ArrayList();
            CubeBeanUtils.copyCollection(dataReqDtoList, list, QualityInspectionSubmitDataReqDto.class);
            RestResponseHelper.extractData((RestResponse)this.qualityInspectionDataApi.batchSubmitDataCU(dataReqDtoList));
            if ((long)list.size() < this.pageSize) break;
            Long l = pageNum;
            Long l2 = pageNum = Long.valueOf(pageNum + 1L);
        }
        return startTime + " 00:00:00";
    }

    private List<LimsQualityInfoRespDto> selectReportInspectionData(String syncStartTime, Long pageNum, Long pageSize) {
        List limitsEos = this.limitsDas.selectLimits(syncStartTime, pageNum, pageSize);
        return limitsEos.stream().map(this::assembleData).collect(Collectors.toList());
    }

    private List<LimsQualityInfoRespDto> selectReportInspectionData(String syncStartTime, String syncEndTime, Long pageNum, Long pageSize) {
        List limitsEos = this.limitsDas.selectLimits(syncStartTime, syncEndTime, pageNum, pageSize);
        return limitsEos.stream().map(this::assembleData).collect(Collectors.toList());
    }

    private LimsQualityInfoRespDto assembleData(LimitsEo eo) {
        LimsQualityInfoRespDto dto = new LimsQualityInfoRespDto();
        dto.setExternalId(eo.getEtid());
        dto.setBatch(eo.getLotno());
        dto.setExternalNo(eo.getReportno());
        dto.setSourceFrom(eo.getSourcefrom());
        dto.setExternalRemark(eo.getRemark());
        dto.setLongCode(eo.getSamplecode());
        dto.setUnqualifiedNum(eo.getUquanum());
        dto.setReleaseNum(eo.getDevquanum());
        dto.setQualifiedNum(eo.getQuanum());
        dto.setReportTime(eo.getReleasedate());
        dto.setReportResult(eo.getUd());
        dto.setReportResultUrl(eo.getUrl());
        dto.setWmsStatus(eo.getWmsstatus());
        dto.setSampleType(eo.getSampletype());
        dto.setSystemType(eo.getSystemtype());
        return dto;
    }
}

