/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.StringCheckResultReqDto;
import com.dtyunxi.tcbj.api.dto.response.SaleOrderRespDto;
import com.dtyunxi.tcbj.api.dto.response.StringCheckResultRespDto;
import com.dtyunxi.tcbj.api.query.IStringCheckResultQueryApi;
import com.dtyunxi.tcbj.app.open.biz.service.FetchDataService;
import com.dtyunxi.tcbj.app.open.biz.service.IStringCodeService;
import com.dtyunxi.tcbj.app.open.dao.das.StringCodeDas;
import com.dtyunxi.tcbj.app.open.dao.das.SyncViewVo;
import com.dtyunxi.tcbj.app.open.dao.eo.StringCodeEo;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.StringCodeCheckReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.StringCodeReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.StringCodeCheckRespDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.StringCodeRespDto;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.PcpItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.query.IPcpItemQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.basicdata.api.query.IPcpDictQueryApi;
import com.yunxi.dg.base.center.basicdata.enums.DictEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StringCodeServiceImpl
implements IStringCodeService {
    private static final Logger log = LoggerFactory.getLogger(StringCodeServiceImpl.class);
    @Resource
    private StringCodeDas stringCodeDas;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private ICacheService cacheService;
    @Resource
    private IStringCheckResultQueryApi stringCheckResultQueryApi;
    @Resource
    private IPcpItemQueryApi itemExtendQueryApi;
    @Resource
    private IPcpDictQueryApi pcpDictApi;

    @Override
    public Long addStringCode(StringCodeReqDto addReqDto) {
        StringCodeEo stringCodeEo = new StringCodeEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)stringCodeEo);
        this.stringCodeDas.insert((BaseEo)stringCodeEo);
        return stringCodeEo.getId();
    }

    @Override
    public void modifyStringCode(StringCodeReqDto modifyReqDto) {
        StringCodeEo stringCodeEo = new StringCodeEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)stringCodeEo);
        this.stringCodeDas.updateSelective((BaseEo)stringCodeEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeStringCode(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.stringCodeDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public StringCodeRespDto queryById(Long id) {
        StringCodeEo stringCodeEo = (StringCodeEo)this.stringCodeDas.selectByPrimaryKey(id);
        StringCodeRespDto stringCodeRespDto = new StringCodeRespDto();
        DtoHelper.eo2Dto((BaseEo)stringCodeEo, (BaseVo)stringCodeRespDto);
        return stringCodeRespDto;
    }

    @Override
    public PageInfo<StringCodeRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        StringCodeReqDto stringCodeReqDto = (StringCodeReqDto)JSON.parseObject((String)filter, StringCodeReqDto.class);
        StringCodeEo stringCodeEo = new StringCodeEo();
        DtoHelper.dto2Eo((BaseVo)stringCodeReqDto, (BaseEo)stringCodeEo);
        PageInfo eoPageInfo = this.stringCodeDas.selectPage((BaseEo)stringCodeEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, StringCodeRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<StringCodeRespDto> queryByList(List<StringCodeCheckReqDto> list) {
        ArrayList dtoList = Lists.newArrayList();
        if (CollectionUtil.isEmpty(list)) {
            return dtoList;
        }
        List queryEoList = list.stream().map(i -> {
            StringCodeEo eo = new StringCodeEo();
            eo.setAntiFakeCode(i.getAntiFakeCode());
            eo.setEasCode(i.getEasSaleOrderNo());
            return eo;
        }).collect(Collectors.toList());
        List eos = this.stringCodeDas.selectStringCodeList(queryEoList);
        DtoHelper.eoList2DtoList((Collection)eos, (Collection)dtoList, StringCodeRespDto.class);
        return dtoList;
    }

    @Override
    public List<StringCodeRespDto> queryByEasNo(String easNo) {
        ArrayList dtoList = Lists.newArrayList();
        List stringCodeEos = this.stringCodeDas.selectByEasNo(easNo);
        DtoHelper.eoList2DtoList((Collection)stringCodeEos, (Collection)dtoList, StringCodeRespDto.class);
        return dtoList;
    }

    @Override
    public void sendMqAndUpdateCache(List<StringCodeCheckRespDto> checkResult) {
        this.commonsMqService.publishMessage("OP_EXTERNAL_TOPIC", "string_check_result_tag", (Object)JSON.toJSONString(checkResult));
    }

    @Override
    public List<StringCodeRespDto> queryByStringList(List<String> list) {
        ArrayList dtoList = Lists.newArrayList();
        List stringCodeEos = this.stringCodeDas.selectStringCodeDataList(list);
        DtoHelper.eoList2DtoList((Collection)stringCodeEos, (Collection)dtoList, StringCodeRespDto.class);
        return dtoList;
    }

    @Override
    public List<StringCodeRespDto> queryByStringNo(String no) {
        ArrayList dtoList = Lists.newArrayList();
        List stringCodeEos = this.stringCodeDas.selectStringCodeDataList((List)Lists.newArrayList((Object[])new String[]{no}));
        DtoHelper.eoList2DtoList((Collection)stringCodeEos, (Collection)dtoList, StringCodeRespDto.class);
        return dtoList;
    }

    private void preHandler(List<StringCodeCheckRespDto> respList) {
        Map<String, PcpItemRespDto> itemMap = this.getPcpItemMap(respList);
        respList.forEach(i -> {
            String itemLongCode = i.getItemLongCode();
            if (CollectionUtil.isNotEmpty((Map)itemMap) && itemMap.containsKey(itemLongCode)) {
                PcpItemRespDto item = (PcpItemRespDto)itemMap.get(itemLongCode);
                if (Objects.equals("Y", item.getImeiCodeFlag())) {
                    i.setAntiFakeCode(item.getSecurityCode());
                    i.setBigRatio(item.getBigRatio());
                    i.setMiddleRatio(item.getMiddleRatio());
                    i.setSmallRatio(item.getSmallRatio());
                } else {
                    i.setCheckResult(true);
                }
            }
        });
    }

    @Override
    public List<StringCodeCheckRespDto> doCheck(List<StringCodeCheckReqDto> list, Integer handlerMode) {
        list = new ArrayList(list.stream().collect(Collectors.toMap(k -> k.getEasSaleOrderNo() + "_" + k.getItemLongCode(), Function.identity(), (o, o1) -> {
            o.setNum(Integer.valueOf(o.getNum() + o1.getNum()));
            return o;
        })).values());
        log.info("\u5408\u5e76\u540e\u4e32\u7801:{}", (Object)JSONObject.toJSONString(list));
        ArrayList respList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)respList, list, StringCodeCheckRespDto.class);
        this.preHandler(respList);
        this.compare(handlerMode, respList);
        return this.groupData(respList);
    }

    private <REQ extends StringCodeCheckReqDto> Map<String, PcpItemRespDto> getPcpItemMap(List<REQ> list) {
        Set itemLongCodes = list.stream().map(StringCodeCheckReqDto::getItemLongCode).collect(Collectors.toSet());
        List items = (List)RestResponseHelper.extractData((RestResponse)this.itemExtendQueryApi.queryItemByItemLongCodes((List)Lists.newArrayList(itemLongCodes)));
        return items.stream().collect(Collectors.toMap(PcpItemRespDto::getLongCode, Function.identity(), (k1, k2) -> k1));
    }

    private void compare(Integer handlerMode, List<StringCodeCheckRespDto> respList) {
        List<String> queryNos = respList.stream().filter(r -> !r.isCheckResult()).map(StringCodeCheckReqDto::getEasSaleOrderNo).distinct().collect(Collectors.toList());
        if (Objects.equals(handlerMode, 1)) {
            Optional.of(queryNos).filter(CollUtil::isNotEmpty).map(r -> (String)r.get(0)).ifPresent(r -> this.singleOrderCheck(respList, (String)r));
        } else {
            List<StringCodeRespDto> stringCodeList = this.queryByStringList(queryNos);
            Map<String, List<StringCodeRespDto>> stringListMap = stringCodeList.stream().collect(Collectors.groupingBy(StringCodeRespDto::getUniqueKey));
            log.info("\u4e32\u7801\u89c6\u56fe\u67e5\u8be2\u7ed3\u679c:{},\u6821\u9a8c\u7ed3\u679c\u6570\u636e:{}", (Object)JSONObject.toJSONString(stringCodeList), (Object)JSONObject.toJSONString(respList));
            this.sendLogMsg(this.calculation(respList, stringListMap, 1));
        }
    }

    private void singleOrderCheck(List<StringCodeCheckRespDto> respList, String r) {
        List<StringCodeRespDto> stringCodeList = this.loadViewStringCode(r);
        if (CollectionUtil.isEmpty(stringCodeList)) {
            return;
        }
        String easCode = stringCodeList.get(0).getEasCode();
        if (easCode.equals(r)) {
            Map<String, List<StringCodeRespDto>> stringListMap = stringCodeList.stream().collect(Collectors.groupingBy(StringCodeRespDto::getAntiFakeCode));
            this.sendLogMsg(this.calculation(respList, stringListMap, 0));
            log.info("\u4e32\u7801\u89c6\u56fe\u67e5\u8be2\u7ed3\u679c:{},\u6821\u9a8c\u7ed3\u679c\u6570\u636e:{}, \u6b63\u5e38\u5339\u914d", (Object)JSONObject.toJSONString(stringCodeList), (Object)JSONObject.toJSONString(respList));
            return;
        }
        Map<String, List<StringCodeRespDto>> stringListMap = stringCodeList.stream().filter(target -> Stream.of(target.getEasCode().split("_")).collect(Collectors.toList()).contains(r)).collect(Collectors.groupingBy(StringCodeRespDto::getAntiFakeCode));
        if (CollectionUtil.isEmpty(stringListMap)) {
            return;
        }
        this.singCheckMergeOrderPoint(respList, r, stringCodeList, easCode, stringListMap);
    }

    private void singCheckMergeOrderPoint(List<StringCodeCheckRespDto> respList, String r, List<StringCodeRespDto> stringCodeList, String easCode, Map<String, List<StringCodeRespDto>> stringListMap) {
        Set stringSet = Arrays.stream(easCode.split("_")).collect(Collectors.toSet());
        StringCheckResultReqDto reqDto = new StringCheckResultReqDto();
        reqDto.setEasSaleOrderNos(new ArrayList(stringSet));
        FetchDataService fetchDataService = req -> (PageInfo)this.stringCheckResultQueryApi.queryByPage(req).getData();
        List<StringCheckResultRespDto> stringCheckResultRespDtos = fetchDataService.fetchAll(reqDto);
        Set existNos = stringCheckResultRespDtos.stream().map(StringCheckResultRespDto::getEasSaleOrderNo).collect(Collectors.toSet());
        existNos.add(r);
        if (existNos.size() == stringSet.size()) {
            this.mergeOrderDetail(respList, r, stringCheckResultRespDtos);
            ArrayList<StringCodeCheckRespDto> list = new ArrayList<StringCodeCheckRespDto>(respList.stream().map(data -> (StringCodeCheckRespDto)BeanUtil.copyProperties((Object)data, StringCodeCheckRespDto.class, (String[])new String[0])).collect(Collectors.toMap(StringCodeCheckReqDto::getItemLongCode, Function.identity(), (o, o1) -> {
                o.setNum(Integer.valueOf(o.getNum() + o1.getNum()));
                return o;
            })).values());
            List<IStringCodeService.StringCheckResultVo> calculation = this.calculation(list, stringListMap, 2);
            boolean b = calculation.stream().allMatch(d -> Objects.equals(d.getStatus(), 1));
            respList.forEach(resp -> resp.setCheckResult(b));
            this.sendLogMsg(respList.stream().map(resp -> this.buildLog((StringCodeCheckRespDto)resp, b ? Long.valueOf(resp.getNum().intValue()) : 0L)).peek(resp -> resp.setExtension(easCode)).collect(Collectors.toList()));
            log.info("\u4e32\u7801\u89c6\u56fe\u67e5\u8be2\u7ed3\u679c:{},\u6821\u9a8c\u7ed3\u679c\u6570\u636e:{}, \u5408\u5355\u5b8c\u5168\u5339\u914d", (Object)JSONObject.toJSONString(stringCodeList), (Object)JSONObject.toJSONString(respList));
            return;
        }
        log.info("\u4e32\u7801\u89c6\u56fe\u67e5\u8be2\u7ed3\u679c:{},\u6821\u9a8c\u7ed3\u679c\u6570\u636e:{}, \u5408\u5355\u672a\u5b8c\u5168\u5339\u914d", (Object)JSONObject.toJSONString(stringCodeList), (Object)JSONObject.toJSONString(respList));
        this.sendLogMsg(this.calculation(respList, stringListMap, 3).stream().peek(d -> d.setExtension(easCode)).collect(Collectors.toList()));
    }

    private List<StringCodeRespDto> loadViewStringCode(String r) {
        List<StringCodeRespDto> stringCodeList = this.queryByStringNo(r);
        if (CollectionUtil.isEmpty(stringCodeList) && CollectionUtil.isEmpty(stringCodeList = this.queryByEasNo(r))) {
            return null;
        }
        return stringCodeList;
    }

    private void mergeOrderDetail(List<StringCodeCheckRespDto> respList, String r, List<StringCheckResultRespDto> stringCheckResultRespDtos) {
        List<StringCodeCheckRespDto> dataList = stringCheckResultRespDtos.stream().filter(s -> !s.getEasSaleOrderNo().equals(r)).map(data -> {
            StringCodeCheckRespDto respDto = new StringCodeCheckRespDto();
            respDto.setNum(Integer.valueOf(Math.toIntExact(data.getPcpNum())));
            respDto.setAntiFakeCode(data.getStringCode());
            respDto.setItemLongCode(data.getLongCode());
            respDto.setDocumentNo(data.getDocumentNo());
            respDto.setEasSaleOrderNo(data.getEasSaleOrderNo());
            return respDto;
        }).collect(Collectors.toList());
        this.preHandler(dataList);
        respList.addAll(dataList);
    }

    private List<StringCodeCheckRespDto> groupData(List<StringCodeCheckRespDto> respList) {
        return new ArrayList<StringCodeCheckRespDto>(respList.stream().collect(Collectors.toMap(StringCodeCheckReqDto::getEasSaleOrderNo, Function.identity(), (o, o1) -> {
            o.setCheckResult(o.isCheckResult() && o1.isCheckResult());
            return o;
        })).values());
    }

    private List<IStringCodeService.StringCheckResultVo> calculation(List<StringCodeCheckRespDto> respList, Map<String, List<StringCodeRespDto>> stringListMap, Integer mode) {
        return respList.stream().map(i -> this.doCalculation(stringListMap, mode, (StringCodeCheckRespDto)i)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private IStringCodeService.StringCheckResultVo doCalculation(Map<String, List<StringCodeRespDto>> stringListMap, Integer mode, StringCodeCheckRespDto i) {
        String uniqueKey;
        if (i.isCheckResult()) {
            return null;
        }
        DictDto dictDto = (DictDto)RestResponseHelper.extractData((RestResponse)this.pcpDictApi.queryByGroupCodeAndCode(DictEnum.STRING_CHECK_CONFIG.getGroupCode(), DictEnum.STRING_CHECK_CONFIG.getCode()));
        if (dictDto == null || Objects.equals(dictDto.getValue(), "1")) {
            i.setCheckResult(true);
            IStringCodeService.StringCheckResultVo resultVo = this.buildLog(i, (long)i.getNum());
            resultVo.setExtension("\u4e32\u7801\u6821\u9a8c\u672a\u5f00\u542f");
            return resultVo;
        }
        String string = uniqueKey = Objects.equals(mode, 1) ? i.getUniqueKey() : i.getAntiFakeCode();
        if (CollectionUtil.isNotEmpty(stringListMap) && stringListMap.containsKey(uniqueKey)) {
            Integer num = this.calculationStringCodeNum(stringListMap.get(uniqueKey), i);
            i.setCheckResult(this.getResult(i, num, mode));
            log.info("\u4e32\u7801\u6821\u9a8c\u5355\u53f7:{}, \u54c1:{},\u4e09\u65b9\u6570\u91cf:{}, pcp\u6570\u91cf:{}, \u662f\u5426\u5bf9\u9f50:{}", new Object[]{i.getEasSaleOrderNo(), i.getItemLongCode(), num, i.getNum(), i.isCheckResult() ? "\u662f" : "\u5426"});
            return this.buildLog(i, (long)num);
        }
        i.setCheckResult(i.getNum().equals(0));
        return this.buildLog(i, 0L);
    }

    private boolean getResult(StringCodeCheckRespDto i, Integer num, Integer mode) {
        if (Objects.equals(mode, 3)) {
            return false;
        }
        return Objects.equals(i.getNum(), num) || num > i.getNum() && (long)(num - i.getNum()) < i.getBigRatio();
    }

    private IStringCodeService.StringCheckResultVo buildLog(StringCodeCheckRespDto i, Long l) {
        IStringCodeService.StringCheckResultVo resultVo = new IStringCodeService.StringCheckResultVo();
        resultVo.setDocumentNo(i.getDocumentNo());
        resultVo.setEasNum(l);
        resultVo.setPcpNum((long)i.getNum());
        resultVo.setLongCode(i.getItemLongCode());
        resultVo.setStatus(i.isCheckResult() ? 1 : 0);
        resultVo.setEasSaleOrderNo(i.getEasSaleOrderNo());
        resultVo.setStringCode(i.getAntiFakeCode());
        return resultVo;
    }

    private void sendLogMsg(List<IStringCodeService.StringCheckResultVo> respList) {
        this.commonsMqService.sendSingleMessage("STRING_CODE_LOG_SYNC", (Object)JSONObject.toJSONString(respList));
    }

    private Long parseNum(StringCodeRespDto sc, StringCodeCheckRespDto i) {
        Integer length = sc.getSerialno().length();
        int s = 12;
        int m = 18;
        int x = 20;
        if (Objects.equals(length, s)) {
            return 1L;
        }
        if (Objects.equals(length, m)) {
            return i.getMiddleRatio();
        }
        if (Objects.equals(length, x)) {
            return i.getBigRatio();
        }
        return 0L;
    }

    private Integer calculationStringCodeNum(List<StringCodeRespDto> scList, StringCodeCheckRespDto i) {
        if (CollectionUtil.isEmpty(scList)) {
            return 0;
        }
        return Math.toIntExact(scList.stream().collect(Collectors.toMap(StringCodeRespDto::getSerialno, Function.identity(), (o, o1) -> o)).values().stream().mapToLong(sc -> this.parseNum((StringCodeRespDto)sc, i)).sum());
    }

    @Override
    public void syncView(String easSaleOrderNo, SaleOrderRespDto d) {
        this.stringCodeDas.syncView(new SyncViewVo(easSaleOrderNo, d.getPlatformOrderNo(), d.getCustomerCode(), d.getCustomerName()));
    }
}

