/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.utils;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.component.track.commons.utils.TransactionTrackContextUtils;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.tcbj.app.open.biz.config.EasConfig;
import com.dtyunxi.tcbj.app.open.biz.utils.EasResponseHelper;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.external.EasLoginDto;
import com.dtyunxi.tcbj.center.openapi.api.enums.EasApiEnum;
import com.dtyunxi.tcbj.center.openapi.common.eas.dto.EASResultResponse;
import com.dtyunxi.tcbj.center.openapi.common.eas.dto.EASResultsResponse;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=1)
@Component
public class EasClient {
    private static final Logger log = LoggerFactory.getLogger(EasClient.class);
    @Autowired
    private EasConfig easConfig;
    @Resource
    private ICacheService cacheService;
    @Resource
    private ILockService lockService;
    private static ILockService LOCK_SERVICE;
    private static EasClient easClient;
    private static EasConfig EAS_CONFIG;
    private static ICacheService CACHE_SERVICE;
    public static final String EAS_TOKEN_KEY = "external:eas:EAS_TOKEN_KEY";
    private static final String EXPIRED_TOKEN = "\u8bf7\u91cd\u65b0\u767b\u9646";
    private static final String EAS_TOKEN_REDIS_LOCK_KEY = "EAS_TOKEN_REDIS_LOCK_KEY";

    @PostConstruct
    public void init() {
        easClient = new EasClient();
        EAS_CONFIG = this.easConfig;
        CACHE_SERVICE = this.cacheService;
        LOCK_SERVICE = this.lockService;
    }

    public static <T> T executeParseArray(Map<String, Object> param, EasApiEnum easApiEnum, Class<T> tClass) {
        String data = EasClient.executeOfOther(param, easApiEnum);
        List list = JSONObject.parseArray((String)data, tClass);
        if (CollectionUtil.isEmpty((Collection)list)) {
            throw new BizException("\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        }
        return (T)list.get(0);
    }

    public static String executeCommon(Map<String, Object> param, EasApiEnum easApiEnum) {
        if (EasApiEnum.CANCEL_ORDER.getApiLink().equals(easApiEnum.getApiLink()) || EasApiEnum.ORDER_AUDIT.getApiLink().equals(easApiEnum.getApiLink())) {
            return EasClient.executeOfCancel(param, easApiEnum);
        }
        return EasClient.executeOfOther(param, easApiEnum);
    }

    public static String executeOfCancel(Map<String, Object> param, EasApiEnum easApiEnum) {
        String data = EasClient.execute(param, easApiEnum);
        List resultList = JSONObject.parseArray((String)data, EASResultsResponse.class);
        if (CollectionUtil.isEmpty((Collection)resultList) || StringUtils.isBlank((CharSequence)((EASResultsResponse)resultList.get(0)).getMessage())) {
            throw new BizException(data);
        }
        if (((EASResultsResponse)resultList.get(0)).getMessage().toLowerCase().equals("fail")) {
            throw new BizException(((EASResultsResponse)resultList.get(0)).getNote());
        }
        return ((EASResultsResponse)resultList.get(0)).getMessage();
    }

    public static String executeOfOther(Map<String, Object> param, EasApiEnum easApiEnum) {
        String data = EasClient.execute(param, easApiEnum);
        EASResultResponse resultResponse = (EASResultResponse)JSON.parseObject((String)data, EASResultResponse.class);
        if (ObjectUtil.isEmpty((Object)resultResponse) || !resultResponse.getHead().toLowerCase().equals("ok")) {
            String repeatResult = EasClient.parseRepeat(resultResponse.getResults());
            if (StringUtils.isNotBlank((CharSequence)repeatResult)) {
                return repeatResult;
            }
            throw new BizException("EAS\u670d\u52a1\u7aef\u5f02\u5e38\uff0cresult\u7ed3\u679c\u5f02\u5e38\uff1a" + data);
        }
        return resultResponse.getResults();
    }

    private static String parseRepeat(String data) {
        log.info("\u89e3\u6790\u5f02\u5e38\u4fe1\u606f\uff0c\u5224\u65ad\u662f\u5426\u4e3a\u5df2\u5b58\u5728\u5355\u636e\uff1a{}", (Object)data);
        try {
            List resultsResponses;
            if (StringUtils.isNotBlank((CharSequence)data) && data.contains("\u5df2\u7ecf\u5bfc\u5165\uff0c\u4e0d\u9700\u8981\u91cd\u590d\u5bfc\u5165") && CollectionUtil.isNotEmpty((Collection)(resultsResponses = JSONObject.parseArray((String)data, EASResultsResponse.class))) && StringUtils.isNotBlank((CharSequence)((EASResultsResponse)resultsResponses.get(0)).getNote())) {
                EASResultResponse resultResponse = (EASResultResponse)JSON.parseObject((String)((EASResultsResponse)resultsResponses.get(0)).getNote(), EASResultResponse.class);
                log.info("\u91cd\u590d\u5bfc\u5165\uff1a{}", (Object)resultResponse.getResults());
                return resultResponse.getResults();
            }
        }
        catch (Exception e) {
            log.error("\u89e3\u6790\u91cd\u590d\u5355\u636e\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
            throw new BizException("-1", "\u89e3\u6790\u91cd\u590d\u5355\u636e\u5f02\u5e38\uff1a" + data);
        }
        return null;
    }

    public static String execute(Map<String, Object> param, EasApiEnum easApiEnum) {
        String url = EAS_CONFIG.getUrl() + "/api?token=" + EasClient.buildEasCommonToken();
        HttpRequest post = HttpUtil.createPost((String)url);
        HashMap bodyMap = Maps.newHashMap();
        bodyMap.put("api", easApiEnum.getApiLink());
        bodyMap.put("data", Lists.newArrayList((Object[])new String[]{JSON.toJSONString(param)}));
        String bodyStr = JSON.toJSONString((Object)bodyMap);
        post.body(bodyStr);
        TransactionTrackContextUtils.setTrackLogRequestData((String)"requestUrl", (Object)url);
        TransactionTrackContextUtils.setTrackLogRequestData((String)"requestData", (Object)bodyStr);
        String result = EasResponseHelper.checkData(EasClient.execute_post(post, bodyMap));
        if (result.equals("10000") && (result = EasClient.retryTokenCommon(post, bodyMap)).equals("10000")) {
            throw new BizException("EAS\u7684TOKEN\u5df2\u7ecf\u5931\u6548");
        }
        return result;
    }

    private static String retryTokenCommon(HttpRequest post, Map<String, Object> bodyMap) {
        log.info("TOKEN\u8fc7\u671f\uff0c\u6e05\u9664TOKEN\u91cd\u65b0\u8bf7\u6c42");
        CACHE_SERVICE.delCache(EAS_TOKEN_KEY);
        String token = EasClient.buildEasCommonToken();
        String url = EAS_CONFIG.getUrl() + "/api?token=" + token;
        post.setUrl(url);
        return EasResponseHelper.checkData(EasClient.execute_post(post, bodyMap));
    }

    private static String execute_post(HttpRequest post, Map<String, Object> bodyMap) {
        log.info("\u6267\u884cEAS\uff0cAPI\u8bf7\u6c42url:{}\uff0c\u53c2\u6570\uff1a{}", (Object)post.getUrl(), (Object)JSON.toJSONString(bodyMap));
        Instant start = Instant.now();
        post.timeout(EAS_CONFIG.getTimeout().intValue());
        HttpResponse httpResponse = post.execute();
        String body = httpResponse.body();
        Instant end = Instant.now();
        log.info("\u6267\u884cEAS API\u8bf7\u6c42\u54cd\u5e94\uff0c\u8bf7\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(bodyMap));
        log.info("\u6267\u884cEAS API\u8bf7\u6c42\u54cd\u5e94\uff0c\u8017\u65f6\uff1a{}\uff0c\u7ed3\u679c\uff1a{}", (Object)Duration.between(start, end).toMillis(), (Object)body);
        TransactionTrackContextUtils.setTrackLogResultData((String)"responseStatus", (Object)httpResponse.isGzip());
        TransactionTrackContextUtils.setTrackLogResultData((String)"responseData", (Object)body);
        TransactionTrackContextUtils.setTrackLogResultData((String)"responseCode", (Object)httpResponse.getStatus());
        return body;
    }

    public static String buildEasCommonToken() {
        log.info("\u83b7\u53d6EAS\u670d\u52a1\u57fa\u7840Token");
        EasLoginDto dto = new EasLoginDto();
        dto.setUser(EAS_CONFIG.getUser());
        dto.setPassword(EAS_CONFIG.getPassword());
        dto.setAuthPattern(EAS_CONFIG.getAuthPattern());
        dto.setDcName(EAS_CONFIG.getDcName());
        dto.setIsEncodePwd(EAS_CONFIG.getIsEncodePwd());
        dto.setLanguage(EAS_CONFIG.getLanguage());
        String url = EAS_CONFIG.getUrl() + "/login";
        return EasClient.buildToken(EAS_TOKEN_REDIS_LOCK_KEY, EAS_TOKEN_KEY, url, dto, EAS_CONFIG.getTokenTimeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String buildToken(String lockKey, String cacheKey, String url, EasLoginDto easLoginDto, Integer timeOut) {
        String string;
        block9: {
            Mutex mutex;
            block7: {
                String string2;
                block8: {
                    mutex = null;
                    log.info("\u83b7\u53d6EAS\u670d\u52a1Token\uff1a{}\uff0c{}", (Object)lockKey, (Object)cacheKey);
                    mutex = LOCK_SERVICE.lock("EasClient", lockKey, 10);
                    if (null == mutex) {
                        throw new BizException("\u83b7\u53d6EAS\u670d\u52a1Token\u5931\u8d25\uff0c\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25");
                    }
                    String cacheToken = (String)CACHE_SERVICE.getCache(cacheKey, String.class);
                    if (!StringUtils.isNotBlank((CharSequence)cacheToken)) break block7;
                    log.info("\u8bfb\u53d6\u7f13\u5b58\u5185Token\uff1a{}", (Object)cacheToken);
                    string2 = cacheToken;
                    if (null == mutex) break block8;
                    LOCK_SERVICE.unlock(mutex);
                }
                return string2;
            }
            try {
                log.info("\u91cd\u65b0\u83b7\u53d6Token\uff1a{}\uff0c{}\uff0c{}", new Object[]{url, timeOut, JSON.toJSONString((Object)easLoginDto)});
                HttpRequest post = HttpUtil.createPost((String)url);
                post.form(BeanUtil.beanToMap((Object)easLoginDto));
                HttpResponse httpResponse = post.execute();
                String body = httpResponse.body();
                JSONObject bodyObj = JSON.parseObject((String)body);
                String data = bodyObj.getString("data");
                JSONObject dataObj = JSON.parseObject((String)data);
                log.info("\u91cd\u65b0\u83b7\u53d6Token\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)dataObj));
                Object token = dataObj.get((Object)"token");
                CACHE_SERVICE.setCache(EAS_TOKEN_KEY, token, timeOut.intValue());
                string = Convert.toStr((Object)token);
                if (null == mutex) break block9;
            }
            catch (Exception e) {
                String string3;
                block10: {
                    try {
                        log.error("\u83b7\u53d6EAS\u670d\u52a1Token\u5931\u8d25\uff0c\u7a0b\u5e8f\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                        log.error(e.getMessage(), (Throwable)e);
                        string3 = null;
                        if (null == mutex) break block10;
                    }
                    catch (Throwable throwable) {
                        if (null != mutex) {
                            LOCK_SERVICE.unlock(mutex);
                        }
                        throw throwable;
                    }
                    LOCK_SERVICE.unlock(mutex);
                }
                return string3;
            }
            LOCK_SERVICE.unlock(mutex);
        }
        return string;
    }

    public static String refreshToken() {
        CACHE_SERVICE.delCache(EAS_TOKEN_KEY);
        return EasClient.buildEasCommonToken();
    }
}

