/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.InventoryCheckItem;
import com.dtyunxi.tcbj.api.dto.request.InventoryCheckReqDto;
import com.dtyunxi.tcbj.api.dto.response.InventoryCheckRespDto;
import com.dtyunxi.tcbj.api.query.IInventoryCheckApi;
import com.dtyunxi.tcbj.api.vo.InTransitInNoticeDetailVo;
import com.dtyunxi.tcbj.app.open.biz.service.IApiLogService;
import com.dtyunxi.tcbj.app.open.biz.service.IExternalInPutExtService;
import com.dtyunxi.tcbj.app.open.biz.service.IMultiAllotOrderService;
import com.dtyunxi.tcbj.app.open.biz.utils.AssertUtil;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.ApiLogReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.external.AllotOrderDetailDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.external.AllotOrderDto;
import com.dtyunxi.tcbj.center.openapi.common.eas.constant.EASExtendKeyEnum;
import com.dtyunxi.tcbj.center.openapi.common.eas.constant.RouteMultiAllotNodeEnum;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.ICsInventoryExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsRelWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsTransferOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.IInternalTradeApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsTransferOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.EasTransferOrderDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.EasTransferOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateCargoReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsRelWarehouseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsRelWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsLogicWarehouseStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsSourceSystemEnum;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.PcpItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.query.IPcpItemQueryApi;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.basicdata.api.query.IPcpDictQueryApi;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderRespDto;
import com.yunxi.dg.base.center.report.api.inventory.IDgLogicWarehouseApi;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicWarehousePageReqDto;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jboss.logging.MDC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExternalInPutServiceExtImpl
implements IExternalInPutExtService {
    private static final Logger log = LoggerFactory.getLogger(ExternalInPutServiceExtImpl.class);
    @Resource
    private IDgLogicWarehouseApi dgLogicWarehouseApi;
    @Resource
    private ILockService lockService;
    @Resource
    private ICsTransferOrderApi csTransferOrderQueryApi;
    @Resource
    private ICsRelWarehouseApi csRelWarehouseApi;
    @Resource
    private IPcpDictQueryApi pcpDictApi;
    @Resource
    private IInventoryCheckApi inventoryCheckApi;
    @Resource
    private IPcpItemQueryApi pcpItemQueryApi;
    @Resource
    private ICsInventoryExposedApi csInventoryExposedApi;
    @Autowired
    private ICsTransferOrderApi transferOrderApi;
    @Resource
    private IInternalTradeApi internalTradeApi;
    @Resource
    private IApiLogService apiLogService;
    @Resource
    private IMultiAllotOrderService multiAllotOrderService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void multiAllotOrderAdd2(List<AllotOrderDto> dto) {
        Mutex mutex;
        AllotOrderDto allotOrderDto;
        block4: {
            log.info("\u65b0\u589e\u591a\u65b9\u8c03\u62e8(\u4f70\u50b2\u603b\u4ee3\u7406\u6a21\u5f0f)\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(dto));
            this.routeMultiAllotTypeCheck(dto);
            this.multiAllotOrderAddVerify(dto);
            this.dealVerifyChannelSupplyInventory(dto, dto.get(0).getAllotType());
            if (dto.get(0).getAllotType().equals(CsPcpBusinessTypeEnum.INTERNAL_DEAL_BA.getCode()) || dto.get(0).getAllotType().equals(CsPcpBusinessTypeEnum.INTERNAL_DEAL_RETURN_BA.getCode()) || dto.get(0).getAllotType().equals(CsPcpBusinessTypeEnum.SALE_RETURN_INTERNAL_DEAL_BA.getCode())) {
                log.info("\u5185\u90e8\u4ea4\u6613(\u4f70\u50b2)\u6216\u5185\u90e8\u4ea4\u6613\u9000(\u4f70\u50b2)\u6216\u9500\u552e\u9000\u8f6c\u5185\u90e8\u4ea4\u6613(\u4f70\u50b2)");
                List<CsInventoryOperateReqDto> csInventoryOperateReqDtoList = dto.get(0).getAllotType().equals(CsPcpBusinessTypeEnum.SALE_RETURN_INTERNAL_DEAL_BA.getCode()) ? this.inventoryOperateListBuild(dto, CsPcpBusinessTypeEnum.SALE_RETURN_INTERNAL_DEAL_BA.getCode()) : this.inventoryOperateListBuild(dto, null);
                List<EasTransferOrderReqDto> easTransferOrderReqDtoList = this.easTransferOrderList(dto);
                log.info("\u5e93\u5b58\u9884\u5360\uff1a{}", (Object)JSON.toJSONString(csInventoryOperateReqDtoList));
                RestResponseHelper.extractData((RestResponse)this.csInventoryExposedApi.batchPreemptInventory(csInventoryOperateReqDtoList));
                CompletableFuture.runAsync(() -> {
                    log.info("\u521b\u5efa\u5355\u636e\uff1a{}", (Object)JSON.toJSONString((Object)easTransferOrderReqDtoList));
                    RestResponseHelper.extractData((RestResponse)this.transferOrderApi.batchEasAddTransferOrder(easTransferOrderReqDtoList));
                });
                return;
            }
            if (!dto.get(0).getAllotType().equals(CsPcpBusinessTypeEnum.ROUTE_INTERNAL_DEAL_BA.getCode())) throw new BizException("\u4e1a\u52a1\u7c7b\u578b\u5f02\u5e38");
            log.info("\u5728\u9014\u5185\u90e8\u4ea4\u6613(\u4f70\u50b2\u603b\u4ee3\u7406\u6a21\u5f0f)\uff1a{}", (Object)JacksonUtil.toJson(dto));
            allotOrderDto = dto.get(0);
            AssertUtil.isTrues(allotOrderDto.getItemDetailList().size() > 1, "-1", "\u5728\u9014\u5185\u90e8\u4ea4\u6613\u4e0d\u5141\u8bb8\u53d1\u8d77\u591a\u4e2a\u660e\u7ec6");
            AllotOrderDetailDto allotOrderDetailDto = (AllotOrderDetailDto)allotOrderDto.getItemDetailList().get(0);
            String key = allotOrderDetailDto.getSkuCode() + allotOrderDetailDto.getQuantity() + allotOrderDetailDto.getOutWarehouseCode();
            mutex = null;
            try {
                log.info("\u5206\u5e03\u5f0f\u9501\uff1a{}", (Object)key);
                mutex = this.lockService.lock("ROUTE_INTERNAL_DEAL", key, 60);
                ApiLogReqDto logReqDto = new ApiLogReqDto();
                logReqDto.setClassName(allotOrderDto.getExternalSaleOrderNo());
                logReqDto.setMethodName(RouteMultiAllotNodeEnum.ACCEPT.getName());
                logReqDto.setStatus(1);
                List<ApiLogReqDto> apiLogReqDtoList = this.apiLogService.queryRouteInternalDeal(logReqDto);
                if (!CollectionUtils.isNotEmpty(apiLogReqDtoList)) break block4;
                log.info("\u8be5\u5185\u90e8\u4ea4\u6613\u5df2\u63a5\u5355");
                if (null == mutex) return;
            }
            catch (Throwable throwable) {
                if (null == mutex) throw throwable;
                this.lockService.unlock(mutex);
                throw throwable;
            }
            this.lockService.unlock(mutex);
            return;
        }
        this.routeMultiAllot(allotOrderDto);
        if (null == mutex) return;
        this.lockService.unlock(mutex);
    }

    private void routeMultiAllotTypeCheck(List<AllotOrderDto> dto) {
        String inWarehouseCode;
        String outWarehouseCode;
        String allotType = dto.get(0).getAllotType();
        if (allotType.equals(CsPcpBusinessTypeEnum.SALE_RETURN_INTERNAL_DEAL_BA.getCode())) {
            outWarehouseCode = ((AllotOrderDetailDto)dto.get(0).getItemDetailList().get(0)).getOutWarehouseCode();
            inWarehouseCode = ((AllotOrderDetailDto)dto.get(1).getItemDetailList().get(0)).getInWarehouseCode();
        } else {
            AllotOrderDetailDto detailDto = (AllotOrderDetailDto)dto.get(0).getItemDetailList().get(0);
            outWarehouseCode = detailDto.getOutWarehouseCode();
            inWarehouseCode = detailDto.getInWarehouseCode();
        }
        DgLogicWarehousePageReqDto inQueryDto = new DgLogicWarehousePageReqDto();
        inQueryDto.setWarehouseCodes((List)Lists.newArrayList((Object[])new String[]{outWarehouseCode, inWarehouseCode}));
        List logicWarehouseDtoList = (List)RestResponseHelper.extractData((RestResponse)this.dgLogicWarehouseApi.queryList(inQueryDto));
        if (CollectionUtil.isEmpty((Collection)logicWarehouseDtoList) || logicWarehouseDtoList.size() != 2) {
            log.info("\u6839\u636e\u51fa\u5165\u4ed3\u5e93\u5224\u65ad\u5355\u636e\u662f\u5426\u4e3a\u5728\u9014\u5185\u90e8\u4ea4\u6613\uff1a{}", (Object)JacksonUtil.toJson((Object)logicWarehouseDtoList));
            throw new BizException("-1", "\u51fa\u5165\u4ed3\u67e5\u8be2\u5f02\u5e38\uff1a{}" + JacksonUtil.toJson((Object)inQueryDto.getWarehouseCodes()));
        }
        List warehouseDtoList = logicWarehouseDtoList.stream().filter(f -> f.getWarehouseClassify().equals("in_transit")).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(warehouseDtoList) && warehouseDtoList.size() == 2) {
            log.info("\u5224\u65ad\u5355\u636e\u662f\u5426\u4e3a\u5728\u9014\u5185\u90e8\u4ea4\u6613");
            allotType = CsPcpBusinessTypeEnum.ROUTE_INTERNAL_DEAL_BA.getCode();
            dto.get(0).setAllotType(allotType);
        }
        String finalAllotType = allotType;
        logicWarehouseDtoList.forEach(it -> {
            if (!Objects.equals(it.getWarehouseStatus(), CsLogicWarehouseStatusEnum.ENABLE.getCode())) {
                throw new BizException("-1", it.getWarehouseName() + "\u72b6\u6001\u5f02\u5e38, \u8bf7\u8054\u7cfb\u7269\u6d41\u90e8\u6838\u5b9e");
            }
            if (!Objects.equals(finalAllotType, CsPcpBusinessTypeEnum.ROUTE_INTERNAL_DEAL_BA.getCode()) && !Objects.equals(it.getWarehouseType(), "3")) {
                throw new BizException("-1", it.getWarehouseName() + "\u975eB\u4ed3, \u8bf7\u8054\u7cfb\u7269\u6d41\u90e8\u6838\u5b9e");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void multiAllotOrderAddVerify(List<AllotOrderDto> dto) {
        String outWarehouseCode;
        String inWarehouseCode;
        AllotOrderDto d;
        block11: {
            boolean specifyBatch = true;
            if (dto.get(0).getAllotType().equals(CsPcpBusinessTypeEnum.INTERNAL_DEAL_BA.getCode()) || dto.get(0).getAllotType().equals(CsPcpBusinessTypeEnum.ROUTE_INTERNAL_DEAL_BA.getCode())) {
                specifyBatch = false;
            }
            d = dto.get(0);
            boolean finalSpecifyBatch = specifyBatch;
            if (!finalSpecifyBatch) {
                log.info("\u4e0d\u6307\u5b9a\u6279\u6b21\u6821\u9a8c\uff1a{}", (Object)d.getSaleCustomerCode());
                Map<String, List<AllotOrderDetailDto>> collect = d.getItemDetailList().stream().collect(Collectors.groupingBy(AllotOrderDetailDto::getSkuCode));
                collect.forEach((k, v) -> {
                    if (v.size() > 1) {
                        throw new BizException("\u8bf7\u6c42\u5931\u8d25\uff0c\u5546\u54c1\uff1a" + k + "\u5b58\u5728\u591a\u884c\u660e\u7ec6");
                    }
                });
            }
            if ((d.getAllotType().equals(CsPcpBusinessTypeEnum.INTERNAL_DEAL_RETURN_BA.getCode()) || d.getAllotType().equals(CsPcpBusinessTypeEnum.SALE_RETURN_INTERNAL_DEAL_BA.getCode())) && StringUtils.isNotBlank((CharSequence)d.getPlatformOrderNo())) {
                Mutex mutex = null;
                try {
                    log.info("\u4f70\u50b2\u5185\u90e8\u4ea4\u6613\u9000\u3001\u9500\u552e\u9000\u8f6c\u5185\u90e8\u4ea4\u6613\u7236\u5355\u53f7\u5e42\u7b49\u6821\u9a8c");
                    mutex = this.lockService.lock("ExternalInPutServiceExtImpl", d.getPlatformOrderNo(), 10);
                    if (null == mutex) {
                        throw new BizException("\u4f70\u50b2\u5185\u90e8\u4ea4\u6613\u9000\u3001\u9500\u552e\u9000\u8f6c\u5185\u90e8\u4ea4\u6613\u7236\u5355\u53f7\u5e42\u7b49\u6821\u9a8c\u5931\u8d25\uff0c\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25");
                    }
                    CsTransferOrderReqDto reqDto = new CsTransferOrderReqDto();
                    reqDto.setPreOrderNo(d.getPlatformOrderNo());
                    List list = (List)RestResponseHelper.extractData((RestResponse)this.csTransferOrderQueryApi.queryTransferOrderList(reqDto));
                    if (CollectionUtils.isNotEmpty((Collection)list) && StringUtils.isNotBlank((CharSequence)((CsTransferOrderRespDto)list.get(0)).getTransferOrderNo())) {
                        throw new BizException("\u4f70\u50b2\u5185\u90e8\u4ea4\u6613\u9000\u3001\u9500\u552e\u9000\u8f6c\u5185\u90e8\u4ea4\u6613\u5df2\u5b58\u5728\u5355\u636e\uff1a" + d.getPlatformOrderNo());
                    }
                    if (null == mutex) break block11;
                }
                catch (Throwable throwable) {
                    if (null != mutex) {
                        this.lockService.unlock(mutex);
                    }
                    throw throwable;
                }
                this.lockService.unlock(mutex);
            }
        }
        if (d.getAllotType().equals(CsPcpBusinessTypeEnum.SALE_RETURN_INTERNAL_DEAL_BA.getCode())) {
            inWarehouseCode = ((AllotOrderDetailDto)dto.get(1).getItemDetailList().get(0)).getInWarehouseCode();
            outWarehouseCode = ((AllotOrderDetailDto)d.getItemDetailList().get(0)).getOutWarehouseCode();
        } else {
            inWarehouseCode = ((AllotOrderDetailDto)d.getItemDetailList().get(0)).getInWarehouseCode();
            outWarehouseCode = ((AllotOrderDetailDto)d.getItemDetailList().get(0)).getOutWarehouseCode();
        }
        log.info("\u6821\u9a8c\u8c03\u5165\u4ed3\u53ca\u8c03\u51fa\u4ed3\u5bf9\u5e94\u7684\u7269\u7406\u4ed3\u662f\u5426\u4e00\u81f4\uff1a{}\uff0c{}", (Object)inWarehouseCode, (Object)outWarehouseCode);
        CsRelWarehouseQueryDto queryDto = new CsRelWarehouseQueryDto();
        queryDto.setWarehouseCodeList((List)Lists.newArrayList((Object[])new String[]{inWarehouseCode, outWarehouseCode}));
        List csRelWarehouseRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.csRelWarehouseApi.queryList(queryDto));
        AssertUtil.isFalse(CollectionUtils.isEmpty((Collection)csRelWarehouseRespDtoList), "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7269\u7406\u4ed3\u4fe1\u606f");
        Map collect = csRelWarehouseRespDtoList.stream().collect(Collectors.toMap(CsRelWarehouseRespDto::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
        CsRelWarehouseRespDto inRelWarehouseRespDto = (CsRelWarehouseRespDto)collect.get(inWarehouseCode);
        AssertUtil.isFalse(ObjectUtil.isEmpty((Object)inRelWarehouseRespDto), inWarehouseCode + "\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7269\u7406\u4ed3\u4fe1\u606f");
        CsRelWarehouseRespDto outRelWarehouseRespDto = (CsRelWarehouseRespDto)collect.get(outWarehouseCode);
        AssertUtil.isFalse(ObjectUtil.isEmpty((Object)outRelWarehouseRespDto), outWarehouseCode + "\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7269\u7406\u4ed3\u4fe1\u606f");
        if (!inRelWarehouseRespDto.getRefWarehouseCode().equals(outRelWarehouseRespDto.getRefWarehouseCode())) {
            throw new BizException("\u8c03\u51fa\u4ed3\u548c\u8c03\u5165\u4ed3\u4e3a\u4e0d\u540c\u7269\u7406\u4ed3");
        }
    }

    private void dealVerifyChannelSupplyInventory(List<AllotOrderDto> dto, String type) {
        log.info("\u591a\u65b9\u8c03\u62e8\u4ea4\u6613\u6e20\u9053\u4f9b\u8d27\u4ed3\u5e93\u5b58\u6821\u9a8c\uff1a{}", (Object)JSON.toJSONString(dto));
        boolean ifOpen = Objects.equals("1", Optional.ofNullable(this.pcpDictApi.queryByGroupCodeAndCode("COMMON_CONFIG", "INTERNAL_DEAL_CHANNEL_CHECK").getData()).map(DictDto::getValue).orElse("0"));
        if (!ifOpen) {
            log.info("\u63a7\u5236\u5173\u95ed\uff0c\u65e0\u9700\u6821\u9a8c");
            return;
        }
        List<Object> itemDetailList = new ArrayList();
        switch (CsPcpBusinessTypeEnum.getByCode((String)type)) {
            case INTERNAL_DEAL_BA: 
            case INTERNAL_DEAL_RETURN_BA: 
            case ROUTE_INTERNAL_DEAL_BA: {
                itemDetailList = dto.stream().map(AllotOrderDto::getItemDetailList).flatMap(Collection::stream).collect(Collectors.toList());
                break;
            }
            case SALE_RETURN_INTERNAL_DEAL_BA: {
                itemDetailList = dto.get(0).getItemDetailList();
                break;
            }
        }
        List items = itemDetailList.stream().map(detailDto -> {
            InventoryCheckItem item = new InventoryCheckItem();
            item.setLongCode(detailDto.getSkuCode());
            item.setBatch(detailDto.getBatch());
            item.setTargetInventory(detailDto.getQuantity());
            item.setLogicWarehouseCode(detailDto.getOutWarehouseCode());
            return item;
        }).collect(Collectors.toList());
        InventoryCheckReqDto checkReqDto = new InventoryCheckReqDto();
        checkReqDto.setItems(items);
        checkReqDto.setCheckType(InventoryCheckReqDto.CheckType.CHANNEL);
        log.info("\u591a\u65b9\u8c03\u62e8\u4ea4\u6613\u6e20\u9053\u4f9b\u8d27\u4ed3\u5e93\u5b58\u6821\u9a8c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)checkReqDto));
        InventoryCheckRespDto inventoryCheckRespDto = (InventoryCheckRespDto)RestResponseHelper.extractData((RestResponse)this.inventoryCheckApi.batchCheckForShare(checkReqDto));
        log.info("\u591a\u65b9\u8c03\u62e8\u4ea4\u6613\u6e20\u9053\u4f9b\u8d27\u4ed3\u5e93\u5b58\u6821\u9a8c\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)inventoryCheckRespDto));
        if (!inventoryCheckRespDto.isCheckResult()) {
            String msg = inventoryCheckRespDto.getItems().stream().filter(c -> !c.isCheckResult()).map(InventoryCheckItem::getCheckReason).collect(Collectors.joining(";")).replaceAll(";", "\n");
            throw new BizException("-1", "\u6e20\u9053\u4ed3\u4f9b\u8d27\u4ed3\u5e93\u5b58\u6821\u9a8c\u5931\u8d25\uff1a" + msg);
        }
    }

    private List<CsInventoryOperateReqDto> inventoryOperateListBuild(List<AllotOrderDto> dto, String allotType) {
        log.info("\u6279\u91cf\u9884\u5360\u6570\u636e\u6784\u5efa\uff1a{}=={}", (Object)JSON.toJSONString(dto), (Object)allotType);
        ArrayList<CsInventoryOperateReqDto> csInventoryOperateReqDtoList = new ArrayList<CsInventoryOperateReqDto>();
        dto.forEach(allot -> {
            if (StringUtils.isBlank((CharSequence)allotType) || allot.getAllotType().equals(allotType)) {
                CsInventoryOperateReqDto csInventoryOperateReqDto = new CsInventoryOperateReqDto();
                BeanUtil.copyProperties((Object)allot, (Object)csInventoryOperateReqDto, (String[])new String[0]);
                csInventoryOperateReqDto.setPlatformOrderNo(allot.getPlatformOrderNo());
                csInventoryOperateReqDto.setSourceNo(allot.getExternalSaleOrderNo());
                csInventoryOperateReqDto.setSourceSystem(CsSourceSystemEnum.EAS.getCode());
                csInventoryOperateReqDto.setSourceType(CsInventorySourceTypeEnum.OUT_ALLOT_PREEMPT.getCode());
                csInventoryOperateReqDto.setBusinessType(CsPcpBusinessTypeEnum.ALLOT_OUT.getCode());
                csInventoryOperateReqDto.setBatchCalculate(Boolean.valueOf(true));
                csInventoryOperateReqDto.setNegativeValidate(Integer.valueOf(1));
                ArrayList inventoryOperateCargoReqDtoList = new ArrayList();
                ArrayList itemDetailList = new ArrayList();
                allot.getItemDetailList().forEach(item -> {
                    CsInventoryOperateCargoReqDto inventoryOperateCargoReqDto = new CsInventoryOperateCargoReqDto();
                    inventoryOperateCargoReqDto.setLongCode(item.getSkuCode());
                    inventoryOperateCargoReqDto.setWarehouseCode(item.getOutWarehouseCode());
                    inventoryOperateCargoReqDto.setChangeInventory(item.getQuantity());
                    inventoryOperateCargoReqDto.setBatch(item.getBatch());
                    inventoryOperateCargoReqDtoList.add(inventoryOperateCargoReqDto);
                });
                csInventoryOperateReqDto.setOperateCargoReqDtoList(inventoryOperateCargoReqDtoList);
                csInventoryOperateReqDtoList.add(csInventoryOperateReqDto);
            }
        });
        return csInventoryOperateReqDtoList;
    }

    private List<EasTransferOrderReqDto> easTransferOrderList(List<AllotOrderDto> dto) {
        ArrayList<EasTransferOrderReqDto> easTransferOrderReqDtoList = new ArrayList();
        String allotType = dto.get(0).getAllotType();
        if (allotType.equals(CsPcpBusinessTypeEnum.SALE_RETURN_INTERNAL_DEAL_BA.getCode())) {
            EasTransferOrderReqDto easTransferOrderReqDto = new EasTransferOrderReqDto();
            AllotOrderDto allotOrderDtoSaleReturn = dto.stream().filter(it -> it.getAllotType().equals(CsPcpBusinessTypeEnum.SALE_RETURN_INTERNAL_DEAL_BA.getCode())).findFirst().get();
            AllotOrderDto allotOrderDtoInternalDeal = dto.stream().filter(it -> it.getAllotType().equals(CsPcpBusinessTypeEnum.INTERNAL_DEAL_BA.getCode())).findFirst().get();
            easTransferOrderReqDto.setSourceSystem(CsSourceSystemEnum.EAS.getCode());
            easTransferOrderReqDto.setPlatformOrderNo(allotOrderDtoSaleReturn.getPlatformOrderNo());
            easTransferOrderReqDto.setParentOrderNo(allotOrderDtoSaleReturn.getPlatformOrderParentNo());
            easTransferOrderReqDto.setExternalSaleOrderNo(allotOrderDtoSaleReturn.getExternalSaleOrderNo());
            easTransferOrderReqDto.setExternalPurchaseOrderNo(allotOrderDtoInternalDeal.getExternalPurchaseOrderNo());
            easTransferOrderReqDto.setAllotType(allotOrderDtoSaleReturn.getAllotType());
            easTransferOrderReqDto.setParentOrderNo(allotOrderDtoSaleReturn.getPlatformOrderParentNo());
            easTransferOrderReqDto.setSupplierCode(allotOrderDtoSaleReturn.getSupplierCode());
            easTransferOrderReqDto.setInWarehouseCode(((AllotOrderDetailDto)allotOrderDtoInternalDeal.getItemDetailList().get(0)).getInWarehouseCode());
            easTransferOrderReqDto.setOutWarehouseCode(((AllotOrderDetailDto)allotOrderDtoSaleReturn.getItemDetailList().get(0)).getOutWarehouseCode());
            easTransferOrderReqDto.setRemark(allotOrderDtoSaleReturn.getRemark());
            HashMap<String, Object> extensionMap = new HashMap<String, Object>();
            extensionMap.put(EASExtendKeyEnum.OUT_INVENTORY_ORG_CODE.code, allotOrderDtoSaleReturn.getOutInventoryOrgCode());
            extensionMap.put(EASExtendKeyEnum.IN_INVENTORY_ORG_CODE.code, allotOrderDtoInternalDeal.getInInventoryOrgCode());
            extensionMap.put(EASExtendKeyEnum.PURCHASE_ORDER_ID.code, allotOrderDtoInternalDeal.getExternalPurchaseOrderId());
            extensionMap.put(EASExtendKeyEnum.PURCHASE_ORDER_NO.code, allotOrderDtoInternalDeal.getExternalPurchaseOrderNo());
            extensionMap.put(EASExtendKeyEnum.SALE_ORDER_ID.code, allotOrderDtoInternalDeal.getExternalSaleOrderId());
            extensionMap.put(EASExtendKeyEnum.SALE_ORDER_NO.code, allotOrderDtoInternalDeal.getExternalSaleOrderNo());
            extensionMap.put(EASExtendKeyEnum.PURCHASE_RETURN_ORDER_ID.code, allotOrderDtoSaleReturn.getExternalPurchaseOrderId());
            extensionMap.put(EASExtendKeyEnum.PURCHASE_RETURN_ORDER_NO.code, allotOrderDtoSaleReturn.getExternalPurchaseOrderNo());
            extensionMap.put(EASExtendKeyEnum.SALE_RETURN_ORDER_ID.code, allotOrderDtoSaleReturn.getExternalSaleOrderId());
            extensionMap.put(EASExtendKeyEnum.SALE_RETURN_ORDER_NO.code, allotOrderDtoSaleReturn.getExternalSaleOrderNo());
            extensionMap.put(EASExtendKeyEnum.SALE_ORG_CODE.code, allotOrderDtoSaleReturn.getSaleOrganizationCode());
            extensionMap.put(EASExtendKeyEnum.SALE_CUS_CODE.code, allotOrderDtoSaleReturn.getSaleCustomerCode());
            extensionMap.put(EASExtendKeyEnum.ITEM_TOTAL_AMOUNT.code, allotOrderDtoSaleReturn.getItemTotalAmount());
            easTransferOrderReqDto.setExtension(JSON.toJSONString(extensionMap));
            List<String> longCodes = allotOrderDtoSaleReturn.getItemDetailList().stream().map(AllotOrderDetailDto::getSkuCode).collect(Collectors.toList());
            Map<String, PcpItemRespDto> map = this.queryItemInfo(longCodes);
            ArrayList<EasTransferOrderDetailReqDto> itemDetailList = new ArrayList<EasTransferOrderDetailReqDto>();
            for (int i = 0; i < allotOrderDtoSaleReturn.getItemDetailList().size(); ++i) {
                PcpItemRespDto pcpItemRespDto;
                AllotOrderDetailDto item = (AllotOrderDetailDto)allotOrderDtoSaleReturn.getItemDetailList().get(i);
                EasTransferOrderDetailReqDto easTransferOrderDetailReqDto = new EasTransferOrderDetailReqDto();
                easTransferOrderDetailReqDto.setLongCode(item.getSkuCode());
                easTransferOrderDetailReqDto.setQuantity(item.getQuantity());
                easTransferOrderDetailReqDto.setBatch(item.getBatch());
                if (ObjectUtil.isNotEmpty(map) && ObjectUtil.isNotEmpty((Object)map.get(item.getSkuCode())) && ObjectUtil.isNotEmpty((Object)(pcpItemRespDto = map.get(item.getSkuCode())).getVolume())) {
                    easTransferOrderDetailReqDto.setVolume(pcpItemRespDto.getVolume().multiply(item.getQuantity()).setScale(4, RoundingMode.DOWN));
                }
                HashMap<String, Object> itemExtensionMap = new HashMap<String, Object>();
                itemExtensionMap.put(EASExtendKeyEnum.SALE_RETURN_ORDER_ENTRYID.code, item.getSaleOrderDetailId());
                itemExtensionMap.put(EASExtendKeyEnum.PURCHASE_RETURN_ORDER_ENTRYID.code, item.getPurchaseOrderDetailId());
                AllotOrderDetailDto itemInternalDeal = (AllotOrderDetailDto)allotOrderDtoInternalDeal.getItemDetailList().get(i);
                itemExtensionMap.put(EASExtendKeyEnum.SALE_ORDER_ENTRYID.code, itemInternalDeal.getSaleOrderDetailId());
                itemExtensionMap.put(EASExtendKeyEnum.PURCHASE_ORDER_ENTRYID.code, itemInternalDeal.getPurchaseOrderDetailId());
                itemExtensionMap.put(EASExtendKeyEnum.INTERNAL_DEAL_DETAIL_PROJECT_NO.code, item.getProjectNo());
                itemExtensionMap.put(EASExtendKeyEnum.INTERNAL_DEAL_DETAIL_IF_ONLINE.code, item.getIfOnline());
                itemExtensionMap.put(EASExtendKeyEnum.INTERNAL_DEAL_DETAIL_TRACK_PLAN.code, item.getTrackPlan());
                easTransferOrderDetailReqDto.setExtension(JSON.toJSONString(itemExtensionMap));
                itemDetailList.add(easTransferOrderDetailReqDto);
            }
            easTransferOrderReqDto.setItemDetailList(itemDetailList);
            easTransferOrderReqDtoList.add(easTransferOrderReqDto);
        } else {
            easTransferOrderReqDtoList = dto.stream().map(allot -> {
                EasTransferOrderReqDto easTransferOrderReqDto = new EasTransferOrderReqDto();
                easTransferOrderReqDto.setSourceSystem(CsSourceSystemEnum.EAS.getCode());
                easTransferOrderReqDto.setPlatformOrderNo(allot.getPlatformOrderNo());
                easTransferOrderReqDto.setParentOrderNo(allot.getPlatformOrderParentNo());
                easTransferOrderReqDto.setExternalSaleOrderNo(allot.getExternalSaleOrderNo());
                easTransferOrderReqDto.setExternalPurchaseOrderNo(allot.getExternalPurchaseOrderNo());
                easTransferOrderReqDto.setAllotType(allot.getAllotType());
                easTransferOrderReqDto.setParentOrderNo(allot.getPlatformOrderParentNo());
                easTransferOrderReqDto.setSupplierCode(allot.getSupplierCode());
                easTransferOrderReqDto.setInWarehouseCode(((AllotOrderDetailDto)allot.getItemDetailList().get(0)).getInWarehouseCode());
                easTransferOrderReqDto.setOutWarehouseCode(((AllotOrderDetailDto)allot.getItemDetailList().get(0)).getOutWarehouseCode());
                easTransferOrderReqDto.setRemark(allot.getRemark());
                HashMap<String, Object> extensionMap = new HashMap<String, Object>();
                extensionMap.put(EASExtendKeyEnum.IN_INVENTORY_ORG_CODE.code, allot.getInInventoryOrgCode());
                extensionMap.put(EASExtendKeyEnum.OUT_INVENTORY_ORG_CODE.code, allot.getOutInventoryOrgCode());
                if (allotType.equals(CsPcpBusinessTypeEnum.INTERNAL_DEAL_BA.getCode())) {
                    extensionMap.put(EASExtendKeyEnum.SALE_ORDER_ID.code, allot.getExternalSaleOrderId());
                    extensionMap.put(EASExtendKeyEnum.SALE_ORDER_NO.code, allot.getExternalSaleOrderNo());
                    extensionMap.put(EASExtendKeyEnum.PURCHASE_ORDER_ID.code, allot.getExternalPurchaseOrderId());
                    extensionMap.put(EASExtendKeyEnum.PURCHASE_ORDER_NO.code, allot.getExternalPurchaseOrderNo());
                } else if (allotType.equals(CsPcpBusinessTypeEnum.INTERNAL_DEAL_RETURN_BA.getCode())) {
                    extensionMap.put(EASExtendKeyEnum.PURCHASE_RETURN_ORDER_ID.code, allot.getExternalPurchaseOrderId());
                    extensionMap.put(EASExtendKeyEnum.PURCHASE_RETURN_ORDER_NO.code, allot.getExternalPurchaseOrderNo());
                    extensionMap.put(EASExtendKeyEnum.SALE_RETURN_ORDER_ID.code, allot.getExternalSaleOrderId());
                    extensionMap.put(EASExtendKeyEnum.SALE_RETURN_ORDER_NO.code, allot.getExternalSaleOrderNo());
                }
                extensionMap.put(EASExtendKeyEnum.SALE_ORG_CODE.code, allot.getSaleOrganizationCode());
                extensionMap.put(EASExtendKeyEnum.SALE_CUS_CODE.code, allot.getSaleCustomerCode());
                extensionMap.put(EASExtendKeyEnum.ITEM_TOTAL_AMOUNT.code, allot.getItemTotalAmount());
                easTransferOrderReqDto.setExtension(JSON.toJSONString(extensionMap));
                List<String> longCodes = allot.getItemDetailList().stream().map(AllotOrderDetailDto::getSkuCode).collect(Collectors.toList());
                Map<String, PcpItemRespDto> map = this.queryItemInfo(longCodes);
                List itemDetailList = allot.getItemDetailList().stream().map(item -> {
                    PcpItemRespDto pcpItemRespDto;
                    EasTransferOrderDetailReqDto easTransferOrderDetailReqDto = new EasTransferOrderDetailReqDto();
                    easTransferOrderDetailReqDto.setLongCode(item.getSkuCode());
                    easTransferOrderDetailReqDto.setQuantity(item.getQuantity());
                    easTransferOrderDetailReqDto.setBatch(item.getBatch());
                    if (ObjectUtil.isNotEmpty((Object)map) && ObjectUtil.isNotEmpty(map.get(item.getSkuCode())) && ObjectUtil.isNotEmpty((Object)(pcpItemRespDto = (PcpItemRespDto)map.get(item.getSkuCode())).getVolume())) {
                        easTransferOrderDetailReqDto.setVolume(pcpItemRespDto.getVolume().multiply(item.getQuantity()).setScale(4, RoundingMode.DOWN));
                    }
                    HashMap<String, Object> itemExtensionMap = new HashMap<String, Object>();
                    if (allotType.equals(CsPcpBusinessTypeEnum.INTERNAL_DEAL_BA.getCode())) {
                        itemExtensionMap.put(EASExtendKeyEnum.SALE_ORDER_ENTRYID.code, item.getSaleOrderDetailId());
                        itemExtensionMap.put(EASExtendKeyEnum.PURCHASE_ORDER_ENTRYID.code, item.getPurchaseOrderDetailId());
                    } else if (allotType.equals(CsPcpBusinessTypeEnum.INTERNAL_DEAL_RETURN_BA.getCode())) {
                        itemExtensionMap.put(EASExtendKeyEnum.PURCHASE_RETURN_ORDER_ENTRYID.code, item.getPurchaseOrderDetailId());
                        itemExtensionMap.put(EASExtendKeyEnum.SALE_RETURN_ORDER_ENTRYID.code, item.getSaleOrderDetailId());
                    }
                    itemExtensionMap.put(EASExtendKeyEnum.INTERNAL_DEAL_DETAIL_PROJECT_NO.code, item.getProjectNo());
                    itemExtensionMap.put(EASExtendKeyEnum.INTERNAL_DEAL_DETAIL_IF_ONLINE.code, item.getIfOnline());
                    itemExtensionMap.put(EASExtendKeyEnum.INTERNAL_DEAL_DETAIL_TRACK_PLAN.code, item.getTrackPlan());
                    easTransferOrderDetailReqDto.setExtension(JSON.toJSONString(itemExtensionMap));
                    return easTransferOrderDetailReqDto;
                }).collect(Collectors.toList());
                easTransferOrderReqDto.setItemDetailList(itemDetailList);
                return easTransferOrderReqDto;
            }).collect(Collectors.toList());
        }
        return easTransferOrderReqDtoList;
    }

    private Map<String, PcpItemRespDto> queryItemInfo(List<String> longCodes) {
        try {
            log.info("\u83b7\u53d6\u5546\u54c1\u4e3b\u6570\u636e\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(longCodes));
            if (CollectionUtils.isEmpty(longCodes)) {
                return new HashMap<String, PcpItemRespDto>();
            }
            List itemList = (List)RestResponseHelper.extractData((RestResponse)this.pcpItemQueryApi.queryItemByItemLongCodes(longCodes));
            if (CollectionUtils.isNotEmpty((Collection)itemList)) {
                return itemList.stream().collect(Collectors.toMap(PcpItemRespDto::getLongCode, entity -> entity));
            }
            return new HashMap<String, PcpItemRespDto>();
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5546\u54c1\u4e3b\u6570\u636e\u4fe1\u606f\u5f02\u5e38");
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private void routeMultiAllot(AllotOrderDto allotOrderDto) {
        List<InTransitInNoticeDetailVo> inTransitInNoticeDetailVoList = this.multiAllotOrderService.routeMultiAllotMatch(allotOrderDto);
        this.multiAllotOrderService.routeMultiAllotPreemptInventory(allotOrderDto);
        InTransitInNoticeDetailVo noticeDetailVo = null;
        try {
            noticeDetailVo = this.multiAllotOrderService.routeMultiAllotCancelToWms(inTransitInNoticeDetailVoList, allotOrderDto);
        }
        catch (Exception e) {
            try {
                this.multiAllotOrderService.routeMultiAllotReleaseInventory(allotOrderDto);
            }
            catch (Exception e2) {
                throw new BizException("-1", "\u63a8\u9001WMS\u53d6\u6d88\u5931\u8d25\uff1a" + e.getMessage() + "\uff1b\u91ca\u653e\u5e93\u5b58\u5931\u8d25\uff1a" + e2.getMessage());
            }
            throw new BizException("-1", "\u63a8\u9001WMS\u53d6\u6d88\u5931\u8d25\uff1a" + e.getMessage());
        }
        this.apiLogService.addRouteInternalDeal(allotOrderDto.getExternalSaleOrderNo(), RouteMultiAllotNodeEnum.ACCEPT, true, noticeDetailVo.getInNoticeNo());
        String reqId = ServiceContext.getContext().getAttachment("yes.req.requestId");
        InTransitInNoticeDetailVo finalNoticeDetailVo = noticeDetailVo;
        CompletableFuture.runAsync(() -> {
            MDC.put((String)"yes.req.requestId", (Object)reqId);
            this.multiAllotOrderService.routeMultiAllotExecute(allotOrderDto, finalNoticeDetailVo);
        });
        log.info("\u5728\u9014\u5185\u90e8\u4ea4\u6613\u63a5\u5355\u5b8c\u6210");
    }
}

