/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.component.track.commons.utils.TransactionTrackContextUtils;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.tcbj.app.open.biz.config.ExternalConfig;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class ExternalClientAbstract<R extends ExternalConfig> {
    private static final Logger logger = LoggerFactory.getLogger(ExternalClientAbstract.class);
    @Resource
    private ICacheService cacheService;
    @Autowired
    private R config;

    public String buildUrl(String url) {
        return ((ExternalConfig)this.config).buildRequestUrl(url);
    }

    public String buildBodyParams(Map<String, Object> headParams) {
        return JSON.toJSONString(headParams);
    }

    public String executePost(String url, Map<String, Object> bodyParams) {
        return this.execute_post(url, bodyParams, new HashMap<String, String>(), null);
    }

    public String executePost(String url, Map<String, Object> bodyParams, Map<String, String> headParams, Map<String, Object> params) {
        return this.execute_post(url, bodyParams, headParams, params);
    }

    public void requestPre(Map<String, String> headParams, Map<String, Object> params) {
    }

    private String execute_post(String url, Map<String, Object> bodyParams, Map<String, String> headParams, Map<String, Object> params) {
        logger.info(((ExternalConfig)this.config).getServiceName() + "POST\u8bf7\u6c42\u53c2\u5165\uff0curl\uff1a{}", (Object)url);
        logger.info("bodyParams\uff1a{}", (Object)(ObjectUtil.isNotEmpty(bodyParams) ? JSON.toJSONString(bodyParams) : ""));
        logger.info("headParams\uff1a{}", (Object)(ObjectUtil.isNotEmpty(headParams) ? JSON.toJSONString(headParams) : ""));
        logger.info("params\uff1a{}", (Object)(ObjectUtil.isNotEmpty(params) ? JSON.toJSONString(params) : ""));
        url = this.buildUrl(url);
        logger.info("\u8bf7\u6c42URL\uff1a{}", (Object)url);
        HttpRequest post = HttpUtil.createPost((String)url);
        String bodyStr = this.buildBodyParams(bodyParams);
        post.body(bodyStr);
        if (ObjectUtil.isNotEmpty(headParams)) {
            post.addHeaders(headParams);
        }
        if (ObjectUtil.isNotEmpty(params)) {
            post.form(params);
        }
        TransactionTrackContextUtils.setTrackLogRequestData((String)"requestUrl", (Object)url);
        TransactionTrackContextUtils.setTrackLogRequestData((String)"requestData", (Object)bodyStr);
        Instant start = Instant.now();
        HttpResponse httpResponse = post.execute();
        String body = httpResponse.body();
        Instant end = Instant.now();
        logger.info("\u8bf7\u6c42" + ((ExternalConfig)this.config).getServiceName() + "\u54cd\u5e94\u8017\u65f6\uff1a{}\uff0c\u7ed3\u679c\uff1a{}", (Object)Duration.between(start, end).toMillis(), (Object)body);
        TransactionTrackContextUtils.setTrackLogResultData((String)"responseStatus", (Object)httpResponse.isGzip());
        TransactionTrackContextUtils.setTrackLogResultData((String)"responseData", (Object)body);
        TransactionTrackContextUtils.setTrackLogResultData((String)"responseCode", (Object)httpResponse.getStatus());
        this.check(body);
        return body;
    }

    abstract void check(String var1);

    protected void setTokenCache(String key, String token, int seconds) {
        logger.info("\u8bbe\u7f6eToken\u7f13\u5b58\uff1a{}\uff0c{}\uff0c{}", new Object[]{key, token, seconds});
        try {
            boolean b = this.cacheService.setCache(key, (Object)token, seconds -= 15);
            if (b) {
                logger.info("\u8bbe\u7f6eToken\u7f13\u5b58\u6210\u529f");
            } else {
                logger.info("\u8bbe\u7f6eToken\u7f13\u5b58\u5931\u8d25");
            }
        }
        catch (Exception e) {
            logger.error("\u8bbe\u7f6eToken\u7f13\u5b58\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected String getTokenCache(String key) {
        logger.info("\u83b7\u53d6Token\u7f13\u5b58\uff1a{}", (Object)key);
        if (StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        try {
            return (String)this.cacheService.getCache(key, String.class);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6Token\u7f13\u5b58\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

