/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.dto.BaseRespDto;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.CargoInventoryReqDto;
import com.dtyunxi.tcbj.api.dto.request.InventoryCheckItem;
import com.dtyunxi.tcbj.api.dto.request.InventoryCheckReqDto;
import com.dtyunxi.tcbj.api.dto.response.InventoryCheckRespDto;
import com.dtyunxi.tcbj.api.dto.response.LogicInventoryRespDto;
import com.dtyunxi.tcbj.api.query.IInventoryCheckApi;
import com.dtyunxi.tcbj.api.query.ILogicInventoryQueryApi;
import com.dtyunxi.tcbj.app.open.biz.service.IOaMaterialApplyService;
import com.dtyunxi.tcbj.app.open.biz.utils.AssertUtil;
import com.dtyunxi.tcbj.app.open.biz.utils.CodeGenerateUtil;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.external.MaterialApplyAddReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.external.MaterialApplyAddress;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.external.MaterialApplyAuditReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.external.MaterialApplyItem;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.external.MaterialApplySummaryDto;
import com.dtyunxi.tcbj.center.openapi.api.enums.ExternalSystenEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerStatusRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerStatusQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsBusinessTypeApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsOtherStorageOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsOtherStorageOrderComboReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsOtherStorageOrderDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsOtherStorageOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.CsBusinessTypeRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.CsOtherStorageOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.OtherStorageAuditBatchReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsOtherStorageOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.PcpItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.query.IPcpItemQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.basicdata.api.query.IPcpRegionQueryApi;
import com.yunxi.dg.base.center.basicdata.dto.request.PcpRegionReqDto;
import com.yunxi.dg.base.center.basicdata.dto.response.PcpRegionRespDto;
import com.yunxi.dg.base.center.report.api.inventory.IDgLogicWarehouseApi;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicWarehouseDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicWarehousePageReqDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RepeatFilter;
import com.yx.tcbj.center.customer.api.dto.request.PCPCustomerSearchReqDto;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OaMaterialApplyServiceImpl
implements IOaMaterialApplyService {
    private static final Logger log = LoggerFactory.getLogger(OaMaterialApplyServiceImpl.class);
    @Resource
    private ICsBusinessTypeApi csBusinessTypeQueryApi;
    @Resource
    private IPcpItemQueryApi pcpItemQueryApi;
    @Resource
    private ICsOtherStorageOrderApi csOtherStorageOrderApi;
    @Resource
    private ILogicInventoryQueryApi logicInventoryQueryApi;
    @Resource
    private IInventoryCheckApi inventoryCheckApi;
    @Resource
    private IDgLogicWarehouseApi dgLogicWarehouseApi;
    @Autowired
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private IPcpRegionQueryApi pcpRegionQueryApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private ICustomerStatusQueryApi customerStatusQueryApi;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private CodeGenerateUtil codeGenerateUtil;
    @Autowired
    RepeatFilter repeatFilter;
    private static final Set<String> NON_SHIPMENT_STATUSES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(CsOtherStorageOrderStatusEnum.OUT.CANCEL.getCode(), CsOtherStorageOrderStatusEnum.OUT.AUDIT_FAILED.getCode(), CsOtherStorageOrderStatusEnum.IN.WAIT_AUDIT.getCode(), CsOtherStorageOrderStatusEnum.IN.AUDIT_FAILED.getCode())));
    private static final Set<String> APPROVAL_ALLOWED_STATUSES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(CsOtherStorageOrderStatusEnum.OUT.WAIT_COMMIT.getCode(), CsOtherStorageOrderStatusEnum.OUT.WAIT_LEVEL_ONE_AUDIT.getCode(), CsOtherStorageOrderStatusEnum.OUT.WAIT_LEVEL_TWO_AUDIT.getCode(), CsOtherStorageOrderStatusEnum.OUT.CANCEL.getCode(), CsOtherStorageOrderStatusEnum.OUT.AUDIT_FAILED.getCode(), CsOtherStorageOrderStatusEnum.IN.WAIT_COMMIT.getCode(), CsOtherStorageOrderStatusEnum.IN.WAIT_AUDIT.getCode(), CsOtherStorageOrderStatusEnum.IN.AUDIT_FAILED.getCode())));
    private static final Set<String> WAIT_AUDIT_STATUSES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(CsOtherStorageOrderStatusEnum.OUT.WAIT_COMMIT.getCode(), CsOtherStorageOrderStatusEnum.OUT.WAIT_LEVEL_ONE_AUDIT.getCode(), CsOtherStorageOrderStatusEnum.OUT.WAIT_LEVEL_TWO_AUDIT.getCode(), CsOtherStorageOrderStatusEnum.IN.WAIT_COMMIT.getCode(), CsOtherStorageOrderStatusEnum.IN.WAIT_AUDIT.getCode())));

    @Override
    public void addOaMaterialApply(MaterialApplyAddReqDto dto) {
        log.info("\u65b0\u589eOA\u7269\u6599\u7533\u8bf7\u5355\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)dto));
        switch (dto.getOaType()) {
            case "oa_wlbf": 
            case "oa_fxly": 
            case "oa_fxth": {
                this.trimText(dto);
                this.checkExistOrder(dto.getPlatformOrderNo(), 0);
                if (dto.getHasSubItem().booleanValue()) {
                    OaMaterialApplyServiceImpl.compareItemAndSubItem(dto);
                }
                if (dto.getPreemptInventory().booleanValue() && !"oa_fxth".equals(dto.getOaType())) {
                    this.checkInventory(dto);
                }
                List<CsOtherStorageOrderComboReqDto> comboOrderList = this.splitOrder(dto);
                if ("oa_fxly".equals(dto.getOaType())) {
                    this.buildMergeOrder(comboOrderList);
                }
                String key = "AUDIT_OTHER_STORAGE:" + dto.getPlatformOrderNo();
                this.repeatFilter.checkRepeat(key, () -> this.batchAddCsOtherStorageOrder(comboOrderList), true, "\u64cd\u4f5c\u9891\u7e41\uff0c\u7269\u6599\u7533\u8bf7\u5355 [" + dto.getPlatformOrderNo() + "] \u6b63\u5728\u63d0\u4ea4");
                break;
            }
            default: {
                throw new BizException("-1", "OA\u8868\u5355\u7c7b\u578b\u6709\u8bef");
            }
        }
    }

    @Override
    public void auditOaMaterialApply(MaterialApplyAuditReqDto dto) {
        log.info("\u5ba1\u6838OA\u7269\u6599\u7533\u8bf7\u5355\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)dto));
        switch (dto.getOaType()) {
            case "oa_wlbf": 
            case "oa_fxly": 
            case "oa_fxth": {
                List<CsOtherStorageOrderRespDto> orderList = this.checkExistOrder(dto.getPlatformOrderNo().trim(), 1);
                if (CollectionUtils.isNotEmpty(orderList)) {
                    List auditIds = orderList.stream().map(BaseRespDto::getId).collect(Collectors.toList());
                    OtherStorageAuditBatchReqDto auditReq = new OtherStorageAuditBatchReqDto();
                    auditReq.setAuditIds(auditIds);
                    auditReq.setAuditResult(dto.getAuditResult());
                    auditReq.setIsOaAudit("Y");
                    RestResponseHelper.extractData((RestResponse)this.csOtherStorageOrderApi.batchAuditCsOtherStorageOrder(auditReq));
                    break;
                }
                log.info("OA\u5355\u53f7{}\u4e0d\u5b58\u5728\u5f85\u5ba1\u8ba2\u5355", (Object)dto.getPlatformOrderNo());
                break;
            }
            default: {
                throw new BizException("-1", "OA\u8868\u5355\u7c7b\u578b\u6709\u8bef");
            }
        }
    }

    private void trimText(MaterialApplyAddReqDto dto) {
        dto.setPlatformOrderNo(dto.getPlatformOrderNo().trim());
        MaterialApplyAddress address = dto.getAddress();
        if (address != null) {
            address.setPhone(address.getPhone() == null ? null : address.getPhone().trim());
            address.setConsignee(address.getConsignee() == null ? null : address.getConsignee().trim());
            address.setProvinceName(address.getProvinceName() == null ? null : address.getProvinceName().trim());
            address.setCityName(address.getCityName() == null ? null : address.getCityName().trim());
            address.setAreaName(address.getAreaName() == null ? null : address.getAreaName().trim());
            address.setDetailAddress(address.getDetailAddress() == null ? null : address.getDetailAddress().trim());
        }
        for (MaterialApplyItem item : dto.getItemList()) {
            item.setSkuCode(item.getSkuCode().trim());
            item.setBatch(item.getBatch() == null ? null : item.getBatch().trim());
            item.setWarehouseCode(item.getWarehouseCode() == null ? null : item.getWarehouseCode().trim());
            item.setReservationNo(item.getReservationNo() == null ? null : item.getReservationNo().trim());
            item.setCostCenterOrgUnit(item.getCostCenterOrgUnit() == null ? null : item.getCostCenterOrgUnit().trim());
            address = item.getAddress();
            if (address == null) continue;
            address.setPhone(address.getPhone() == null ? null : address.getPhone().trim());
            address.setConsignee(address.getConsignee() == null ? null : address.getConsignee().trim());
            address.setProvinceName(address.getProvinceName() == null ? null : address.getProvinceName().trim());
            address.setCityName(address.getCityName() == null ? null : address.getCityName().trim());
            address.setAreaName(address.getAreaName() == null ? null : address.getAreaName().trim());
            address.setDetailAddress(address.getDetailAddress() == null ? null : address.getDetailAddress().trim());
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getSubItemList())) {
            for (MaterialApplyItem item : dto.getSubItemList()) {
                item.setSkuCode(item.getSkuCode().trim());
                item.setBatch(item.getBatch() == null ? null : item.getBatch().trim());
                item.setWarehouseCode(item.getWarehouseCode() == null ? null : item.getWarehouseCode().trim());
                item.setReservationNo(item.getReservationNo() == null ? null : item.getReservationNo().trim());
                item.setCostCenterOrgUnit(item.getCostCenterOrgUnit() == null ? null : item.getCostCenterOrgUnit().trim());
                address = item.getAddress();
                if (address == null) continue;
                address.setPhone(address.getPhone() == null ? null : address.getPhone().trim());
                address.setConsignee(address.getConsignee() == null ? null : address.getConsignee().trim());
                address.setProvinceName(address.getProvinceName() == null ? null : address.getProvinceName().trim());
                address.setCityName(address.getCityName() == null ? null : address.getCityName().trim());
                address.setAreaName(address.getAreaName() == null ? null : address.getAreaName().trim());
                address.setDetailAddress(address.getDetailAddress() == null ? null : address.getDetailAddress().trim());
            }
        }
    }

    private List<CsOtherStorageOrderRespDto> checkExistOrder(String platformOrderNo, int checkType) {
        CsOtherStorageOrderReqDto queryDto = new CsOtherStorageOrderReqDto();
        queryDto.setPreOrderNo(platformOrderNo);
        queryDto.setOrderSrc(ExternalSystenEnum.OA.getCode());
        List orderList = (List)RestResponseHelper.extractData((RestResponse)this.csOtherStorageOrderApi.queryByParams(queryDto));
        if (checkType == 0) {
            this.validateOrderStatus(orderList, NON_SHIPMENT_STATUSES, "\u63d0\u4ea4\u5931\u8d25\uff1a\u5df2\u5b58\u5728\u76f8\u540c\u5355\u53f7\u8ba2\u5355\uff0c\u65e0\u6cd5\u91cd\u590d\u63d0\u4ea4");
            return null;
        }
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)orderList), "-1", "\u63d0\u4ea4\u5931\u8d25\uff1a\u672a\u521b\u5efa\u8ba2\u5355");
        this.validateOrderStatus(orderList, APPROVAL_ALLOWED_STATUSES, "\u63d0\u4ea4\u5931\u8d25\uff1a\u5b58\u5728\u53d1\u8d27\u4e2d\u6216\u5df2\u53d1\u8d27\u8ba2\u5355\uff0c\u65e0\u6cd5\u91cd\u590d\u63d0\u4ea4");
        List<CsOtherStorageOrderRespDto> pendingList = orderList.stream().filter(order -> WAIT_AUDIT_STATUSES.contains(order.getOrderStatus())).collect(Collectors.toList());
        AssertUtil.isTrue(CollectionUtils.isNotEmpty(pendingList), "-1", "\u63d0\u4ea4\u5931\u8d25\uff1a\u91cd\u590d\u5ba1\u6279");
        return pendingList;
    }

    private void validateOrderStatus(List<CsOtherStorageOrderRespDto> orderList, Set<String> allowedStatuses, String errorMessage) {
        boolean allAllowed = orderList.stream().allMatch(order -> allowedStatuses.contains(order.getOrderStatus()));
        AssertUtil.isTrue(allAllowed, "-1", errorMessage);
    }

    private CustomerRespDto checkCustomerStatus(MaterialApplyAddReqDto applyDto) {
        AssertUtil.isTrue(ObjectUtil.isNotEmpty((Object)applyDto.getCustomerCode()), "\u5ba2\u6237\u7f16\u7801\u5b57\u6bb5\u672a\u4f20\u503c");
        PCPCustomerSearchReqDto pcpCustomerSearchReqDto = new PCPCustomerSearchReqDto();
        pcpCustomerSearchReqDto.setCode(applyDto.getCustomerCode());
        List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryPCPCustomerDetail(pcpCustomerSearchReqDto));
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)customerRespDtos), "\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        CustomerRespDto customerRespDto = (CustomerRespDto)customerRespDtos.get(0);
        AssertUtils.notNull((Object)customerRespDto.getStatusId(), (String)"\u5ba2\u6237\u8d26\u53f7\u6570\u636e\u5f02\u5e38\uff1a\u72b6\u6001\u6570\u636e\u4e3a\u7a7a");
        CustomerStatusRespDto customerStatusRespDto = (CustomerStatusRespDto)RestResponseHelper.extractData((RestResponse)this.customerStatusQueryApi.queryById(customerRespDto.getStatusId()));
        AssertUtils.notNull((Object)customerStatusRespDto, (String)"\u5ba2\u6237\u8d26\u53f7\u6570\u636e\u5f02\u5e38\uff1a\u72b6\u6001\u6570\u636e\u4e3a\u7a7a");
        AssertUtil.assertEqual(1, customerStatusRespDto.getAccountStatus(), "\u5ba2\u6237\u8d26\u53f7\u5df2\u7981\u7528");
        AssertUtil.assertEqual(1, customerStatusRespDto.getRecordStatus(), "\u5ba2\u6237\u8d26\u53f7\u5df2\u505c\u7528");
        return customerRespDto;
    }

    public static void compareItemAndSubItem(MaterialApplyAddReqDto dto) {
        List itemList = Optional.ofNullable(dto.getItemList()).orElse(Collections.emptyList());
        List subItemList = Optional.ofNullable(dto.getSubItemList()).orElse(Collections.emptyList());
        ArrayList<String> errors = new ArrayList<String>();
        HashMap<MatchKey, MaterialApplyItem> itemMap = new HashMap<MatchKey, MaterialApplyItem>();
        for (MaterialApplyItem item2 : itemList) {
            itemMap.put(new MatchKey(item2), item2);
        }
        for (MaterialApplyItem subItem : subItemList) {
            MatchKey key = new MatchKey(subItem);
            MaterialApplyItem mainItem = (MaterialApplyItem)itemMap.get(key);
            if (mainItem != null) {
                subItem.setCostCenterOrgUnit(mainItem.getCostCenterOrgUnit());
                subItem.setUnit(mainItem.getUnit());
                continue;
            }
            String errorMsg = String.format("\u9884\u7559\u5355\u53f7 %s\u3001\u7269\u6599\u7f16\u7801 %s \u7684\u7269\u6599\u660e\u7ec6\u548c\u7269\u6599\u5b50\u9879\u4fe1\u606f\u4e0d\u4e00\u81f4", key.reservationNo, key.skuCode);
            errors.add(errorMsg);
        }
        if (!errors.isEmpty()) {
            throw new BizException("1000", ((Object)errors).toString());
        }
        Map<MatchKey, Integer> totalQtyByMain = itemList.stream().collect(Collectors.groupingBy(item -> new MatchKey((MaterialApplyItem)item), Collectors.mapping(MaterialApplyItem::getQuantity, Collectors.reducing(0, Integer::sum))));
        Map<MatchKey, Integer> totalQtyBySub = subItemList.stream().collect(Collectors.groupingBy(item -> new MatchKey((MaterialApplyItem)item), Collectors.mapping(MaterialApplyItem::getQuantity, Collectors.reducing(0, Integer::sum))));
        for (Map.Entry<MatchKey, Integer> entry : totalQtyByMain.entrySet()) {
            Integer subQty;
            MatchKey key = entry.getKey();
            Integer mainQty = entry.getValue();
            if (mainQty.compareTo(subQty = totalQtyBySub.getOrDefault(key, 0)) == 0) continue;
            String errorMsg = String.format("\u9884\u7559\u5355\u53f7 %s\u3001\u7269\u6599\u7f16\u7801 %s \u7684\u7269\u6599\u660e\u7ec6\u548c\u7269\u6599\u5b50\u9879\u6570\u91cf\u4e0d\u4e00\u81f4\u3002\u660e\u7ec6\u6570\u91cf\uff1a%s\uff0c\u5b50\u9879\u6570\u91cf\uff1a%s", key.reservationNo, key.skuCode, mainQty, subQty);
            errors.add(errorMsg);
        }
        if (!errors.isEmpty()) {
            throw new BizException("-1", ((Object)errors).toString());
        }
    }

    private void checkInventory(MaterialApplyAddReqDto dto) {
        log.info("\u7269\u6599\u7533\u8bf7\u5355\u6821\u9a8c\u5e93\u5b58\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        List itemList = dto.getHasSubItem() != false ? dto.getSubItemList() : dto.getItemList();
        List itemSummaryList = itemList.stream().collect(Collectors.groupingBy(item -> Arrays.asList(item.getWarehouseCode(), item.getSkuCode(), item.getBatch()), Collectors.summingInt(MaterialApplyItem::getQuantity))).entrySet().stream().map(e -> {
            List key = (List)e.getKey();
            return new MaterialApplySummaryDto((String)key.get(0), (String)key.get(1), (String)key.get(2), (Integer)e.getValue());
        }).collect(Collectors.toList());
        List checkLogicInventoryReq = itemSummaryList.stream().map(cargo -> {
            CargoInventoryReqDto reqDto = new CargoInventoryReqDto();
            reqDto.setBatch(cargo.getBatch());
            reqDto.setWarehouseCode(cargo.getWarehouseCode());
            reqDto.setCargoCode(cargo.getSkuCode());
            return reqDto;
        }).collect(Collectors.toList());
        log.info("\u5176\u4ed6\u51fa\u5e93\u5355\u6821\u9a8c\u903b\u8f91\u4ed3\u5e93\u5b58\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(checkLogicInventoryReq));
        Map<String, BigDecimal> inventoryCheck = ((List)RestResponseHelper.extractData((RestResponse)this.logicInventoryQueryApi.queryInventoryByCargo(checkLogicInventoryReq))).stream().collect(Collectors.toMap(this::degreeKey, LogicInventoryRespDto::getAvailable, (o, o1) -> o1));
        log.info("\u5176\u4ed6\u51fa\u5e93\u5355\u6821\u9a8c\u6e20\u9053\u4ed3\u5e93\u5b58\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString(inventoryCheck));
        ArrayList<String> errorDetails = new ArrayList<String>();
        for (MaterialApplySummaryDto item2 : itemSummaryList) {
            String key = this.degreeKey(item2);
            BigDecimal available = inventoryCheck.getOrDefault(key, BigDecimal.ZERO);
            if ((long)item2.getQuantity().intValue() <= available.longValueExact()) continue;
            String batchInfo = item2.getBatch() == null || item2.getBatch().trim().isEmpty() ? "" : " \u6279\u6b21[" + item2.getBatch() + "]";
            String errorMsg = String.format("\u4ed3\u5e93[%s] \u7269\u6599[%s]%s \u7533\u8bf7\u6570\u91cf[%d] > \u53ef\u7528\u5e93\u5b58[%d]", item2.getWarehouseCode(), item2.getSkuCode(), batchInfo, item2.getQuantity(), available.longValueExact());
            errorDetails.add(errorMsg);
        }
        if (!errorDetails.isEmpty()) {
            String errorMsg = String.join((CharSequence)"\n", errorDetails);
            throw new BizException("-1", "\u4ee5\u4e0b\u7269\u6599\u5e93\u5b58\u4e0d\u8db3\uff1a" + errorMsg);
        }
        List collect = itemSummaryList.stream().map(good -> {
            InventoryCheckItem item = new InventoryCheckItem();
            item.setLongCode(good.getSkuCode());
            item.setBatch(good.getBatch());
            item.setTargetInventory(new BigDecimal(good.getQuantity()));
            item.setLogicWarehouseCode(good.getWarehouseCode());
            return item;
        }).collect(Collectors.toList());
        InventoryCheckReqDto checkChannelInventoryReq = new InventoryCheckReqDto();
        checkChannelInventoryReq.setCheckType(InventoryCheckReqDto.CheckType.CHANNEL);
        checkChannelInventoryReq.setItems(collect);
        log.info("\u5176\u4ed6\u51fa\u5e93\u5355\u6821\u9a8c\u6e20\u9053\u4ed3\u5e93\u5b58\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)checkChannelInventoryReq));
        InventoryCheckRespDto inventoryCheckRespDto = (InventoryCheckRespDto)RestResponseHelper.extractData((RestResponse)this.inventoryCheckApi.batchCheckForShare(checkChannelInventoryReq));
        log.info("\u5176\u4ed6\u51fa\u5e93\u5355\u6821\u9a8c\u6e20\u9053\u4ed3\u5e93\u5b58\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)inventoryCheckRespDto));
        if (!inventoryCheckRespDto.isCheckResult()) {
            String msg = inventoryCheckRespDto.getItems().stream().filter(c -> !c.isCheckResult()).map(InventoryCheckItem::getCheckReason).collect(Collectors.joining(";")).replaceAll(";", "\n");
            throw new BizException("-1", "\u4ee5\u4e0b\u7269\u6599\u5e93\u5b58\u4e0d\u8db3\uff1a" + msg);
        }
    }

    private List<CsOtherStorageOrderComboReqDto> splitOrder(MaterialApplyAddReqDto applyDto) {
        OrganizationDto organization = (OrganizationDto)RestResponseHelper.extractData((RestResponse)this.organizationQueryApi.queryOneByOrgCode(null, applyDto.getOrganizationCode()));
        AssertUtil.isTrue(ObjectUtil.isNotEmpty((Object)organization), "10000", "\u516c\u53f8\u4ee3\u7801\u4e0d\u5b58\u5728");
        CsBusinessTypeRespDto businessType = (CsBusinessTypeRespDto)RestResponseHelper.extractData((RestResponse)this.csBusinessTypeQueryApi.queryByCode(applyDto.getBusinessType()));
        AssertUtil.isTrue(ObjectUtil.isNotEmpty((Object)businessType) && ObjectUtil.isNotEmpty((Object)businessType.getCode()), "10000", "\u9886\u7528\u76ee\u7684\u4e0d\u5b58\u5728");
        List itemList = applyDto.getHasSubItem() != false ? applyDto.getSubItemList() : applyDto.getItemList();
        List logicWarehouseCodes = itemList.stream().map(MaterialApplyItem::getWarehouseCode).distinct().collect(Collectors.toList());
        DgLogicWarehousePageReqDto logicWarehousePageReqDto = new DgLogicWarehousePageReqDto();
        logicWarehousePageReqDto.setWarehouseStatus("enable");
        logicWarehousePageReqDto.setWarehouseCodes(logicWarehouseCodes);
        List logicWarehouseList = (List)RestResponseHelper.extractData((RestResponse)this.dgLogicWarehouseApi.queryList(logicWarehousePageReqDto));
        HashMap warehouseMap = CollectionUtils.isNotEmpty((Collection)logicWarehouseList) ? logicWarehouseList.stream().collect(Collectors.toMap(it -> it.getWarehouseCode(), Function.identity(), (oldValue, newValue) -> oldValue)) : new HashMap();
        List skuCodes = itemList.stream().map(MaterialApplyItem::getSkuCode).distinct().collect(Collectors.toList());
        List skuList = (List)RestResponseHelper.extractData((RestResponse)this.pcpItemQueryApi.queryItemByItemLongCodes(skuCodes));
        Map<Object, Object> skuMap = new HashMap();
        if (itemList != null) {
            skuMap = skuList.stream().filter(Objects::nonNull).collect(Collectors.toMap(PcpItemRespDto::getLongCode, dto -> dto, (existing, replacement) -> existing));
        }
        Map<String, List<MaterialApplyItem>> detailMap = itemList.stream().collect(Collectors.groupingBy(item -> {
            MaterialApplyAddress address = item.getAddress();
            String addressKey = address == null ? "" : address.getSplitKey();
            return item.getWarehouseCode() + "_" + item.getReservationNo() + "_" + item.getCostCenterOrgUnit() + "_" + addressKey;
        }));
        ArrayList<String> errorMsg = new ArrayList<String>();
        ArrayList<String> errorSku = new ArrayList<String>();
        StringBuffer addressErrorMsg = new StringBuffer();
        ArrayList<CsOtherStorageOrderComboReqDto> otherStorageOrderList = new ArrayList<CsOtherStorageOrderComboReqDto>();
        HashMap<String, String> addressCacheMap = new HashMap<String, String>();
        for (Map.Entry<String, List<MaterialApplyItem>> entry : detailMap.entrySet()) {
            MaterialApplyAddress address;
            List<MaterialApplyItem> splitItemList = entry.getValue();
            CsOtherStorageOrderComboReqDto comboReqDto = new CsOtherStorageOrderComboReqDto();
            CsOtherStorageOrderReqDto orderReqDto = new CsOtherStorageOrderReqDto();
            MaterialApplyItem firstItem = splitItemList.get(0);
            orderReqDto.setPreOrderNo(applyDto.getPlatformOrderNo());
            orderReqDto.setCostOrgCode(organization.getCode());
            orderReqDto.setCostOrgName(organization.getName());
            DgLogicWarehouseDto warehouseDto = (DgLogicWarehouseDto)warehouseMap.get(firstItem.getWarehouseCode());
            AssertUtil.isTrue(ObjectUtil.isNotEmpty((Object)warehouseDto), "10000", "\u5e93\u5b58\u5730\u70b9\uff08" + firstItem.getWarehouseCode() + "\uff09\u9519\u8bef\u6216\u8005\u672a\u542f\u7528\uff1a");
            orderReqDto.setWarehouseId(warehouseDto.getId());
            orderReqDto.setWarehouseCode(warehouseDto.getWarehouseCode());
            orderReqDto.setWarehouseName(warehouseDto.getWarehouseName());
            orderReqDto.setOrganizationId(warehouseDto.getOrganizationId());
            orderReqDto.setOrganization(warehouseDto.getCargoEscheatageName());
            switch (applyDto.getOaType()) {
                case "oa_wlbf": 
                case "oa_fxly": {
                    orderReqDto.setType(CsPcpBusinessTypeEnum.OTHER_OUT.getCode());
                    break;
                }
                case "oa_fxth": {
                    orderReqDto.setType(CsPcpBusinessTypeEnum.OTHER_IN.getCode());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684 oaType \u7c7b\u578b: " + applyDto.getOaType());
                }
            }
            orderReqDto.setBusinessType(businessType.getId());
            orderReqDto.setBusinessTypeName(businessType.getBusinessTypeName());
            orderReqDto.setReservationNo(firstItem.getReservationNo());
            orderReqDto.setCostCenterCode(firstItem.getCostCenterOrgUnit());
            if (!"oa_wlbf".equals(applyDto.getOaType())) {
                CustomerRespDto customer = this.checkCustomerStatus(applyDto);
                orderReqDto.setCustomerCode(applyDto.getCustomerCode());
                orderReqDto.setCustomerName(customer.getCustomerName());
                orderReqDto.setCustomerType(applyDto.getCustomerType());
            }
            orderReqDto.setOrderSrc(ExternalSystenEnum.OA.getCode());
            orderReqDto.setSourceSystem(ExternalSystenEnum.OA.getCode());
            orderReqDto.setIsSendEas(Integer.valueOf(1));
            orderReqDto.setTotalOrder(Integer.valueOf(0));
            orderReqDto.setMessage(applyDto.getDigest());
            MaterialApplyAddress materialApplyAddress = address = applyDto.getHasSubItem() != false ? firstItem.getAddress() : applyDto.getAddress();
            if (address != null) {
                orderReqDto.setConsignee(address.getConsignee());
                orderReqDto.setPhone(address.getPhone());
                orderReqDto.setProvinceName(address.getProvinceName());
                if (StringUtils.isBlank((CharSequence)address.getProvinceCode())) {
                    orderReqDto.setProvinceCode(this.getAddressCode(addressCacheMap, address.getProvinceName(), null, addressErrorMsg));
                }
                orderReqDto.setCityName(address.getCityName());
                if (StringUtils.isBlank((CharSequence)address.getCityCode())) {
                    orderReqDto.setCityCode(this.getAddressCode(addressCacheMap, address.getCityName(), orderReqDto.getProvinceCode(), addressErrorMsg));
                }
                orderReqDto.setAreaName(address.getAreaName());
                if (StringUtils.isBlank((CharSequence)address.getAreaCode()) && StringUtils.isNotBlank((CharSequence)address.getAreaName())) {
                    orderReqDto.setAreaCode(this.getAddressCode(addressCacheMap, address.getAreaName(), orderReqDto.getCityCode(), addressErrorMsg));
                }
                orderReqDto.setAddress(address.getDetailAddress());
            }
            HashMap<String, CsOtherStorageOrderDetailReqDto> mergedDetailsMap = new HashMap<String, CsOtherStorageOrderDetailReqDto>();
            HashMap<String, String> extensionMap = null;
            for (MaterialApplyItem applyItem : splitItemList) {
                String skuBatchKey = applyItem.getSkuCode() + "_" + applyItem.getBatch();
                if (mergedDetailsMap.containsKey(skuBatchKey)) {
                    CsOtherStorageOrderDetailReqDto existing2 = (CsOtherStorageOrderDetailReqDto)mergedDetailsMap.get(skuBatchKey);
                    existing2.setQuantity(existing2.getQuantity().add(BigDecimal.valueOf(applyItem.getQuantity().intValue())));
                    continue;
                }
                PcpItemRespDto pcpItem = (PcpItemRespDto)skuMap.get(applyItem.getSkuCode());
                if (pcpItem == null) {
                    errorSku.add(applyItem.getSkuCode());
                    continue;
                }
                CsOtherStorageOrderDetailReqDto detail = new CsOtherStorageOrderDetailReqDto();
                detail.setBatch(applyItem.getBatch());
                detail.setQuantity(BigDecimal.valueOf(applyItem.getQuantity().intValue()));
                detail.setCargoId(pcpItem.getId());
                detail.setCargoCode(pcpItem.getLongCode());
                detail.setLongCode(pcpItem.getLongCode());
                detail.setArtNo(pcpItem.getArtNo());
                detail.setCargoName(pcpItem.getName());
                detail.setSpecification(pcpItem.getSpecification());
                detail.setVolume(pcpItem.getVolume() != null ? pcpItem.getVolume() : BigDecimal.ZERO);
                detail.setWeight(pcpItem.getGrossWeight() != null ? pcpItem.getGrossWeight() : BigDecimal.ZERO);
                if (ObjectUtil.isNotEmpty((Object)applyItem.getOuterOrderNo())) {
                    extensionMap = new HashMap<String, String>();
                    extensionMap.put("outerOrderNo", applyItem.getOuterOrderNo());
                    detail.setExtension(JSON.toJSONString(extensionMap));
                }
                mergedDetailsMap.put(skuBatchKey, detail);
            }
            ArrayList detailList = new ArrayList(mergedDetailsMap.values());
            comboReqDto.setCsOtherStorageOrderReqDto(orderReqDto);
            comboReqDto.setDetailList(detailList);
            otherStorageOrderList.add(comboReqDto);
        }
        if (!errorSku.isEmpty()) {
            errorMsg.add("\u4ee5\u4e0b\u7269\u6599\u7f16\u53f7\u6709\u8bef:" + errorSku.stream().distinct().collect(Collectors.joining()) + "\n");
        }
        if (addressErrorMsg.length() > 0) {
            errorMsg.add("\u4ee5\u4e0b\u5730\u5740\u586b\u5199\u6709\u8bef:" + addressErrorMsg + "\n");
        }
        AssertUtil.isTrue(ObjectUtil.isEmpty(errorMsg), ((Object)errorMsg).toString());
        return otherStorageOrderList;
    }

    private String getAddressCode(Map<String, String> addressCacheMap, String name, String parentCode, StringBuffer errorMsg) {
        String code = null;
        String cacheKey = parentCode + "_" + name;
        if (addressCacheMap.containsKey(cacheKey)) {
            code = addressCacheMap.get(cacheKey);
        } else {
            PcpRegionReqDto reqDto = new PcpRegionReqDto();
            reqDto.setName(name);
            reqDto.setParentCode(parentCode);
            reqDto.setPageNum(Integer.valueOf(1));
            reqDto.setPageSize(Integer.valueOf(1));
            List list = ((PageInfo)this.pcpRegionQueryApi.queryByPage(reqDto).getData()).getList();
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                code = ((PcpRegionRespDto)list.get(0)).getCode();
            }
            addressCacheMap.put(cacheKey, code);
        }
        if (code == null && errorMsg != null) {
            errorMsg.append(name).append("\u3001");
        }
        return code;
    }

    private void buildMergeOrder(List<CsOtherStorageOrderComboReqDto> comboOrderList) {
        List orderList = comboOrderList.stream().map(it -> it.getCsOtherStorageOrderReqDto()).collect(Collectors.toList());
        log.info("\u5176\u4ed6\u51fa\u5e93\u5355\u751f\u6210\u5408\u5e76\u5355\u53f7\uff1a{}", (Object)JSON.toJSONString(comboOrderList));
        List logicWarehouseCodes = orderList.stream().map(CsOtherStorageOrderReqDto::getWarehouseCode).distinct().collect(Collectors.toList());
        DgLogicWarehousePageReqDto logicWarehousePageReqDto = new DgLogicWarehousePageReqDto();
        logicWarehousePageReqDto.setWarehouseCodes(logicWarehouseCodes);
        List dgLogicWarehouseDtoList = (List)RestResponseHelper.extractData((RestResponse)this.dgLogicWarehouseApi.queryList(logicWarehousePageReqDto));
        AssertUtil.isFalse(CollectionUtils.isEmpty((Collection)dgLogicWarehouseDtoList), "\u627e\u4e0d\u5230\u4ed3\u5e93\u4fe1\u606f\uff1a" + logicWarehouseCodes);
        Map warehouseRespMap = dgLogicWarehouseDtoList.stream().collect(Collectors.toMap(DgLogicWarehouseDto::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
        log.info("\u4ed3\u5e93\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)dgLogicWarehouseDtoList));
        LinkedHashMap<String, Integer> mergeOrderMap = new LinkedHashMap<String, Integer>();
        HashMap<String, Integer> mergeOrderCountMap = new HashMap<String, Integer>();
        for (CsOtherStorageOrderReqDto order : orderList) {
            DgLogicWarehouseDto warehouseRespDto = (DgLogicWarehouseDto)warehouseRespMap.get(order.getWarehouseCode());
            AssertUtil.isFalse(ObjectUtil.isEmpty((Object)warehouseRespDto), "\u627e\u4e0d\u5230\u4ed3\u5e93\u4fe1\u606f\uff1a" + order.getWarehouseCode());
            String key = String.format("%s-%s", warehouseRespDto.getPhysicsWarehouseCode(), warehouseRespDto.getCostOrg());
            mergeOrderCountMap.merge(key, 1, Integer::sum);
        }
        int mergeOrderIndexCounter = 1;
        for (CsOtherStorageOrderReqDto order : orderList) {
            DgLogicWarehouseDto warehouseRespDto = (DgLogicWarehouseDto)warehouseRespMap.get(order.getWarehouseCode());
            String key = String.format("%s-%s", warehouseRespDto.getPhysicsWarehouseCode(), warehouseRespDto.getCostOrg());
            if (!mergeOrderMap.containsKey(key)) {
                mergeOrderMap.put(key, mergeOrderIndexCounter++);
            }
            int mergeOrderIndex = (Integer)mergeOrderMap.get(key);
            int totalNum = (Integer)mergeOrderCountMap.get(key);
            String mergeOrderNo = String.format("%s-%d", order.getPreOrderNo(), mergeOrderIndex);
            order.setMergeOrderNo(mergeOrderNo);
            HashMap<String, Integer> extensionMap = new HashMap<String, Integer>();
            extensionMap.put("masterOrderSpiltNum", totalNum);
            order.setExtension(JSON.toJSONString(extensionMap));
        }
    }

    private void batchAddCsOtherStorageOrder(List<CsOtherStorageOrderComboReqDto> comboOrderList) {
        try {
            RestResponseHelper.extractData((RestResponse)this.csOtherStorageOrderApi.batchAddCsOtherStorageOrder(comboOrderList));
        }
        catch (Exception e) {
            throw new BizException("-1", "\u521b\u5efa\u8ba2\u5355\u5931\u8d25\uff0c\u4ee5\u4e0b\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage());
        }
    }

    private void otherOutMergeToWms(List<CsOtherStorageOrderRespDto> orderList) {
        log.info("\u65b0\u589e\u3001\u7f16\u8f91\u3001\u5ba1\u6838\u89e6\u53d1\u63a8\u9001\u5408\u5355\uff1a{}", (Object)JSON.toJSONString(orderList));
        List<String> mergeOrderList = orderList.stream().map(CsOtherStorageOrderRespDto::getMergeOrderNo).distinct().collect(Collectors.toList());
        mergeOrderList.forEach(mergeOrder -> this.commonsMqService.sendSingleMessage("OTHER_OUT_ORDER_MERGE_TO_WMS", mergeOrder));
    }

    private String degreeKey(MaterialApplySummaryDto v) {
        return this.degreeKey(v.getWarehouseCode(), Optional.ofNullable(v.getBatch()).orElse(""), v.getSkuCode());
    }

    private String degreeKey(LogicInventoryRespDto v) {
        return this.degreeKey(v.getWarehouseCode(), Optional.ofNullable(v.getBatch()).orElse(""), v.getItemLongCode());
    }

    public String degreeKey(String wareCode, String batch, String longCode) {
        return wareCode + "_" + Optional.ofNullable(batch).filter(StringUtils::isNotBlank).orElse("") + "_" + longCode;
    }

    static class MatchKey {
        private String reservationNo;
        private String skuCode;

        public MatchKey(MaterialApplyItem item) {
            this.reservationNo = item.getReservationNo();
            this.skuCode = item.getSkuCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MatchKey)) {
                return false;
            }
            MatchKey key = (MatchKey)o;
            return Objects.equals(this.reservationNo, key.reservationNo) && Objects.equals(this.skuCode, key.skuCode);
        }

        public int hashCode() {
            return Objects.hash(this.reservationNo, this.skuCode);
        }
    }
}

