/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.auth.interceptor;

import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.tcbj.app.open.biz.auth.ResultBo;
import com.dtyunxi.tcbj.app.open.biz.auth.check.ICheckExecutor;
import com.dtyunxi.tcbj.app.open.biz.auth.config.ThirdAuthProperties;
import com.dtyunxi.tcbj.app.open.biz.auth.match.IMatch;
import com.dtyunxi.tcbj.app.open.biz.auth.match.MatchBo;
import java.io.IOException;
import java.io.PrintWriter;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.HandlerInterceptor;

public class ThirdAuthInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ThirdAuthInterceptor.class);
    @Resource
    private IMatch match;
    @Autowired
    private ICheckExecutor checkExecutor;
    @Resource
    private ThirdAuthProperties thirdAuthProperties;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        return this.match(request, response);
    }

    private boolean match(HttpServletRequest request, HttpServletResponse response) {
        String path = request.getRequestURI().replace(request.getContextPath(), "");
        if (this.system(request) && this.match.match(new MatchBo(path)).isSuccess()) {
            ResultBo executor = this.checkExecutor.executor(request);
            if (executor.isSuccess()) {
                return true;
            }
            try (PrintWriter writer = response.getWriter();){
                writer.write(executor.getErrorMsg());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return false;
        }
        return true;
    }

    private boolean system(HttpServletRequest request) {
        if (this.thirdAuthProperties.isGlobalCheck()) {
            if (StringUtils.isBlank((CharSequence)request.getHeader("Application-Key"))) {
                throw new BizException("-1", "Application-Key \u4e0d\u80fd\u4e3a\u7a7a");
            }
            return !CollectionUtil.isNotEmpty(this.thirdAuthProperties.getIgnoreCheckList()) || !this.thirdAuthProperties.getIgnoreCheckList().contains(request.getHeader("Application-Key"));
        }
        return false;
    }
}

