/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.openapi.qimen.weizhi.client;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.tcbj.openapi.qimen.weizhi.client.IQimenWmsClient;
import com.dtyunxi.tcbj.openapi.qimen.weizhi.common.QimenPropertiesConfig;
import com.dtyunxi.tcbj.openapi.qimen.weizhi.exceptions.BizException;
import com.dtyunxi.tcbj.openapi.qimen.weizhi.exceptions.ConnectorExceptionCode;
import com.dtyunxi.tcbj.openapi.qimen.weizhi.util.HttpUtil;
import com.dtyunxi.tcbj.openapi.qimen.weizhi.util.SignUtil;
import com.dtyunxi.tcbj.openapi.qimen.weizhi.util.SymmetricEncoder;
import com.dtyunxi.util.DateUtil;
import com.qimen.api.DefaultQimenClient;
import com.qimen.api.QimenClient;
import com.qimen.api.QimenRequest;
import com.qimen.api.QimenResponse;
import com.taobao.api.internal.util.XmlWriter;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;

public class CommonQimenClient
implements IQimenWmsClient {
    private final Logger logger = LoggerFactory.getLogger(CommonQimenClient.class);
    private final QimenPropertiesConfig qimenProperties;
    private String signMethod = "md5";
    private static final Map<String, QimenClient> CUSTOMER_CLIENT = new ConcurrentHashMap<String, QimenClient>(4);

    public CommonQimenClient(QimenPropertiesConfig qimenProperties) {
        this.qimenProperties = qimenProperties;
    }

    @Override
    public String invoke(String reqBody, String method, String appKey, String targetAppKey, String appSecret, String signMethod, String partnerId, String format, String version, String url) throws Exception {
        TreeMap<String, String> param = new TreeMap<String, String>();
        reqBody = SymmetricEncoder.XORencode(reqBody, targetAppKey);
        param.put("reqBody", reqBody);
        param.put("app_key", appKey);
        param.put("target_app_key", targetAppKey);
        param.put("method", method);
        param.put("timestamp", DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        param.put("partner_id", partnerId);
        param.put("format", format);
        param.put("v", version);
        param.put("sign_method", signMethod);
        param.put("sign", SignUtil.signTopRequest(SignUtil.sortByKey(param), appSecret, signMethod));
        this.logger.info("\u5947\u95e8\u8bf7\u6c42\uff1areqParam -> {}", param);
        String response = HttpUtil.postForm(url, param);
        this.logger.info("\u5947\u95e8\u54cd\u5e94\uff1aresponse -> {}", (Object)response);
        JSONObject qiMenBody = JSONObject.parseObject((String)response);
        JSONObject qiMenResponseBody = qiMenBody.getJSONObject("response");
        if ("failure".equals(qiMenResponseBody.getString("flag"))) {
            throw new BizException(ConnectorExceptionCode.QIMEN_REQUEST_ERROR_FOUND.getCode(), ConnectorExceptionCode.QIMEN_REQUEST_ERROR_FOUND.getMsg() + ":" + qiMenResponseBody.getString("code") + "->" + qiMenResponseBody.getString("message") + "->" + qiMenResponseBody.getString("sub_code"));
        }
        String respBody = qiMenResponseBody.getString("respBody");
        respBody = SymmetricEncoder.XORdecode(respBody, targetAppKey);
        this.logger.info("\u5f00\u653e\u5e73\u53f0\u54cd\u5e94\uff1arespBody -> {}", (Object)respBody);
        return respBody;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public QimenResponse invoke(QimenRequest qimenRequest, Boolean decode) throws Exception {
        XmlWriter tRsp = new XmlWriter(true, "request", QimenRequest.class);
        this.logger.info("\u8bf7\u6c42XML:{}", (Object)tRsp.write((Object)qimenRequest));
        QimenPropertiesConfig.Properties properties = this.qimenProperties.findByCustomer(qimenRequest.getCustomerId());
        if (!properties.getWmsRequest().booleanValue()) {
            throw new BizException("0000", "wms\u5165\u53e3\u5df2\u5173\u95ed");
        }
        QimenClient qimenClient = CUSTOMER_CLIENT.get(qimenRequest.getCustomerId());
        Class<CommonQimenClient> clazz = CommonQimenClient.class;
        // MONITORENTER : com.dtyunxi.tcbj.openapi.qimen.weizhi.client.CommonQimenClient.class
        if (qimenClient == null) {
            Class<CommonQimenClient> clazz2 = CommonQimenClient.class;
            // MONITORENTER : com.dtyunxi.tcbj.openapi.qimen.weizhi.client.CommonQimenClient.class
            qimenClient = new DefaultQimenClient(properties.getQimenServerUrl(), properties.getQimenAppKey(), properties.getQimenAppSecret());
            ((DefaultQimenClient)qimenClient).setConnectTimeout(300000);
            ((DefaultQimenClient)qimenClient).setReadTimeout(300000);
            CUSTOMER_CLIENT.put(qimenRequest.getCustomerId(), qimenClient);
            // MONITOREXIT : clazz2
        }
        // MONITOREXIT : clazz
        QimenResponse rsp = qimenClient.execute(qimenRequest);
        this.logger.info("\u54cd\u5e94XML01:{}", (Object)JSONObject.toJSONString((Object)rsp));
        this.logger.info("\u54cd\u5e94XML02:{}", (Object)tRsp.write((Object)rsp));
        if ("failure".equals(rsp.getFlag())) {
            throw new BizException(ConnectorExceptionCode.QIMEN_REQUEST_ERROR_FOUND.getCode(), ConnectorExceptionCode.QIMEN_REQUEST_ERROR_FOUND.getMsg() + ":" + rsp.getCode() + "->" + rsp.getMessage());
        }
        if (decode == false) return rsp;
        String respBody = rsp.getBody();
        respBody = SymmetricEncoder.XORdecode(respBody, properties.getQimenTargetAppKey());
        this.logger.info("\u5f00\u653e\u5e73\u53f0\u54cd\u5e94\uff1arespBody -> {}", (Object)respBody);
        return (QimenResponse)JSONObject.parseObject((String)respBody, QimenResponse.class);
    }

    @Override
    public QimenResponse invoke(QimenRequest qimenRequest) throws Exception {
        return this.invoke(qimenRequest, false);
    }
}

