/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.openapi.qimen.weizhi.common;

import com.dtyunxi.tcbj.openapi.qimen.weizhi.common.QimenPropertiesConfig;
import com.dtyunxi.tcbj.openapi.qimen.weizhi.services.IProcessorWms;
import com.google.common.collect.Maps;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class QimenWmsSelector
implements ApplicationContextAware {
    private Map<String, IProcessorWms> processorMap;
    private QimenPropertiesConfig qimenPropertiesConfig;

    public IProcessorWms selectProcessorWms(String customerId) {
        return this.processorMap.get(customerId);
    }

    public QimenPropertiesConfig.Properties selectPropert(String customerId) {
        return this.qimenPropertiesConfig.findByCustomer(customerId);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.processorMap = Maps.newHashMap();
        this.qimenPropertiesConfig = (QimenPropertiesConfig)applicationContext.getBean(QimenPropertiesConfig.class);
        Map processorWmsMap = applicationContext.getBeansOfType(IProcessorWms.class);
        for (QimenPropertiesConfig.Properties property : this.qimenPropertiesConfig.getProperties()) {
            for (IProcessorWms processorWms : processorWmsMap.values()) {
                if (!property.getPcpChannelCode().equals(processorWms.getChannelCode())) continue;
                this.processorMap.put(property.getQimenCustomerId(), processorWms);
            }
        }
    }
}

