/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.openapi.qimen.weizhi.common;

import com.dtyunxi.tcbj.openapi.qimen.weizhi.common.QimenPropertiesConfig;
import com.dtyunxi.tcbj.openapi.qimen.weizhi.services.IProcessorWms;
import com.google.common.collect.Maps;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class QimenWmsSelector
implements ApplicationContextAware {
    private Map<String, IProcessorWms> processorMap;
    private QimenPropertiesConfig qimenPropertiesConfig;

    public IProcessorWms selectProcessorWms(String customerId) {
        System.out.println("=== selectProcessorWms \u8c03\u7528 ===");
        System.out.println("\u8bf7\u6c42\u7684customerId: [" + customerId + "]");
        System.out.println("\u5f53\u524d\u6620\u5c04\u8868\u5927\u5c0f: " + (this.processorMap != null ? Integer.valueOf(this.processorMap.size()) : "null"));
        if (this.processorMap != null) {
            System.out.println("\u5f53\u524d\u6620\u5c04\u8868\u5185\u5bb9:");
            this.processorMap.forEach((k, v) -> System.out.println("  " + k + " -> " + v.getClass().getSimpleName()));
        }
        IProcessorWms result = this.processorMap.get(customerId);
        System.out.println("\u67e5\u627e\u7ed3\u679c: " + (result != null ? result.getClass().getSimpleName() : "null"));
        System.out.println("=== selectProcessorWms \u7ed3\u675f ===");
        return result;
    }

    public QimenPropertiesConfig.Properties selectPropert(String customerId) {
        return this.qimenPropertiesConfig.findByCustomer(customerId);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.processorMap = Maps.newHashMap();
        this.qimenPropertiesConfig = (QimenPropertiesConfig)applicationContext.getBean(QimenPropertiesConfig.class);
        Map processorWmsMap = applicationContext.getBeansOfType(IProcessorWms.class);
        System.out.println("=== QimenWmsSelector \u521d\u59cb\u5316\u5f00\u59cb ===");
        System.out.println("\u914d\u7f6e\u6570\u91cf: " + this.qimenPropertiesConfig.getProperties().size());
        System.out.println("\u5904\u7406\u5668\u6570\u91cf: " + processorWmsMap.size());
        for (QimenPropertiesConfig.Properties property : this.qimenPropertiesConfig.getProperties()) {
            System.out.println("\u914d\u7f6e\u9879 - customerId: " + property.getQimenCustomerId() + ", pcpChannelCode: [" + property.getPcpChannelCode() + "]");
            for (IProcessorWms processorWms : processorWmsMap.values()) {
                String processorChannelCode = processorWms.getChannelCode();
                System.out.println("  \u5904\u7406\u5668 - channelCode: [" + processorChannelCode + "]");
                System.out.println("  \u5339\u914d\u7ed3\u679c: " + property.getPcpChannelCode().equals(processorChannelCode));
                if (!property.getPcpChannelCode().equals(processorWms.getChannelCode())) continue;
                this.processorMap.put(property.getQimenCustomerId(), processorWms);
                System.out.println("  \u5df2\u6dfb\u52a0\u6620\u5c04: " + property.getQimenCustomerId() + " -> " + processorWms.getClass().getSimpleName());
            }
        }
        System.out.println("\u6700\u7ec8\u6620\u5c04\u5173\u7cfb:");
        this.processorMap.forEach((k, v) -> System.out.println("  " + k + " -> " + v.getClass().getSimpleName()));
        System.out.println("=== QimenWmsSelector \u521d\u59cb\u5316\u5b8c\u6210 ===");
    }
}

