/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.portal.svr.service.impl.integration;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.tcbj.portal.svr.dto.request.LoginRequestDto;
import com.dtyunxi.tcbj.portal.svr.service.impl.identity.TokenVerificationPortalServiceImpl;
import com.dtyunxi.tcbj.portal.svr.service.integration.MarketingLoginService;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.SsoRespDto;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class MarketingLoginServiceImpl
implements MarketingLoginService {
    @Resource
    private RestTemplate restTemplate;
    @Resource
    private TokenVerificationPortalServiceImpl tokenVerificationPortalService;
    @Value(value="${marketing.login.url}")
    private String loginUrl;

    @Override
    public String login(LoginRequestDto loginRequestDto) {
        String credential = loginRequestDto.getCredential();
        String identifier = loginRequestDto.getIdentifier();
        if (StringUtils.isBlank((CharSequence)credential) || StringUtils.isBlank((CharSequence)identifier)) {
            throw new BizException("\u7528\u6237\u540d\u6216\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String s = (String)this.restTemplate.postForObject(this.loginUrl, (Object)loginRequestDto, String.class, new Object[0]);
        JSONObject jsonObject = JSON.parseObject((String)s);
        String msg = (String)jsonObject.get((Object)"msg");
        if (!"\u8bf7\u6c42\u6210\u529f".equals(msg)) {
            throw new BizException("\u767b\u9646\u8425\u9500\u4e91\u5931\u8d25");
        }
        SsoRespDto login = this.tokenVerificationPortalService.login(identifier);
        if (login == null) {
            throw new BizException("\u767b\u5165\u4e1a\u52a1\u4e2d\u53f0\u5931\u8d25");
        }
        String token = login.getToken();
        return token;
    }
}

