/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.portal.svr.service.impl.integration;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.tcbj.portal.svr.dto.request.TokenRequestDto;
import com.dtyunxi.tcbj.portal.svr.dto.response.CMsg;
import com.dtyunxi.tcbj.portal.svr.dto.response.MarketingTokenResponseDto;
import com.dtyunxi.tcbj.portal.svr.dto.response.TokenVerificationResponseDto;
import com.dtyunxi.tcbj.portal.svr.service.integration.MarketingTokenVerificationService;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class MarketingTokenVerificationServiceImpl
implements MarketingTokenVerificationService {
    private static final Logger logger = LoggerFactory.getLogger(MarketingTokenVerificationServiceImpl.class);
    @Value(value="${marketing.token.url}")
    private String tokenUrl;
    @Resource
    private RestTemplate restTemplate;

    @Override
    public TokenVerificationResponseDto tokenVerification(String token) {
        if (StringUtils.isBlank((CharSequence)token)) {
            throw new BizException("\u4f20\u5165\u7684token\u4e0d\u80fd\u4e3a\u7a7a");
        }
        TokenRequestDto tokenRequestDto = new TokenRequestDto();
        tokenRequestDto.setToken(token);
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        String param = JSONObject.toJSONString((Object)tokenRequestDto);
        HttpEntity formEntity = new HttpEntity((Object)param, (MultiValueMap)headers);
        String s = (String)this.restTemplate.postForObject(this.tokenUrl, (Object)formEntity, String.class, new Object[0]);
        MarketingTokenResponseDto marketingTokenResponseDto = (MarketingTokenResponseDto)JSON.parseObject((String)s, MarketingTokenResponseDto.class);
        logger.info("\u6253\u5370\u8425\u9500\u4e91\u8fd4\u56de\u7684\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)marketingTokenResponseDto));
        String code = marketingTokenResponseDto.getCode();
        if (!"0".equals(code)) {
            throw new BizException("\u89e3\u6790token\u8bf7\u6c42\u5931\u8d25");
        }
        CMsg data = marketingTokenResponseDto.getData();
        if (data == null) {
            throw new BizException("token\u4e0d\u5408\u6cd5");
        }
        TokenVerificationResponseDto tokenVerificationResponseDto = data.getMsg();
        return tokenVerificationResponseDto;
    }
}

