/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.service.gateway.swiftpass.impl.query;

import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.yundt.cube.center.payment.service.exception.PartnerException;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.BaseGatewayResult;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.CheckResult;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.swiftpass.AbstractSpQueryGatewayService;
import com.dtyunxi.yundt.cube.center.payment.service.partner.swiftpass.domain.BaseSpResponse;
import com.dtyunxi.yundt.cube.center.payment.service.partner.swiftpass.domain.request.SpQueryRequest;
import com.dtyunxi.yundt.cube.center.payment.service.partner.swiftpass.domain.response.SpQueryResponse;
import com.dtyunxi.yundt.cube.center.payment.service.trade.helper.OrderAssistant;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PartnerConfigEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PayOrderEo;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="spPayOrderQueryGatewayService")
@Transactional(transactionManager="paymentCenterDataSourceTransactionManager", rollbackFor={Exception.class})
public class SpPayOrderQueryGatewayServiceImpl
extends AbstractSpQueryGatewayService<SpQueryResponse> {
    public BaseGatewayResult rechargeResult(String tradeId, SpQueryResponse response) throws Exception {
        CheckResult result = new CheckResult(1, tradeId);
        PayOrderEo partnerOrder = OrderAssistant.createPayOrder((String)tradeId);
        if (BaseSpResponse.isTradeSuccess(response.getTradeState())) {
            partnerOrder.setPartnerOrderId(response.getTransactionId());
            partnerOrder.setAmount(new BigDecimal(response.getTotalFee()).movePointLeft(2));
            if (StringUtils.isNotBlank((CharSequence)response.getTimeEnd())) {
                partnerOrder.setFinishTime(DateUtil.parseDate((String)response.getTimeEnd(), (String)"yyyyMMddHHmmss"));
            } else {
                partnerOrder.setFinishTime(new Date());
            }
            this.payOrderProcessorService.handleSuccOrder((Object)partnerOrder);
        } else if (BaseSpResponse.isTradeFail(response.getTradeState())) {
            partnerOrder.setErrorCode(response.getErrCode());
            partnerOrder.setErrorMsg(response.getErrMsg());
            this.payOrderProcessorService.handleFailOrder((Object)partnerOrder);
        } else if (BaseSpResponse.isTradeProcess(response.getTradeState())) {
            boolean expired;
            PayOrderEo oldPayOrder = (PayOrderEo)this.payOrderDas.selectByLogicKey((Object)tradeId);
            boolean bl = expired = 0 > new DateTime((Object)oldPayOrder.getOrderTime()).plusMinutes(oldPayOrder.getExpireTime() + 30).compareTo((ReadableInstant)new DateTime());
            if (expired) {
                this.logger.info("{}\u6e20\u9053\u5df2\u8fc7\u8d85\u65f6\u65f6\u95f4\u5e76\u518d\u8d8530\u5206\u949f\uff0c\u6807\u8bb0\u4e3a\u5931\u8d25", (Object)tradeId);
                partnerOrder.setErrorCode(response.getErrCode());
                partnerOrder.setErrorMsg("\u8d85\u65f6\u672a\u652f\u4ed8");
                this.payOrderProcessorService.handleFailOrder((Object)partnerOrder);
            }
            this.logger.info("{}\u6e20\u9053\u8ba2\u5355\u672a\u652f\u4ed8\uff0c \u4e0d\u4fee\u6539\u8ba2\u5355\u72b6\u6001", (Object)tradeId);
        } else {
            this.logger.info("{}\u6e20\u9053\u8ba2\u5355\u6b63\u5728\u5904\u7406\u4e2d\uff0c \u4e0d\u4fee\u6539\u8ba2\u5355\u72b6\u6001", (Object)tradeId);
        }
        return result;
    }

    public SpQueryResponse _execute(String tradeId) throws Exception {
        PayOrderEo payOrder = (PayOrderEo)this.payOrderDas.selectByLogicKey((Object)tradeId);
        PartnerConfigEo config = (PartnerConfigEo)this.payPartnerConfigDas.selectByLogicKey((Object)payOrder.getPartnerConfigCode());
        SpQueryRequest request = new SpQueryRequest();
        request.setService("unified.trade.query");
        request.setOutTradeNo(OrderAssistant.getOutTradeNo((PayOrderEo)payOrder));
        request.setTransactionId(payOrder.getPartnerOrderId());
        request.setMchId(config.getPtMerId());
        request.setEncryptKey(config.getLcPrivKey());
        request.setDecryptKey(config.getPtPubKey());
        return (SpQueryResponse)((Object)this.spPartnerService.queryOrder((Object)request));
    }

    public void validate(String tradeId, SpQueryResponse response) throws Exception {
        if (!"0".equals(response.getStatus()) || !"0".equals(response.getResultCode())) {
            throw new PartnerException("\u6e20\u9053\u67e5\u8be2\u5931\u8d25");
        }
    }
}

