/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.service.gateway.swiftpass.impl.query;

import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.yundt.cube.center.payment.service.exception.PartnerException;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.BaseGatewayResult;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.CheckResult;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.swiftpass.AbstractSpQueryGatewayService;
import com.dtyunxi.yundt.cube.center.payment.service.partner.swiftpass.domain.BaseSpResponse;
import com.dtyunxi.yundt.cube.center.payment.service.partner.swiftpass.domain.request.SpRefundQueryRequest;
import com.dtyunxi.yundt.cube.center.payment.service.partner.swiftpass.domain.response.SpRefundQueryResponse;
import com.dtyunxi.yundt.cube.center.payment.service.trade.helper.OrderAssistant;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PartnerConfigEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.RefundOrderEo;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="spRefundOrderQueryGatewayService")
@Transactional(transactionManager="paymentCenterDataSourceTransactionManager", rollbackFor={Exception.class})
public class SpRefundOrderQueryGatewayServiceImpl
extends AbstractSpQueryGatewayService<SpRefundQueryResponse> {
    public BaseGatewayResult rechargeResult(String refundId, SpRefundQueryResponse response) throws Exception {
        CheckResult result = new CheckResult(1, refundId);
        RefundOrderEo partnerOrder = OrderAssistant.createRefundOrder((String)refundId, (String)response.getTransactionId(), (Date)new Date());
        if (CollectionUtils.isEmpty(response.getRefundDatas())) {
            this.payRefundOrderProcessorService.handleFailOrder((Object)partnerOrder);
            return result;
        }
        for (SpRefundQueryResponse.RefundData refundData : response.getRefundDatas()) {
            if (refundId.equals(refundData.getOutRefundNo()) && BaseSpResponse.isRefundSuccess(refundData.getRefundStatus())) {
                partnerOrder.setAmount(new BigDecimal(refundData.getRefundFee()).movePointLeft(2));
                if (StringUtils.isNotBlank((CharSequence)refundData.getRefundTime())) {
                    partnerOrder.setFinishTime(DateUtil.parseDate((String)refundData.getRefundTime(), (String)"yyyyMMddHHmmss"));
                } else {
                    partnerOrder.setFinishTime(new Date());
                }
                this.payRefundOrderProcessorService.handleSuccOrder((Object)partnerOrder);
                continue;
            }
            if (refundId.equals(refundData.getOutRefundNo()) && BaseSpResponse.isRefundFail(refundData.getRefundStatus())) {
                partnerOrder.setErrorMsg(response.getErrMsg());
                partnerOrder.setErrorCode(response.getErrCode());
                this.payRefundOrderProcessorService.handleFailOrder((Object)partnerOrder);
                continue;
            }
            this.logger.info("{}\u8ba2\u5355\u4e0e\u672c\u6b21\u67e5\u8be2\u4e0d\u5339\u914d\u6216\u8005\u627e\u4e0d\u5230\u8be5\u8ba2\u5355\uff0c \u4e0d\u5904\u7406\u672c\u5730\u8ba2\u5355", (Object)refundId);
        }
        return result;
    }

    public SpRefundQueryResponse _execute(String refundId) throws Exception {
        RefundOrderEo refundOrder = (RefundOrderEo)this.payRefundOrderDas.selectByLogicKey((Object)refundId);
        PartnerConfigEo config = (PartnerConfigEo)this.payPartnerConfigDas.selectByLogicKey((Object)refundOrder.getPartnerConfigCode());
        SpRefundQueryRequest request = new SpRefundQueryRequest();
        request.setService("unified.trade.refundquery");
        request.setOutRefundNo(refundId);
        request.setMchId(config.getPtMerId());
        request.setEncryptKey(config.getLcPrivKey());
        request.setDecryptKey(config.getPtPubKey());
        return this.spPartnerService.queryRefundOrder(request);
    }

    public void validate(String refundId, SpRefundQueryResponse response) throws Exception {
        if (!"0".equals(response.getStatus()) || !"0".equals(response.getResultCode())) {
            throw new PartnerException("\u6e20\u9053\u67e5\u8be2\u5931\u8d25");
        }
    }
}

