/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.service.gateway.swiftpass.impl.trade;

import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.AttachData;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.BaseGatewayResult;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.GatewayResult;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.swiftpass.AbstractSpGatewayService;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.swiftpass.SpGatewayServiceConstants;
import com.dtyunxi.yundt.cube.center.payment.service.partner.swiftpass.domain.request.SpPlaceRequest;
import com.dtyunxi.yundt.cube.center.payment.service.partner.swiftpass.domain.response.SpPlaceResponse;
import com.dtyunxi.yundt.cube.center.payment.service.trade.helper.NotifyAssistant;
import com.dtyunxi.yundt.cube.center.payment.service.trade.helper.OrderAssistant;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PartnerConfigEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PayOrderAttachInfoEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PayOrderEo;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="spPayOrderCreateGatewayService")
@Transactional(transactionManager="paymentCenterDataSourceTransactionManager", rollbackFor={Exception.class})
public class SpPayOrderCreateGatewayServiceImpl
extends AbstractSpGatewayService<PayOrderEo, SpPlaceResponse> {
    public BaseGatewayResult rechargeResult(PayOrderEo payOrder, SpPlaceResponse response) throws Exception {
        GatewayResult result = this.parseResponse(response, payOrder.getTradeId());
        PayOrderEo partnerOrder = OrderAssistant.createPayOrder((String)payOrder.getTradeId());
        if ("0".equals(response.getResultCode()) && "0".equals(response.getStatus())) {
            String var6;
            this.payOrderProcessorService.handleAcceptOrder((Object)partnerOrder);
            AttachData data = new AttachData();
            switch (var6 = SpGatewayServiceConstants.payTypeMapper.get(payOrder.getPayType())) {
                case "pay.alipay.jspay": {
                    data.put((Object)"target", (Object)response.getRequestUrl());
                    data.put((Object)"orderInfo", (Object)response.getPayInfo());
                    data.put((Object)"payUrl", (Object)response.getPayUrl());
                    break;
                }
                case "pay.alipay.native": {
                    data.put((Object)"codeUrl", (Object)response.getCodeUrl());
                    data.put((Object)"codeImgUrl", (Object)response.getCodeImgUrl());
                    break;
                }
                case "pay.weixin.native": {
                    data.put((Object)"codeUrl", (Object)response.getCodeUrl());
                    data.put((Object)"codeImgUrl", (Object)response.getCodeImgUrl());
                    break;
                }
                case "pay.weixin.jspay": {
                    data.put((Object)"weixinStr", (Object)response.getPayInfo());
                    break;
                }
                case "pay.weixin.raw.app": {
                    data.put((Object)"weixinStr", (Object)response.getPayInfo());
                    break;
                }
                case "unified.trade.native": {
                    data.put((Object)"codeUrl", (Object)response.getCodeUrl());
                    data.put((Object)"codeImgUrl", (Object)response.getCodeImgUrl());
                }
            }
            result.setData((Map)data);
        } else {
            if (!"0".equals(response.getStatus())) {
                partnerOrder.setErrorCode(response.getStatus());
                partnerOrder.setErrorMsg(response.getMessage());
            } else {
                partnerOrder.setErrorCode(response.getErrCode());
                partnerOrder.setErrorMsg(response.getErrMsg());
            }
            this.payOrderProcessorService.handleFailOrder((Object)partnerOrder);
        }
        return result;
    }

    public SpPlaceResponse _execute(PayOrderEo payOrder) throws Exception {
        PartnerConfigEo configEo = (PartnerConfigEo)this.payPartnerConfigDas.selectByLogicKey((Object)payOrder.getPartnerConfigCode());
        PayOrderAttachInfoEo attachInfoEo = (PayOrderAttachInfoEo)this.payOrderAttachInfoDas.selectByLogicKey((Object)payOrder.getTradeId());
        String notifyUrl = NotifyAssistant.getNotifyUrlWithTradeId((String)payOrder.getTradeId(), (String)"swiftpass");
        SpPlaceRequest request = new SpPlaceRequest(OrderAssistant.getOutTradeNo((PayOrderEo)payOrder), payOrder.getBody(), payOrder.getAmount(), notifyUrl, payOrder.getOrderTime(), payOrder.getExpireTime());
        request.setMchId(configEo.getPtMerId());
        request.setMchCreateIp(attachInfoEo.getIp());
        request.setService(SpGatewayServiceConstants.payTypeMapper.get(payOrder.getPayType()));
        request.setEncryptKey(configEo.getLcPrivKey());
        request.setDecryptKey(configEo.getPtPubKey());
        switch (SpGatewayServiceConstants.payTypeMapper.get(payOrder.getPayType())) {
            case "pay.weixin.jspay": {
                if (!StringUtils.isNotBlank((CharSequence)payOrder.getPtUserId())) break;
                request.setIsRaw("1");
                request.setSubOpenId(payOrder.getPtUserId());
                request.setSubAppid(configEo.getPtAccount());
                break;
            }
            case "pay.weixin.raw.app": {
                request.setAppId(configEo.getPtAccount());
            }
        }
        return (SpPlaceResponse)((Object)this.spPartnerService.placeOrder((Object)request));
    }

    public void validate(PayOrderEo payOrder, SpPlaceResponse spPlaceResponse) throws Exception {
    }
}

