/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.unionpay.gateway.cscanb.impl.query;

import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.huieryun.core.util.JSON;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.AbstractGatewayService;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.BaseGatewayResult;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.CheckResult;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.GatewayResult;
import com.dtyunxi.yundt.cube.center.payment.service.trade.helper.OrderAssistant;
import com.dtyunxi.yundt.cube.center.payment.service.trade.processor.OrderProcessorService;
import com.dtyunxi.yundt.cube.center.payment.unionpay.config.UnionPayConfig;
import com.dtyunxi.yundt.cube.center.payment.unionpay.partner.domain.response.CscanbPayQueryResponse;
import com.dtyunxi.yundt.cube.center.payment.unionpay.util.UnionPayUtil;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PayOrderAttachInfoEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PayOrderEo;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Exception.class})
@Service(value="cscanbPayQueryGatewayServiceImpl")
public class CscanbPayQueryGatewayServiceImpl
extends AbstractGatewayService<PayOrderEo, CscanbPayQueryResponse> {
    @Resource
    private UnionPayConfig unionPayConfig;
    @Resource
    protected OrderProcessorService<PayOrderEo, PayOrderAttachInfoEo> payOrderProcessorWrapperService;

    public BaseGatewayResult rechargeResult(PayOrderEo payOrderEo, CscanbPayQueryResponse response) throws Exception {
        CheckResult result = new CheckResult(1, payOrderEo.getTradeId());
        if ("PAID".equals(response.getBillStatus())) {
            String payTime = response.getPayTime();
            PayOrderEo partnerOrder = OrderAssistant.createPayOrder((String)payOrderEo.getTradeId(), (Date)DateUtil.parseDate((String)payTime, (String)"yyyy-MM-dd HH:mm:ss"));
            PayOrderAttachInfoEo payOrderAttachInfoEo = PayOrderAttachInfoEo.newInstance();
            payOrderAttachInfoEo.setTradeId(payOrderEo.getTradeId());
            payOrderAttachInfoEo.setExtension(JSON.toJsonString((Object)((Object)response)));
            this.payOrderProcessorWrapperService.handleSuccOrder((Object)partnerOrder, (Object)payOrderAttachInfoEo);
            result.setDoneSucc(true);
            return result;
        }
        if ("TRADE_CLOSED".equals(response.getBillStatus())) {
            PayOrderEo partnerOrder = OrderAssistant.createPayOrder((String)payOrderEo.getTradeId(), null);
            partnerOrder.setParentTradeId(payOrderEo.getParentTradeId());
            partnerOrder.setErrorCode(response.getErrCode());
            partnerOrder.setErrorMsg(response.getErrMsg());
            partnerOrder.setParentTradeId(payOrderEo.getParentTradeId());
            result.setDoneSucc(false);
            result.setErrorCode(response.getErrCode());
            result.setErrorMsg(response.getErrMsg());
            this.payOrderProcessorWrapperService.handleFailOrder((Object)partnerOrder);
            return result;
        }
        return result;
    }

    private GatewayResult parseBaseResponse(CscanbPayQueryResponse response, String tradeId) {
        GatewayResult result = new GatewayResult();
        result.setNotifyTradeId(tradeId);
        result.setDoneSucc(false);
        if ("SUCCESS".equals(response.getErrCode())) {
            result.setDoneSucc(true);
        } else {
            result.setErrorCode(response.getErrCode());
            result.setErrorMsg(response.getErrMsg());
        }
        return result;
    }

    public CscanbPayQueryResponse _execute(PayOrderEo payOrderEo) throws Exception {
        Date date = new Date();
        QueryBody reqBody = new QueryBody();
        reqBody.requestTimestamp = DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss");
        reqBody.mid = this.unionPayConfig.getMid();
        reqBody.tid = this.unionPayConfig.getTid();
        reqBody.instMid = this.unionPayConfig.getInstMid();
        reqBody.billNo = payOrderEo.getTradeId();
        reqBody.billDate = DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd");
        String time = DateFormatUtils.format((Date)date, (String)"yyyyMMddHHmmss");
        String nonce = UUID.randomUUID().toString().replace("-", "");
        String authorization = UnionPayUtil.getAuthorization(this.unionPayConfig.getAppId(), this.unionPayConfig.getAppKey(), time, nonce, reqBody.toString());
        this.logger.info("C\u626bB\u652f\u4ed8\u7ed3\u679c\u67e5\u8be2\uff0c\u5411\u6e20\u9053\u53d1\u8d77\u8bf7\u6c42\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c \u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)this.unionPayConfig.getCscanbQueryUrl(), (Object)reqBody);
        String result = CscanbPayQueryGatewayServiceImpl.request(this.unionPayConfig.getCscanbQueryUrl(), authorization, reqBody.toString());
        CscanbPayQueryResponse response = (CscanbPayQueryResponse)((Object)JSON.parseObject((String)result, CscanbPayQueryResponse.class));
        this.logger.info("response:{}", (Object)JSON.toJsonString((Object)((Object)response)));
        return response;
    }

    public void validate(PayOrderEo payOrderEo, CscanbPayQueryResponse unionPayResponse) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String request(String url, String authorization, String reqBody) {
        String response = "";
        PrintWriter out = null;
        BufferedReader in = null;
        try {
            String line;
            URL realUrl = new URL(url);
            URLConnection conn = realUrl.openConnection();
            HttpURLConnection httpUrlConnection = (HttpURLConnection)conn;
            httpUrlConnection.setRequestProperty("Content-Type", "application/json");
            httpUrlConnection.setRequestProperty("authorization", authorization);
            httpUrlConnection.setDoOutput(true);
            httpUrlConnection.setDoInput(true);
            out = new PrintWriter(httpUrlConnection.getOutputStream());
            out.write(reqBody);
            out.flush();
            httpUrlConnection.connect();
            in = new BufferedReader(new InputStreamReader(httpUrlConnection.getInputStream()));
            while ((line = in.readLine()) != null) {
                response = response + line;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return response;
    }

    static class QueryBody {
        String msgId;
        String requestTimestamp;
        String srcReserve;
        String mid;
        String tid;
        String instMid;
        String billNo;
        String refundOrderId;
        String billDate;

        QueryBody() {
        }

        String toJson() {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            if (this.msgId != null) {
                sb.append("\"msgId\":\"" + this.msgId + "\",");
            }
            if (this.requestTimestamp != null) {
                sb.append("\"requestTimestamp\":\"" + this.requestTimestamp + "\",");
            }
            if (this.srcReserve != null) {
                sb.append("\"srcReserve\":\"" + this.srcReserve + "\",");
            }
            if (this.mid != null) {
                sb.append("\"mid\":\"" + this.mid + "\",");
            }
            if (this.tid != null) {
                sb.append("\"tid\":\"" + this.tid + "\",");
            }
            if (this.instMid != null) {
                sb.append("\"instMid\":\"" + this.instMid + "\",");
            }
            if (this.billNo != null) {
                sb.append("\"billNo\":\"" + this.billNo + "\",");
            }
            if (this.refundOrderId != null) {
                sb.append("\"refundOrderId\":\"" + this.refundOrderId + "\",");
            }
            if (this.billDate != null) {
                sb.append("\"billDate\":\"" + this.billDate + "\",");
            }
            if (sb.charAt(sb.length() - 1) == ',') {
                sb.deleteCharAt(sb.length() - 1);
            }
            sb.append("}");
            return sb.toString();
        }

        public String toString() {
            return this.toJson();
        }
    }
}

