/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.unionpay.gateway.cscanb.impl.trade;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.BaseGatewayResult;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.GatewayResult;
import com.dtyunxi.yundt.cube.center.payment.service.trade.helper.OrderAssistant;
import com.dtyunxi.yundt.cube.center.payment.service.trade.processor.OrderProcessorService;
import com.dtyunxi.yundt.cube.center.payment.unionpay.config.UnionPayConfig;
import com.dtyunxi.yundt.cube.center.payment.unionpay.gateway.cscanb.AbstractCscanBPayGatewayService;
import com.dtyunxi.yundt.cube.center.payment.unionpay.mq.dto.CscanbQrCodeCloseDto;
import com.dtyunxi.yundt.cube.center.payment.unionpay.partner.UnionPayPartnerService;
import com.dtyunxi.yundt.cube.center.payment.unionpay.partner.domain.request.UnionPayRequest;
import com.dtyunxi.yundt.cube.center.payment.unionpay.partner.domain.response.UnionPayResponse;
import com.dtyunxi.yundt.cube.center.payment.unionpay.util.UnionPayUtil;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PayOrderAttachInfoEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PayOrderEo;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Exception.class})
@Service(value="cscanbPayOrderCreateGatewayService")
public class CscanbPayOrderCreateGatewayServiceImpl
extends AbstractCscanBPayGatewayService<PayOrderEo, UnionPayResponse> {
    private static final String instId = "QRPAYDEFAULT";
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private UnionPayConfig unionPayConfig;
    @Resource
    protected UnionPayPartnerService unionPayPartnerService;
    @Resource
    protected OrderProcessorService<PayOrderEo, PayOrderAttachInfoEo> payOrderProcessorWrapperService;

    public BaseGatewayResult rechargeResult(PayOrderEo payOrderEo, UnionPayResponse response) throws Exception {
        GatewayResult gatewayResult = this.parseBaseResponse(response, payOrderEo.getTradeId());
        PayOrderEo partnerOrder = OrderAssistant.createPayOrder((String)payOrderEo.getTradeId(), (Date)new Date());
        if ("SUCCESS".equals(response.getErrCode())) {
            HashMap<String, String> attach = new HashMap<String, String>();
            attach.put("outTradeNo", response.getBillNo());
            attach.put("codeImgUrl", response.getBillQRCode());
            gatewayResult.setData(attach);
            PayOrderAttachInfoEo payOrderAttachInfoEo = PayOrderAttachInfoEo.newInstance();
            payOrderAttachInfoEo.setTradeId(payOrderEo.getTradeId());
            payOrderAttachInfoEo.setPayInfo(JSON.toJSONString((Object)((Object)response)));
            this.payOrderProcessorService.handleAcceptOrder((Object)partnerOrder, (Object)payOrderAttachInfoEo);
            CscanbQrCodeCloseDto closeDto = new CscanbQrCodeCloseDto();
            closeDto.setTradeId(payOrderEo.getTradeId());
            closeDto.setQrCodeId(response.getQrCodeId());
            this.logger.info("\u53d1\u9001\u4e8c\u7ef4\u7801\u5173\u95ed\u5ef6\u8fdfMQ\uff0c{}", (Object)JSON.toJSONString((Object)closeDto));
            this.commonsMqService.sendDelaySingleMessageAsync("CSCANB_EXPIRE_TAG", (Object)closeDto, Long.valueOf(Long.parseLong(response.getExpireTime()) + 10L));
        } else {
            this.logger.info("\u5411\u94f6\u8054\u53d1\u8d77C\u626bB\u751f\u6210\u652f\u4ed8\u4e8c\u7ef4\u7801\u5931\u8d25, \u4e2d\u53f0\u652f\u4ed8\u6d41\u6c34\u53f7: {}", (Object)payOrderEo.getTradeId());
            partnerOrder.setParentTradeId(payOrderEo.getParentTradeId());
            partnerOrder.setErrorCode(response.getErrCode());
            partnerOrder.setErrorMsg(response.getErrMsg());
            partnerOrder.setParentTradeId(payOrderEo.getParentTradeId());
            gatewayResult.setDoneSucc(false);
            gatewayResult.setErrorCode(response.getErrCode());
            gatewayResult.setErrorMsg(response.getErrMsg());
            this.payOrderProcessorWrapperService.handleFailOrder((Object)partnerOrder);
        }
        return gatewayResult;
    }

    private GatewayResult parseBaseResponse(UnionPayResponse response, String tradeId) {
        GatewayResult result = new GatewayResult();
        result.setNotifyTradeId(tradeId);
        result.setDoneSucc(false);
        if ("SUCCESS".equals(response.getErrCode())) {
            result.setDoneSucc(true);
        } else {
            result.setErrorCode(response.getErrCode());
            result.setErrorMsg(response.getErrMsg());
        }
        return result;
    }

    public UnionPayResponse _execute(PayOrderEo payOrderEo) throws Exception {
        this.logger.info("unionPayConfig:{}", (Object)JSON.toJSONString((Object)this.unionPayConfig));
        UnionPayRequest reqBody = new UnionPayRequest();
        Date date = new Date();
        reqBody.setRequestTimestamp(new SimpleDateFormat("yyyyMMddHHmmss").format(date));
        reqBody.setMid(this.unionPayConfig.getMid());
        reqBody.setTid(this.unionPayConfig.getTid());
        reqBody.setInstMid(instId);
        reqBody.setBillDate(new SimpleDateFormat("yyyy-MM-dd").format(date));
        Integer expireTime = 1800;
        if (null != payOrderEo.getExpireTime()) {
            expireTime = payOrderEo.getExpireTime();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, expireTime);
        String expireTimes = DateUtil.getDateFormat((Date)calendar.getTime(), (String)"yyyy-MM-dd HH:mm:ss");
        this.logger.info("\u8fc7\u671f\u65f6\u95f4:{}", (Object)expireTimes);
        reqBody.setExpireTime(expireTimes);
        String outTradeNo = UnionPayUtil.getNewTradeId(payOrderEo.getTradeId());
        this.updatePayOrderTradeId(payOrderEo, outTradeNo);
        payOrderEo.setTradeId(outTradeNo);
        reqBody.setBillNo(payOrderEo.getTradeId());
        reqBody.setTotalAmount(new BigDecimal("100").multiply(payOrderEo.getAmount()).intValue());
        this.logger.info("cscanbPayNotifyUrl:{}", (Object)this.unionPayConfig.getCscanbPayNotifyUrl());
        this.logger.info("webPayNotifyUrl:{}", (Object)this.unionPayConfig.getWebPayUrl());
        reqBody.setNotifyUrl(this.unionPayConfig.getCscanbPayNotifyUrl());
        String time = new SimpleDateFormat("yyyyMMddHHmmss").format(date);
        String nonce = UUID.randomUUID().toString().replace("-", "");
        String authorization = UnionPayUtil.getAuthorization(this.unionPayConfig.getAppId(), this.unionPayConfig.getAppKey(), time, nonce, reqBody.toString());
        this.logger.info("\u5411\u6e20\u9053\u53d1\u8d77\u8bf7\u6c42\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{},authorization:{},nonce:{},\u8bf7\u6c42\u53c2\u6570\uff1a{}", new Object[]{this.unionPayConfig.getCscanbUrl(), authorization, nonce, reqBody.toString()});
        String result = this.request(this.unionPayConfig.getCscanbUrl(), authorization, reqBody.toString());
        UnionPayResponse response = (UnionPayResponse)((Object)JSON.parseObject((String)result, UnionPayResponse.class));
        this.logger.info("C\u626bB\u8fd4\u56de\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)((Object)response)));
        if (!"SUCCESS".equals(response.getErrCode())) {
            throw new Exception(response.getErrMsg());
        }
        response.setExpireTime(expireTime.toString());
        return response;
    }

    private void updatePayOrderTradeId(PayOrderEo payOrderEo, String outTradeNo) {
        PayOrderEo updateEo = new PayOrderEo();
        updateEo.setId(payOrderEo.getId());
        updateEo.setTradeId(outTradeNo);
        this.payOrderDas.updateSelective((BaseEo)updateEo);
    }

    public void validate(PayOrderEo payOrderEo, UnionPayResponse unionPayResponse) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String request(String url, String authorization, String reqBody) {
        String response = "";
        PrintWriter out = null;
        BufferedReader in = null;
        try {
            String line;
            URL realUrl = new URL(url);
            URLConnection conn = realUrl.openConnection();
            HttpURLConnection httpUrlConnection = (HttpURLConnection)conn;
            httpUrlConnection.setRequestProperty("Content-Type", "application/json");
            httpUrlConnection.setRequestProperty("authorization", authorization);
            httpUrlConnection.setDoOutput(true);
            httpUrlConnection.setDoInput(true);
            out = new PrintWriter(httpUrlConnection.getOutputStream());
            out.write(reqBody);
            out.flush();
            httpUrlConnection.connect();
            in = new BufferedReader(new InputStreamReader(httpUrlConnection.getInputStream()));
            while ((line = in.readLine()) != null) {
                response = response + line;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.logger.info("\u6536\u5230\u6e20\u9053\u54cd\u5e94:{}", (Object)response);
        return response;
    }
}

