/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.unionpay.gateway.webpay.impl;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.status.OrderStatus;
import com.dtyunxi.yundt.cube.center.payment.dto.exception.ApiException;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.DefaultGatewayService;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.BaseGatewayResult;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.CheckResult;
import com.dtyunxi.yundt.cube.center.payment.service.trade.check.CheckOrderService;
import com.dtyunxi.yundt.cube.center.payment.unionpay.gateway.webpay.WebPayGatewayService;
import com.dtyunxi.yundt.cube.center.payment.unionpay.gateway.webpay.impl.query.WebPayOrderQueryGatewayServiceImpl;
import com.dtyunxi.yundt.cube.center.payment.unionpay.gateway.webpay.impl.trade.WebPayOrderCreateGatewayServiceImpl;
import com.dtyunxi.yundt.cube.center.payment.unionpay.gateway.webpay.impl.trade.WebPayOrderRefundGatewayServiceImpl;
import com.dtyunxi.yundt.cube.center.payment.unionpay.partner.domain.response.WebPayQueryResponse;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.PayOrderDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.EnterpriseOrderEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PartnerConfigEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PayOrderEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.RefundOrderEo;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="webPayGatewayService")
@Transactional(rollbackFor={Exception.class})
public class WebPayGatewayServiceImpl<T, M, R>
extends DefaultGatewayService
implements WebPayGatewayService<PayOrderEo, RefundOrderEo, EnterpriseOrderEo> {
    private static final Logger log = LoggerFactory.getLogger(WebPayGatewayServiceImpl.class);
    private final String APPLICATION_NAME = "tcbj-center-payment";
    private final String UNION_PAY_KEY = "UNION-PAY";
    @Resource
    private ILockService lockService;
    @Resource
    private CheckOrderService checkPayOrderService;
    @Resource
    private PayOrderDas payOrderDas;
    @Resource
    private WebPayOrderCreateGatewayServiceImpl webPayOrderCreateGatewayServiceImpl;
    @Resource
    private WebPayOrderRefundGatewayServiceImpl webPayOrderRefundGatewayServiceImpl;
    @Resource
    private WebPayOrderQueryGatewayServiceImpl webPayOrderQueryGatewayServiceImpl;

    public BaseGatewayResult closePayTrade(PayOrderEo order) {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BaseGatewayResult createPayTrade(PayOrderEo order) {
        BaseGatewayResult baseGatewayResult = null;
        Mutex mutex = null;
        try {
            mutex = this.lockService.lock("tcbj-center-payment", order.getAppCode() + "UNION-PAY" + order.getStoreOrderId(), 3, 20, TimeUnit.SECONDS);
            if (null == order.getParentTradeId()) {
                PayOrderEo filter = new PayOrderEo();
                filter.setAppCode(order.getAppCode());
                filter.setStoreOrderId(order.getStoreOrderId());
                filter.setSqlFilters(Collections.singletonList(SqlFilter.in((String)"status", Arrays.asList(OrderStatus.ACCEPT.getStatus(), OrderStatus.SUCCESS.getStatus()))));
                List orderEos = this.payOrderDas.select((BaseEo)filter);
                if (CollectionUtils.isNotEmpty((Collection)orderEos)) {
                    throw new ApiException(String.format("\u94f6\u8054C\u626bB\u4e0d\u5141\u8bb8\u91cd\u590d\u652f\u4ed8\uff01\u4e2d\u53f0\u652f\u4ed8\u6d41\u6c34\u53f7: %s", order.getStoreOrderId()));
                }
            }
            baseGatewayResult = this.webPayOrderCreateGatewayServiceImpl.execute(order);
            if (null == mutex) return baseGatewayResult;
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new ApiException(e.getMessage());
            }
            catch (Throwable throwable) {
                if (null == mutex) throw throwable;
                this.lockService.unlock(mutex);
                throw throwable;
            }
        }
        this.lockService.unlock(mutex);
        return baseGatewayResult;
    }

    public BaseGatewayResult createRefundTrade(RefundOrderEo order) {
        return this.webPayOrderRefundGatewayServiceImpl.execute(order);
    }

    public BaseGatewayResult handleNotify(Map<String, String> notify, String ntfyTradeId) throws Exception {
        return null;
    }

    public CheckResult checkOrder(String tradeId) {
        CheckResult result = new CheckResult();
        try {
            PayOrderEo payOrderEo = (PayOrderEo)this.payOrderDas.selectByLogicKey((Object)tradeId);
            WebPayQueryResponse response = this.webPayOrderQueryGatewayServiceImpl._execute(payOrderEo);
            return (CheckResult)this.webPayOrderQueryGatewayServiceImpl.rechargeResult(payOrderEo, response);
        }
        catch (Exception e) {
            e.printStackTrace();
            return result;
        }
    }

    public BaseGatewayResult downloadTradeOrder(PartnerConfigEo partnerConfig) {
        return null;
    }
}

