/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.unionpay.gateway.webpay.impl.query;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.AbstractGatewayService;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.BaseGatewayResult;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.CheckResult;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.GatewayResult;
import com.dtyunxi.yundt.cube.center.payment.service.trade.helper.OrderAssistant;
import com.dtyunxi.yundt.cube.center.payment.service.trade.processor.OrderProcessorService;
import com.dtyunxi.yundt.cube.center.payment.unionpay.config.UnionPayConfig;
import com.dtyunxi.yundt.cube.center.payment.unionpay.partner.domain.response.WebPayQueryResponse;
import com.dtyunxi.yundt.cube.center.payment.unionpay.util.UnionPayUtil;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PayOrderAttachInfoEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PayOrderEo;
import java.math.BigDecimal;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Exception.class})
@Service(value="webPayOrderQueryGatewayServiceImpl")
public class WebPayOrderQueryGatewayServiceImpl
extends AbstractGatewayService<PayOrderEo, WebPayQueryResponse> {
    @Resource
    private UnionPayConfig unionPayConfig;
    @Resource
    protected OrderProcessorService<PayOrderEo, PayOrderAttachInfoEo> payOrderProcessorWrapperService;

    public BaseGatewayResult rechargeResult(PayOrderEo payOrderEo, WebPayQueryResponse response) throws Exception {
        CheckResult gatewayResult = new CheckResult(1, payOrderEo.getTradeId());
        if ("TRADE_SUCCESS".equals(response.getStatus())) {
            String payTime = response.getPayTime();
            PayOrderEo partnerOrder = OrderAssistant.createPayOrder((String)payOrderEo.getTradeId(), (Date)DateUtil.parseDate((String)payTime, (String)"yyyy-MM-dd HH:mm:ss"));
            PayOrderAttachInfoEo payOrderAttachInfoEo = PayOrderAttachInfoEo.newInstance();
            payOrderAttachInfoEo.setTradeId(payOrderEo.getTradeId());
            payOrderAttachInfoEo.setExtension(JSON.toJSONString((Object)((Object)response)));
            partnerOrder.setPartnerOrderId(response.getSeqId());
            partnerOrder.setAmount(new BigDecimal(response.getTotalAmount()).divide(new BigDecimal("100"), 2));
            this.payOrderProcessorWrapperService.handleSuccOrder((Object)partnerOrder, (Object)payOrderAttachInfoEo);
            return gatewayResult;
        }
        if ("TRADE_CLOSED".equals(response.getStatus())) {
            PayOrderEo partnerOrder = OrderAssistant.createPayOrder((String)payOrderEo.getTradeId());
            partnerOrder.setParentTradeId(partnerOrder.getParentTradeId());
            partnerOrder.setErrorCode("CLOSED");
            partnerOrder.setErrorMsg("\u8d26\u5355\u5173\u95ed");
            this.payOrderProcessorWrapperService.handleFailOrder((Object)partnerOrder);
            return gatewayResult;
        }
        return gatewayResult;
    }

    private GatewayResult parseBaseResponse(WebPayQueryResponse response, String tradeId) {
        GatewayResult result = new GatewayResult();
        result.setNotifyTradeId(tradeId);
        result.setDoneSucc(false);
        if ("SUCCESS".equals(response.getErrCode())) {
            result.setDoneSucc(true);
        } else {
            result.setErrorCode(response.getErrCode());
            result.setErrorMsg(response.getErrMsg());
        }
        return result;
    }

    public WebPayQueryResponse _execute(PayOrderEo payOrderEo) throws Exception {
        JSONObject json = new JSONObject();
        Date date = new Date();
        json.put("requestTimestamp", (Object)DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss"));
        json.put("mid", (Object)this.unionPayConfig.getMid());
        json.put("tid", (Object)this.unionPayConfig.getTid());
        json.put("instMid", (Object)this.unionPayConfig.getInstMid());
        json.put("merOrderId", (Object)payOrderEo.getTradeId());
        this.logger.info("\u516c\u4f17\u53f7\u652f\u4ed8\u7ed3\u679c\u67e5\u8be2\uff0c\u5411\u6e20\u9053\u53d1\u8d77\u8bf7\u6c42\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c \u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)this.unionPayConfig.getCscanbQueryUrl(), (Object)json);
        String result = this.send(this.unionPayConfig.getCscanbQueryUrl(), json.toString(), date);
        WebPayQueryResponse response = (WebPayQueryResponse)((Object)com.dtyunxi.huieryun.core.util.JSON.parseObject((String)result, WebPayQueryResponse.class));
        this.logger.info("response:{}", (Object)com.dtyunxi.huieryun.core.util.JSON.toJsonString((Object)((Object)response)));
        return response;
    }

    public void validate(PayOrderEo payOrderEo, WebPayQueryResponse unionPayResponse) throws Exception {
    }

    public String send(String url, String entity, Date date) throws Exception {
        String authorization = UnionPayUtil.getOpenBodySig(this.unionPayConfig.getAppId(), this.unionPayConfig.getAppKey(), entity, date);
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("Authorization", authorization);
        StringEntity se = new StringEntity(entity, "UTF-8");
        se.setContentType("application/json");
        httpPost.setEntity((HttpEntity)se);
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        HttpEntity entity1 = response.getEntity();
        String resStr = null;
        if (entity1 != null) {
            resStr = EntityUtils.toString((HttpEntity)entity1, (String)"UTF-8");
        }
        httpClient.close();
        response.close();
        this.logger.info("C\u626bB\u652f\u4ed8\u7ed3\u679c\u67e5\u8be2\u8fd4\u56de\u4fe1\u606f:{}", (Object)resStr);
        return resStr;
    }
}

