/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.unionpay.mq.process;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.payment.unionpay.config.UnionPayConfig;
import com.dtyunxi.yundt.cube.center.payment.unionpay.mq.dto.CscanbQrCodeCloseDto;
import com.dtyunxi.yundt.cube.center.payment.unionpay.partner.domain.response.UnionPayResponse;
import com.dtyunxi.yundt.cube.center.payment.unionpay.util.HttpUtils;
import com.dtyunxi.yundt.cube.center.payment.unionpay.util.UnionPayUtil;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.PayOrderDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PayOrderEo;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="CSCANB_EXPIRE_TAG")
public class CscanbQrCodeCloseMessageProcessor
implements IMessageProcessor<CscanbQrCodeCloseDto> {
    private static final Logger log = LoggerFactory.getLogger(CscanbQrCodeCloseMessageProcessor.class);
    private final String instId = "QRPAYDEFAULT";
    @Resource
    private PayOrderDas payOrderDas;
    @Resource
    private UnionPayConfig unionPayConfig;

    public MessageResponse process(CscanbQrCodeCloseDto closeDto) {
        block8: {
            log.info("\u4e8c\u7ef4\u7801\u8d85\u65f6\u5173\u95edmq\u6d88\u8d39:{}", (Object)JSON.toJSONString((Object)closeDto));
            try {
                if (StringUtils.isBlank((CharSequence)closeDto.getTradeId())) {
                    return MessageResponse.SUCCESS;
                }
                log.info("\u6536\u5230MQ\u6d88\u606f tradeId\uff1a{}", (Object)closeDto.getTradeId());
                PayOrderEo payOrderEo = (PayOrderEo)this.payOrderDas.selectByLogicKey((Object)closeDto.getTradeId());
                if (null == payOrderEo) {
                    return MessageResponse.SUCCESS;
                }
                if ("S".equals(payOrderEo.getStatus()) || "F".equals(payOrderEo.getStatus())) {
                    return MessageResponse.SUCCESS;
                }
                if (!"A".equals(payOrderEo.getStatus()) && !"P".equals(payOrderEo.getStatus())) break block8;
                UnionPayResponse response = new UnionPayResponse();
                try {
                    response = this.closeQrCode(closeDto);
                }
                catch (Exception e) {
                    log.error("\u8c03\u7528\u94f6\u8054\u5173\u95ed\u4e8c\u7ef4\u7801\u63a5\u53e3\u5f02\u5e38");
                    e.printStackTrace();
                    return MessageResponse.SUCCESS;
                }
                if ("SUCCESS".equals(response.getErrCode())) {
                    PayOrderEo updateEo = new PayOrderEo();
                    updateEo.setId(payOrderEo.getId());
                    updateEo.setStatus("F");
                    updateEo.setErrorCode("QR_CLOSED");
                    updateEo.setErrorMsg("\u8d85\u65f6\u672a\u652f\u4ed8\uff0c\u4e8c\u7ef4\u7801\u5931\u6548");
                    this.payOrderDas.updateSelective((BaseEo)updateEo);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return MessageResponse.SUCCESS;
    }

    private UnionPayResponse closeQrCode(CscanbQrCodeCloseDto closeDto) throws Exception {
        JSONObject json = new JSONObject();
        Date date = new Date();
        json.put("requestTimestamp", (Object)DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss"));
        json.put("billNo", (Object)closeDto.getTradeId());
        json.put("qrCodeId", (Object)closeDto.getQrCodeId());
        json.put("mid", (Object)this.unionPayConfig.getMid());
        json.put("tid", (Object)this.unionPayConfig.getTid());
        json.put("instMid", (Object)"QRPAYDEFAULT");
        String timestamp = new SimpleDateFormat("yyyyMMddHHmmss").format(date);
        String nonce = UUID.randomUUID().toString().replace("-", "");
        String authorization = UnionPayUtil.getAuthorization(this.unionPayConfig.getAppId(), this.unionPayConfig.getAppKey(), timestamp, nonce, json.toString());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("authorization", authorization);
        String result = HttpUtils.httpPostRequest(this.unionPayConfig.getQrBillCodeCloseUrl(), map, json.toJSONString());
        return (UnionPayResponse)((Object)JSON.parseObject((String)result, UnionPayResponse.class));
    }
}

