/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.component.track.config;

import com.dtyunxi.cube.component.track.client.aspect.TransactionActionAspect;
import com.dtyunxi.cube.component.track.client.aspect.TransactionNodeActionAspect;
import com.dtyunxi.cube.component.track.client.config.TransactionTrackConfigVo;
import com.dtyunxi.cube.component.track.client.feign.filter.TransactionTrackFeignFilter;
import com.dtyunxi.cube.component.track.config.TransactionTrackInterceptorWebMvcConfigurer;
import feign.RequestInterceptor;
import java.util.ArrayList;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@EnableConfigurationProperties
public class TransactionTrackAutoConfiguration {
    @Bean
    public TransactionTrackInterceptorWebMvcConfigurer transactionTrackInterceptorWebMvcConfigurer(TransactionTrackConfigVo transactionTrackConfigVo) {
        ArrayList<String> urls = new ArrayList<String>();
        urls.add("/swagger-resources/**");
        urls.add("/swagger-resources");
        urls.add("/webjars/springfox-swagger-ui/**");
        urls.add("/webjars/springfox-swagger-ui/*.*");
        urls.add("/swagger-ui.html");
        urls.add("/swagger-ui/*.*");
        urls.add("/v2/api-docs");
        urls.add("/favicon.ico");
        urls.add("/xapi.html");
        urls.add("/xapi/**");
        return new TransactionTrackInterceptorWebMvcConfigurer(transactionTrackConfigVo).setExcludePathPatterns(urls);
    }

    @Bean
    @ConditionalOnClass(value={RequestInterceptor.class})
    public TransactionTrackFeignFilter transactionTrackFeignFilter(TransactionTrackConfigVo transactionTrackConfigVo) {
        return new TransactionTrackFeignFilter(transactionTrackConfigVo);
    }

    @Configuration
    protected static class TransactionTrackAspectConfiguration {
        protected TransactionTrackAspectConfiguration() {
        }

        @Bean
        public TransactionActionAspect transactionActionAspect() {
            return new TransactionActionAspect();
        }

        @Bean
        public TransactionNodeActionAspect transactionNodeActionAspect() {
            return new TransactionNodeActionAspect();
        }
    }
}

