/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.export.biz.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.afterturn.easypoi.excel.export.ExcelBatchExportService;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.mj.biz.commons.utils.EasyPoiExportUtil;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.module.export.biz.constant.ExportTypeEnum;
import com.dtyunxi.tcbj.module.export.biz.constant.GiftBoxTypeEnum;
import com.dtyunxi.tcbj.module.export.biz.impl.BaseExportService;
import com.dtyunxi.tcbj.module.export.biz.impl.ExportService;
import com.dtyunxi.tcbj.module.export.biz.utils.MyEasyPoiExportUtil;
import com.dtyunxi.tcbj.module.export.biz.vo.price.PriceLimitSkuDetailVo;
import com.dtyunxi.tcbj.module.export.biz.vo.price.SkuPolicyPriceVo;
import com.dtyunxi.tcbj.module.export.biz.vo.price.SuggestedRetailPriceVo;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.CustomerTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerExtDetailRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceModelSetTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.dto.es.PriceLimitPolicyEsSkuExtDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.es.PricePolicyEsSkuExtDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceLimitSkuQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.SkuPolicyPriceQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.item.ItemSkuRetailPriceReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceLimitSkuDetailRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.SkuPolicyPriceRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.item.ItemSkuRetailPriceRespDto;
import com.dtyunxi.yundt.cube.center.price.api.query.IBasePriceItemQueryApi;
import com.dtyunxi.yundt.cube.center.price.api.query.IPriceLimitQueryApi;
import com.dtyunxi.yundt.cube.center.price.api.query.IPriceQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import com.yx.tcbj.center.price.api.constant.BaseDiscountImportEnum;
import com.yx.tcbj.center.price.api.dto.request.PrBaseDiscountBrandReqDto;
import com.yx.tcbj.center.price.api.dto.request.PrBaseDiscountQueryReqDto;
import com.yx.tcbj.center.price.api.dto.response.PrBaseDiscountRespDto;
import com.yx.tcbj.center.price.api.exception.PriceCenterExceptionCode;
import com.yx.tcbj.center.price.api.query.IPrBaseDiscountQueryApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="PriceExportService")
public class PriceExportService {
    private static final Logger logger = LoggerFactory.getLogger(PriceExportService.class);
    private static final String EXPORT_ALL_PRICE_LIMIT_KEY = "EXPORT_ALL_PRICE_LIMIT";
    private static final String EXPORT_ALL_DEALER_PRICE_KEY = "EXPORT_ALL_DEALER_PRICE";
    @Resource
    private ExportService exportService;
    @Resource
    private IPrBaseDiscountQueryApi discountQueryApi;
    @Resource
    private IPriceLimitQueryApi priceLimitQueryApi;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IContext context;
    @Resource
    private IBasePriceItemQueryApi basePriceItemQueryApi;
    @Resource
    private IPriceQueryApi priceQueryApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi baseCustomerQueryApi;
    @Resource
    private ICacheService cacheService;

    public RestResponse<Object> exportBaseDiscount(PrBaseDiscountQueryReqDto reqDto) {
        BaseExportService baseExportService = new BaseExportService(ExportTypeEnum.BASE_DISCOUNT.getName(), ExportTypeEnum.BASE_DISCOUNT);
        String orgIdStr = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.organizationid");
        if (StringUtils.isBlank((CharSequence)orgIdStr)) {
            PriceCenterExceptionCode.ORG_ID_NOT_EXIST.throwException();
        }
        reqDto.setMerchantId(Long.valueOf(orgIdStr));
        baseExportService.executor(req -> {
            try {
                Long total = null;
                double num = 0.0;
                Integer pageNum = 1;
                Integer pageSize = 5000;
                ArrayList rList = Lists.newArrayList();
                ArrayList<ExcelExportEntity> excelParams = new ArrayList<ExcelExportEntity>();
                for (BaseDiscountImportEnum enumObj : BaseDiscountImportEnum.values()) {
                    ExcelExportEntity entity = new ExcelExportEntity(enumObj.getName(), (Object)enumObj.getName());
                    if (enumObj == BaseDiscountImportEnum.STANDARD_DISCOUNT) {
                        entity.setNumFormat("0.00");
                    }
                    excelParams.add(entity);
                }
                HashSet<String> brandSets = new HashSet<String>();
                while (total == null || (double)pageNum.intValue() <= num) {
                    reqDto.setPageNum(pageNum);
                    reqDto.setPageSize(pageSize);
                    logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\u67e5\u8be2\u57fa\u7840\u6263\u7387\u53c2\u6570:{},UUID:{}", (Object)JSONObject.toJSONString((Object)reqDto), (Object)baseExportService.getId());
                    PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.discountQueryApi.queryByPage(reqDto));
                    if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
                        logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\u67e5\u8be2\u57fa\u7840\u6263\u7387\u7ed3\u679c:{},UUID:{}", (Object)pageInfo.getList().size(), (Object)baseExportService.getId());
                    }
                    if (total == null) {
                        total = pageInfo.getTotal();
                        num = Math.ceil(Double.valueOf(total.longValue()) / (double)pageSize.intValue());
                        logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\u521d\u59cb\u5316UUID:{},\u67e5\u8be2\u57fa\u7840\u6263\u7387\u603b\u6570:{},\u4e00\u5171\u9700\u8981\u5206\u6279:{}\u6b21", new Object[]{baseExportService.getId(), total, num});
                    }
                    pageNum = pageNum + 1;
                    if (!CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) continue;
                    String customerCodeColumnName = BaseDiscountImportEnum.CUSTOMER_CODE.getName();
                    String customerNameColumnName = BaseDiscountImportEnum.CUSTOMER_NAME.getName();
                    String standardDiscountColumnName = BaseDiscountImportEnum.STANDARD_DISCOUNT.getName();
                    for (PrBaseDiscountRespDto respDto : pageInfo.getList()) {
                        HashMap<String, Object> vo = new HashMap<String, Object>();
                        vo.put(customerCodeColumnName, respDto.getCustomerCode());
                        vo.put(customerNameColumnName, respDto.getCustomerName());
                        vo.put(standardDiscountColumnName, respDto.getStandardDiscount());
                        if (CollectionUtils.isNotEmpty((Collection)respDto.getBrandDiscountList())) {
                            for (PrBaseDiscountBrandReqDto brandDto : respDto.getBrandDiscountList()) {
                                vo.put(brandDto.getBrandName(), brandDto.getBrandDiscount());
                                if (brandSets.contains(brandDto.getBrandName())) continue;
                                brandSets.add(brandDto.getBrandName());
                                ExcelExportEntity entity = new ExcelExportEntity(brandDto.getBrandName(), (Object)brandDto.getBrandName());
                                entity.setNumFormat("0.00");
                                excelParams.add(entity);
                            }
                        }
                        rList.add(vo);
                    }
                    pageInfo.getList().clear();
                }
                logger.info(ExportTypeEnum.BASE_DISCOUNT.getName() + "\u5217\u8868\u67e5\u8be2\u6570\u636e\u8f6c\u6362\u7ed3\u679c\u5927\u5c0f:{},UUID:{}", (Object)rList.size(), (Object)baseExportService.getId());
                if (CollectionUtils.isNotEmpty((Collection)rList)) {
                    String suffix = ".xlsx";
                    ExportParams params = new ExportParams(null, "", ".xls".equalsIgnoreCase(suffix) ? ExcelType.HSSF : ExcelType.XSSF);
                    String exportUrl = EasyPoiExportUtil.exportByMap((String)(baseExportService.getExcelName() + suffix), (ExportParams)params, excelParams, (List)rList);
                    this.exportService.success(baseExportService.getId(), exportUrl);
                } else {
                    this.exportService.fail(baseExportService.getId(), "\u5bfc\u51fa" + ExportTypeEnum.BASE_DISCOUNT.getName() + "\u5217\u8868,\u6570\u636e\u4e3a\u7a7a");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("\u5bfc\u51fa{}\u5217\u8868-\u9519\u8bef:{}", (Object)ExportTypeEnum.BASE_DISCOUNT.getName(), (Object)e.toString());
                this.exportService.fail(baseExportService.getId(), "\u5bfc\u51fa" + ExportTypeEnum.BASE_DISCOUNT.getName() + "\u5217\u8868\u9519\u8bef\u3010" + e.getMessage() + "\u3011");
            }
            return null;
        }, null);
        return new RestResponse("0", "\u5bfc\u51fa" + ExportTypeEnum.BASE_DISCOUNT.getName() + "\u6210\u529f");
    }

    public RestResponse<Object> exportPriceLimit(PriceLimitSkuQueryReqDto reqDto) {
        Assert.notNull((Object)reqDto.getCustomerId(), (String)"-1", (String)"\u8bf7\u9009\u62e9\u5ba2\u6237");
        return this.commonExportPriceLimit(reqDto, null);
    }

    public RestResponse<Object> exportAllPriceLimit() {
        CustomerSearchReqDto searchReqDto = new CustomerSearchReqDto();
        searchReqDto.setListFlag(Boolean.valueOf(true));
        searchReqDto.setChannel(CustomerTypeEnum.BRAND.getCode());
        searchReqDto.setType(CustomerTypeEnum.DEALER.getCode());
        RestResponse pageInfoRestResponse = this.customerExtQueryApi.queryByPage(JSONObject.toJSONString((Object)searchReqDto), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
        if (pageInfo == null || CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            throw new BizException("100000", "\u627e\u4e0d\u5230\u5ba2\u6237\u4fe1\u606f");
        }
        PriceLimitSkuQueryReqDto reqDto = new PriceLimitSkuQueryReqDto();
        return this.commonExportPriceLimit(reqDto, pageInfo.getList());
    }

    private RestResponse<Object> commonExportPriceLimit(PriceLimitSkuQueryReqDto dto, List<CustomerRespDto> customerRespDtos) {
        String exportTypeName = ExportTypeEnum.PRICE_LIMIT.getName();
        BaseExportService baseExportService = new BaseExportService(exportTypeName, ExportTypeEnum.PRICE_LIMIT);
        baseExportService.executor(req -> {
            Boolean lockFlag = (Boolean)this.cacheService.getCache(EXPORT_ALL_PRICE_LIMIT_KEY, Boolean.class);
            try {
                IContext context = (IContext)SpringBeanUtil.getBean(IContext.class);
                if (context != null) {
                    logger.info("\u5bfc\u51fa\u6253\u5370\u83b7\u53d6\u7684userId={},instanceId={},tenantId={}", new Object[]{context.userId(), context.instanceId(), context.tenantId()});
                }
                ArrayList rList = Lists.newArrayList();
                if (CollectionUtils.isNotEmpty((Collection)customerRespDtos)) {
                    if (Boolean.TRUE.equals(lockFlag)) {
                        TimeUnit.MINUTES.sleep(15L);
                    } else {
                        this.cacheService.setCache(EXPORT_ALL_PRICE_LIMIT_KEY, (Object)Boolean.TRUE, 900);
                    }
                }
                String title = null;
                ExportParams params = new ExportParams(title, "", ExcelType.XSSF);
                ExcelBatchExportService batchService = ExcelBatchExportService.getExcelBatchExportService((ExportParams)params, PriceLimitSkuDetailVo.class);
                Workbook workbook = null;
                int kb = 1024;
                String fileName = "cube/" + exportTypeName + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss") + ".xlsx";
                if (CollectionUtils.isNotEmpty((Collection)customerRespDtos)) {
                    int logPrintNum = customerRespDtos.size() * 3 / 4;
                    for (int i = 0; i < customerRespDtos.size(); ++i) {
                        CustomerRespDto customerRespDto = (CustomerRespDto)customerRespDtos.get(i);
                        dto.setCustomerId(customerRespDto.getId());
                        this.commonSearchPriceLimit(dto, baseExportService, rList, exportTypeName, customerRespDto);
                        long totalMemorySize = Runtime.getRuntime().totalMemory() / (long)kb;
                        long freeMemorySize = Runtime.getRuntime().freeMemory() / (long)kb;
                        long usedMemory = (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / (long)kb;
                        if (i > logPrintNum) {
                            logger.info(exportTypeName + "\u5217\u8868\u5ba2\u6237\u53c2\u6570:{}:\u67e5\u8be2\u6570\u636e\u8f6c\u6362\u7ed3\u679c\u5927\u5c0f:{},UUID:{},\u5171\u67e5{}\u4e2a\u5ba2\u6237\uff0c\u5f53\u524d\u67e5\u8be2\u7b2c{}\u4e2a\u5ba2\u6237,\u7269\u7406\u603b\u5185\u5b58\u4e3a:{}kb,\u5df2\u4f7f\u7528\u7269\u7406\u5185\u5b58\u4e3a{}kb,\u5269\u4f59\u7269\u7406\u5185\u5b58\u4e3a:{}kb", new Object[]{JSONObject.toJSONString((Object)customerRespDto), rList.size(), baseExportService.getId(), customerRespDtos.size(), i + 1, totalMemorySize, usedMemory, freeMemorySize});
                        }
                        workbook = batchService.appendData((Collection)rList);
                        rList.clear();
                    }
                } else {
                    CustomerRespDto cusDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)this.baseCustomerQueryApi.queryById(dto.getCustomerId()));
                    this.commonSearchPriceLimit(dto, baseExportService, rList, exportTypeName, cusDto);
                    workbook = batchService.appendData((Collection)rList);
                }
                if (workbook != null) {
                    String downloadUrl = MyEasyPoiExportUtil.commonInit();
                    String exportUrl = null;
                    exportUrl = CollectionUtils.isNotEmpty((Collection)customerRespDtos) ? MyEasyPoiExportUtil.getBigFileUrl(title, downloadUrl, workbook, fileName) : MyEasyPoiExportUtil.getFileUrl(title, downloadUrl, workbook, null, fileName);
                    this.exportService.success(baseExportService.getId(), exportUrl);
                } else {
                    this.exportService.fail(baseExportService.getId(), "\u5bfc\u51fa" + exportTypeName + "\u5217\u8868,\u6570\u636e\u4e3a\u7a7a");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("\u5bfc\u51fa{}\u5217\u8868-\u9519\u8bef:{}", (Object)exportTypeName, (Object)e.toString());
                this.exportService.fail(baseExportService.getId(), "\u5bfc\u51fa" + exportTypeName + "\u5217\u8868\u9519\u8bef\u3010" + e.getMessage() + "\u3011");
            }
            finally {
                if (!Boolean.TRUE.equals(lockFlag)) {
                    this.cacheService.delCache(EXPORT_ALL_PRICE_LIMIT_KEY);
                }
                ExcelExportUtil.closeExportBigExcel();
            }
            return null;
        }, null);
        return new RestResponse("0", "\u5bfc\u51fa" + exportTypeName + "\u5df2\u6267\u884c");
    }

    private void commonSearchPriceLimit(PriceLimitSkuQueryReqDto reqDto, BaseExportService baseExportService, List<PriceLimitSkuDetailVo> rList, String exportTypeName, CustomerRespDto customerRespDto) {
        String customerName = customerRespDto != null ? customerRespDto.getName() : "";
        String customerCode = customerRespDto != null ? customerRespDto.getCode() : "";
        Long total = null;
        double num = 0.0;
        Integer pageNum = 1;
        Integer pageSize = 5000;
        while (total == null || (double)pageNum.intValue() <= num) {
            reqDto.setPageNum(pageNum);
            reqDto.setPageSize(pageSize);
            logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\u67e5\u8be2{}\u53c2\u6570:{},UUID:{}", new Object[]{exportTypeName, JSONObject.toJSONString((Object)reqDto), baseExportService.getId()});
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.priceLimitQueryApi.queryCustSkuPriceLimitByPage(reqDto));
            if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
                logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\u67e5\u8be2{}\u7ed3\u679c:{},UUID:{}", new Object[]{exportTypeName, pageInfo.getList().size(), baseExportService.getId()});
            }
            if (total == null) {
                total = pageInfo.getTotal();
                num = Math.ceil(Double.valueOf(total.longValue()) / (double)pageSize.intValue());
                logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\u521d\u59cb\u5316UUID:{},\u67e5\u8be2{}\u603b\u6570:{},\u4e00\u5171\u9700\u8981\u5206\u6279:{}\u6b21", new Object[]{exportTypeName, baseExportService.getId(), total, num});
            }
            pageNum = pageNum + 1;
            if (!CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) continue;
            for (PriceLimitSkuDetailRespDto respDto : pageInfo.getList()) {
                if (CollectionUtils.isNotEmpty((Collection)respDto.getSkuLimitPolicyExtDtoList())) {
                    for (int i = 0; i < respDto.getSkuLimitPolicyExtDtoList().size(); ++i) {
                        PriceLimitPolicyEsSkuExtDto extDto = (PriceLimitPolicyEsSkuExtDto)respDto.getSkuLimitPolicyExtDtoList().get(i);
                        PriceLimitSkuDetailVo policyVo = new PriceLimitSkuDetailVo();
                        this.priceLimitCommonCopy(policyVo, respDto, customerName, customerCode);
                        String priceLower = extDto.getSkuLowerLimit() != null ? String.format("%.2f", extDto.getSkuLowerLimit()) : "\u4e0d\u9650";
                        String priceUpper = extDto.getSkuUpperLimit() != null ? String.format("%.2f", extDto.getSkuUpperLimit()) : "\u4e0d\u9650";
                        policyVo.setPriceLimitSpace(priceLower + " ~ " + priceUpper);
                        if (i == 0) {
                            policyVo.setCurPriceLimit("\u5f53\u524d\u4ef7\u76d8");
                        }
                        policyVo.setName(extDto.getName());
                        policyVo.setPolicyCode(extDto.getPolicyCode());
                        policyVo.setEffectiveTime(extDto.getEffectiveTime());
                        policyVo.setInvalidTime(extDto.getInvalidTime());
                        policyVo.setCustomerRangeDesc(CollectionUtils.isNotEmpty((Collection)extDto.getCustomerRangeDescList()) ? extDto.getCustomerRangeDescList().stream().collect(Collectors.joining(",")) : "");
                        policyVo.setItemRangeDesc(CollectionUtils.isNotEmpty((Collection)extDto.getItemRangeDescList()) ? extDto.getItemRangeDescList().stream().collect(Collectors.joining(",")) : "");
                        policyVo.setCreateTime(extDto.getCreateTime());
                        policyVo.setAuditPassTime(extDto.getAuditPassTime());
                        rList.add(policyVo);
                    }
                    continue;
                }
                PriceLimitSkuDetailVo vo = new PriceLimitSkuDetailVo();
                this.priceLimitCommonCopy(vo, respDto, customerName, customerCode);
                rList.add(vo);
            }
            pageInfo.getList().clear();
        }
    }

    private void priceLimitCommonCopy(PriceLimitSkuDetailVo vo, PriceLimitSkuDetailRespDto respDto, String customerName, String customerCode) {
        CubeBeanUtils.copyProperties((Object)vo, (Object)respDto, (String[])new String[]{"skuAttr"});
        vo.setCustomerName(customerName);
        vo.setCustomerCode(customerCode);
        if (StringUtils.isBlank((CharSequence)vo.getItemCode())) {
            vo.setItemCode(vo.getSkuCode());
        }
        if (StringUtils.isNotBlank((CharSequence)respDto.getSkuAttr())) {
            vo.setSkuAttr(respDto.getSkuAttr().substring(1, respDto.getSkuAttr().length() - 1).replaceAll("\"", ""));
        }
    }

    public RestResponse<Object> exportSuggestedRetailPrice(ItemSkuRetailPriceReqDto reqDto) {
        String exportTypeName = ExportTypeEnum.SUGGESTED_RETAIL_PRICE.getName();
        BaseExportService baseExportService = new BaseExportService(exportTypeName, ExportTypeEnum.SUGGESTED_RETAIL_PRICE);
        baseExportService.executor(req -> {
            try {
                ArrayList rList = Lists.newArrayList();
                Long total = null;
                double num = 0.0;
                Integer pageNum = 1;
                Integer pageSize = 5000;
                while (total == null || (double)pageNum.intValue() <= num) {
                    reqDto.setPageNum(pageNum);
                    reqDto.setPageSize(pageSize);
                    logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\u67e5\u8be2{}\u53c2\u6570:{},UUID:{}", new Object[]{exportTypeName, JSONObject.toJSONString((Object)reqDto), baseExportService.getId()});
                    PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.basePriceItemQueryApi.querySkuRetailPriceByPage(reqDto));
                    if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
                        logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\u67e5\u8be2{}\u7ed3\u679c:{},UUID:{}", new Object[]{exportTypeName, pageInfo.getList().size(), baseExportService.getId()});
                    }
                    if (total == null) {
                        total = pageInfo.getTotal();
                        num = Math.ceil(Double.valueOf(total.longValue()) / (double)pageSize.intValue());
                        logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\u521d\u59cb\u5316UUID:{},\u67e5\u8be2{}\u603b\u6570:{},\u4e00\u5171\u9700\u8981\u5206\u6279:{}\u6b21", new Object[]{exportTypeName, baseExportService.getId(), total, num});
                    }
                    pageNum = pageNum + 1;
                    if (!CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) continue;
                    for (ItemSkuRetailPriceRespDto respDto : pageInfo.getList()) {
                        SuggestedRetailPriceVo vo = new SuggestedRetailPriceVo();
                        CubeBeanUtils.copyProperties((Object)vo, (Object)respDto, (String[])new String[]{"skuAttr"});
                        if (StringUtils.isNotBlank((CharSequence)respDto.getSkuAttr())) {
                            vo.setSkuAttr(respDto.getSkuAttr().substring(1, respDto.getSkuAttr().length() - 1).replaceAll("\"", ""));
                        }
                        vo.setGiftBoxStr(GiftBoxTypeEnum.YES.getCode().equals(respDto.getGiftBox()) ? GiftBoxTypeEnum.YES.getName() : GiftBoxTypeEnum.NO.getName());
                        vo.setSkuPrice(MapUtils.isNotEmpty((Map)respDto.getSkuPriceMap()) ? String.format("%.2f", respDto.getSkuPriceMap().get(1L)) : "\u672a\u8bbe\u7f6e");
                        rList.add(vo);
                    }
                    pageInfo.getList().clear();
                }
                logger.info(exportTypeName + "\u5217\u8868\u67e5\u8be2\u6570\u636e\u8f6c\u6362\u7ed3\u679c\u5927\u5c0f:{},UUID:{}", (Object)rList.size(), (Object)baseExportService.getId());
                if (CollectionUtils.isNotEmpty((Collection)rList)) {
                    baseExportService.exportUrl(rList, SuggestedRetailPriceVo.class);
                } else {
                    this.exportService.fail(baseExportService.getId(), "\u5bfc\u51fa" + exportTypeName + "\u5217\u8868,\u6570\u636e\u4e3a\u7a7a");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("\u5bfc\u51fa{}\u5217\u8868-\u9519\u8bef:{}", (Object)exportTypeName, (Object)e.toString());
                this.exportService.fail(baseExportService.getId(), "\u5bfc\u51fa" + exportTypeName + "\u5217\u8868\u9519\u8bef\u3010" + e.getMessage() + "\u3011");
            }
            return null;
        }, null);
        return new RestResponse("0", "\u5bfc\u51fa" + exportTypeName + "\u6210\u529f");
    }

    public RestResponse<Object> exportDealerPrice(SkuPolicyPriceQueryReqDto reqDto) {
        Assert.notNull((Object)reqDto.getCustomerId(), (String)"-1", (String)"\u8bf7\u9009\u62e9\u5ba2\u6237");
        return this.commonExportDealerPrice(reqDto, null);
    }

    public RestResponse<Object> exportAllDealerPrice() {
        CustomerSearchReqDto searchReqDto = new CustomerSearchReqDto();
        searchReqDto.setListFlag(Boolean.valueOf(true));
        searchReqDto.setChannel(CustomerTypeEnum.DEALER.getCode());
        searchReqDto.setType(CustomerTypeEnum.RETAILER.getCode());
        RestResponse pageInfoRestResponse = this.customerExtQueryApi.queryByPage(JSONObject.toJSONString((Object)searchReqDto), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
        if (pageInfo == null || CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            throw new BizException("100000", "\u627e\u4e0d\u5230\u5ba2\u6237\u4fe1\u606f");
        }
        SkuPolicyPriceQueryReqDto reqDto = new SkuPolicyPriceQueryReqDto();
        return this.commonExportDealerPrice(reqDto, pageInfo.getList());
    }

    private RestResponse<Object> commonExportDealerPrice(SkuPolicyPriceQueryReqDto dto, List<CustomerRespDto> customerRespDtos) {
        String exportTypeName = ExportTypeEnum.DEALER_PRICE_SKU.getName();
        BaseExportService baseExportService = new BaseExportService(exportTypeName, ExportTypeEnum.DEALER_PRICE_SKU);
        baseExportService.executor(req -> {
            Boolean lockFlag = (Boolean)this.cacheService.getCache(EXPORT_ALL_DEALER_PRICE_KEY, Boolean.class);
            try {
                IContext context = (IContext)SpringBeanUtil.getBean(IContext.class);
                if (context != null) {
                    logger.info("\u5bfc\u51fa\u6253\u5370\u83b7\u53d6\u7684userId={},instanceId={},tenantId={}", new Object[]{context.userId(), context.instanceId(), context.tenantId()});
                }
                ArrayList rList = Lists.newArrayList();
                if (CollectionUtils.isNotEmpty((Collection)customerRespDtos)) {
                    if (Boolean.TRUE.equals(lockFlag)) {
                        TimeUnit.MINUTES.sleep(5L);
                    } else {
                        this.cacheService.setCache(EXPORT_ALL_DEALER_PRICE_KEY, (Object)Boolean.TRUE, 300);
                    }
                }
                String title = null;
                ExportParams params = new ExportParams(title, "", ExcelType.XSSF);
                ExcelBatchExportService batchService = ExcelBatchExportService.getExcelBatchExportService((ExportParams)params, SkuPolicyPriceVo.class);
                Workbook workbook = null;
                if (CollectionUtils.isNotEmpty((Collection)customerRespDtos)) {
                    for (CustomerRespDto customerRespDto : customerRespDtos) {
                        SkuPolicyPriceQueryReqDto queryReqDto = new SkuPolicyPriceQueryReqDto();
                        queryReqDto.setCustomerId(customerRespDto.getId());
                        this.commonSearchDealerPrice(queryReqDto, baseExportService, rList, exportTypeName, customerRespDto);
                        logger.info(exportTypeName + "\u5217\u8868\u53c2\u6570:{}:\u67e5\u8be2\u6570\u636e\u8f6c\u6362\u7ed3\u679c\u5927\u5c0f:{},UUID:{}", new Object[]{JSONObject.toJSONString((Object)queryReqDto), rList.size(), baseExportService.getId()});
                        workbook = batchService.appendData((Collection)rList);
                        rList.clear();
                    }
                } else {
                    CustomerExtDetailRespDto cusDto = (CustomerExtDetailRespDto)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryById(dto.getCustomerId()));
                    this.commonSearchDealerPrice(dto, baseExportService, rList, exportTypeName, cusDto);
                    logger.info(exportTypeName + "\u5217\u8868\u53c2\u6570:{}:\u67e5\u8be2\u6570\u636e\u8f6c\u6362\u7ed3\u679c\u5927\u5c0f:{},UUID:{}", new Object[]{JSONObject.toJSONString((Object)dto), rList.size(), baseExportService.getId()});
                    workbook = batchService.appendData((Collection)rList);
                }
                String fileName = "cube/" + exportTypeName + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss") + ".xlsx";
                if (workbook != null) {
                    String downloadUrl = MyEasyPoiExportUtil.commonInit();
                    String exportUrl = CollectionUtils.isNotEmpty((Collection)customerRespDtos) ? MyEasyPoiExportUtil.getBigFileUrl(title, downloadUrl, workbook, fileName) : MyEasyPoiExportUtil.getFileUrl(title, downloadUrl, workbook, null, fileName);
                    this.exportService.success(baseExportService.getId(), exportUrl);
                } else {
                    this.exportService.fail(baseExportService.getId(), "\u5bfc\u51fa" + exportTypeName + "\u5217\u8868,\u6570\u636e\u4e3a\u7a7a");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("\u5bfc\u51fa{}\u5217\u8868-\u9519\u8bef:{}", (Object)exportTypeName, (Object)e.toString());
                this.exportService.fail(baseExportService.getId(), "\u5bfc\u51fa" + exportTypeName + "\u5217\u8868\u9519\u8bef\u3010" + e.getMessage() + "\u3011");
            }
            finally {
                if (!Boolean.TRUE.equals(lockFlag)) {
                    this.cacheService.delCache(EXPORT_ALL_DEALER_PRICE_KEY);
                }
                ExcelExportUtil.closeExportBigExcel();
            }
            return null;
        }, null);
        return new RestResponse("0", "\u5bfc\u51fa" + exportTypeName + "\u6210\u529f");
    }

    private <T extends CustomerRespDto> void commonSearchDealerPrice(SkuPolicyPriceQueryReqDto reqDto, BaseExportService baseExportService, List<SkuPolicyPriceVo> rList, String exportTypeName, T customerRespDto) {
        String customerName = customerRespDto != null ? customerRespDto.getName() : "";
        String customerCode = customerRespDto != null ? customerRespDto.getCode() : "";
        Long total = null;
        double num = 0.0;
        Integer pageNum = 1;
        Integer pageSize = 150;
        while (total == null || (double)pageNum.intValue() <= num) {
            reqDto.setPageNum(pageNum);
            reqDto.setPageSize(pageSize);
            logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\u67e5\u8be2{}\u53c2\u6570:{},UUID:{}", new Object[]{exportTypeName, JSONObject.toJSONString((Object)reqDto), baseExportService.getId()});
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.priceQueryApi.querySkuPolicyDistributePriceByPage(reqDto));
            if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
                logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\u67e5\u8be2{}\u7ed3\u679c:{},UUID:{}", new Object[]{exportTypeName, pageInfo.getList().size(), baseExportService.getId()});
            }
            if (total == null) {
                total = pageInfo.getTotal();
                num = Math.ceil(Double.valueOf(total.longValue()) / (double)pageSize.intValue());
                logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\u521d\u59cb\u5316UUID:{},\u67e5\u8be2{}\u603b\u6570:{},\u4e00\u5171\u9700\u8981\u5206\u6279:{}\u6b21", new Object[]{exportTypeName, baseExportService.getId(), total, num});
            }
            pageNum = pageNum + 1;
            if (!CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) continue;
            Integer zero = new Integer(1);
            for (SkuPolicyPriceRespDto respDto : pageInfo.getList()) {
                SkuPolicyPriceVo notPolicyVo = new SkuPolicyPriceVo();
                CubeBeanUtils.copyProperties((Object)notPolicyVo, (Object)respDto, (String[])new String[0]);
                notPolicyVo.setCustomerName(customerName);
                notPolicyVo.setCustomerCode(customerCode);
                if (StringUtils.isNotBlank((CharSequence)respDto.getSkuAttr())) {
                    notPolicyVo.setSkuAttrStr(respDto.getSkuAttr().substring(1, respDto.getSkuAttr().length() - 1).replaceAll("\"", ""));
                }
                String priceLower = respDto.getSkuLowerLimit() != null ? String.format("%.2f", respDto.getSkuLowerLimit()) : "\u4e0d\u9650";
                String priceUpper = respDto.getSkuUpperLimit() != null ? String.format("%.2f", respDto.getSkuUpperLimit()) : "\u4e0d\u9650";
                notPolicyVo.setSkuSpace(priceLower + " ~ " + priceUpper);
                notPolicyVo.setSkubrandBasePrice(respDto.getSkubrandBasePrice());
                notPolicyVo.setSkuDealerBasePrice(respDto.getSkuDealerBasePrice());
                if (CollectionUtils.isNotEmpty((Collection)respDto.getPricePolicyEsSkuExtDtos())) {
                    for (int i = 0; i < respDto.getPricePolicyEsSkuExtDtos().size(); ++i) {
                        SkuPolicyPriceVo vo = new SkuPolicyPriceVo();
                        CubeBeanUtils.copyProperties((Object)vo, (Object)notPolicyVo, (boolean)false, (String[])new String[0]);
                        PricePolicyEsSkuExtDto extDto = (PricePolicyEsSkuExtDto)respDto.getPricePolicyEsSkuExtDtos().get(i);
                        if (CollectionUtils.isNotEmpty((Collection)extDto.getSkuLadderPriceList())) {
                            StringBuilder skuLaderPriceBuilder = new StringBuilder();
                            StringBuilder skuSupplyPriceBuilder = new StringBuilder();
                            int listSize = extDto.getSkuLadderPriceList().size();
                            for (int j = 0; j < extDto.getSkuLadderPriceList().size(); ++j) {
                                PricePolicyEsSkuExtDto.SkuLadderPrice skuLadderPrice = (PricePolicyEsSkuExtDto.SkuLadderPrice)extDto.getSkuLadderPriceList().get(j);
                                priceLower = skuLadderPrice.getLowerNum() != null ? String.valueOf(skuLadderPrice.getLowerNum()) : "1";
                                priceUpper = skuLadderPrice.getUpperNum() != null ? String.valueOf(skuLadderPrice.getUpperNum()) : "\u4e0d\u9650";
                                skuLaderPriceBuilder.append(priceLower).append("~").append(priceUpper).append(": ").append(skuLadderPrice.getLadderPrice()).append("\u5143").append(listSize > 1 ? " ; " : "");
                                skuSupplyPriceBuilder.append(priceLower).append("~").append(priceUpper).append(": ").append(skuLadderPrice.getSupplyPrice()).append("\u5143").append(listSize > 1 ? " ; " : "");
                            }
                            vo.setSkuLadderPrice(skuLaderPriceBuilder.toString());
                            vo.setSkuPolicyPrice(skuSupplyPriceBuilder.toString());
                        } else {
                            if (extDto.getSupplyPrice() != null) {
                                vo.setSkuLadderPrice("1~\u4e0d\u9650: " + String.format("%.2f", extDto.getSupplyPrice()) + "\u5143");
                            } else {
                                vo.setSkuLadderPrice("\u6682\u65e0\u62a5\u4ef7");
                            }
                            if (extDto.getHasDiscountPrice()) {
                                vo.setSkuPolicyPrice("1~\u4e0d\u9650\uff1a" + String.format("%.2f", extDto.getSkuPolicyPrice()) + "\u5143");
                            } else {
                                vo.setSkuPolicyPrice("\u6682\u65e0\u62a5\u4ef7");
                            }
                        }
                        if (extDto.getCalcPriceDescriptionRespDto() != null) {
                            vo.setCalculateFormula("\u653f\u7b56\u4ef7=" + extDto.getCalcPriceDescriptionRespDto().getCalculateFormula());
                            vo.setCalculateFormulaDesc(extDto.getCalcPriceDescriptionRespDto().getCalculateFormulaDesc());
                        }
                        if (zero.equals(extDto.getRankNo())) {
                            vo.setCurPrice("\u5f53\u524d\u4ef7\u683c");
                        }
                        if (extDto.isSkuPolicyPriceOutRange()) {
                            vo.setSkuPolicyPriceOutRangeStr("\u8d85\u51fa\u4ef7\u76d8");
                        }
                        vo.setName(extDto.getName());
                        vo.setPolicyCode(extDto.getPolicyCode());
                        vo.setEffectiveTime(extDto.getEffectiveTime());
                        vo.setInvalidTime(extDto.getInvalidTime());
                        vo.setPriceTypeName(extDto.getPriceTypeName());
                        vo.setCustomerRangeDesc(CollectionUtils.isNotEmpty((Collection)extDto.getCustomerRangeDescList()) ? extDto.getCustomerRangeDescList().stream().collect(Collectors.joining(",")) : "");
                        vo.setItemRangeDesc(CollectionUtils.isNotEmpty((Collection)extDto.getItemRangeDescList()) ? extDto.getItemRangeDescList().stream().collect(Collectors.joining(",")) : "");
                        vo.setCreateTime(extDto.getCreateTime());
                        vo.setAuditPassTime(extDto.getAuditPassTime());
                        vo.setShopName(extDto.getShopName());
                        vo.setPriceModeName(PriceModelSetTypeEnum.DIRECT_SET.getCode().equals(extDto.getPriceModelSetType()) ? "\u76f4\u63a5\u5b9a\u4ef7" : "\u6263\u7387\u5b9a\u4ef7");
                        rList.add(vo);
                    }
                    continue;
                }
                notPolicyVo.setSkuLadderPrice(respDto.getSupplyPrice() == null ? "\u6682\u65e0\u62a5\u4ef7" : String.valueOf(respDto.getSupplyPrice()));
                rList.add(notPolicyVo);
            }
            pageInfo.getList().clear();
        }
    }
}

