/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.export.biz.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.CustomerStoreReqDto;
import com.dtyunxi.tcbj.api.dto.request.TbPersonPartnerRelReqDto;
import com.dtyunxi.tcbj.api.query.ICustomerDistributorsQueryApi;
import com.dtyunxi.tcbj.api.query.ITbPersonPartnerRelQueryApi;
import com.dtyunxi.tcbj.module.export.biz.constant.ExportTypeEnum;
import com.dtyunxi.tcbj.module.export.biz.impl.BaseExportService;
import com.dtyunxi.tcbj.module.export.biz.impl.ExportService;
import com.dtyunxi.tcbj.module.export.biz.vo.customer.StoreCheckVo;
import com.dtyunxi.yundt.cube.center.customer.api.constants.CustomerCheckStatusEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerCheckRelationReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerCheckRelationRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.ICustomerCheckRelationQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class StoreCheckExportService {
    @Resource
    private ExportService exportService;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private ICustomerDistributorsQueryApi customerDistributorsQueryApi;
    @Resource
    private ICustomerCheckRelationQueryApi customerCheckRelationQueryApi;
    @Resource
    private ITbPersonPartnerRelQueryApi tbPersonPartnerRelQueryApi;

    public RestResponse<Object> exportStoreCheck(CustomerStoreReqDto customerStoreReqDto) {
        Long orgId = (Long)this.customerExtQueryApi.queryCurrentUserOrgId().getData();
        Assert.notNull((Object)orgId, (String)"\u7ec4\u7ec7id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        BaseExportService baseExportService = new BaseExportService(ExportTypeEnum.STORE_CHECK_MSG.getName(), ExportTypeEnum.STORE_CHECK_MSG);
        baseExportService.executor(req -> {
            customerStoreReqDto.setOrgId(orgId);
            PageInfo customerStoreResponseDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.customerDistributorsQueryApi.queryCustomerStorePage(JSON.toJSONString((Object)customerStoreReqDto), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)));
            if (CollectionUtils.isNotEmpty((Collection)customerStoreResponseDtoPageInfo.getList())) {
                ArrayList storeCheckVos = Lists.newArrayList();
                CubeBeanUtils.copyCollection((Collection)storeCheckVos, (Collection)customerStoreResponseDtoPageInfo.getList(), StoreCheckVo.class);
                List storeIds = customerStoreResponseDtoPageInfo.getList().stream().map(c -> c.getStoreId()).collect(Collectors.toList());
                CustomerCheckRelationReqDto customerCheckRelationReqDto = new CustomerCheckRelationReqDto();
                customerCheckRelationReqDto.setStoreIds(storeIds);
                customerCheckRelationReqDto.setOrgId(orgId);
                List customerCheckRelationRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerCheckRelationQueryApi.queryByStoreIds(customerCheckRelationReqDto));
                if (!CollectionUtils.isEmpty((Collection)customerCheckRelationRespDtos)) {
                    List salesmanIds = customerCheckRelationRespDtos.stream().map(c -> c.getSalesmanId().toString()).collect(Collectors.toList());
                    TbPersonPartnerRelReqDto tbPersonPartnerRelReqDto = new TbPersonPartnerRelReqDto();
                    tbPersonPartnerRelReqDto.setRowIds(salesmanIds);
                    tbPersonPartnerRelReqDto.setCustomerId(orgId.toString());
                    PageInfo tbPersonPartnerRelRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.tbPersonPartnerRelQueryApi.queryByPage(JSON.toJSONString((Object)tbPersonPartnerRelReqDto), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)));
                    List rowIds = tbPersonPartnerRelRespDtoPageInfo.getList().stream().map(c -> c.getRowId()).collect(Collectors.toList());
                    Map<Long, CustomerCheckRelationRespDto> customerCheckRelationRespDtoMap = customerCheckRelationRespDtos.stream().collect(Collectors.toMap(key -> key.getStoreId(), val -> val));
                    storeCheckVos.stream().forEach(c -> {
                        CustomerCheckRelationRespDto orDefault = customerCheckRelationRespDtoMap.getOrDefault(c.getStoreId(), null);
                        if (null != orDefault) {
                            c.setCheckStatus(rowIds.contains(orDefault.getSalesmanId()) ? CustomerCheckStatusEnum.BOUND.getName() : CustomerCheckStatusEnum.DISABLE.getName());
                            c.setSalemanName(orDefault.getSalesmanName());
                        }
                    });
                }
                baseExportService.exportUrl(storeCheckVos, StoreCheckVo.class);
            } else {
                this.exportService.fail(baseExportService.getId(), "\u5bfc\u51fa" + ExportTypeEnum.STORE_CHECK_MSG.getName() + "\u5217\u8868,\u6570\u636e\u4e3a\u7a7a");
            }
            return null;
        }, null);
        return new RestResponse("0", "\u5bfc\u51fa" + ExportTypeEnum.STORE_CHECK_MSG.getName() + "\u6210\u529f");
    }

    public RestResponse<Object> exportStoreSaleman(String storeId) {
        Long orgId = (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryCurrentUserOrgId());
        return new RestResponse("0", "\u5bfc\u51fa" + ExportTypeEnum.STORE_SALEMAN_RELATION.getName() + "\u6210\u529f");
    }
}

